// ----------------------------------------------
// Listing zum Artikel 'Mathe schafft Natur -
// Algorithmische 3D-Landschaften in POV-Ray' 
// c't 20/03 Seite 206
//
// letzter Schritt - Flllicht
//
// Szene fuer Persistence of Vision Ray Tracer 
// (POV-Ray) http://www.povray.org
// ----------------------------------------------
//

#version 3.5;

global_settings {
  assumed_gamma 1.0
}

// ----------------------------------------

camera {
  location  <1.0, -4.0, 1.0>
  up z
  sky z
  look_at   <0.0, 0.0, 0.5>
  angle 40
}

sky_sphere {
  pigment {
    gradient z
    color_map {
      [0.0 rgb <0.6,0.7,1.0>]
      [0.2 rgb <0.2,0.3,0.9>]
    }
  }
}

light_source {
  <3000, 1000, 2000>
  color rgb <2.2, 1.8, 1.5>
}


light_source {
  <-1000, -3000, 5000>
  color rgb <0.6,0.7,1.0>*0.4
  shadowless
}

// ----------------------------------------

#declare Vegetations_Textur=
  texture {
    pigment {
      wrinkles
      color_map {
        [0.25 color rgb <0.03,0.2,0.03>]
        [0.30 color rgb <0.1,0.3,0.05>]
        [0.55 color rgb <0.1,0.3,0.05>]
        [0.80 color rgb <0.01,0.1,0.015>]
      }
      scale 0.1
    }
    normal {
      granite 1.6
      warp { turbulence 0.3 }
      scale 0.2
    }
    finish {
      diffuse 0.6
      brilliance 1.5
      ambient <0.6,0.7,1.0>*0.05
    }
    scale 0.05
  }

#declare Fels_Textur=
  texture {
    pigment {
      agate
      color_map {
        [0.4 color rgb 0.8]
        [0.6 color rgb <0.6,0.53,0.5>]
        [0.85 color rgb <0.6,0.53,0.5>]
        [0.87 color rgb 0.4]
      }
      warp {
        turbulence 0.5
        omega 0.7
        lambda 5
      }
    }
    finish { ambient <0.6,0.7,1.0>*0.05 }
    scale 0.03
  }


#include "functions.inc"

#declare Fein_Struktur=
  function {
    pattern {
      bozo
      poly_wave 3
      scale <0.7, 0.7, 0.25>
      rotate <-22.5, 0, -30>
      scale 1/2
      warp {
        turbulence 0.8
        omega 0.5
        lambda 2.4
        octaves 15
      }
      scale 2
    }
  }

#declare Fein_Struktur2=
  function {
    pattern {
      pigment_pattern {
        bozo
        pigment_map {
          [0.4 granite
                color_map {[0 rgb 0][1 rgb 1]}
                warp { turbulence 0.5 }
                scale 0.016
          ]
          [0.55 color rgb 0]
        }
      }
      scale 0.1
    }
  }

#declare Relief_Funktion=
  function {
    z - f_noise3d(x, y, 0)*1.5
      - Fein_Struktur(x, y, z)*0.15
      - Fein_Struktur2(x, y, z)*0.00017
  }


isosurface {
  function { Relief_Funktion(x, y, z) }

  accuracy 0.00001
  max_gradient 8

  contained_by {
    box { <-4, -4, -1>, <4, 4, 1.5> }
  }

  texture {
    slope {
      -z
      altitude z*0.55, 0, 2
    }
    texture_map {
      [0.340 Vegetations_Textur ]
      [0.341 Fels_Textur ]
    }
  }
}
