#if HAVE_CONFIG_H
# include <config.h>
#endif

#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#include <stdio.h>
#if HAVE_STRING_H
# include <string.h>
#endif
#include <errno.h>

int wait_for_event (char **event);

int
main (int argc, char *argv[])
{
  char *event;
  int result = wait_for_event (&event);

  if (result < 0)
    {
#if HAVE_STRERROR
      fprintf (stderr, "Fehler: %s", strerror (ENOMEM));
#else
      fprintf (stderr, "Fehler: Kein freier Speicher mehr");
#endif
      return EXIT_FAILURE;
    }
  if (!strncasecmp (event, "fehler:", 7))
    {
      fprintf (stderr, "%s", event);
      return EXIT_FAILURE;
    }
  
  printf ("%s\n", event);
  free (event);

  return EXIT_SUCCESS;
}
