using System;

/* GC.ReregisterForFinalize() - fr Exceptions im Finalize
 * Erneuter Aufruf des Destruktors findet erst nach dem nchsten Collect statt - 
 * wird also nicht etwa gleich wieder hintendran gehngt.
 * 
 * Experiment mit CWDDerived: Wenn auf irgendeiner Ebene das Finalize ein ReRegister aufruft,
 * dann wird das Objekt als solches neu registriert:
 * 
 * CWDDerived, Destruct
 *    -> CWD, Destruct: ReRegister
 * 
 * Ergebnis: Beim nchsten Collect wird wiederum der Destruktor von CWDDerived aufgerufen.
 * Ist auch logisch, nur halt ein Fallstrick. So gehts nicht:
 * 
 * ~CWDDerived()
 * {
 *   // Killt irgendeine Ressource, die das Objekct "immer" hat
 * }
 * 
 * Wenn CWD ein Reregister macht, dann kracht es beim erneuten Aufruf des Destruktors. 
 * Deshalb: 
 * ~CWDDerived()
 * {
 *   if (MyResource != null)
 *   { // Kill MyResource
 *     // ...
 *     MyResource = null;
 *   }
 * 
 */  
namespace ReRegister
{

	public class ClassWithDestructor
	{
		static int ObjCounter;
		public string ObjName;
		private bool SimFinalizeException;

		public ClassWithDestructor(bool _SimFinalizeException)
		{
			ObjName = String.Format("{0}({1})", ToString(), ObjCounter++);
			SimFinalizeException = _SimFinalizeException;
		}

		public ClassWithDestructor(string NewObjName)
		{
			ObjName = String.Format("{0}({1})", NewObjName, ObjCounter++);;
		}

		~ClassWithDestructor()
		{
			Console.WriteLine(ObjName+ ": CWD, Destruct start");
			try
			{
				if (SimFinalizeException)
				{ 
					SimFinalizeException = false;
					throw new Exception("Simulated Error");
				}
				Console.WriteLine(ObjName+ ": CWD, Destruct done");
			}
			catch(Exception e)
			{
				Console.WriteLine("Finalize failed: "+e.Message+". Reregistering..");
				GC.ReRegisterForFinalize(this);
			}
		
		}
	}

	public class CWDDerived : ClassWithDestructor
	{
		public CWDDerived(): base(true)
		{
		}

		~CWDDerived()
		{
			Console.WriteLine(ObjName+ ": CWDDerived, Destruct");
		}
	}


	/// <summary>
	/// Zusammendfassende Beschreibung fr Class1.
	/// </summary>
	class Class1
	{
		/// <summary>
		/// Der Haupteinstiegspunkt fr die Anwendung.
		/// </summary>
		[STAThread]
		static void Main(string[] args)
		{ ClassWithDestructor CWD = null;
			CWDDerived CWDd = null;

			CWD = new ClassWithDestructor(false);
			CWD = new ClassWithDestructor(true);
			CWD = null;
			CWDd = new CWDDerived();
			CWDd = null;
			GC.Collect();
			Console.WriteLine("Waiting for finalizers -- press ENTER");
			Console.ReadLine();
			// Wenn man den auskommentiert, kommt das zweite Finalize fr CWD(1) erst am Programmende
			GC.Collect();   
			Console.WriteLine("Waiting for finalizers -- press ENTER");
			Console.ReadLine();

		}
	}
}
