class ct.WeatherXML extends XML {
	var xml_url:String;             // Die Adresse der XML-Datei
	var xml_loaded:Boolean = false; // Ladezustand der XML-Daten 							   //	true = geladen)
	var currentWeaterData:XMLNode;  // Enthaelt die aktuellen 							   //Wetterdaten (XML)
	var historyWeaterData:XMLNode;  // Enthaelt die historischen 							   //	Wetterdaten (XML)

	// Constructor
	function WeatherXML (myURL:String) {
		xml_url = myURL;
		this.ignoreWhite = true;  // leere Nodes ignorieren
		this.load(xml_url);       // "load" method der XML Klasse
		this.onLoad = dataLoaded; // Ruft die Methode "dataLoaded" 						  // auf wenn die Daten da sind
	}

	// Wird aufgerufen, wenn das XML Objekt die Daten vollstaendig 	// geladen hat.
	private function dataLoaded () {
		xml_loaded = true; // die Daten sind da

		var firstXMLChild = this.firstChild;
		currentWeaterData = firstXMLChild.childNodes[0];
		historyWeaterData = firstXMLChild.childNodes[1];
	}

	// Zerlegt die XML-Daten und liefert passenden String zurueck
	private function parseWeatherXML (myType:String): Number {
		var myNextNode  = true;
		var myNodeCnt   = 1; // ersten Knoten ueberspringen 
		var valueName   = "";
		var valueValue  = "";
		var returnValue = 0;

		while (myNextNode) {
			valueName  = getXMLNode(currentWeaterData.childNodes[myNodeCnt].childNodes[0], 0); // Liefert den Namen
			valueValue = getXMLNode(currentWeaterData.childNodes[myNodeCnt].childNodes[1], 0); // Liefert den Wert

			if(valueName == undefined) {
				// die XML-Struktur ist defekt
				myNextNode  = false;
				returnValue = 888;
			} else {
				myNodeCnt++;

				if(valueName == myType) {
					// den Wert haben wir gesucht
					myNextNode  = false;
					returnValue = valueValue;
				}
			}
		}

		return(returnValue);
	}

	private function getXMLNode (myStructur:XMLNode, 								myIndex:Number): String {
		// einen XML Knoten holen
		var thisNode:XMLNode = myStructur.childNodes[myIndex];

		if (thisNode.nodeType == 3) {
			return (thisNode.nodeValue);
		} else {
			return (thisNode.nodeName);
		}
	}

	function getValue (myType:String): Number {
		// Interface, um gesuchte Werte an Film zu uebergeben
		if (xml_loaded) {
			// Wert suchen und uebergeben
			return (parseWeatherXML(myType));
		} else {
			// Daten noch nicht geladen
			return (999);
		}
	}

	function reLoadXML () {
		// Daten neu laden
		xml_loaded = false;
		this.load(xml_url);       // "load"-Methode der XML-Klasse
		// Ruft Methode dataload auf, wenn die Daten da sind
		this.onLoad = dataLoaded; 
	}

	static function celToFar (myCelVal:Number): Number {
		// Rechnet Celsius in Fahrenheit um
		return ((myCelVal*1.8) + 32);
	}

	static function farToCel (myFarVal:Number): Number {
		// Rechnet Fahrenheit in Celsius um
		return (0.5555556 * (myFarVal - 32));
	}
}
