#!/usr/bin/perl
use lib "./module";
use Config::IniFiles;
use HTML::Template;
use CGI;

&doINIfileSettings;
&execINIfileChanges if $cgiOutput->param('do') eq "change";
# Werte aus dem Formular bernehmen?
&showINIfileContent($INIform);
exit 1;



sub doINIfileSettings {
	$INIfile = "INIedit.ini"; 
	$INIform = "INIedit.html";
	$FieldWidth = 250;
	# Mindestbreite der Eingabefelder
	$Fontwidth = 8;
	# Ungefhre Breite der Eingabefelder an Font anpassen
	$cgiOutput = new CGI;
	tie %cfgFile, 'Config::IniFiles', (-file => $INIfile);
	tied(%cfgFile)->ReadConfig;
}



sub execINIfileChanges	{
	@fields = $cgiOutput->param;
	for $field (@fields)	{
		if ($field =~ /___/)	{
			($section, $param) = split /___/, $field;
			$cfgFile{$section}{$param} = $cgiOutput->param($field);
			print "set: $section,$param = " . $cgiOutput->param($field) . "\n<br>";
			print "cfg: $section,$param = " . $cfgFile{$section}{$param} . "\n<br>";
		}
	}
	tied(%cfgFile)->RewriteConfig;
	tied(%cfgFile)->ReadConfig;
	$theMessage = "$INIfile wurde aktualisiert. (Schreibrechte?)";
}


sub showINIfileContent {
	my @TemplateData = ();  
	my $newWidth;
	foreach my $section (tied(%cfgFile)->Sections)	{
		my %theSection = ();  
		$theSection{SECTIONNAME} = $section;
 		foreach $param (tied(%cfgFile)->Parameters($section))	{
			my %PARAMETER = ();
			$PARAMETER{PARAMETERNAME} = $param;
			$PARAMETER{PARAMETERFIELD} = $section . "___" . $param;
			$PARAMETER{PARAMETERVALUE} = $cfgFile{$section}{$param};
			$newWidth = 20 + length($cfgFile{$section}{$param}) * $Fontwidth;
			# Notwendige Breite ungefhr berechnen
			$FieldWidth = $newWidth if ($newWidth > $FieldWidth);
			push @{$theSection{PARAMETERNAMES}}, \%PARAMETER;
		}
		push @TemplateData, \%theSection;
	}
	my $HTMLcode = &TemplateFile($_[0]);
	$template = HTML::Template->new(scalarref => \$HTMLcode);
	$template->param(HTMLTemplate => \@TemplateData);
	print "Content-Type: text/html\n\n";
	print $template->output;
}




sub TemplateFile {
	my $TMPLfilename = shift; 
	my $HTMLdata;
	open(FILE, "<$TMPLfilename") || die ("Dateifehler : -$TMPLfilename- $!\n");
	while (<FILE>) {$HTMLdata .= $_}
	close(FILE);
	$HTMLdata =~ s/\$(\w+)/${$1}/g;
	# alle enthaltenen Variablennamen durch Werte ersetzen
	return $HTMLdata;
}

