// BeginInvokeDemoMulti.cs - viermaliger BeginInvoke-Aufruf eines Delegaten
//  demonstriert folgende Techniken: 
//   - Technik der Parameterrckgabe via EndInvoke()
//   - Aufruf ohne Rckrufmethode (null) mglich
// erschreckendes Ergebnis: Das Beispiel erhrtet den Verdacht, dass BeginInvoke() 
// mit Threadpool-Threads arbeitet (Verzgerungen von mindestens 0,5s je Aufruf)
// 

using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Threading; 

namespace BeginInvokeDemo
{
	/// <summary>
	/// Zusammenfassung fr Form1.
	/// </summary>
	public class Form1 : System.Windows.Forms.Form
	{
    private System.Windows.Forms.Button button1;
    private System.Windows.Forms.ToolTip toolTip1;
    private System.Windows.Forms.TextBox textBox1;
    private System.ComponentModel.IContainer components;

		public Form1()
		{
			//
			// Erforderlich fr die Windows Form-Designeruntersttzung
			//
			InitializeComponent();
			//
			// TODO: Fgen Sie den Konstruktorcode nach dem Aufruf von InitializeComponent hinzu
			//
		}

		/// <summary>
		/// Die verwendeten Ressourcen bereinigen.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Vom Windows Form-Designer generierter Code
		/// <summary>
		/// Erforderliche Methode fr die Designeruntersttzung. 
		/// Der Inhalt der Methode darf nicht mit dem Code-Editor gendert werden.
		/// </summary>
		private void InitializeComponent()
		{
      this.components = new System.ComponentModel.Container();
      this.button1 = new System.Windows.Forms.Button();
      this.toolTip1 = new System.Windows.Forms.ToolTip(this.components);
      this.textBox1 = new System.Windows.Forms.TextBox();
      this.SuspendLayout();
      // 
      // button1
      // 
      this.button1.Location = new System.Drawing.Point(16, 24);
      this.button1.Name = "button1";
      this.button1.Size = new System.Drawing.Size(240, 32);
      this.button1.TabIndex = 0;
      this.button1.Text = "Trigger 4 AsyncDelegates";
      this.toolTip1.SetToolTip(this.button1, "Ruft 4 Methoden via Delegat asychron vom Haupt-Thread aus auf. Die Zeiten beweise" +
        "n, dass die Implementierung Threadpool-Threads verwendet.");
      this.button1.Click += new System.EventHandler(this.button1_Click);
      // 
      // textBox1
      // 
      this.textBox1.Location = new System.Drawing.Point(16, 72);
      this.textBox1.Multiline = true;
      this.textBox1.Name = "textBox1";
      this.textBox1.Size = new System.Drawing.Size(240, 176);
      this.textBox1.TabIndex = 1;
      this.textBox1.Text = "";
      // 
      // Form1
      // 
      this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
      this.ClientSize = new System.Drawing.Size(280, 270);
      this.Controls.Add(this.textBox1);
      this.Controls.Add(this.button1);
      this.Name = "Form1";
      this.Text = "BeginInvoke mit Delegaten";
      this.ResumeLayout(false);

    }
		#endregion

		/// <summary>
		/// Der Haupteinstiegspunkt fr die Anwendung.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new Form1());
		}

    public string AsycMeth()
    {
      DateTime dt = DateTime.Now; 
      string res = "ThreadID: " + AppDomain.GetCurrentThreadId().ToString() + 
        " Time: " +dt.ToLongTimeString() + "." + 
        ((dt.Millisecond < 100) ? "0": "") + dt.Millisecond.ToString(); 
      System.Threading.Thread.Sleep(1000); 
      return res; 
    }

    // Delegat-Typ asynchron auszufhrende Methode
    public delegate string myAsyncDelegate (); 
    private void button1_Click(object sender, System.EventArgs e)
    {
      textBox1.Text="Bitte 2 Sekunden warten"; 
      Application.DoEvents(); 
      // Delegat fr asynchron auszufhrende Methode 
      myAsyncDelegate AsyncM = new myAsyncDelegate(AsycMeth);
      // vierfacher Aufruf: 
      IAsyncResult asyncRes0 = AsyncM.BeginInvoke(null, null); 
      IAsyncResult asyncRes1 = AsyncM.BeginInvoke(null, null); 
      IAsyncResult asyncRes2 = AsyncM.BeginInvoke(null, null); 
      IAsyncResult asyncRes3 = AsyncM.BeginInvoke(null, null); 


      // Ergebnisse einsammeln und ausgeben
      textBox1.Text+= "\r\n" +(string) AsyncM.EndInvoke(asyncRes0); 
      int i, j; 
      ThreadPool.GetAvailableThreads(out i,out j); 
      textBox1.Text+="\r\nThreadPool.GetAvailableThreads: "+i.ToString() + " "; 
      ThreadPool.GetMaxThreads(out i,out j); 
      textBox1.Text+="\r\nThreadPool.GetMaxThreads:   "+i.ToString() + " "; 
      textBox1.Text+= "\r\n" + (string) AsyncM.EndInvoke(asyncRes1); 
      textBox1.Text+= "\r\n" + (string) AsyncM.EndInvoke(asyncRes2); 
      textBox1.Text+= "\r\n" + (string) AsyncM.EndInvoke(asyncRes3); 
    }
	}
}
