// Gegenberstellung der drei verschiedenen Timer des .NET Framework.
// Windows-Timer, Thread-Timer, Server-Timer

using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Threading;
using System.Timers;

namespace ThreadTimer
{
	public class Form1 : System.Windows.Forms.Form
	{
		private System.Windows.Forms.Button bStartTimerThread;
		private System.Windows.Forms.ToolTip toolTip1;
		private System.Windows.Forms.ListBox listBox1;
		private System.Windows.Forms.Button bStartWindowsTimer;
		private System.Timers.Timer timer1;
		private System.Windows.Forms.Button bStartServerTimer;
		private System.ComponentModel.IContainer components;

		public Form1()
		{
			InitializeComponent();
		}

		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Vom Windows Form-Designer generierter Code
		/// <summary>
		/// Erforderliche Methode fr die Designeruntersttzung. 
		/// Der Inhalt der Methode darf nicht mit dem Code-Editor gendert werden.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			this.bStartTimerThread = new System.Windows.Forms.Button();
			this.toolTip1 = new System.Windows.Forms.ToolTip(this.components);
			this.listBox1 = new System.Windows.Forms.ListBox();
			this.bStartWindowsTimer = new System.Windows.Forms.Button();
			this.timer1 = new System.Timers.Timer();
			this.bStartServerTimer = new System.Windows.Forms.Button();
			((System.ComponentModel.ISupportInitialize)(this.timer1)).BeginInit();
			this.SuspendLayout();
			// 
			// bStartTimerThread
			// 
			this.bStartTimerThread.Location = new System.Drawing.Point(16, 16);
			this.bStartTimerThread.Name = "bStartTimerThread";
			this.bStartTimerThread.Size = new System.Drawing.Size(200, 23);
			this.bStartTimerThread.TabIndex = 0;
			this.bStartTimerThread.Text = "Start Timer-Thread";
			this.toolTip1.SetToolTip(this.bStartTimerThread, "Startet einen Timer-Thread mit minimalem Intervall (1 msec)");
			this.bStartTimerThread.Click += new System.EventHandler(this.bStartTimerThread_Click);
			// 
			// listBox1
			// 
			this.listBox1.Location = new System.Drawing.Point(8, 112);
			this.listBox1.Name = "listBox1";
			this.listBox1.Size = new System.Drawing.Size(232, 173);
			this.listBox1.TabIndex = 1;
			// 
			// bStartWindowsTimer
			// 
			this.bStartWindowsTimer.Location = new System.Drawing.Point(16, 48);
			this.bStartWindowsTimer.Name = "bStartWindowsTimer";
			this.bStartWindowsTimer.Size = new System.Drawing.Size(200, 23);
			this.bStartWindowsTimer.TabIndex = 2;
			this.bStartWindowsTimer.Text = "Start Windows-Timer";
			this.toolTip1.SetToolTip(this.bStartWindowsTimer, "Startet einen Windows-Timer mit minimalem Intervall (1 msec)");
			this.bStartWindowsTimer.Click += new System.EventHandler(this.bStartWindowsTimer_Click);
			// 
			// timer1
			// 
			this.timer1.Interval = 1;
			this.timer1.SynchronizingObject = this;
			this.timer1.Elapsed += new System.Timers.ElapsedEventHandler(this.timer1_Elapsed);
			// 
			// bStartServerTimer
			// 
			this.bStartServerTimer.Location = new System.Drawing.Point(16, 80);
			this.bStartServerTimer.Name = "bStartServerTimer";
			this.bStartServerTimer.Size = new System.Drawing.Size(200, 23);
			this.bStartServerTimer.TabIndex = 3;
			this.bStartServerTimer.Text = "Start Server-Timer";
			this.toolTip1.SetToolTip(this.bStartServerTimer, "Startet einen Severtimer-Thread mit minimalem Intervall (1 msec)");
			this.bStartServerTimer.Click += new System.EventHandler(this.bStartServerTimer_Click);
			// 
			// Form1
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(248, 293);
			this.Controls.Add(this.bStartServerTimer);
			this.Controls.Add(this.bStartWindowsTimer);
			this.Controls.Add(this.listBox1);
			this.Controls.Add(this.bStartTimerThread);
			this.Name = "Form1";
			this.Text = "ThreadTimer";
			((System.ComponentModel.ISupportInitialize)(this.timer1)).EndInit();
			this.ResumeLayout(false);

		}
		#endregion

		[STAThread]
		static void Main() 
		{
			Application.Run(new Form1());
		}

		private volatile int CBCount;

		/// <summary>
		/// Gemeinsame Zeitmessung und Button-Logik fr alle drei Timer
		/// </summary>
		private void DoTiming()
		{ 
      // Buttons aus, Startzeit festhalten, Zhler zurck
			bStartTimerThread.Enabled = false;
			bStartWindowsTimer.Enabled = false;
			bStartServerTimer.Enabled = false;

      CBCount = 0; // Zhler zurck, Startzeit festhalten
			DateTime StartTime = DateTime.Now;

			// Warten auf den ersten Rckruf
			while (CBCount == 0)
				Application.DoEvents();
			
			DateTime STime = DateTime.Now;
			listBox1.Items.Add(String.Format("Erste Ausfhrung nach {0} ms", 
				((TimeSpan)(STime-StartTime)).TotalMilliseconds));

			// Warten auf 1000 weitere Rckrufe  
			while (CBCount <= 1000)
				Application.DoEvents();

			DateTime EndTime = DateTime.Now;
			listBox1.Items.Add(String.Format("Zeit fr 1000 Rckrufe: {0} ms", 
				((TimeSpan)(EndTime-StartTime)).TotalMilliseconds));
		  listBox1.Items.Add("");

      // Buttons wieder an
			bStartTimerThread.Enabled = true;
			bStartWindowsTimer.Enabled = true;
			bStartServerTimer.Enabled = true;
		}

    // Rckruf fr den Thread-Timer; state bleibt null
		private void TimerCB(object State)
		{
			CBCount++;
		}

		private void bStartTimerThread_Click(object sender, System.EventArgs e)
		{  
			 // Start nach 100 MSec, Wiederholungsintervall 1 msec
			 System.Threading.Timer TD = new System.Threading.Timer(
				   new TimerCallback(TimerCB), null, 100, 1);
			 listBox1.Items.Add("Thread-Timer, 100 ms Startzeit, 1 ms Intervall");

			 DoTiming();

			 TD.Change(Timeout.Infinite, 0);  // Timer aus			 
		}

		// fr den Windows-Timer und den Server-Timer
		private void timer1_Elapsed(object sender, System.Timers.ElapsedEventArgs e)
		{
			CBCount++;
		}

		private void bStartWindowsTimer_Click(object sender, System.EventArgs e)
		{	
      // Windows-Timer ist eine Komponente & bereits verdrahtet
			timer1.Enabled = true;
			listBox1.Items.Add("Windows-Timer, 0 ms Startzeit, 1 ms Intervall");

			DoTiming();

			timer1.Enabled = false;  // Timer aus			 
	
		}

		private void bStartServerTimer_Click(object sender, System.EventArgs e)
		{ System.Timers.Timer ServerTimer  = new System.Timers.Timer();

      // Server-Timer gibt es nicht als visuelle Komponente
			ServerTimer.Interval = 1;
			ServerTimer.Elapsed += new ElapsedEventHandler(timer1_Elapsed);
			// Start nach 0 MSec, Wiederholungsintervall 1 msec
			ServerTimer.Enabled = true;
			listBox1.Items.Add("Server-Timer, 0 ms Startzeit, 1 ms Intervall");

			DoTiming();

			ServerTimer.Enabled = false ;  // Timer aus			 
		}
	}
}
