#!/usr/bin/perl -T
use warnings;
use strict;

use IO::Socket::INET;

# Anders als im abgedruckten Listing wird einiges parameterisiert,
# um die Anpassung zu erleichtern
my $CHROOT_DIR  = "/var/jail";
my $SERVER_PORT = 7;
my $LOGFILE     = "/var/log/perl-server.log";
my $RUNAS_USER  = "nobody";
my $RUNAS_GROUP = "nogroup";

# Zuerst Daemon werden, sofern wir nicht unter Windows laufen
unless ( $^O =~ /MSWin32/ ) {
    my $ppid = fork;
    exit if $ppid;
    die "fork: $!" unless defined $ppid;
}

# Das Logfile anlegen, um alles dahin umzuleiten
open LOG, ">$LOGFILE" or die "logfile: $!";
open STDERR, ">>&LOG";
select LOG;
$| = 1;

# Jetzt laufen wir im Hintergrund und ffnen das Master Socket
my $server = IO::Socket::INET->new(
    LocalPort => $SERVER_PORT,
    Proto     => 'tcp',
    Listen    => SOMAXCONN
  )
  or die "Konnte Port $SERVER_PORT nicht ffnen: $!";

# Auch die folgenden beiden Security-Features gibt es unter
# Windows nicht
unless ( $^O =~ /MSWin32/ ) {

    # Die Auflsung des Namens in die nummerischen IDs
    # muss vor dem chroot stehen, weil dazu /etc/passwd
    # und /etc/group erreichbar sein mssen
    my $uid = getpwnam($RUNAS_USER);
    my $gid = getgrnam($RUNAS_GROUP);

    # Erstmal nachsehen, ob das Verzeichnis schon existiert
    # und es gegebenenfalls anlegen
    mkdir $CHROOT_DIR unless -e $CHROOT_DIR;

    # Wenn es ein Verzeichnis ist, wechseln wir hinein
    warn "chroot: $!\n"
      unless -d $CHROOT_DIR
      and chroot $CHROOT_DIR;

    # Jetzt die Privilegien abwerfen
    $) = "$gid $gid" if $gid;
    $> = $uid if $uid;
}

# Am Ende eines Kind-Prozesses muss der Vater nichts unternehmen
$SIG{CHLD} = 'IGNORE';

while (1) {

    # Auf eine Verbindung warten
    die "Fehler in accept: $!"
      unless defined( my $client = $server->accept() );

    # Ein Kind zu ihrer Behandlung zeugen
    my $pid = fork;
    die "fork: $!" unless defined $pid;

    if ($pid) {

        # Dies hier tut der Vater-Prozess
        close $client;
    }
    else {

        # Die tut das Kind
        close $server;
        protokoll($client);
        exit;
    }
}

# Die Behandlung des Protokolls
sub protokoll {
    my $sock = shift;
    print $sock $_ while <$sock>;
}
