	.module smd.c
	.area lit
_abHalfPattern::
	.byte 21,49
	.byte 23,15
	.byte 22,50
	.byte 20,12
	.dbfile F:\hwb\ct\0405\ct03\smd.c
	.dbsym e abHalfPattern _abHalfPattern A[8:8]c
_abFullPattern::
	.byte 0,2
	.byte 3,1
	.byte 0,2
	.byte 3,1
	.dbsym e abFullPattern _abFullPattern A[8:8]c
	.area text
	.dbfile F:\hwb\ct\0405\ct03\smd.c
	.dbfunc e vSmdDummy _vSmdDummy fV
	.even
_vSmdDummy::
	.dbline -1
	.dbline 97
; /* smd.c: Schrittmotorsteuerung
; 
;    Jens Altenburg / c't
; */
; 
; 
; /***************************************************************************
; * HEADER-FILES (Only those that are needed in this file)                   *
; ****************************************************************************/
; /* System-headerfiles */
; #include "cdef.h"                      /* General definitions and types */
; 
; /* Own headerfiles */
; #include "smd.h"
; 
; /* Foreign headerfiles */
; #include <stdlib.h>
; 
; /***************************************************************************
; *    Konstaten                                                             *
; ****************************************************************************/
; const byte abHalfPattern[] = {0x15, 0x31, 0x17, 0x0f, 0x16, 0x32, 0x14, 0x0c};
; const byte abFullPattern[] = {0x00, 0x02, 0x03, 0x01, 0x00, 0x02, 0x03, 0x01};
; 
; #define nTableSize       7          /* Maske fr Index in Bitmustertabelle */
; #define nSmdMask         0x3f
; #define mcSetDriver(x)   (P1OUT = (P1OUT & ~nSmdMask) | x)
; #define nRampSize        8
; #define nSmdLowSpeed     60000          /* niedrige Geschwindigkeit */
; #define nSmdHighSpeed    5000           /* Hchstgeschwindigkeit */
; 
; /***************************************************************************
; *    Variablen                                                             *
; ****************************************************************************/
; byte bSmdState; /*
; * Description : Variable fr Zustandsautomat
; */
; 
; fCallBackSmd fSmdFunc; /*
; * Description : Callbackfunktion fr Benachrichtigung
; */
; 
; const byte *pBitMuster; /*
; * Description : Index auf Bitmuster
; */
; 
; byte bRamp; /*
; * Description : Index auf Rampe
; */
; 
; dword dwSteps; /*
; * Description : Schrittzahl
; */
; 
; int8 i8Dir; /*
; * Description : Decrement/Increment
; */
; 
; byte bSmdCount; /*
; * Description : Schrittzhler
; */
; 
; word awRamp[nRampSize]; /*
; * Description : Beschleunigung/Bremsung
; */
; 
; 
; /* Zugriffsmakros fr Merkflags */
; 
; 
; 
; /***************************************************************************
; * Defines und Makros Zugriff                                               *
; ****************************************************************************/
; enum {
;      enSmdInit = 0,                /* tut nix */
;      enSmdPrep1,                   /* Start-Stop vorbereiten */
;      enSmdPrep2,                   /* Normalmode vorbereiten */
;      enSmdStartStop,               /* Start-Stop-Mode */
;      enSmdRampUp,                  /* Beschleunigung */
;      enSmdMove,                    /* Drehung */
;      enSmdRampDown,                /* Bremsen */
;      };
; 
; #define mcPowerOn()	      (P1OUT &= ~0x40)
; #define mcPowerOff()	  (P1OUT |=  0x40)						   
; 
; 
; /***************************************************************************
; *    Code                                                                  *
; ****************************************************************************/
; 
; /***************************************************************************
; *    Funktion: Dummy fr Benachrichtigungsfunktion                         *
; *    Autor:    Jens Altenburg                                              *
; ****************************************************************************/
; void vSmdDummy( void ){
	.dbline -2
	.dbline 98
;       }
L2:
	.dbline 0 ; func end
	ret
	.dbend
	.dbfunc e SMD_vCritical _SMD_vCritical fV
	.even
_SMD_vCritical::
	.dbline -1
	.dbline 104
; 
; /***************************************************************************
; *    Funktion: Not-Aus, Motor wird sofort gestoppt                         *
; *    Autor:    Jens Altenburg                                              *
; ****************************************************************************/
; void SMD_vCritical( void ){
	.dbline -2
	.dbline 106
; 
;      }
L3:
	.dbline 0 ; func end
	ret
	.dbend
	.dbfunc e SMD_vInit _SMD_vInit fV
	.even
_SMD_vInit::
	.dbline -1
	.dbline 113
; 
; /***************************************************************************
; *    Funktion: Initialisierung                                             *
; *                                                                          *
; *    Autor:    Jens Altenburg                                              *
; ****************************************************************************/
; void SMD_vInit( void ){
	.dbline 114
;      fSmdFunc = vSmdDummy;                   /* Callbackfunktion initialisieren */
	mov #_vSmdDummy,R13
	mov R13,_fSmdFunc
	.dbline 115
;      bSmdState = enSmdInit;
	mov.b #0,_bSmdState
	.dbline -2
	.dbline 116
;      }
L4:
	.dbline 0 ; func end
	ret
	.dbend
	.dbfunc e SMD_vStart _SMD_vStart fV
;              w -> R4
;              i -> R5
;             iW -> 10(SP)
;           wMax -> R5
;           bTyp -> R4
;           fSmd -> R6
	.even
_SMD_vStart::
	push R4
	push R5
	push R6
	mov R15,R4
	mov R14,R6
	mov 8(R1),R5
	.dbline -1
	.dbline 131
; 
; 
; /***************************************************************************
; *    Funktion: Kommunikationsinterface zum Schrittmotortreiber             *
; *              - Benachritigungsfunktion initialisieren                    *
; *              - Bewegungsmode einstellen                                  *
; *              - Hochlaufkurve berechnen                                   *
; *              - Schrittzahl einstellen                                    *
; *    Autor:    Jens Altenburg                                              *
; ****************************************************************************/
; void SMD_vStart ( fCallBackSmd fSmd,    /* Benachrichtigung */
;                   byte bTyp,            /* Bewegungstyp, Halbschritt, Vollschritt */
;                   word wMax,            /* Maximalgeschwindigkeit */
;                   int32 iW              /* Schrittzahl, Vorzeichen = Drehrichtung */
;                 ){
	.dbline 134
;      word w;
;      byte i;
; 	 fSmdFunc = fSmd;                   /* Benachrichtigungsfunktion */
	mov R6,_fSmdFunc
	.dbline 135
;      if(iW == 0){
	mov #0,R14
	mov #0,R15
	push 14(R1)
	push 14(R1)
	call #cmp32
	jne L6
	.dbline 135
	.dbline 136
; 	 	   fSmdFunc();
	call _fSmdFunc
	.dbline 137
; 		   return;                		/* Schrittzahl 0 abfangen */
	jmp L5
L6:
	.dbline 139
; 		   }
;      if(iW >= 0){                       /* Drehrichtung festlegen */
	mov 10(R1),R14
	mov 12(R1),R15
	push #0
	push #0
	call #cmp32
	jl L8
	.dbline 139
	.dbline 140
;           dwSteps = iW;
	mov 10(R1),_dwSteps
	mov 12(R1),_dwSteps+2
	.dbline 141
;           i8Dir = 1;
	mov.b #1,_i8Dir
	.dbline 142
;           }
	jmp L9
L8:
	.dbline 143
;      else {
	.dbline 144
;           dwSteps = -iW;
	mov 10(R1),R12
	mov 12(R1),R13
	inv R12
	inv R13
	add #1,R12
	addc #0,R13
	mov R12,_dwSteps
	mov R13,_dwSteps+2
	.dbline 145
;           i8Dir = -1;
	mov.b #-1,_i8Dir
	.dbline 146
;           }
L9:
	.dbline 147
;      if(bTyp){                          /* Unterscheidung Halb/Vollschritt */
	cmp.b #0,R4
	jeq L10
	.dbline 147
	.dbline 148
;           pBitMuster = &abHalfPattern[0];
	mov #_abHalfPattern,R13
	mov R13,_pBitMuster
	.dbline 149
;           }
	jmp L11
L10:
	.dbline 150
;      else {
	.dbline 151
;           pBitMuster = &abFullPattern[0];
	mov #_abFullPattern,R13
	mov R13,_pBitMuster
	.dbline 152
;           }
L11:
	.dbline 154
;      /* Hochlauframpe berechnen */
;      if(wMax < nSmdHighSpeed) wMax = nSmdHighSpeed; /* Maximalgeschwindigkeit begrenzen */
	cmp #5000,R5
	jhs L12
	.dbline 154
	mov #5000,R5
L12:
	.dbline 155
;      if(wMax > (nSmdLowSpeed - nRampSize)){
	mov #59992,R13
	cmp R5,R13
	jhs L14
	.dbline 155
	.dbline 156
;           wMax = nSmdLowSpeed - nRampSize;
	mov R13,R5
	.dbline 157
;           }
L14:
	.dbline 158
;      if(dwSteps < (2 * nRampSize)){     /* nur Start-Stop Geschwindigkeit */
	mov _dwSteps,R14
	mov _dwSteps+2,R15
	push #0
	push #16
	call #cmp32
	jhs L16
	.dbline 158
	.dbline 159
;           awRamp[0] = nSmdLowSpeed;
	mov #60000,_awRamp
	.dbline 160
;           bSmdState = enSmdPrep1;       /* Bewegung vorbereiten */
	mov.b #1,_bSmdState
	.dbline 161
;           }
	jmp L17
L16:
	.dbline 162
;      else {
	.dbline 163
;           w = nSmdLowSpeed - wMax;      /* Differenzgeschwindigkeit */
	mov #60000,R4
	sub R5,R4
	.dbline 164
;           w = w / nRampSize;            /* Geschwindigkeitsschritte */
	clrc
	rrc R4
	rra R4
	rra R4
	.dbline 165
	mov.b #0,R5
	jmp L21
L18:
	.dbline 165
	.dbline 166
	mov R5,R13
	and #255,R13
	add #1,R13
	push SR
	dint
	nop
	mov R4,&0x130
	mov R13,&0x138
	mov &0x13A,R13
	pop SR
	mov #60000,R12
	sub R13,R12
	mov #_awRamp,R13
	mov R5,R11
	and #255,R11
	add R11,R11
	add R13,R11
	mov R12,0(R11)
	.dbline 167
L19:
	.dbline 165
	add.b #1,R5
L21:
	.dbline 165
	cmp.b #8,R5
	jlo L18
	.dbline 168
	mov _dwSteps,R12
	mov _dwSteps+2,R13
	sub #16,R12
	subc #0,R13
	mov R12,_dwSteps
	mov R13,_dwSteps+2
	.dbline 169
	mov.b #2,_bSmdState
	.dbline 170
L17:
	.dbline -2
	.dbline 171
; 		  for(i = 0; i < nRampSize; i++){
;                awRamp[i] = nSmdLowSpeed - w * (i + 1);
;                }
;           dwSteps -= 2 * nRampSize;     /* Schritte mit Hchstgeschwindigkeit */
;           bSmdState = enSmdPrep2;       /* Bewegung vorbereiten */
;           }
;      }
L5:
	pop R6
	pop R5
	pop R4
	.dbline 0 ; func end
	ret
	.dbsym r w 4 i
	.dbsym r i 5 c
	.dbsym l iW 10 L
	.dbsym r wMax 5 i
	.dbsym r bTyp 4 c
	.dbsym r fSmd 6 pfV
	.dbend
	.dbfunc e SMD_wMove _SMD_wMove fi
;              i -> R5
;          wTime -> R4
	.even
_SMD_wMove::
	push R4
	push R5
	.dbline -1
	.dbline 179
; 
; 
; /***************************************************************************
; *    Funktion: Interruptservive-Funktion zur Motorsteuerung                *
; *                                                                          *
; *    Autor:    Jens Altenburg                                              *
; ****************************************************************************/
; word SMD_wMove  ( void ){                    /* Bewegungserzeugung */
	.dbline 182
	mov.b _bSmdState,R4
	and #255,R4
	cmp #0,R4
	jeq L26
	cmp #1,R4
	jeq L27
	cmp #2,R4
	jeq L28
	cmp #3,R4
	jeq L29
	cmp #4,R4
	jeq L32
	cmp #5,R4
	jeq L35
	cmp #6,R4
	jeq L39
	jmp L23
X0:
	.dbline 182
;      byte i;
;      word wTime;
;      switch(bSmdState){
L26:
	.dbline 184
;           case enSmdInit:                    /* tut nix */
;                mcPowerOff();                 /* Haltestrom einstellen */
	or.b #64,&0x21
	.dbline 185
;                wTime = nSmdLowSpeed;         /* Zeitspanne bis zum nchsten Aufruf */
	mov #60000,R4
	.dbline 186
;                break;
	jmp L24
L27:
	.dbline 188
;           case enSmdPrep1:                   /* Start-Stop vorbereiten */
;                mcPowerOn();
	and.b #-65,&0x21
	.dbline 189
;                wTime = awRamp[0];            /* Zeit aus Rampentabelle */
	mov _awRamp,R4
	.dbline 190
;                bSmdState = enSmdStartStop;
	mov.b #3,_bSmdState
	.dbline 191
;                break;
	jmp L24
L28:
	.dbline 193
;           case enSmdPrep2:                   /* Normalmode vorbereiten */
;                mcPowerOn();
	and.b #-65,&0x21
	.dbline 195
;                //P2OUT &= ~0x01;
; 			   wTime = awRamp[0];
	mov _awRamp,R4
	.dbline 196
;                bRamp = 0;
	mov.b #0,_bRamp
	.dbline 197
; 			   bSmdState = enSmdRampUp;
	mov.b #4,_bSmdState
	.dbline 198
;                break;
	jmp L24
L29:
	.dbline 200
;           case enSmdStartStop:               /* Start-Stop-Mode */
;                i = bSmdCount & nTableSize;   /* Offset fr Zeiger auf Tabelle begrenzen */
	mov.b _bSmdCount,R5
	and.b #7,R5
	.dbline 201
;                mcSetDriver(*(pBitMuster+i));
	mov R5,R13
	and #255,R13
	add _pBitMuster,R13
	mov.b @R13,R13
	and #255,R13
	mov.b &0x21,R12
	and #192,R12
	or R13,R12
	mov R12,R13
	mov.b R13,&0x21
	.dbline 202
;                bSmdCount += i8Dir;           /* nchster Schritt */
	add.b _i8Dir,_bSmdCount
	.dbline 203
;                dwSteps--;
	mov _dwSteps,R12
	mov _dwSteps+2,R13
	sub #1,R12
	subc #0,R13
	mov R12,_dwSteps
	mov R13,_dwSteps+2
	.dbline 204
;                if(dwSteps == 0){
	mov #0,R14
	mov #0,R15
	push _dwSteps+2
	push _dwSteps
	call #cmp32
	jne L30
	.dbline 204
	.dbline 205
; 			          bSmdState = enSmdInit;
	mov.b #0,_bSmdState
	.dbline 206
;  					  fSmdFunc();
	call _fSmdFunc
	.dbline 207
; 					  } 
L30:
	.dbline 208
;                wTime = awRamp[0];            /* Schrittzeit */
	mov _awRamp,R4
	.dbline 209
;                break;
	jmp L24
L32:
	.dbline 211
;           case enSmdRampUp:                  /* Beschleunigung */
;                i = bSmdCount & nTableSize;   /* Zeiger auf Bitmuster berechnen */
	mov.b _bSmdCount,R5
	and.b #7,R5
	.dbline 212
;                mcSetDriver(*(pBitMuster+i));
	mov R5,R13
	and #255,R13
	add _pBitMuster,R13
	mov.b @R13,R13
	and #255,R13
	mov.b &0x21,R12
	and #192,R12
	or R13,R12
	mov R12,R13
	mov.b R13,&0x21
	.dbline 213
;                bSmdCount += i8Dir;           /* nchster Schritt */
	add.b _i8Dir,_bSmdCount
	.dbline 214
;                bRamp++;
	add.b #1,_bRamp
	.dbline 215
;                wTime = awRamp[bRamp];
	mov #_awRamp,R13
	mov.b _bRamp,R12
	and #255,R12
	add R12,R12
	add R13,R12
	mov @R12,R4
	.dbline 216
;                if(bRamp >= nRampSize - 1) bSmdState = enSmdMove;
	cmp.b #7,_bRamp
	jlo L24
	.dbline 216
	mov.b #5,_bSmdState
	.dbline 217
;                break;
	jmp L24
L35:
	.dbline 219
;           case enSmdMove:                    /* Drehung */
;                i = bSmdCount & nTableSize;   /* Zeiger auf Bitmuster berechnen */
	mov.b _bSmdCount,R5
	and.b #7,R5
	.dbline 220
;                mcSetDriver(*(pBitMuster+i));
	mov R5,R13
	and #255,R13
	add _pBitMuster,R13
	mov.b @R13,R13
	and #255,R13
	mov.b &0x21,R12
	and #192,R12
	or R13,R12
	mov R12,R13
	mov.b R13,&0x21
	.dbline 221
;                bSmdCount += i8Dir;           /* nchster Schritt */
	add.b _i8Dir,_bSmdCount
	.dbline 222
;                dwSteps--;
	mov _dwSteps,R12
	mov _dwSteps+2,R13
	sub #1,R12
	subc #0,R13
	mov R12,_dwSteps
	mov R13,_dwSteps+2
	.dbline 223
;                if(dwSteps == 0) bSmdState = enSmdRampDown;
	mov #0,R14
	mov #0,R15
	push _dwSteps+2
	push _dwSteps
	call #cmp32
	jne L36
	.dbline 223
	mov.b #6,_bSmdState
L36:
	.dbline 224
;                wTime = awRamp[nRampSize - 1];
	mov _awRamp+14,R4
	.dbline 225
;                break;
	jmp L24
L39:
	.dbline 227
;           case enSmdRampDown:                /* Bremsen */
;                i = bSmdCount & nTableSize;   /* Zeiger auf Bitmuster berechnen */
	mov.b _bSmdCount,R5
	and.b #7,R5
	.dbline 228
;                mcSetDriver(*(pBitMuster+i));
	mov R5,R13
	and #255,R13
	add _pBitMuster,R13
	mov.b @R13,R13
	and #255,R13
	mov.b &0x21,R12
	and #192,R12
	or R13,R12
	mov R12,R13
	mov.b R13,&0x21
	.dbline 229
;                bSmdCount += i8Dir;           /* nchster Schritt */
	add.b _i8Dir,_bSmdCount
	.dbline 230
;                bRamp--;
	sub.b #1,_bRamp
	.dbline 231
;                wTime = awRamp[bRamp];
	mov #_awRamp,R13
	mov.b _bRamp,R12
	and #255,R12
	add R12,R12
	add R13,R12
	mov @R12,R4
	.dbline 232
;                if(bRamp == 0){
	cmp.b #0,_bRamp
	jne L24
	.dbline 232
	.dbline 233
;                     bSmdState = enSmdInit;
	mov.b #0,_bSmdState
	.dbline 234
;                     fSmdFunc();              /* Motorbewegung ist beendet */
	call _fSmdFunc
	.dbline 236
;                     //P2OUT |= 0x01;
; 					}
	.dbline 237
;                break;
L23:
L24:
	.dbline 239
;           }
;      return wTime;
	mov R4,R14
	.dbline -2
L22:
	pop R5
	pop R4
	.dbline 0 ; func end
	ret
	.dbsym r i 5 c
	.dbsym r wTime 4 i
	.dbend
	.area bss
	.dbfile F:\hwb\ct\0405\ct03\smd.c
	.even
_awRamp::
	.blkb 16
	.dbsym e awRamp _awRamp A[16:8]i
_bSmdCount::
	.blkb 1
	.dbsym e bSmdCount _bSmdCount c
_i8Dir::
	.blkb 1
	.dbsym e i8Dir _i8Dir C
	.even
_dwSteps::
	.blkb 4
	.dbsym e dwSteps _dwSteps l
_bRamp::
	.blkb 1
	.dbsym e bRamp _bRamp c
	.even
_pBitMuster::
	.blkb 2
	.dbsym e pBitMuster _pBitMuster pc
	.even
_fSmdFunc::
	.blkb 2
	.dbsym e fSmdFunc _fSmdFunc pfV
_bSmdState::
	.blkb 1
	.dbsym e bSmdState _bSmdState c
	.area lit
	.even
	.area idata
	.even
	.area data
	.even
	.area bss
	.even
