'======================================================================
'berarbeitet: 	10.03.2004 Jochen Bierbauer
'Urversion: 	Myrko Leitner 
'Funktion: 		Script ermittelt durch bergegenen Windows-Benutzernamen
'				die zugehrige Mailadresse aus dem Active Directory.
'Parameter:		Auer dem Windows-Benutzer keine erforderlich
'======================================================================
set args = wscript.arguments
CheckForUser(args(0))
function CheckForUser(strUserName)

    '===================================================================
    'Create ADO command object for the connection.
    '===================================================================
    Set objConnection = CreateObject("ADODB.Connection")
    objConnection.Provider = "ADsDSOObject"
    objConnection.Open "Active Directory Provider"

    Set objCommand = CreateObject("ADODB.Command")
    objCommand.ActiveConnection = objConnection

	'===================================================================
    'Get the ADsPath for the domain to search.
    '===================================================================
    Set root = GetObject("LDAP://rootDSE")
    sDomain = root.get("defaultNamingContext")
    Set Domain = GetObject("LDAP://" & sDomain)

	'===================================================================
    'Build the ADsPath element of the commandtext
    '===================================================================
    sADsPath = "<" & Domain.ADsPath & ">"

    '======================================================================
    'Build the returned attributes element of the commandtext.
    '======================================================================
    sAttribsToReturn = "mail"

    '===================================================================
    'Build the filter element of the commandtext
    '===================================================================
    If (strUserName = "") Then
      sFilter = "(&(objectCategory=person)(objectClass=user))"
    Else
      sFilter = "(&(objectCategory=person)(objectClass=user)(cn=" & strUserName & "))"
    End If
	
	'===================================================================
    'Build the depth element of the commandtext.
    '===================================================================
    sDepth = "subTree"
	
	'===================================================================
    'Assemble the commandtext.
    '===================================================================
    objcommand.CommandText = sADsPath & ";" & sFilter & ";" & sAttribsToReturn & ";" & sDepth

    Set objRecordSet = objCommand.Execute

    WScript.echo "set mailadress=" & objRecordSet("mail")

    objConnection.Close

End function