unit STunit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, AudioIO, ExtCtrls, Buttons, ComCtrls, MMSYSTEM;

const freq:integer=3600;
const buffsize=4096; //= 4096 x 1 oder 2048 x 2
const deltaupdown2:integer=100;
const diffmax=20;

type headertype=packed record
     name:array[1..16] of char;
     flags:byte;
     start:word;
     size:word;
     res:longword;
     prsum:word;
     end;


type Pwavheader=^wavheader;
     wavheader= packed record
     riff            : array[1..4] of char;
     rifflen         : longword;
     WAVE            : array[1..4] of char;
     fmt_            : array[1..4] of char;
     fmt_len         : longword;
     fm              : Waveformat_tag; // in MMSystem
     case boolean of
       true:(PCM_nBitspersample:word);
       false:(w1:word);
     end;

type PPCMData=^PCMData;
     PCMData= packed record
      data:array[1..4] of char;
      datalen:longword;
      buffer:array of byte;
     end;

type recordstatustype=(waitforpause,waitforsignal,recordactive,recordstop);


type
  TForm1 = class(TForm)
    StartButton: TButton;
    Timer1: TTimer;
    RunStatusLabel: TLabel;
    BufferStatusLabel: TLabel;
    TimeStatusLabel: TLabel;
    Panel1: TPanel;
    RecordSpeedButton: TSpeedButton;
    ProgressBar1: TProgressBar;
    MaxLabel: TLabel;
    AudioIn1: TAudioIn;
    Image1: TImage;
    Filltime: TLabel;
    rResolution: TRadioGroup;
    UpDown1: TUpDown;
    xvers: TLabel;
    Bitmuster: TLabel;
    lsyncanz: TLabel;
    Memo1: TMemo;
    TrackBarSchwelle: TTrackBar;
    Label1: TLabel;
    Label2: TLabel;
    Freqlabel: TLabel;
    lrecbuf: TLabel;
    UpDown2: TUpDown;
    abLabel: TLabel;
    bislabel: TLabel;
    StatusBar1: TStatusBar;
    OpenDialog1: TOpenDialog;
    Graph: TRadioGroup;
    TrackBar1: TTrackBar;
    LineInvol: TTrackBar;
    rInput: TRadioGroup;
    rOutput: TRadioGroup;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Procedure WritelnC (const s:string; const Args: array of const);
    Procedure WriteAdd (const s:string; const Args: array of const);
    procedure StartButtonClick(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure AudioIn1Stop(Sender: TObject);
    procedure UpdateStatus;
    procedure RecordSpeedButtonClick(Sender: TObject);
    Procedure Initgraph;
    Procedure Setpoint (x:integer;v,v1:smallint;isflanke:boolean;diff:double);
    Procedure Showgraph;
    Procedure Getminmax (size:integer);

    function AudioIn1BufferFilled(Buffer: PChar;
      var Size: Integer): Boolean;
    Procedure InterpretBuffer(ab,bis:Integer;SuperTape:boolean);
    procedure FormCreate(Sender: TObject);
    procedure StopbuttonClick(Sender: TObject);
    procedure rResolutionClick(Sender: TObject);
    procedure UpDown1Click(Sender: TObject; Button: TUDBtnType);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure Stopprec;
    procedure LoginNxtdat;
    Function  getvalue (x:integer):smallint;
    procedure UpDown2Click(Sender: TObject; Button: TUDBtnType);
    procedure InitInterpreter;
    procedure InterpretSTheader;
    procedure InterpretSTData;
    procedure InterpretSuperTape (i:integer;var diff,aktflanke:double);
    procedure Image1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure TrackBarSchwelleChange(Sender: TObject);
    procedure GraphClick(Sender: TObject);
    procedure TrackBar1Change(Sender: TObject);
    procedure Memo1Click(Sender: TObject);
    function Getmixer(auxtype:integer):integer;
    procedure LineInvolChange(Sender: TObject);
    procedure InitRawOutDat;
    Procedure InitRawInDat (const name:string);
    Procedure InitBinOutDat;
    procedure Image1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    //Procedure InitBinInDat;
  private
    { Private declarations }
    Vol:UINT;
    LineinDevice:integer;
    cursor1,cursor2:double;
    Min, Max,v1,V2 : smallint;
    xMin, xMax,TempMax  : smallint;
    mittelwert:smallint;
    xv:double;
    flankeup, flankedown: boolean;
    bitcount:integer;
    letzteflanke:double;
    s:shortstring;
    zwischenflanke:boolean;
    withscope:boolean;
    maxdiff:double;
    buffcount:integer;
    aktschwelle:smallint;
    rawindat,rawoutdat:file;
    binindat,binoutdat:file of byte;
    binoutopen:boolean;
    fs:integer;
    fp:integer;
    prsumx:word;
    xAb,xBis:integer;
    yp0:integer;
    headerlen:integer;
    bufferloaded:boolean;
    prsum,prsumD,prsumh:word;
    recordstatus:recordstatustype;
    diskrim:double;
    maxdiffhigh,maxdifflow,mindiffhigh,
    mindifflow,avgdiffhigh,avgdifflow:double;
    diffhighcount,difflowcount:integer;
    maxdifflowpos,maxdiffhighpos,mindifflowpos,mindiffhighpos:integer;
    ny:double;
  public
  end;



var
  Form1: TForm1;

implementation

{$R *.DFM}

type loadstatustype=(syncbit,syncbyte,loadHeader,loaddata,dataloaded);
var loadstatus:loadstatustype;
var d:byte;
var bitnr:byte;
var syncanz:integer;
var diffarray:array[0..100] of integer;
var header:headertype;
var headera:array[0..25] of byte absolute header;
var headerptr:integer;
var data:array[0..$FFFF] of byte;
var dataptr:integer;
var trigger:boolean;
var triggeroffs:double;
var bit:byte;

var nbuffer: array [0..buffsize-1] of byte; // bei 8 Bit PCM
var mass:double;
var mittwert:integer;
var qf:int64;
var Interpretaktiv:boolean;
var headerok:boolean;

Procedure CloseFileX(var F);
begin
if TFilerec(F).Handle <> 0 then CloseFile(File(F));
TFilerec(F).Handle:=0;
end;



// hng halt dran ..)
Procedure Tform1.WritelnC (const s:string; const Args: array of const);
begin
memo1.lines.add (Format(s,Args));
end;

Procedure Tform1.Writeadd (const s:string; const Args: array of const);
begin
 with memo1 do  lines[lines.count-1]:=lines[lines.count-1]+format(s,Args);
end;

Function Tform1.Getmixer(AUXType:integer):integer;
var mresult:mmresult;
var AuxCaps     : TAuxCaps;
var pmxl:MIXERLINE;
var i:integer;
begin
 Result:=-1;
 for i := 0 to auxGetNumDevs - 1 do
          begin
             mresult:=auxGetDevCaps(I, @AuxCaps, SizeOf(AuxCaps));
             if mresult <>  MMSYSERR_NOERROR then exit;
             if ((AuxCaps.dwSupport and AUXCAPS_VOLUME) <> 0) and
                ((AuxCaps.wTechnology and  AUXType) <> 0 ) then
                begin
                  Result := i;
                  break;
                end;
          end;
if result=-1 then exit;
pmxl.cbStruct:=sizeof(pmxl);
mresult:=MixerGetLineInfo(Result,@pmxl, MIXER_OBJECTF_AUX);
end;



Procedure TForm1.Stopprec;
begin
  if TFilerec(Rawoutdat).Handle <>0 then
   begin
   CloseFileX (rawoutdat);
   if buffcount=0 then
    begin
    erase (rawoutdat);
    memo1.Lines.add ('Keine Daten aufgenommen');
    end
    else memo1.Lines.add ('Aufnahme von '+ inttostr(buffcount*buffsize)+ 'samples =>'+TFilerec(rawoutdat).name);
    end;
  Recordstatus:=Recordstop;

end;


Procedure TForm1.Getminmax (size:integer);
var
  i     :  integer;
  v     : Smallint;

begin
  xMin := getvalue(0);
  xMax := xMin;
  For i := 0 to size-1 Do
     Begin
      v:=getvalue(i);
      If (xMin > v) Then xMin := v;
      If (xMax < v) Then xMax := v;
   end;
  If (Min > xMin) Then Min := xMin;
  If (Max < xMax) Then Max := xMax;
  TempMax := xMax;
  If (Abs(xMin) > xMax) Then TempMax := Abs(xMin);
  If (Abs(Min) > Max) Then Max := Abs(Min);
end;



function TForm1.AudioIn1BufferFilled(Buffer:Pchar;var Size:integer):Boolean;
  Var ta,te:int64;
  Var N:integer;
  begin
  queryperformancecounter(ta);
  N := Size Div (audioin1.quantization div 8) ;
  move (buffer^,nbuffer,N);
  Getminmax (size);
  with trackBarSchwelle do aktschwelle:=round((1 shl audioin1.Quantization)*(max-position)/deltaupdown2);
  Result := TRUE;
  case recordstatus of
   waitforpause:  if TempMax < aktschwelle  then
                    begin recordstatus:=waitforSignal; memo1.Lines.add('Warte auf Signal') end;
   waitforsignal: if TempMax >=aktschwelle  then
                    begin recordstatus:=Recordactive; memo1.Lines.add('Aufnahme in Gang') end;
   Recordactive:  if Tempmax < aktschwelle  then
                    begin recordstatus:=Recordstop; memo1.Lines.add ('Aufnahme gestoppt') end;
  end;
  case recordstatus of
     Recordactive: begin

                   if rOutput.itemindex =1 then
                    begin // Buffer als Raw-Datei ablegen
                       Blockwrite (rawoutdat,nbuffer,1);
                       inc (buffcount);
                    end;
                    if (graph.ItemIndex <>0) or (rOutput.itemindex=2)
                     then InterpretBuffer (0,N-1,rOutput.itemindex=2);
                 end;
      Recordstop:
                begin
                 case rOutput.itemindex of
                  0:; //Line- in => line-out macht der Mixer
                  1:  begin       // Buffer als Raw-Datei ablegen
                      if buffcount < 10 then
                         begin
                         rewrite(rawoutdat,buffsize); //  waren wohl nur Knackser
                         memo1.Lines.Add('Aufnahme verworfen')
                         end
                       else
                          begin
                          stopprec;  // abspeichern
                          Loginnxtdat; // nchste Datei
                          end;
                       buffcount:=0;
                      end;
                  2 : begin
                      if loadstatus <> dataloaded then memo1.lines.add ('nix Supertape geladen');
                      end
                  end;
               Recordstatus:=waitforsignal;
               memo1.lines.add('Warte auf Signal');
               end;
       end;

  queryperformancecounter(te);
  Filltime.caption:=Format (' %6.3f ms / %6.3f ms %d',[1e3*(te-ta)/Qf,1e3*N/audioin1.framerate,N]);
 end;

var debug:integer;

Function TForm1.getvalue (x:integer):smallint;
var buffnr:integer;
var p:integer;
begin
if x < 0 then exit;
if Audioin1.quantization=8 then p:=x+headerlen else p:=2*x+headerlen;
if (rInput.itemindex=1) and ((p <fp) or (p >= fp+buffsize)) then
 begin
 buffnr:=(p div buffsize);
 if buffnr >= fs then
   begin
   getvalue:=0;
   exit;
   end;

 fp:=buffnr*buffsize;
 seek (rawindat,buffnr);
 blockread(rawindat,nbuffer,1);
 end;
if Audioin1.quantization=8 then getvalue:=nbuffer[p-fp]-$80
else getvalue:=smallint(pointer(@nbuffer[p-fp])^);
With TrackbarSchwelle do if position <> max then if abs(result) < aktschwelle then result:=0;

end;


Procedure TForm1.Initgraph;

Procedure Mark (x:double;col:integer);
var xp:integer;
  begin
  if (x < xAb) or (x > xBis) then exit;
  xp:=round((x-xAb-triggeroffs)*xv);
  with image1,canvas do
   begin
   pen.color:=col;
   moveto(xp,top);
   lineto(xp,0);
   end;
  end;

begin
 xAb:=round(upDown2.position*deltaupdown2);
 xBis:=xAb+trunc(image1.width/xv);
 yp0:=image1.height div 2;

 with image1,canvas do
   begin
   FillRect(Rect(0,0,width,height));
   if graph.itemindex = 3 then
    begin
     pen.Color:=clYellow;
     moveto (0,height-round(diskrim*height/diffmax));
     lineto (width,height -round(diskrim*height/diffmax));
     pen.color:=clblack;
    end;

    mark(cursor1,clred);
    mark(cursor2,clblue);
    pen.color:=clblack;
    moveto (0,yp0+round(xmin*mass));
   end;
 //trigger:=false;
 trigger:=true;
 triggeroffs:=0;
 ablabel.caption :=inttostr(xAb);
 bislabel.caption:=inttostr(xBis);
end;


Procedure TForm1.setpoint (x:integer;v,v1:smallint;isflanke:boolean;diff:double);
 var xp,yp,xp1:integer;
 var delta:double;

begin
 if not trigger then exit;
 xp:=round((x-xAb-triggeroffs)*xv);
 if (xp > image1.width) or (xp < 0 )then exit;

 case graph.itemindex of
     1,2: begin
        yp:=yp0  - round (v*mass);
        image1.canvas.LineTo(xp,yp);
        if isflanke and (Graph.itemindex=2) then
         begin
          delta:=abs (v/v1) /(abs(v/v1)+1);
          xp1:= round((x-xAb-triggeroffs-delta)*xv);
          image1.Canvas.pen.Color:=clyellow;
          image1.Canvas.MoveTo(xp1,0);
          image1.canvas.LineTo(xp1,yp0);
          image1.Canvas.MoveTo(xp,yp);
          Image1.Canvas.Pen.Color:=clblack;
          end;
         end;
      3: begin
         yp:= round (image1.height-diff*image1.height/diffmax);
         image1.canvas.Pixels[xp,yp]:=clBlack;
         end;
  end;

end;




Function ZX81toASC (zx:char):char;
const zxchar=
#0'..........\#$:?()><=+-*/;,.0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ';
begin
if byte(zx)>=length(zxchar) then result:='.' else result:=zxchar[byte(zx)+1];
end;




procedure Tform1.InterpretSTheader;
var i:integer;
var STname:string;
var SText:string;
var nr:string;
var a:char;
var res:string;

begin
Headerok:= prsumH=header.prsum;
if Headerok then res:='ok' else res:='##';

STname:='';
for i:=1 to 12 do
 begin
 if header.flags and $40 > 0 then a:=ZX81toASC(Header.name[i]) else a:=header.name[i];

 if a=#0 then break;
 Stname:=STname+a;
 end;
SText:='';
for i:=13 to 16 do
 begin
 if header.flags and $40 > 0 then a:=ZX81toASC(Header.name[i]) else a:=header.name[i];
 if a=#0 then break;
 Stext:=SText+a;
 end;



with header do memo1.lines.add (Format('%d x16h "%s"',[syncanz,STname+SText]));
with header do memo1.lines.add (Format('Header flags:$%x start:$%x size:%d prsum:%d prsumH:%d',[flags,start,size,prsum,prsumH]));
memo1.lines.add('Header Prfsumme='+res);
if headerok then
 begin
 nr:=''; i:=0;
 while Fileexists(STname+nr+Stext) do begin inc (i); nr:='.'+inttostr(i) end;
 assignFile (BinOutDat,STname+nr+Stext+'.ST');
 Rewrite(Binoutdat);
 For i:=0 to 25 do write (Binoutdat,headera[i]);
 if (Header.flags and $80) > 0 then freq:=7200;
 end;
end;

procedure Tform1.InterpretSTData;

var res:string;
begin
if prsumD=prsum then res:='ok' else res:='##';
memo1.lines.add('Daten gelesen, Prsumme:'+res);
memo1.Lines.add(Tfilerec(binoutdat).Name+' abgespeichert');
ClosefileX(binoutdat);
freq:=3600;

end;




Procedure TForm1.InterpretSuperTape (i:integer; var diff,aktflanke:double);

begin

         if diff >= diskrim then
                begin
                if (loadstatus=loadheader) or (loadstatus=loadheader) or (loadstatus=loaddata) then
                 begin
                 if diff  > maxdiffhigh then begin maxdiffhigh:=diff;maxdiffhighpos:=i end;
                 if diff < mindiffhigh then begin mindiffhigh:=diff; mindiffhighpos:=i end;
                 avgdiffhigh:=avgdiffhigh+diff;
                 inc (diffhighcount);
                 end;
                if zwischenflanke then Bit:=0 else Bit:=$80;
                zwischenflanke:=false;
                letzteflanke:=aktflanke;
                inc (Bitcount);
                if length(s) < 20 then s:=s+char(bit shr 7+$30);
                if loadstatus=syncbit then
                 begin
                 d:=(d shr 1 + Bit) and $FF;
                 if d=$16 then begin loadstatus:=syncbyte; bitnr:=0; end;
                 syncanz:=0;

                 end
                else
                 begin
                  if bitnr=0 then d:=bit else d:=d shr 1 +Bit;
                  bitnr:=(bitnr+1) and $7;
                  inc (prsumx,bit shr 7);

                   if bitnr=0 then
                   case loadstatus of
                    syncbyte:begin
                             case d of
                             $16:begin loadstatus:=syncbyte; inc (syncanz) end;
                              $2A:if syncanz> 3 then
                                  begin headerptr:=0; prsumx:=0; loadstatus:=loadHeader; end
                                  else loadstatus:=syncbit;

                              $C5:if syncanz> 3 then
                                  begin dataptr:=0; prsumx:=0; loadstatus:=loadData; end
                                  else loadstatus:=syncbit;
                              else loadstatus:=syncbit;
                              end;
                             end;
                  loadheader:begin

                              headera[headerptr]:=d;
                              if headerptr=high(headera)-2 then prsumH:=prsumx;
                              if headerptr=high(headera) then
                               begin interpretSTHeader; loadstatus:=syncbit;  end
                              else inc (headerptr);
                             end;
                  loaddata: begin
                              if headerok then
                               begin
                               data[dataptr]:=d;
                               if dataptr <header.size-1 then write (binoutdat,d);
                               if dataptr=header.size-1 then prsumD:=prsumx;
                               if dataptr=header.size   then prsum:=D;
                               if dataptr=header.size+1 then
                                  begin
                                  prsum:=Prsum +(D shl 8);
                                  interpretSTdata;
                                  loadstatus:=dataloaded;
                                  end
                               else inc (dataptr);
                               end
                               else Loadstatus:=syncbit;
                             end;

                    end;//case
                  end; // if syncbit else
               end // diff > diskrim
              else
               begin
               zwischenflanke:=true;
               if (loadstatus=loadheader) or (loadstatus=loadheader) or (loadstatus=loaddata) then
                begin
                if diff > maxdifflow then begin maxdifflow:=diff; maxdifflowpos:=i end;
                if diff < mindifflow then begin mindifflow:=diff; mindifflowpos:=i end;
                avgdifflow:=avgdifflow+diff;
                inc (difflowcount);
                end;
               end;


end;




Procedure TForm1.InterpretBuffer(ab,bis:integer;SuperTape:boolean);
Var
  i:integer;

  var v : smallint;
  var diff:double;
  var isFlanke:boolean;
  var aktflanke:double;
  var x0,x1:integer;
  var flanknr:integer;
  var insertmode:boolean;
  var vz:integer;
  var x:double;
  var korrekt:smallint;
  begin
  if interpretaktiv then
   begin
   showmessage ('berlauf: Grafik abschalten');
   exit;
   end;
  interpretaktiv:=true;


 if ab=0 then
   begin
   diskrim:=Audioin1.framerate/freq*0.8;
   flanknr:=0;
   Letzteflanke:=0;
   bit:=0;
   diff:=0;
   insertmode:=false;
   korrekt:=0;
   if graph.itemindex >0 then initgraph;
   s:='';
   end;

  if letzteflanke> ab then letzteflanke:=ab;
  For i := ab to bis Do
     Begin
         v:=getvalue(i);
         v:=v-round((v1-v)*ny); //Delta v * ny hinzumischen

     // ******************** Ist flanke ? **************


        flankeup:=  (v >= 0) and (v1 < 0);
        flankedown:=(v <= 0) and (v1 > 0);
        isFlanke:=flankeup or flankedown;

        if not trigger and flankeup then
          begin
          trigger:=true;
          triggeroffs:=i- abs(v/v1) /(abs(v/v1)+1);
          end;

        if graph.itemindex >0 then setpoint (i,v,v1,isflanke,diff);
        if isFlanke then
          begin
            aktflanke:=i-1+1/(abs(v/v1)+1);
            diff:=aktflanke-letzteflanke;

            inc (flanknr);
           if (rOutput.Itemindex=2) and SuperTape then
            begin
            InterpretSuperTape(i,diff,aktflanke);
            if loadstatus=dataloaded then
             begin
             closeFileX (binoutdat);
             headerok:=false;
             loadstatus:=syncbit;
             end;
            end

          else letzteflanke:=aktflanke;

         end; // if isFlanke
   //***********************************************************
      v1:=v;
     End; //For i
     interpretaktiv:=false;
 end;

Procedure TForm1.Showgraph;
// Graph ab aktueller position mit zoom ausgeben
var ab,bis:integer;
begin
 if not bufferloaded then exit;
 ab:=UpDown2.position*deltaupdown2;
 bis:=ab+trunc(image1.width/xv);
 if ab > 100 then dec (ab,100) else ab:=0;
 InterpretBuffer(ab,bis,false);
end;

Procedure TForm1.UpdateStatus;
var i:integer;
var vol2:UINT;
type peaktype=record
     wert:integer;
     sum:integer;
     pos:integer;
     end;

var peak:array[0..5] of peaktype;
var peaknr:integer;
var newpeak:boolean;
var r:char;
begin
  With AudioIn1 Do
   If (AudioIn1.AudioActive) Then
     Begin
       RunStatusLabel.Caption := 'Started';
       BufferStatusLabel.Caption := Format('Queued: %3d;  Processed: %3d',[QueuedBuffers, ProcessedBuffers]);
       TimeStatusLabel.Caption := Format('Seconds %.3n',[ElapsedTime]);
       FreqLabel.Caption:=Format ('%6.2f %5d Hz', [maxdiff,freq]);
       bitmuster.Caption:=s;
       lSyncanz.Caption:=inttostr(syncanz);
       if rInput.ItemIndex=0 then
         begin
         case recordstatus of
          waitforpause:  r:='P';
          waitforsignal: r:='S';
          recordactive:  r:='R';
          recordstop:    r:='Q';
         end;
         lrecbuf.Caption:=inttostr(buffcount)+r;
         end;

     End
   Else
     Begin
       RunStatusLabel.Caption := 'Stopped';
       BufferStatusLabel.Caption := '';
       TimeStatusLabel.Caption := '';
     End;

   { Update the progress bar }
   If (AudioIn1.AudioActive) Then
     Begin
       ProgressBar1.Position := Round(100*TempMax/(1 shl audioin1.quantization)*2);
     End
   Else
     Begin
       ProgressBar1.Position := 0;
       MaxLabel.Caption := '';
     End;
   if LineinDevice <> -1 then
      if auxGetVolume(LineinDevice, @Vol2) = MMSYSERR_NOERROR
        then if vol2 <> vol then
         begin
         vol:=vol2;
         Lineinvol.Position:=255-hi(Vol);
         end;
   MaxLabel.Caption := Format('Max %5d;  Peak %5d Min %5d',[Max,TempMax,Min]);

End;

procedure TForm1.Timer1Timer(Sender: TObject);
begin
  UpdateStatus;
end;

procedure TForm1.AudioIn1Stop(Sender: TObject);
begin
   RecordSpeedButton.Down := FALSE;
end;




procedure TForm1.RecordSpeedButtonClick(Sender: TObject);
begin
  If (RecordSpeedButton.Down) Then
     StartButtonClick(Sender)
  Else
     AudioIn1.StopAtOnce;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
 with audioin1 do
  begin
  BufferSize:=buffsize;
  stereo:=false;
  //framerate:=44100;   // 0,045 ms/samplepoint
  framerate:=44100;
  Quantization:=8;
  rResolution.itemindex:=0;
  bufferloaded:=false;
  ny:=0;
  xv:=1;
  end;
 binoutopen:=false;
 opendialog1.filename:='';
 image1.Width:=512;
 Trackbarschwelle.Position:=7;
 mass:=image1.Height/(1 shl audioin1.quantization);
 queryperformancefrequency(qf);
 with image1,canvas do
  begin
  brush.Color:=clgreen;
  FillRect(Rect(0,0,width,height));
  end;
 LineinDevice:=getmixer(AUXCAPS_AUXIN);
 LineinVol.Visible:= LineinDevice<>-1;
 end;

procedure TForm1.StopbuttonClick(Sender: TObject);
begin
 AudioIn1.StopAtOnce;
end;

procedure TForm1.rResolutionClick(Sender: TObject);
begin
if RResolution.ItemIndex=0
 then audioin1.quantization:=8
 else  audioin1.quantization:=16;
 mass:=image1.Height/(1 shl audioin1.quantization);
 if audioin1.AudioActive then StartbuttonClick (self);

end;

procedure TForm1.UpDown1Click(Sender: TObject; Button: TUDBtnType);
var p:integer;
begin
if upDown1.Position > 0 then xv:=updown1.Position
 else case -updown1.Position of
 0: xv:=1/2;
 1: xv:=1/5;
 2: xv:=1/10;
 3: xv:=1/20;
 4: xv:=1/50;
 5: xv:=1/100;
 6: xv:=1/200;
 7: xv:=1/500;
 8: xv:=1/1000;
 9: xv:=1/2000;
10: xv:=1/5000;
 end;
xvers.Caption:=Floattostr(xv);
p:=updown2.position*deltaupdown2;
deltaupdown2:=round(100/xv);
updown2.position:=p div deltaupdown2;
updown2.max :=round(fs*buffsize/ deltaupdown2);
showgraph;
end;



Procedure  TForm1.LoginNxtdat;
var i:integer;
var datname:string;
 begin
 i:=1;
 repeat
  datname:='wave.'+inttostr(audioin1.Quantization)+'.'+inttostr(audioin1.FrameRate)+'.'+inttostr(i)+'.raw';
  if not fileexists(datname) then break;
  inc (i);
 until false;
 assignFile (rawoutdat,datname);
 rewrite(rawoutdat,buffsize);
 memo1.Lines.add ('Aufnahme nach '+datname);
 end;


procedure TForm1.InitRawoutdat;
begin
Min := 0;
Max := 0;
Recordstatus:=Waitforpause;
memo1.lines.add ('Warte auf pause');
with Trackbarschwelle do if position=max then position:= max-3;
buffcount:=0;
loginNxtdat;
end;

procedure TForm1.InitInterpreter;
begin
        v1:= 0;
        v2:= 0;
        flankeup:=false;
        flankedown:=false;
        bitcount:=0;
        bitnr:=0;
        syncanz:=0;
        d:=0;
        loadstatus:=syncbit;
        s:='';
        letzteflanke:=0;
        zwischenflanke:=false;
        maxdiff:=0;
        xAb:=0; xBis:=0;
        headerlen:=0;
        fillchar (diffarray,sizeof(diffarray),#0);
  end;

procedure TForm1.StartButtonClick(Sender: TObject);
begin
   image1.Width:=512;

   if StartButton.Caption='Sto&p' then
    begin
    memo1.lines.Add('abgebrochen');
    Startbutton.Caption:='&Start';
    rInput.Enabled:=true;
    rOutput.Enabled:=true;
    rResolution.Enabled:=true;
    freq:=3600;
    interpretaktiv:=false;
    headerok:=false;
    case rInput.itemIndex of
     0:  AudioIn1.StopAtOnce;
     1:;
     2:;
     end;

     case rOutput.itemIndex of
     0:; //Audioout1.StopAtOnce;
     1:  stopprec;
     2:  CloseFileX(Binoutdat);
     3:; // nischt zu tun
     end;
    updown1.Min:=1;

    end
  else
   begin
   memo1.clear;
   if rOutput.Itemindex=0 then
    begin
    showmessage ('sorry, Line-out noch nicht drin');
    exit;
    end;
   StartButton.Caption:='Sto&p';
   rInput.Enabled:=false;
   rOutput.Enabled:=false;
   rResolution.Enabled:=false;

   case rOutput.itemIndex of
     0:;   //Playbuffer
     1:  InitRawOutDat;
     2:  InitBinoutdat;
     end;

    case rInput.itemIndex of
     0:   If (Not AudioIn1.Start) Then ShowMessage(AudioIn1.ErrorMessage)
          Else
            Begin
             Min := 0;
             Max := 0;
             RecordSpeedButton.Down := TRUE;
             image1.Width:=256;
             Initinterpreter;
             Initgraph;
             recordstatus:=Waitforpause;
             memo1.lines.add('Warte auf Pause');
            End;

     1:   InitRawInDat('');
     2:   CloseFileX (Binindat);  //InitBinInDat;
     end;
  //   if (rInput.ItemIndex <>0) and (routput.ItemIndex<>0) then Startbutton.Caption:='&Start';
   end;
  xBis:=xAb+trunc(image1.width/xv);
  updown2.Left:=image1.left+image1.Width-100;
  bislabel.Left:=image1.Left+image1.Width-10;
  bislabel.caption:=inttostr(xbis);

end;

procedure TForm1.InitBinOutdat;
begin
InitInterpreter;
graph.itemindex:=2;
   maxdiffhigh:=0;
   maxdifflow:=0;
   mindiffhigh:=1000;
   mindifflow:=1000;
   avgdiffhigh:=0;
   avgdifflow:=0;
   diffhighcount:=0;
   difflowcount:=0;
memo1.Lines.Add('Aufnahme fr SuperTape-Binrdatei');
end;


procedure TForm1.InitRawinDat (const name:string);
var m,i:integer;
var P:Pwavheader;
var p1:PPCMdata;
var nxtadr:longword;
var ab:integer;
begin
CloseFileX (Rawindat);
if audioin1.audioactive then  ShowMessage ('Audio activ')
else
 begin
 opendialog1.FileName:=name;
 If openDialog1.FileName='' then
  begin
  ForceCurrentDirectory:=true;
  opendialog1.Filter:='Audiodateien|*.wav;*.raw';
  If not opendialog1.Execute  then exit;
  end;
 assignFile (rawindat,opendialog1.Filename);
 reset(rawindat,buffsize);
 fs:=filesize(rawindat);
 blockread (rawindat,nbuffer,1);
 P:=@nbuffer;
 //*****************WAV ******************************************
 if comparetext(extractfileext (opendialog1.Filename),'.wav') =0
  then with P^ do begin
   WritelnC(' %s %s %s',[string(riff),string(wave),string(fmt_)]);
   WritelnC(' Formatlen  = %d',[fmt_len]);
   WritelnC (' FormatTag  = %d',[fm.wFormattag]);
     case fm.wFormatTag of
     WAVE_FORMAT_PCM: Writeadd(' PCM, %d Bits/Sample',[PCM_nBitsperSample]);
     else Writeadd(' Format unsupported',[]);
   end;
   WritelnC(' Channels   = %d',[fm.nChannels]);
   WritelnC(' Sampes/s   = %d',[fm.nSamplesPerSec]);
   WritelnC(' AvgBytes/s = %d',[fm.nAvgBytesPerSec]);
   WritelnC(' BlockAlign = %d',[fm.nBlockalign]);
    Nxtadr:=longword(addr(P^.fm))+fmt_len;
     repeat
     if ((nxtadr < longword(addr(P^.fm))) or (nxtadr > longword(addr(P^.Wave))+rifflen)) then break;
     P1:=PPCMdata(Nxtadr);
     WritelnC(' Data       = %s',[string(P1^.data)]);
     WritelnC(' Datalen    = %d',[P1^.datalen]);
     Nxtadr:=longword(addr(P1^.buffer))+P1^.datalen
     until P1^.data ='data';

  if fm.wformatTag <> WAVE_FORMAT_PCM then exit;
  audioin1.Framerate:=fm.nsamplesPerSec;
  audioin1.Quantization:=PCM_nBitsPerSample;
  audioin1.Stereo:=fm.nChannels > 1;
  headerlen:=longint(@P1^.data)-longword(@P^)+8;
  end
  //**************************************************
  else Writelnc('loaded: %d Blcke = %d Bytes',[fs,fs*buffsize]);

  if audioin1.Quantization=8 then rResolution.itemindex:=0
  else  if audioin1.Quantization=16 then rResolution.itemindex:=1
  else begin showmessage ('framerate not supported'); exit end;

 fp:=0;
 image1.Width:=512;
 Updown2.enabled:=true;
 initinterpreter;
 bufferloaded:=true;
 getminmax(buffsize); // vom ersten Buffer
 Updown2.max :=round(fs*buffsize/ deltaupdown2);
 with image1,canvas do
  begin
  brush.Color:=clgreen;
  FillRect(Rect(0,0,width,height));
  end;
 if graph.itemindex > 0 then
  begin
  //anfngliche Pause berspringen
  ab:=0;
  if aktschwelle>0 then
   while (ab < fs*buffsize) and (abs (getvalue(ab))< aktschwelle) do  inc (ab);
  if ab < fs*buffsize-deltaupdown2  then  updown2.Position:=round(ab/deltaupdown2);
  showgraph;
  end;
 if rOutput.itemindex in [2,3] then
 begin
 //InterpretBuffer(0,fs*buffsize,true);
 for i:=0 to fs-1 do Interpretbuffer(i*buffsize,(i+1)*buffsize-1,true);
 if (difflowcount) <> 0 then memo1.Lines.add (Format('low : %f (%d) %f %f (%d)',[mindifflow,mindifflowpos,avgdifflow/difflowcount,maxdifflow,maxdifflowpos]));
 if (diffhighcount) <> 0 then memo1.Lines.add (Format('high: %f(%d) %f %f (%d)',[mindiffhigh,mindiffhighpos,avgdiffhigh/diffhighcount,maxdiffhigh,maxdiffhighpos]));
 end;
 end;
end;


procedure TForm1.UpDown2Click(Sender: TObject; Button: TUDBtnType);
begin
showgraph;
end;

procedure TForm1.Image1MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
var xpos,ypos:double;
var v,v1:smallint;
begin
if not bufferloaded  or (graph.Itemindex=0) then exit;
xpos:=xAb+(x/xv);
statusbar1.Panels.Items[0].Text:=Floattostr(xpos);
statusbar1.Panels.Items[1].Text:=FloattostrF(xpos*1e3/audioin1.framerate,fffixed,6,3)+ ' ms';

case graph.ItemIndex of
 1,2: begin
    v :=getvalue(trunc (xpos));
    v1:=getvalue(trunc (xpos)+1);
    ypos:=v+(v1-v)*frac(xpos);
    statusbar1.Panels.Items[2].Text:=Floattostr(ypos);
    statusbar1.Panels.Items[3].Text:=FloattostrF((image1.Height div 2 -y)/image1.Height*256,fffixed,6,3);
    end;
 3: begin
    statusbar1.Panels.Items[2].Text:='';
    statusbar1.Panels.Items[3].Text:=Floattostr((image1.Height-y)/image1.Height*diffmax);
    end;
 end;

end;


procedure TForm1.TrackBarSchwelleChange(Sender: TObject);
begin
 with trackBarSchwelle do aktschwelle:=round((1 shl audioin1.Quantization)*(max-position)/100);
 if Graph.ItemIndex > 0 then showgraph;
end;

procedure TForm1.GraphClick(Sender: TObject);
begin
if Graph.ItemIndex > 0 then showgraph;
end;

procedure TForm1.TrackBar1Change(Sender: TObject);
begin
ny:=Trackbar1.position*0.1;
if Graph.ItemIndex > 0 then showgraph;
end;

procedure TForm1.Memo1Click(Sender: TObject);
var res:integer;
var newpos:integer;
begin
val (memo1.seltext,newpos,res);
if res = 0 then updown2.Position:=newpos div 100;
showgraph;
end;




procedure TForm1.LineInvolChange(Sender: TObject);
begin
vol:=(255-LineInVol.Position) shl 24 + (255-LineInVol.Position) shl 8;
auxSetVolume(LineinDevice,vol);
end;

procedure TForm1.Image1MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var xpos:double;
begin
xpos:=xAb+(x/xv);
 case Button of
  mbLeft:  begin cursor1:=xpos;statusbar1.Panels[4].Text:=Floattostr(xpos); end;
  mbright: begin cursor2:=xpos;statusbar1.Panels[5].Text:=Floattostr(xpos); end;
 end;
statusbar1.Panels[6].Text:=FloattostrF((abs(cursor2-cursor1))*1e3/audioin1.framerate,fffixed,6,3)+' ms';
showgraph;
end;

procedure TForm1.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
 if audioin1.AudioActive then StartbuttonClick (self);
 sleep(10);
 CanClose:=true;
end;



end.
