VERSION 5.00
Begin {C62A69F0-16DC-11CE-9E98-00AA00574A4F} frmDatenabgleichOrdner 
   Caption         =   "frmDatenabgleichOrdner"
   ClientHeight    =   2370
   ClientLeft      =   45
   ClientTop       =   435
   ClientWidth     =   4335
   OleObjectBlob   =   "frmDatenabgleichOrdner.frx":0000
   StartUpPosition =   1  'Fenstermitte
End
Attribute VB_Name = "frmDatenabgleichOrdner"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

' 2004, Ralf Nebelo

Public strEntryID As String
Public strBasisOrdner As String

Private Sub cmdOLOrdner_Click()
    Dim objOLOrdner As MAPIFolder
    
    'Outlook-Ordner abfragen
    Set objOLOrdner = Application.GetNamespace("MAPI").PickFolder
    'Wenn Order gewhlt und...
    If Not objOLOrdner Is Nothing Then
        '... dieser ein Notizordner ist, dann...
        If objOLOrdner.DefaultItemType = olNoteItem Then
            '... Fehlermeldung ausgeben
            MsgBox "Kein Abgleich von Notizordnern mglich.", vbInformation, OL_Datenabgleich.APPNAME
        'Wenn Ordner kein Notizordner ist, dann...
        Else
            '... Entry-ID des Ordners in globaler Variable speichern
            strEntryID = objOLOrdner.EntryID
            'Ordnername in TextBox bernehmen
            txtOLOrdner.Text = objOLOrdner.Name
        End If
    End If
End Sub

Private Sub cmdOrdner_Click()
    Dim strVorgabe As String
    Dim strOrdner As String
    
    'Wenn txtOrdner leer ist, dann...
    If txtOrdner.Text = "" Then
        '... Pfadvorgabe aus Basisordner und Name des korrespondierenden
        'Outlook-Ordners zusammensetzen
        strVorgabe = OL_Datenabgleich.AddSlash(strBasisOrdner) & txtOLOrdner
    'Wenn txtOrdner einen Dateiordnernamen enthlt, dann...
    Else
        '... Pfadvorgabe aus Basisordner und Dateiordnernamen kombinieren
        strVorgabe = OL_Datenabgleich.AddSlash(strBasisOrdner) & txtOrdner.Text
    End If
    'Wenn die Pfadvorgabe nicht auf einen vorhandenen Dateiordner verweist, dann...
    If OL_Datenabgleich.OrdnerVorhanden(strVorgabe) = False Then
        '... Pfad des Basisordners als Pfadvorgabe nutzen
        strVorgabe = strBasisOrdner
    End If
   
    'Abgleichordner abfragen, wobei der in der Pfadvorgabe enthaltene
    'Ordner vorgewhlt ist
    strOrdner = ctlDialoge.GetFolder("Whlen Sie ein Unterverzeichnis des Basisverzeichnisses, mit dem der gewhlte Outlook-Ordner abgeglichen werden soll:", "Desktop", strVorgabe, True)
    'Wenn Abgleichordner gewhlt, dann...
    If strOrdner > "" Then
        '... Ordnernamen aus Pfad isolieren und in txtOrdner eintragen
        txtOrdner.Text = Right(strOrdner, Len(strOrdner) - Len(strBasisOrdner) - 1)
    End If
End Sub

Private Sub cmdOK_Click()
    'Wenn kein Outlook-Ordner gewhlt, dann...
    If txtOLOrdner.Text = "" Then
        '... entsprechende Meldung ausgeben
        MsgBox "Bitte whlen Sie einen Outlook-Ordner.", vbInformation, OL_Datenabgleich.APPNAME
        'Prozedur verlassen
        Exit Sub
    End If
    
    'Wenn kein Abgleichordner gewhlt, dann...
    If txtOrdner.Text = "" Then
        '... entsprechende Meldung ausgeben
        MsgBox "Bitte whlen Sie ein Abgleichverzeichnis.", vbInformation, OL_Datenabgleich.APPNAME
        'Prozedur verlassen
        Exit Sub
    End If
    
    'Userform verbergen
    Me.Hide
End Sub

Private Sub cmdCancel_Click()
    'Keine Entry-ID zurckgeben
    strEntryID = ""
    'Userform verbergen
    Me.Hide
End Sub

