VERSION 5.00
Begin {C62A69F0-16DC-11CE-9E98-00AA00574A4F} frmDatenabgleich 
   Caption         =   "frmDatenabgleich"
   ClientHeight    =   4875
   ClientLeft      =   45
   ClientTop       =   435
   ClientWidth     =   6375
   OleObjectBlob   =   "frmDatenabgleich.frx":0000
   StartUpPosition =   1  'Fenstermitte
End
Attribute VB_Name = "frmDatenabgleich"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

' 2004, Ralf Nebelo

Private Declare Function GetComputerName Lib "kernel32" Alias "GetComputerNameA" (ByVal lpBuffer As String, nSize As Long) As Long
Dim strBasisOrdner As String
Dim blnCancel As Boolean

Private Sub ctlDialoge_Enter()

End Sub

Private Sub UserForm_Initialize()
    'Pfad des Basisordners aus Registry lesen
    strBasisOrdner = GetSetting(OL_Datenabgleich.APPNAME, "Einstellungen", "BasisOrdner", "")
    'Wenn kein Ordner angegeben oder Ordner nicht verfgbar, dann...
    If strBasisOrdner = "" Or OL_Datenabgleich.OrdnerVorhanden(strBasisOrdner) = False Then
        '... Fehler melden
        MsgBox "Kein Abgleichordner angegeben oder Ordner nicht bereit." & vbCr & "Bitte nehmen Sie zunchst die Grundeinstellungen vor.", vbExclamation, OL_Datenabgleich.APPNAME
        'Userform beenden
        End
    End If

    'Fenstertiteltext festlegen
    Me.Caption = OL_Datenabgleich.APPNAME & " -  2004, Ralf Nebelo"
    'cmdBericht-Schaltflche deaktivieren
    cmdBericht.Enabled = False
End Sub

Private Sub UserForm_Activate()
    Dim intAnzEintrge As Integer
    Dim intI As Integer
    Dim strEintrag() As String
    Dim strEntryID As String
    Dim objOLOrdner As MAPIFolder
    Dim strZielOrdner As String
    Dim intGesichert As Integer
    Dim intGelesen As Integer
    Dim objItem As Object
   
    'Fehlerverfolgung aus
    On Error Resume Next
    
    'Zunchst kein Abbruch
    blnCancel = False
    
    'Meldung in Listenfeld ausgeben
    Call Ausgabe("Abgleich gestartet (" & Now & ")")
    'Gestrichelte Linie in Listenfeld ausgeben
    Call Ausgabe("-")
    'Anzahl der Abgleichzuordnungen aus Registry lesen
    intAnzEintrge = CInt(GetSetting(OL_Datenabgleich.APPNAME, "Einstellungen", "Eintrge", "0"))
    'Alle Zuordnungen durchlaufen
    For intI = 0 To intAnzEintrge - 1
        'Zuordnung aus nummeriertem Registry-Eintrag lesen
        strEintrag() = Split(GetSetting(OL_Datenabgleich.APPNAME, "Einstellungen", Format(intI + 1, "00")), ",")
        'Eindeutige Entry-ID des abzugleichenden Outlook-Ordners isolieren
        strEntryID = strEintrag(1)
        
        'ber Entry-ID Verweis auf Outlook-Ordner holen
        Set objOLOrdner = GetNamespace("MAPI").GetFolderFromID(strEntryID)
        'Wenn Outlook-Ordner nicht existiert, dann...
        If objOLOrdner Is Nothing Then
            '... Fehlermeldung in Listenfeld ausgeben
            Call Ausgabe("FEHLER: Der Outlook-Ordner " & Chr(34) & strEintrag(0) & Chr(34) & " existiert nicht")
            'Fehler zurcksetzen
            Err.Clear
        'Wenn Outlook-Ordner existiert, dann...
        Else
            '... Pfad des Zieldateiordners aus Basispfad und Ordnernamen bilden
            strZielOrdner = OL_Datenabgleich.AddSlash(strBasisOrdner) & strEintrag(2)
            'Ordnername in Listenfeld ausgeben
            Call Ausgabe("Outlook-Ordner " & Chr(34) & objOLOrdner.Name & Chr(34) & " mit " & strZielOrdner & " abgleichen")
            'Wenn Zielordner nicht existiert, dann...
            If OL_Datenabgleich.OrdnerVorhanden(strZielOrdner) = False Then
                '... Fehlermeldung in Listenfeld ausgeben
                Call Ausgabe("FEHLER: " & "Der Zielordner " & strZielOrdner & " ist nicht vorhanden oder bereit")
            'Ansonsten...
            Else
                '... Prozedur fr die Sicherung der Ordnerinhalte aufrufen
                intGesichert = OLOrdnerSichern(objOLOrdner, strZielOrdner)
                'Anzahl der gesicherten Elemente in Listenfeld ausgeben
                Call Ausgabe(CStr(intGesichert) & " Element(e) gespeichert")
                'Wenn Benutzer auf "Abbrechen" klickt, dann...
                If blnCancel = True Then
                    '... Schleife verlassen
                    Exit For
                End If
                
                'Prozedur fr das Einlesen von Ordnerinhalten aufrufen
                intGelesen = OLOrdnerEinlesen(strZielOrdner, objOLOrdner)
                'Anzahl der gelesenen Elemente in Listenfeld ausgeben
                Call Ausgabe(CStr(intGelesen) & " Element(e) eingelesen")
                'Wenn Benutzer auf "Abbrechen" klickt, dann...
                If blnCancel = True Then
                    '... Schleife verlassen
                    Exit For
                End If
            End If
        End If
        'Gestrichelte Linie in Listenfeld ausgeben
        Call Ausgabe("-")
    Next
    
    'Wenn Anwender Abgleich abgebrochen hat, dann...
    If blnCancel = True Then
        '... gestrichelte Linie in Listenfeld ausgeben
        Call Ausgabe("-")
        'Abbruchmeldung in Listenfeld ausgeben
        Call Ausgabe("Abgleich abgebrochen (" & Now & ")")
    'Wenn Abgleich ohne Abbruch beendet wurde, dann...
    Else
        '... entsprechende Meldung in Listenfeld ausgeben
        Call Ausgabe("Abgleich beendet (" & Now & ")")
    End If
    
    'Schaltflche cmdBericht aktivieren
    cmdBericht.Enabled = True
    'Beschriftung der Schaltflche cmdCancel in "Schlieen" ndern
    cmdCancel.Caption = "Schlieen"
    
    'Ordner Postausgang von ungltigen Eintrgen, die durch den
    'Import fehlerhafter Mails entstanden sind, subern. Die Eintrge
    'zeichnen sich dadurch aus, dass sie keinen Empfnger haben.
    'Alle Elemente des Ordners durchlaufen
    For Each objItem In GetNamespace("MAPI").GetDefaultFolder(olFolderOutbox).Items
        'Wenn Element keinen Empfnger hat, dann...
        If objItem.Recipients.Count = 0 Then
            '... Element lschen
            objItem.Delete
        End If
    Next
End Sub

Private Sub cmdBericht_Click()
    Dim strDateiname As String
    Dim intButton As Integer
    Dim intI As Integer
    
    'Fehlerverfolgung aus
    On Error Resume Next
    
    'Dateinamen zum Speichern der Berichtsdatei abfragen
    strDateiname = ctlDialoge.FileSave("Textdateien", "*.txt", "Abgleichbericht vom " & Date & ".txt", , "Bericht speichern")
    'Wenn Dateiname gewhlt und ...
    If strDateiname > "" Then
        '... die Datei bereits existiert, dann...
        If Dir(strDateiname) > "" Then
            '... um Erlaubnis zum berschreiben nachfragen
            intButton = MsgBox("Die gewhlte Berichtsdatei ist bereits vorhanden." & vbCr & "Mchten Sie sie ersetzen?", vbQuestion + vbYesNoCancel + vbDefaultButton2, OL_Datenabgleich.APPNAME)
            'Wenn nicht Ja-Button gewhlt, dann...
            If intButton <> vbYes Then
                '... Prozedur verlassen
                Exit Sub
            End If
        End If
        
        'Textdatei fr Ausgabe ffnen
        Open strDateiname For Output As #1
        With lstVerlauf
            'Alle Eintrge des Listenfelds hineinschreiben
            For intI = 0 To .ListCount - 1
                Print #1, .List(intI)
            Next
        End With
        'Textdatei schlieen
        Close #1
    End If
End Sub

Private Sub cmdCancel_Click()
    'Wenn die Schaltflche cmdCancel die Beschriftung "Abbrechen" hat, dann...
    If cmdCancel.Caption = "Abbrechen" Then
        '... Abbruch des Abgleichs signalisieren
        blnCancel = True
    'Wenn cmdCancel die Beschriftung "Schlieen" hat, dann...
    Else
        '... Userform entladen
        Unload Me
    End If
End Sub

'*******************************************************************************
'Allgemeine Prozeduren
'*******************************************************************************

Private Function OLOrdnerSichern(objOLOrdner As MAPIFolder, strZielOrdner As String) As Integer
    Dim strDieserComputer As String
    Dim blnCheckAlter As Boolean
    Dim intAlter As Integer
    Dim objItem As Object
    Dim blnSichern As Boolean
    Dim intItemAlter As Integer
    Dim strPfadname As String
    Dim intZhler As Integer
    
    'Fehlerverfolgung aus
    On Error Resume Next
    
    'Computernamen ermitteln
    strDieserComputer = HolComputerName
    
    'Maximalalter der zu sichernden Elemente beachten?
    blnCheckAlter = CBool(GetSetting(OL_Datenabgleich.APPNAME, "Einstellungen", "CheckAlter", "Wahr"))
    'Maximalalter auslesen
    intAlter = CInt(GetSetting(OL_Datenabgleich.APPNAME, "Einstellungen", "Alter", "2"))
 
    'Alle Elemente des Outlook-Ordners durchlaufen
    For Each objItem In objOLOrdner.Items
        'Auf Ereignisse reagieren
        DoEvents
        
        'Davon ausgehen, dass Element gespeichert werden soll
        blnSichern = True
        
        'Wenn Userproperty "EingelesenVon" nicht leer ist, das Element
        'also von einem fremden PC stammt, dann...
        If HolUserProp(objItem, "EingelesenVon") > "" Then
            '... Element nicht sichern
            blnSichern = False
        'Wenn Element von diesem PC stammt und...
        Else
            '... wenn das Maximalalter beachtet werden soll, dann...
            If blnCheckAlter = True Then
                '... Alter des Elements in Tagen berechnen
                intItemAlter = Date - DateValue(objItem.CreationTime)
                'Wenn Elementalter grer als das Maximalalter ist, dann...
                If intItemAlter > intAlter Then
                    '... Element nicht sichern
                    blnSichern = False
                End If
            End If
        End If
        
        'Wenn Element gesichert werden soll, dann...
        If blnSichern = True Then
            '... Pfadnamen aus Quellpfad des Zielordners, Computernamen
            'und Entry-ID des zu sichernden Outlook-Elements zusammensetzen;
            'Extension fehlt
            strPfadname = OL_Datenabgleich.AddSlash(strZielOrdner) & strDieserComputer & "_" & objItem.EntryID
            'Wenn noch keine Datei existiert, die mit dem Pfadnamen
            'beginnt (und an die eventuell schon die Namen von Computern
            'angehngt wurden, die die Datei zuvor eingelesen haben),
            'dann...
            If Dir(strPfadname & "*.msg") = "" Then
                '... Element als MSG-Datei abspeichern
                objItem.SaveAs strPfadname & ".msg"
                
                'Wenn Datei jetzt existiert, dann...
                If Dir(strPfadname & ".msg") > "" Then
                    '... Zhler erhhen
                    intZhler = intZhler + 1
                    'Erfolgsmeldung ausgeben
                    Call Ausgabe("  Gespeichert: " & Chr(34) & objItem.Subject & Chr(34))
                'Wenn Datei nicht existiert, dann...
                Else
                    'Meldung ber Misserfolg ausgeben
                    Call Ausgabe("  Nicht gespeichert: " & Chr(34) & objItem.Subject & Chr(34))
                End If
            End If
        End If
        
        'Wenn Benutzer auf "Abbrechen" geklickt hat, dann...
        If blnCancel = True Then
            '... Schleife verlassen
            Exit For
        End If
    Next
    
    'Zhlerwert zurckgeben
    OLOrdnerSichern = intZhler
End Function

Private Function OLOrdnerEinlesen(strQuellordner As String, objOLOrdner As MAPIFolder) As Integer
    Dim strDieserComputer As String
    Dim strDateiname As String
    Dim strQuellComputer As String
    Dim objItem As Object
    Dim strNeuerDateiname As String
    Dim blnErfolg As Boolean
    Dim intZhler As Integer
    
    'Fehlerverfolgung aus
    On Error Resume Next

    'Computernamen ermitteln
    strDieserComputer = HolComputerName
    
    'Dateinamen der ersten MSG-Datei im Quellordner ermitteln
    strDateiname = Dir(OL_Datenabgleich.AddSlash(strQuellordner) & "*.msg")
    'Schleife wiederholen, solange MSG-Datei gefunden wird
    Do While strDateiname <> ""
        'Auf Ereignisse reagieren
        DoEvents
        
        'Wenn Dateiname nicht mit dem Namen dieses Computers beginnt,
        'die Datei also von einem anderen PC stammt, und...
        If InStr(LCase(strDateiname), LCase(strDieserComputer) & "_") <> 1 Then
            '... wenn Name dieses Computers mit Bindestrich davor nicht im
            'weiteren Dateinamen vorkommt, die Datei also nicht bereits
            'von diesem Computer gelesen wurde, dann...
            If InStr(LCase(strDateiname), "-" & LCase(strDieserComputer)) = 0 Then
                '... von erfolgreichem Import ausgehen
                blnErfolg = True
            
                'Name des Quellcomputers aus Dateinamen isolieren
                strQuellComputer = LeftString(strDateiname, "_")
                'Neues Element aus Datei erstellen
                Set objItem = Application.CreateItemFromTemplate(OL_Datenabgleich.AddSlash(strQuellordner) & strDateiname, objOLOrdner)
                With objItem
                    'Userproperty "EingelesenVon" anlegen und
                    'Name des Quellcomputers darin speichern
                    .UserProperties.Add("EingelesenVon", olText).Value = strQuellComputer
                    'Wenn Element eine Nachricht ist, dann...
                    If TypeName(objItem) = "MailItem" Then
                        '... als ungelesen markieren
                        .UnRead = True
                        
                        'Ggf. vorhandenen Fehler zurcksetzen
                        Err.Clear
                        'Element in den Zielordner verschieben
                        .Move objOLOrdner
                        'Im Falle eines Fehlers...
                        If Err <> 0 Then
                            '... Misserfolg vermerken
                            blnErfolg = False
                            'Fehler zurcksetzen
                            Err.Clear
                        End If
                    'Wenn Element keine Nachricht ist, dann...
                    Else
                        '... im Outlook-Zielordner speichern
                        .Save
                        'Erfolg oder Misserfolg vermerken
                        blnErfolg = objItem.Saved
                    End If
                End With
                
                'Wenn Einlesen erfolgreich war, dann...
                If blnErfolg = True Then
                    '... Zhler erhhen
                    intZhler = intZhler + 1
                    'Erfolgsmeldung in Listenfeld ausgeben
                    Call Ausgabe("  Eingelesen: " & Chr(34) & objItem.Subject & Chr(34))
                    
                    'Jetzt noch Datei als eingelesen kennzeichnen, dazu
                    'Namen dieses Computers an Dateinamen anhngen
                    strNeuerDateiname = LeftString(strDateiname, ".") & "-" & strDieserComputer & ".msg"
                    'Ggf. vorhandenen Fehler zurcksetzen
                    Err.Clear
                    'MSG-Datei mit neuem Namen umbenennen
                    Name OL_Datenabgleich.AddSlash(strQuellordner) & strDateiname As OL_Datenabgleich.AddSlash(strQuellordner) & strNeuerDateiname
                    'Wenn Operation nicht erfolgreich war, dann...
                    If Err <> 0 Then
                        '... Fehlermeldung ausgeben
                        Call Ausgabe("  FEHLER: MSG-Datei von " & Chr(34) & objItem.Subject & Chr(34) & " konnte nicht umbenannt werden.")
                        'Fehler zurcksetzen
                        Err.Clear
                    End If
                'Wenn Element nicht gelesen werden konnte, dann...
                Else
                    '... Meldung ber Misserfolg ausgeben
                    Call Ausgabe("  Nicht eingelesen: " & Chr(34) & objItem.Subject & Chr(34))
                    'Element lschen (insbesondere Mails aus Ordner Entwrfe)
                    objItem.Delete
                End If
            End If
        End If
        
        'Nchste MSG-Datei ermitteln
        strDateiname = Dir()
        
        'Wenn Benutzer auf "Abbrechen" geklickt hat, dann...
        If blnCancel = True Then
            '... Schleife verlassen
            Exit Do
        End If
    Loop

    'Zhlerwert zurckgeben
    OLOrdnerEinlesen = intZhler
End Function

Private Function HolUserProp(objItem As Object, strPropName As String) As String
    Dim objUserProp As UserProperty
                
    'Fehlerverfolgung aus
    On Error Resume Next
    
    'Verweis auf benutzerdefinierte Eigenschaft holen
    Set objUserProp = objItem.UserProperties.Find(strPropName)
    'Wert der Eigenschaft zurckgeben
    HolUserProp = objUserProp.Value
End Function

Private Function HolComputerName() As String
    Dim strPuffer As String
    Dim lngLnge As Long
    
    'bergabepuffer einrichten
    strPuffer = Space(16)
    'Lnge des bergabepuffers berechnen
    lngLnge = Len(strPuffer)
    'Wenn API-Funktion Wert zurckliefert, dann...
    If CBool(GetComputerName(strPuffer, lngLnge)) Then
        '... Computernamen aus Puffer isolieren und zurckgeben
        HolComputerName = Left(strPuffer, lngLnge)
    End If
End Function

Private Function LeftString(strText As String, strChar As String) As String
    Dim intPos As Integer
    
    'Nach erstem Vorkommen von strChar in strText suchen
    intPos = InStr(strText, strChar)
    'Wenn Zeichen entdeckt, dann...
    If intPos > 0 Then
        '... Text vor dem Zeichen zurckgeben
        LeftString = Left(strText, intPos - 1)
    End If
End Function

Private Sub Ausgabe(strText As String)
    'Wenn strText die Zeichenkette "FEHLER:" enthlt, dann...
    If InStr(UCase(strText), "FEHLER:") > 0 Then
        '... kurzes Tonsignal ausgeben
        Beep
    End If
    
    'Wenn strText "-" ist, dann...
    If strText = "-" Then
        '... hundert Striche ausgeben
        strText = String(100, "-")
    End If
    
    With lstVerlauf
        'strText dem Listenfeld lstVerlauf hinzufgen
        .AddItem strText
        'Letztes Element markieren
        .ListIndex = .ListCount - 1
    End With
    'Userform neuzeichnen, da neuer Eintrag ansonsten
    'nicht zu sehen ist
    Me.Repaint
End Sub
