<?php
include('adodb/adodb.inc.php');
include('global.inc.php');
$conn = &ADONewConnection(DBTYPE);
$conn->Connect(DBHOST, DBUSER, DBPASS, DBNAME);
$conn->SetFetchMode(ADODB_FETCH_ASSOC);
$data = array (
   'title'   => 'Alle MP3-Titel',
   'version' => strftime("%d.%m.%Y")
);
$sql = sprintf("
   SELECT
      albums.album   album,
      albums.id      album_id,
      artists.artist artist,
      artists.id     artist_id
   FROM
      albums,
      artists,
      titles
   WHERE
      albums.id = titles.album_id
      AND artists.id = titles.artist_id
      AND album_id = %d",
   $_GET['id']);
$res = $conn->Execute($sql);
$data['title'] = 'Titelliste: ' . $res->fields['artist'] . ' - ' . $res->fields['album'];

$artist_id = $res->fields['artist_id'];
$album_id = $res->fields['album_id'];

$sql = sprintf(
   "SELECT
      titles.no           position,
      titles.title        track,
      titles.bitrate      bitrate,
      titles.file_name    filename,
      titles.file_size    filesize,
      titles.playing_time playing_time,
      titles.id           id
   FROM
      titles
   WHERE
      titles.album_id = %d
      AND titles.artist_id = %d
   ORDER BY
      titles.no",
   $album_id,
   $artist_id);
$res = $conn->Execute($sql);
$i = 0;
while (!$res->EOF)
{
   $mins = intval($res->fields['playing_time'] / 60);
   $data['tracks'][$i] =
      array(
         'position'     => $res->fields['position'],
         'track'        => $res->fields['track'],
         'bitrate'      => $res->fields['bitrate'],
         'filename'     => $res->fields['filename'],
         'id'           => $res->fields['id'],
         'filesize'     =>
            number_format($res->fields['filesize'] / 1024,
            1, ',', '.'),
         'playing_time' =>
            sprintf("%d:%02d",
               $mins,
               $res->fields['playing_time'] - ($mins * 60)
            )
      );
   $res->MoveNext();
   $i++;
}
$res->Close();
$conn->Close();
$tpl = tmpl_open("albumtitles.tmpl");
tmpl_set($tpl, $data);
echo tmpl_parse($tpl);
tmpl_close($tpl);
?>
