#! /bin/sh
#
# Achtung, dieses Skript ist als root auszufhren!

# folgende Variablen bitte an die eigene Umgebung anpassen:

# Pfad, unter dem MySQL die Datenbankdateien ablegt
MYSQL_DATA_DIR=/var/lib/mysql

# Name der MySQL-Datenbank
DBNAME=music
DBUSER=music
DBPASS=music

# Pfad zu den MP3-Dateien
# MP3PATH=/mnt/mm/Musik/CDs
MP3PATH=/srv/www/htdocs/music

# Unterhalb dieser Zeile bitte nichts ndern!
# ------------------------------------------------------------------
CSVFILE=mp3.csv
OUTPUT=$MYSQL_DATA_DIR/$DBNAME/$CSVFILE
TMPFILE=`mktemp`

# MySQL-Datenbank einrichten
echo MySQL-Datenbank wird eingerichtet ..
mysql -u root $DBNAME < db_music_init.sql

# MP3-Tags auslesen und in ein Flatfile schreiben
echo ID3-Informationen werden gelesen ..
cd $MP3PATH
find . -name "*.[mM][pP]3" -type f -exec mp3info -p "%l;%a;%y;%G;%o;%n;%t;%S;%Q;%r;%L;%k;%F\n" {} \; > $OUTPUT

echo "LOAD DATA INFILE '$CSVFILE' REPLACE INTO TABLE mp3 FIELDS TERMINATED BY ';' LINES TERMINATED BY '\n' (album_name, artist, published, genre_id, stereo, track_no, track_title, playing_time, sample_freq, bitrate, mpeg_layer, file_size, file_name);" > $TMPFILE

# Flatfile in Datenbank einlesen
echo Flatfile wird in Datenbank importiert ..
mysql -u root $DBNAME < $TMPFILE
rm -f $TMPFILE
rm -f $OUTPUT

echo Datenbank wird normalisiert ..
mysql -u $DBUSER -p$DBPASS $DBNAME < db_music_normalize.sql

exit 0

