unit DelphiComCSClientU;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, CS_DLLLib_TLB, CS_EXELib_TLB, MMSystem;

type
  TForm1 = class(TForm)
    bInProcEarly: TButton;
    bOutProcEarly: TButton;
    Memo1: TMemo;
    Label1: TLabel;
    procedure bInProcEarlyClick(Sender: TObject);
    procedure bOutProcEarlyClick(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation
{$R *.dfm}

const Msgs: Array[0..6] of String =
  ('Empty loop', 'NoParam', 'IntParam', 'StrParam', 'StrParam2', 'IntProp', 'StrProp');

procedure TForm1.bInProcEarlyClick(Sender: TObject);
var CT: ICoCsDLLDisp;
    STime, elapsed: Cardinal;
    BNum, x, Dummy: Integer;
begin
  Memo1.Clear;
  Memo1.Lines.Add('*** Delphi 7 - early binding ***');
  STime := timeGetTime;
  CT := CoCoCsDLL.Create;
  elapsed := timeGetTime - STime;
  Memo1.Lines.Add('Create (single): '+IntToStr(elapsed));
  if GetCurrentProcessId = Cardinal(CT.ProcessID) then Memo1.Lines.Add('in-process')
   else Memo1.Lines.Add('out-of-process');

  STime := timeGetTime;
  for x := 1 to 100000 do
  begin
    CT := CoCoCsDLL.Create;
  end;
  elapsed := timeGetTime - STime;
  Memo1.Lines.Add('Create (100K): '+IntToStr(elapsed));

  for BNum := 0 to 6 do
  begin
     Dummy := 0;
     STime := timeGetTime;
     for x := 1 to 1000000 do // 1E6
       case BNum of
         0: Inc(Dummy, 1);
         1: CT.NoParam;
         2: CT.IntParam(4);
         3: CT.StrParam('Some string');
         4: CT.StrParam('Some String with twice as many characters');
         5: Dummy := CT.IntProp;
         6: if CT.StrProp <> '' then ;
       end;
      elapsed := timeGetTime - STime;
      Memo1.Lines.Add(Msgs[BNum] + ': ' + IntToStr(elapsed));;
  end;
end;

procedure TForm1.bOutProcEarlyClick(Sender: TObject);
const DivFac = 100;
var CT: ICsExeDisp;
    STime, elapsed: Cardinal;
    BNum, x, Dummy: Integer;
begin
  Memo1.Lines.Add('*** Delphi 7 - early binding ***');
  STime := timeGetTime;
  CT := CoCsExe.Create;
  elapsed := timeGetTime - STime;
  Memo1.Lines.Add('Create (single): '+IntToStr(elapsed));
  if GetCurrentProcessId = Cardinal(CT.ProcessID) then Memo1.Lines.Add('in-process')
   else Memo1.Lines.Add('out-of-process');
  STime := timeGetTime;
  for x := 1 to 100000 div DivFac do
  begin
    CT := CoCsExe.Create;
  end;
  elapsed := timeGetTime - STime;
  Memo1.Lines.Add('Create (100K): '+IntToStr(elapsed * DivFac));

  for BNum := 0 to 6 do
  begin
     Dummy := 0;
     STime := timeGetTime;
     for x := 1 to 1000000 div DivFac do // 1E6
       case BNum of
         0: Inc(Dummy, 1);
         1: CT.NoParam;
         2: CT.IntParam(4);
         3: CT.StrParam('Some string');
         4: CT.StrParam('Some String with twice as many characters');
         5: Dummy := CT.IntProp;
         6: if CT.StrProp <> '' then ;
       end;
      elapsed := timeGetTime - STime;
      Memo1.Lines.Add(Msgs[BNum] + ': ' + IntToStr(elapsed * DivFac));
  end;
end;

end.
