VERSION 5.00
Begin {C62A69F0-16DC-11CE-9E98-00AA00574A4F} frmNachverfolgung 
   Caption         =   "frmNachverfolgung"
   ClientHeight    =   5085
   ClientLeft      =   45
   ClientTop       =   435
   ClientWidth     =   7695
   OleObjectBlob   =   "frmNachverfolgung.frx":0000
   StartUpPosition =   1  'Fenstermitte
End
Attribute VB_Name = "frmNachverfolgung"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

' 2004, Ralf Nebelo

Private Sub UserForm_Initialize()
    Dim vntWerte As Variant
    Dim intAnzahl As Integer
    Dim intI As Integer
    Dim strEntryID As String
    Dim objItem As Object
    
    'Fehlerverfolgung ausschalten
    On Error Resume Next
    
    'Alle Registry-Werte in zweidimensionale Feldvariable einlesen
    vntWerte = GetAllSettings(OL_Nachverfolgung.APPNAME, "Elemente")
    'Anzahl der Feldvariablenwerte ermitteln
    intAnzahl = UBound(vntWerte, 1) + 1
    'Wenn Anzahl Null ist, dann...
    If intAnzahl = 0 Then
        '... Meldung anzeigen und...
        MsgBox "Es sind derzeit keine Elemente zur Nachverfolgung gekennzeichnet.", vbInformation, OL_Nachverfolgung.APPNAME
        '... Dialogfeld vor dem Sichtbarwerden schlieen
        End
    End If
    
    'Fenstertiteltext festlegen
    Me.Caption = OL_Nachverfolgung.APPNAME & " -  2004, Ralf Nebelo"
    
    'Listenfeld konfigurieren
    With lstElemente
        'Vier Spalten einrichten
        .ColumnCount = 4
        'Spaltenbreiten festlegen; letzte Spalte unsichtbar
        .ColumnWidths = "150;150;60;0"
    
        'Alle Elemente der Feldvariablen durchlaufen
        For intI = 1 To intAnzahl
            'Entry-ID aus Dimension 0 des Elements auslesen
            strEntryID = vntWerte(intI - 1, 0)
            
            'Verweis auf Outlook-Element ber Entry-ID holen
            Set objItem = GetNamespace("MAPI").GetItemFromID(strEntryID)
            'Wenn Outlook-Element vorhanden ist, dann...
            If Not objItem Is Nothing Then
                With lstElemente
                    '... Betreff in erste Spalte des Listenfelds bernehmen
                    .AddItem objItem.Subject
                    'Absender in zweite Spalte bernehmen
                    .List(.ListCount - 1, 1) = objItem.SenderName
                    'Datum der Elementerstellung in dritte Spalte bernehmen
                    .List(.ListCount - 1, 2) = Format(objItem.CreationTime, "Short Date")
                    'Entry-ID in unsichtbare Spalte bernehmen
                    .List(.ListCount - 1, 3) = strEntryID
                End With
            'Wenn Element nicht mehr vorhanden ist, dann...
            Else
                '... Elementeintrag aus Registry lschen (Schlsselname = Entry-ID)
                DeleteSetting OL_Nachverfolgung.APPNAME, "Elemente", strEntryID
            End If
            
            'Verweis auf Outlook-Element lschen
            Set objItem = Nothing
        Next
        
        'Letztes Element markieren
        .ListIndex = .ListCount - 1
    End With

    'Prozedur fr Schaltflchenstatus aufrufen
    Call ButtonStatus
End Sub

Private Sub lstElemente_DblClick(ByVal Cancel As MSForms.ReturnBoolean)
    'Klick auf cmdShow-Button simulieren
    If lstElemente.ListIndex > -1 Then
        cmdShow_Click
    End If
End Sub

Private Sub cmdShow_Click()
    Dim strEntryID As String
    Dim objItem As Object
    
    'Entry-ID aus unsichtbarer Listenfeldspalte lesen
    strEntryID = lstElemente.List(lstElemente.ListIndex, 3)
    'Verweis auf Outlook-Element ber Entry-ID holen
    Set objItem = GetNamespace("MAPI").GetItemFromID(strEntryID)
    'Wenn Outlook-Element existiert, dann...
    If Not objItem Is Nothing Then
        '... Outlook-Element anzeigen
        objItem.Display
    End If
End Sub

Private Sub cmdLschen_Click()
    Dim strEntryID As String
    
    With lstElemente
        'Entry-ID aus unsichtbarer Listenfeldspalte lesen
        strEntryID = .List(.ListIndex, 3)
        'Aktuellen Listenfeldeintrag lschen
        .RemoveItem .ListIndex
    End With
    'Elementeintrag aus Registry lschen (Schlsselname = Entry-ID)
    DeleteSetting OL_Nachverfolgung.APPNAME, "Elemente", strEntryID
    
    'Prozedur fr Schaltflchenstatus aufrufen
    Call ButtonStatus
End Sub

Private Sub cmdCancel_Click()
    'Userform entladen
    Unload Me
End Sub

Private Sub UserForm_QueryClose(Cancel As Integer, CloseMode As Integer)
    'Prozedur OLNV_StartButtonsAnlegen aufrufen, um die aktuelle Elementzahl
    'in der Beschriftung des zweiten Makrostart-Buttons anzuzeigen
    Call OL_Nachverfolgung.OLNV_StartButtonsAnlegen
End Sub

Private Sub ButtonStatus()
    'cmdShow nur aktivieren, wenn Listenfeldelement markiert
    cmdShow.Enabled = lstElemente.ListIndex > -1
    'cmdLschen nur aktivieren, wenn Listenfeldelement markiert
    cmdLschen.Enabled = lstElemente.ListIndex > -1
End Sub

