/*****************************************************************
master.c

License: GPL
         If you publish any numbers based on this program, 
         please send me a note. Please mention my employer
	 "c't magazin, http://www.heise.de/ct", as source of 
         this program.

Disclaimer:

   Use at your own risk.
   The author takes no responsibility that this programm compiles, runs
   or does anything useful. No repsonibiltity for eventual harm to 
   your system is taken either.

   I'm not able to guarantee any support or bug fixes. 
   I will do my best though :-)

----Compile:

cc -O3 master.c -o master
******************************************************************/

#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/mman.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <unistd.h>
#include <netinet/in.h>
#include <netdb.h>
#include <errno.h>
#include <malloc.h>
#include <fcntl.h>
#include <time.h>
#include <ctype.h>
#include <stdlib.h>
#include <string.h>
#include <netinet/tcp.h>

#define TRUE 1
#define FALSE 0

/* global vars - FIXME: check which really need to be global */

struct	sockaddr_in s_in;

char	verbose=FALSE, debug=FALSE, param_f=FALSE, ign_size=FALSE;

static int sock = -1;

#define MAX_SYNC_CLIENTS 128

int sync_port = 7777;
int nr_sync_clients = 0;

static const int getwww_magic = 0xdeadbeef;

int main(int argc, char ** argv)
{

struct sockaddr_in s_s_in;         // sync host IP
int	errflag=0;

int	i, c;

extern	char *	optarg;
extern	int	optind;

 int fd[MAX_SYNC_CLIENTS];
 int ret;

 while ( ( c = getopt( argc, argv, "vd:p:" ) ) != -1 )
   {
     switch( c )
       {
       case 'v': verbose=TRUE; break;
       case 'd': debug=TRUE; break;
       case 'p': sync_port=atoi(optarg); break;
       case '?': errflag++; break;
       }
   }

 if ( optind+1 != argc ) {
   errflag++;
 } else {
   nr_sync_clients=atoi(argv[optind++]);
 }
 
 if (nr_sync_clients > MAX_SYNC_CLIENTS) errflag++;
 if (nr_sync_clients <= 0) errflag++;
 
 if ( errflag )
   {
     fprintf( stderr, "%s [options] <number of clients>\n"
	      "\t[-v]\tverbose output\n"
	      "\t[-d]\tdebugging\n"
	      "\t[-p port]\tsync master port (def. 7777)\n"
	      , argv[0] );
     return 1;
   }

 bzero ((char *) &s_s_in, sizeof (s_s_in));
 s_s_in.sin_port = htons(sync_port);

 sock = socket (AF_INET, SOCK_STREAM, 0);
 if (bind(sock, (struct sockaddr*)&s_s_in, sizeof(s_s_in)) < 0) {
   fprintf(stderr, "sync bind failed\n");
   exit(1);
 }

 if (listen(sock, sync_port) == -1) {
   fprintf(stderr,"sync listen failed\n");
   exit(2);
 }

 if (verbose)
   printf("waiting for connections\n");
 
 for (i = 0; i < nr_sync_clients; i++) {
   struct sockaddr addr;
   int in_addrlen = sizeof(addr);
   unsigned int magic;
   
   fd[i] = accept(sock,&addr,&in_addrlen);
   ret = write(fd[i], &getwww_magic, sizeof(getwww_magic));
   if (ret != sizeof(getwww_magic)) {
     fprintf(stderr,"sync write failed\n");
     exit(2);
   }
   ret = read(fd[i], &magic, sizeof(magic));
   if (magic != getwww_magic) {
     fprintf(stderr,"bad magic from client\n");
     exit(2);
   }
 }
 // all clients have arrived, start up:
 for (i = 0; i < nr_sync_clients; i++) {
   ret = write(fd[i], &getwww_magic, sizeof(getwww_magic));
   if (ret != sizeof(getwww_magic)) {
     fprintf(stderr,"sync write failed\n");
     exit(2);
   }
   close (fd[i]);
 }
 close(sock);
 return 0;
}




