Option Explicit

' ***********************************************************************************************************
' * Scriptname:  complete.vbs
' * Version:     1.0 (24.07.2004)
' * Requirement: - WSH 2.0 oder grer
' *              - BITSADMIN.EXE Version 1.5 oder grer (im gleichen Verzeichnis, wie dieses Script)
' *
' * Description: Schliet den BITS-Auftrag ab, gibt eine Meldung an den Benutzer aus und zeit das Verzeichnis
' *              an, in dem die bertragene Datei liegt.
' *
' * Autor:       Stefan Finkenzeller
' * Parameter 1: Name des BITS-Jobs
' * Parameter 2: Lokaler, absoluter Dateiname der bertragenen Datei (z.B. c:\download\xx.pdf)
' ***********************************************************************************************************

Main()

'**************
'***  Main  ***
'**************
Sub Main

    Dim strJobname, strFilename
  
    ' Prfen, ob zwei Parameter bergeben wurden
    GetParameter strJobname, strFilename
  
    ' BITS anweisen, den Job abzuschlieen und die bertragene Datei zugreifbar zu machen
    CompleteJob  strJobname
  
    ' Meldung dem Benutzer ausgeben
    Wscript.echo "BITS hat die Datei '" + strFilename + "' erfolgreich bertragen."

    ' Verzeichnis anzeigen, in dem sich die bertragene Datei befindet
    ViewDirectory strFilename
  
End Sub


'***********************
'***  GetParameter  *** Prfen, ob zwei Parameter bergeben wurden und gibt diese ber die Parameter zurck
'***********************
Sub GetParameter(strJobname, strFilename)
  
    Dim oArgs
    Set oArgs = wscript.Arguments 
  
    If oArgs.Count <> 2  Then 
        Wscript.echo "Falsche Anzahl an Parametern. Dieses Script wird nur vom Tool BITSADMIN.EXE aufgerufen!" & vbCRLF _
                     & "USAGE: wscript.exe complete.vbs <jobname> <lokaler Dateiname>"
        ' Script abbrechen
        Wscript.Quit(1)
    End If 
  
    ' Parameter dem Aufrufer zurckgeben
    strJobname = oArgs(0)
    strFilename = Replace(oArgs(1), "@~@", " ")		' evtl. enthaltene Leerzeichen wurden vorher kodiert, damit der Pfad komplett bertragen wird
  
End Sub


'*********************
'***  CompleteJob  *** BITS anweisen, den Job abzuschlieen und die bertragene Datei zugreifbar zu machen
'*********************
Sub CompleteJob(strJobname)
  
    Dim strBitsadmin, oWshShell, intRet, strBefehl 
  
    ' Pfad von BITSADMIN.EXE zusammenbauen (liegt im gleichen Verzeichnis, wie dieses Script)
    strBitsadmin = GetScriptPath() & "bitsadmin.exe"
  
    ' Kommando ausfhren
    set oWshShell = Wscript.CreateObject("Wscript.Shell") 
    strBefehl = AddQuotes(strBitsadmin) & " /complete " & strJobname
    intRet = oWshShell.Run(strBefehl, 0, TRUE) 

    ' Prfen, ob alles geklappt hat (Returncode)
    If intRet <> 0 Then
      	CallError "Job konnte nicht abgeschlossen werden.", strBefehl, intRet
    End If
  
End Sub


'***********************
'***  ViewDirectory  *** Verzeichnis anzeigen, in dem sich die bertragene Datei befindet
'***********************
Sub ViewDirectory(strFilename)
  
    Dim strExplorer, oWshShell, intRet, strBefehl 
  
    ' Pfad von EXPLORER.EXE zusammenbauen 
    strExplorer = GetSystemroot() & "explorer.exe"
  
    ' Kommando ausfhren
    set oWshShell = Wscript.CreateObject("Wscript.Shell") 
    strBefehl = AddQuotes(strExplorer) & " /select," & AddQuotes(strFilename)
    intRet = oWshShell.Run(strBefehl, 1, FALSE) 

    ' Prfen, ob alles geklappt hat (Returncode)
    If intRet <> 0 Then
      	CallError "Datei kann im Explorer nicht angezeigt werden.", strBefehl, intRet
    End If
  
 End Sub


' ****************************************************************************************
' **************************   H I L F S F U N K T I O N E N   ***************************
' ****************************************************************************************


'***********************
'***  GetScriptPath  *** Liefert den Pfad des aktuellen Scriptes zurck
'***********************
Function GetScriptPath()

    GetScriptPath = Left(Wscript.Scriptfullname, InStrRev(WScript.ScriptFullname, "\"))

End Function


'***********************
'***  GetSystemroot  *** Liefert den Pfad auf SystemRoot zurck (z.B. 'C:\winnt\')
'***********************
Function GetSystemroot()

    Dim objWshShell, objWshSysEnv

    Set objWshShell = WScript.CreateObject("Wscript.Shell")
    Set objWshSysEnv = objWshShell.Environment("PROCESS")
    GetSystemroot = objWshSysEnv("SYSTEMROOT") & "\"
    Set objWshSysEnv = nothing
    Set objWshShell = nothing

End Function


'*******************
'***  AddQuotes  *** Fgt an den Anfang und an das Ende Hochkommas an
'*******************
Function AddQuotes(strString)

    AddQuotes = Chr(34) & strString & Chr(34)
    
End Function


'*******************
'***  CallError  *** Gibt einen Fehler aus und beendet das Script
'*******************
Sub CallError(strErrortext, strBefehl, intError)

    ' Fehlermeldung ausgeben
    WScript.echo "*** FEHLER: " & strErrortext & " ***" & vbCRLF & "Befehl: '" & strBefehl & "'" & vbCRLF & "Fehlercode: " & CStr(intError)

    ' Script abbrechen
    Wscript.Quit(2)
   
End Sub