// EnumAPIs - demonstriert den Aufruf von Enum-Funktionen via PInvoke
//   da das Compact Framework fr PInvoke keine Rckruffunktionen untersttzt
//   muss eine C-DLL als Zwischenschicht (Thunk) geschaltet werden, die 
//   Rckrufe in SendMessage ummnzt
// Autor: Rudolf Huttary, 9.2004

#define Emulator  // Emulator arbeitet mit enumX86.dll, phys. Gert mit enumArm.dll
using System; 
using System.Windows.Forms;
using Microsoft.WindowsCE.Forms; 
using System.Runtime.InteropServices;
using System.Text;

namespace EnumAPIs
{
	public class Form1 : System.Windows.Forms.Form
	{
		private System.Windows.Forms.ListBox listBox1;
		private System.Windows.Forms.Button button1;
		private System.Windows.Forms.Button button2;
		private System.Windows.Forms.Button bClear;
		private System.Windows.Forms.MainMenu mainMenu1;

		public Form1()
		{
			InitializeComponent();
		}
		protected override void Dispose( bool disposing )
		{
			base.Dispose( disposing );
		}
		#region Vom Windows Form-Designer generierter Code
		/// <summary>
		/// Erforderliche Methode fr die Designeruntersttzung. 
		/// Der Inhalt der Methode darf nicht mit dem Code-Editor gendert werden.
		/// </summary>
		private void InitializeComponent()
		{
			this.mainMenu1 = new System.Windows.Forms.MainMenu();
			this.listBox1 = new System.Windows.Forms.ListBox();
			this.button1 = new System.Windows.Forms.Button();
			this.button2 = new System.Windows.Forms.Button();
			this.bClear = new System.Windows.Forms.Button();
			// 
			// listBox1
			// 
			this.listBox1.Location = new System.Drawing.Point(8, 48);
			this.listBox1.Size = new System.Drawing.Size(224, 210);
			// 
			// button1
			// 
			this.button1.Location = new System.Drawing.Point(8, 8);
			this.button1.Size = new System.Drawing.Size(96, 32);
			this.button1.Text = "EnumWindows";
			this.button1.Click += new System.EventHandler(this.bEnumWindows_Click);
			// 
			// button2
			// 
			this.button2.Location = new System.Drawing.Point(152, 8);
			this.button2.Size = new System.Drawing.Size(80, 32);
			this.button2.Text = "EnumFonts";
			this.button2.Click += new System.EventHandler(this.bEnumFonts_Click);
			// 
			// bClear
			// 
			this.bClear.Location = new System.Drawing.Point(104, 8);
			this.bClear.Size = new System.Drawing.Size(48, 32);
			this.bClear.Text = "Clear";
			this.bClear.Click += new System.EventHandler(this.bClear_Click);
			// 
			// Form1
			// 
			this.Controls.Add(this.bClear);
			this.Controls.Add(this.button2);
			this.Controls.Add(this.button1);
			this.Controls.Add(this.listBox1);
			this.Menu = this.mainMenu1;
			this.Text = "EnumAPIs";
			this.Load += new System.EventHandler(this.Form1_Load);

		}
		#endregion

		static void Main() 
		{
			Application.Run(new Form1());
		}

#if Emulator
		[DllImport ("enumX86.dll")]
		static extern bool EnumWindowsPoster(IntPtr hwnd); 
		[DllImport ("enumX86.dll")]
		static extern bool EnumFontsPoster(IntPtr hwnd); 
#else
		[DllImport ("enumARM.dll")]
		static extern bool EnumWindowsPoster(IntPtr hwnd); 
		[DllImport ("enumARM.dll")]
		static extern bool EnumFontsPoster(IntPtr hwnd); 
#endif
		private void bEnumWindows_Click(object sender, System.EventArgs e)
		{
			EnumWindowsPoster(mw.Hwnd); 
		}
		private void bEnumFonts_Click(object sender, System.EventArgs e)
		{
			EnumFontsPoster(mw.Hwnd); 
		} 
		private void bClear_Click(object sender, System.EventArgs e)
		{
			listBox1.Items.Clear(); 
		}

		// Rckrufmethode fr MyMessWindow 
		// Verarbetet die SendMessage-Nachrichten der C-DLL
		private void MessageCB(ref Message m)
		{
			if (m.Msg == 1000)
			{
				StringBuilder sb = new StringBuilder(256); 
				int res = GetWindowText((uint) m.LParam, sb, sb.Capacity); 
				listBox1.Items.Add(m.LParam.ToString() + " " + sb.ToString()); 
				m.Result = new IntPtr(1); 
			}
			if (m.Msg == 1001)
			{
				int len = (int) m.LParam; 
				char[] buf = new char[len]; 
				Marshal.Copy(m.WParam, buf,0, len); 
				string s = new String(buf); 
				listBox1.Items.Add(s); 
				m.Result = new IntPtr(1); 
			}
		}

		[DllImport ("coredll.dll")]
		static extern int GetWindowText(uint hWnd, StringBuilder WindowCaption, int nMaxCount);

		MyMessWindow mw; 
		private void Form1_Load(object sender, System.EventArgs e)
		{
			mw = new MyMessWindow(new msg_CB(MessageCB)); 
		}

     	delegate void msg_CB(ref Message m); 
		class MyMessWindow : MessageWindow
		{
			msg_CB CB; 
			public MyMessWindow(msg_CB cb)
			{
				CB = cb; 
			}

			protected override void WndProc(ref Message m)
			{
				CB(ref m); 
			}
		}
	}
}
