/* c't Mikrocontroller-im-LAN Demo Source
 * Datei: led.c 
 * Info: Routinen zur LED-Steuerung
 * Autor: Benjamin Benz (bbe@heise.de)
 * Datum: 24.06.04
*/

#include <io.h>
#include <delay.h>
#include "led.h"

#include "delay.h"

void LED_on(char LED){
	PORTD &= ~LED;
}

void LED_off(char LED){
	PORTD |= LED;	// LED ausschalten
}

void lauflicht(char runs){		// Achtung Endlosschleife!!!!
	LED_off(LED_ALL);
	int i=0;
	while (i<runs){
		LED_on(LED_ROT);
		delay_100ms();
		LED_off(LED_ROT);
		
		LED_on(LED_ORANGE);
		delay_100ms();
		LED_off(LED_ORANGE);
		
		LED_on(LED_GELB);
		delay_100ms();
		LED_off(LED_GELB);
		
		LED_on(LED_GRUEN);
		delay_100ms();
		LED_off(LED_GRUEN);
		i++;
	}
}

//Der Wert der Variablen LED wird mit den LEDs (allen vier) angezeigt.
void switch_LED(char LED){
	PORTD= (PORTD & ~LED_ALL) | (~LED << 3); 
}
	
