import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;

/**
 * @author olz
 * 
 * This class does the TCP/IP work to operate the XPort
 * Most of the get and set methods herein follow the same pattern:
 * Establish a connection, prepare a command, send this command and disconnect.
 * 
 */
public class Communication extends Thread {
	/** connection to XPort */
	protected Socket socket = null;
	/** dis contains data provided by XPort */
	protected BufferedReader dis = null;
	/** dos contains data sent to XPort */
	protected BufferedWriter dos = null;
	
	/**
	 * This method converts the given String ipa_str and the int port into a
	 * useable TCP/IP address and then calls a helper method tcpip_connect()
	 * to establish a connection to the XPort 
	 * @param ipa_str
	 * @param port
	 * @throws IOException
	 * @throws Exception  */
	public void connect(String ipa_str, int port) throws IOException, Exception {
		InetAddress ipa = null;
		try {
			ipa = InetAddress.getByName(ipa_str);
		} 
		catch (UnknownHostException UHEx) {
			throw UHEx;
		} 
		catch (Exception Ex) {
			throw Ex;
		}
		try {
			tcpip_connect(ipa, port);
		} 
		catch (IOException IOEx) {
			throw IOEx;
		} 
		catch (Exception Ex) {
			throw Ex;
		}
	}
	/** this method will end the current connection to the XPort
	 * 
	 * @throws IOException
	 * @throws Exception
	 */
	public synchronized void disconnect() throws IOException, Exception{
		try {
			tcpip_disconnect();
		}
		catch (IOException IOEx) {
			throw IOEx;
		}
		catch (Exception Ex) {
			throw Ex;
		}
	}
	
	/** uses a TCP/IP connection to send a String to the XPort 
	 * 
	 * @param sendString
	 * @throws IOException
	 * @throws Exception
	 */
	public synchronized void send(String sendString) throws IOException, Exception {
		System.out.println(sendString);
		try {
			dos.write(sendString, 0, sendString.length());	
			// write data to dos as String starting at String[0]
			// and ending at String[String.length()]
		} 
		catch (IOException IOEx) {
			throw IOEx;
		} 
		catch (Exception Ex) {
			throw Ex;
		}
		try {
			dos.flush();	// write dos to XPort
		} 
		catch (IOException IOEx) {
			throw IOEx;
		} 
		catch (Exception Ex) {
			throw Ex;
		}
		return;
	}
	
	/** uses a TCP/IP connection to send a String to the XPort 
	 * 
	 * @param sendByte
	 * @throws IOException
	 * @throws Exception
	 */
	public synchronized void send(byte sendByte[]) throws IOException, Exception {
		try {
			for (int i = 0; i < sendByte.length; i++) {
				dos.write(sendByte[i]);		// bytewise write data to dos 
			}
		}
		catch (IOException IOEx) {
			throw IOEx;
		}
		catch (Exception Ex) {
			throw Ex;
		}
		try {
			dos.flush();				// write dos to XPort
		}
		catch (IOException IOEx) {
			throw IOEx;
		}
		catch (Exception Ex) {
			throw Ex;
		}
		
		return;
	}
	
	/** closes the TCP/IP connection 
	 * 
	 * @throws IOException
	 * @throws Exception
	 */
	private void tcpip_disconnect() throws IOException, Exception {
		if (socket.isConnected()) {
			try {
				dis.close();		// close input and output stream 
				dos.close();		// as well as the socket
				socket.close();
			}
			catch (IOException IOEx) {
				throw IOEx;
			}
			catch (Exception Ex) {
				throw Ex;
			}
		}
	}
	
	/** reads data supplied by the XPort and returns a String 
	 * 
	 * @return
	 * @throws InterruptedIOException
	 * @throws IOException
	 * @throws Exception
	 */	public String receiveString() throws InterruptedIOException, IOException,
	Exception {
		String antwort = "";
		try {
			dis.ready();		// check if data is available (actually redundant since
								// the calling method from the GUI class already made 
								// this sure but better safe than sorry... :-)
		}
		catch (IOException IOEx) {
			throw IOEx;
		}
		catch (Exception Ex) {
			throw Ex;
		}
		try {
			antwort = readBuffer();	// call helper method to read from dis
		}
		catch (IOException IOEx) {
			throw IOEx;
		}
		catch (Exception Ex) {
			throw Ex;
		}
		return antwort;
	}
	/** this method will read from DataInputStream dis, 
	 * convert the chars read into ASCII and return its answer as a String
	 * 
	 * @return
	 * @throws IOException
	 * @throws Exception
	 */
	private synchronized String readBuffer() throws IOException, Exception {
		int lesen;					// init helper variables
		String gelesen = "";
		
		while (dis.ready()) {		// loop while data available
			lesen = (dis.read());	// read from dis, put data into lesen
			
									// scan for printable ASCII characters and add them
									// to gelesen
			if (lesen == 0x0a) {
				gelesen += "\n"; // add Line Feed
			} else {
				if (lesen == 0x20) {
					gelesen += " "; // add Blank
				} else {
					if (lesen == 0x0d) {
						gelesen += "\r"; // add Carriage Return
					} else {
						if (lesen > 0x20 && lesen < 0x7e) { // add readable chars
							gelesen += new Character((char) lesen)
							.toString();
						} else {
							gelesen += " (0x" + Integer.toHexString(lesen)
							+ ") "; // add non-readable chars as bytes in brackets
						}
					}
				}
			}
		}
		return gelesen;
	}
	
	/** reads data supplied by the XPort and returns an array of bytes 
	 * 
	 * @param length
	 * @return
	 * @throws InterruptedIOException
	 * @throws IOException
	 * @throws Exception
	 */	public byte[] receiveByteArray(int length) throws InterruptedIOException, IOException,
	Exception {
		byte[] antwort = {0,		// this method hardly differs from the string
				0,0,0,0};			// reading one, so same comments apply
		try {
			dis.ready();
		}
		catch (IOException IOEx) {
			throw IOEx;
		}
		catch (Exception Ex) {
			throw Ex;
		}
		try {
			antwort = readByteArrayBuffer(length);
		}
		catch (IOException IOEx) {
			throw IOEx;
		}
		catch (Exception Ex) {
			throw Ex;
		}
		return antwort;
	}
	
	/** this method will read from DataInputStream dis and 
	 * return its answer as an array of bytes
	 * 
	 * @param length
	 * @return
	 * @throws IOException
	 * @throws Exception
	 */
	private synchronized byte[] readByteArrayBuffer(int length) throws IOException, Exception {
		/* this method again hardly differs from the string reading one, so same comments
		 * apply here as well
		 */
		
		int lesen =0;
		byte gelesen[] = {0,
				0,0,0,0};
		int i =0;
		int timeout =0;
		while(!dis.ready() && timeout < 8) { // wait max 2 seconds for data
			try {
				wait(250);
				timeout++;
			}
			catch (InterruptedException IntEx) {
			}
		}
		while (dis.ready()) {
			while (i < length) {
				try {
					lesen = (dis.read());
					gelesen[i] = (byte)lesen;
					i++;
				}
				catch (IOException IOEx) {
					throw IOEx;
				}
				catch (Exception Ex) {
					throw Ex;
				}
			}
		}
		System.out.println("readBytearray Ende");
		return gelesen;
	}
	
	/** this class does all the actual TCP/IP connection setup work
	 * 
	 * @param ipa
	 * @param port
	 * @throws IOException
	 * @throws Exception
	 */
	public void tcpip_connect(InetAddress ipa, int port) throws IOException,
	Exception {
		try {
			//	really establish a TCP connection (at last...) 
			socket = new Socket(ipa.getHostAddress(), port);
		}
		catch (IOException IOEx) {
			throw IOEx;
		}
		catch (Exception Ex) {
			throw Ex;
		}
		try {		// set up a buffered stream to read from XPort and write to PC
			dis = new BufferedReader(new InputStreamReader(socket.getInputStream()));
		}
		catch (IOException IOEx) {
			throw IOEx;
		}
		catch (Exception Ex) {
			throw Ex;
		}
		try {		// set up a buffered stream to read from PC and write to XPort
			dos = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream()));
		} 
		catch (IOException IOEx) {
			throw IOEx;
		} 
		catch (Exception Ex) {
			throw Ex;
		}
	}
	
	/** this method simply returns the value of DataInputStream dis' method ready()
	 * 
	 * @return
	 * @throws Exception
	 */	
	public boolean DataReady() throws Exception{
		try {
			return dis.ready();
		} 
		catch (Exception Ex) {
			return false;
		}
	}
}