<?php
// include the parser class
require_once ("RSSParser.class.php");

$rssParser = new RSSParser();

$rssSource = "http://www.heise.de/newsticker/heise.rdf";
// $rssSource = "http://www.spiegel.de/schlagzeilen/rss/0,5291,,00.xml";
// $rssSource="http://msdn.microsoft.com/rss.xml";

$rssFile = implode("",file($rssSource));

echo "RSS-Quelle: ".$rssSource;

// start the parsing process
$rssParser->runRSSParsingProcess ($rssFile);

// get the arrays and print the information
$channelInfo = $rssParser->getRSSChannel();
$rssItems    = $rssParser->getRSSItems();

if (isset ($channelInfo["version"]) ) {
  echo "<br>RSS-Version: ".$channelInfo["version"];
} // if
echo "<br>";
if ( isset($channelInfo["imageURL"]) && $channelInfo["imageURL"] != "" ) {
  echo "<a href=\"".$channelInfo["imageLink"]."\">";
  echo "<img src=\"".$channelInfo["imageURL"]."\" ";
  echo "title=\"".$channelInfo["imageTitle"]."\"";
  echo "/>";
  echo "</a>";
} // if
echo "<br>Channel: <b>".$channelInfo["title"]."</b>";
echo "<br>Items: <b>".count($rssItems)."</b>";

foreach ($rssItems as $item) {
  echo "<br>";
  echo "<a href=\"".$item["link"]."\">";
  echo "<span class=\"rssItem\">";
  echo $item["title"];
  echo "</span>";
  echo "</a>";
} // foreach


?>