# -*- coding: ISO-8859-1 -*-
import unittest
from zope.testing.doctestunit import DocFileSuite, DocTestSuite

from blog.interfaces import IBlog, IBlogEntry
from blog.app import Blog, BlogEntry

# providedBy prft, ob eine Klasse behauptet, ein Interface zu
# implementieren, verifyClass prft, ob sie es auch tut.
from zope.interface.verify import verifyClass

class Test(unittest.TestCase):

    def makeTestObjects(self):
        return Blog(), BlogEntry()

    def test_interfaces(self):
        blog, blog_entry = self.makeTestObjects()
        self.assert_(IBlog.providedBy(blog))
        self.assert_(IBlogEntry.providedBy(blog_entry))

    def test_class_implementations(self):
        self.assert_(verifyClass(IBlog, Blog))
        self.assert_(verifyClass(IBlogEntry, BlogEntry))

def test_suite():
    suite = unittest.TestSuite()
    suite.addTest(DocFileSuite('readme.txt'))
    suite.addTest(DocTestSuite('blog.app'))
    suite.addTest(unittest.makeSuite(Test))
    return suite

if __name__ == '__main__':
    unittest.main(defaultTest='test_suite')
