/* $Id: mkqsort.cpp 94 2004-12-15 10:27:17Z olau $ */

#ifdef DEBUG
#include <stdio.h>
#endif
#ifdef __GNUG__
#include <unistd.h>
#endif
#include <string.h>
#include <stdlib.h>
#include "../bwt.h"


/* ssort2 -- Faster Version of Multikey Quicksort
Quelle: http://www.cs.princeton.edu/~rs/strings/demo.c
*/

#ifndef min
#define min(a, b) ((a)<=(b) ? (a) : (b))
#endif

#define swap2(a, b) { t = *(a); *(a) = *(b); *(b) = t; }
#define ptr2char(i) (*(*(i) + depth))
#define med3(a, b, c) med3func(a, b, c, depth)


void vecswap2(char **a, char **b, int n)
{   
   while (n-- > 0)
   {
      char *t = *a;
      *a++ = *b;
      *b++ = t;
   }
}


char **med3func(char **a, char **b, char **c, int depth)
{
   int va, vb, vc;
   if ((va = ptr2char(a)) == (vb = ptr2char(b)))
      return a;
   if ((vc = ptr2char(c)) == va || vc == vb)
      return c;       
   return va < vb ?
      (vb < vc ? b : (va < vc ? c : a ))
      : (vb > vc ? b : (va < vc ? a : c ));
}


void inssort(char **a, int n, int d)
{
   char **pi, **pj, *s, *t;

   for (pi = a + 1; --n > 0; pi++)
   {
      for (pj = pi; pj > a; pj--)
      {
         // Inline strcmp: break if *(pj-1) <= *pj
         for (s = *(pj - 1) + d, t = *pj + d; *s == *t && * s!= 0; s++, t++);
         if (*s <= *t)
            break;
         swap2(pj, pj - 1);
      }
   }
}


void ssort2(char **a, int n, int depth)
{
   int d, r, partval;
   char **pa, **pb, **pc, **pd, **pl, **pm, **pn, *t;

   if (n < 10)
   {
      inssort(a, n, depth);
      return;
   }
   pl = a;
   pm = a + n / 2;
   pn = a + n - 1;
   if (n > 30)
   {   // On big arrays, pseudomedian of 9
      d = n / 8;
      pl = med3(pl, pl + d, pl + 2 * d);
      pm = med3(pm - d, pm, pm + d);
      pn = med3(pn - 2 * d, pn - d, pn);
   }
   pm = med3(pl, pm, pn);
   swap2(a, pm);
   partval = ptr2char(a);
   pa = pb = a + 1;
   pc = pd = a + n - 1;
   for (;;)
   {
      while (pb <= pc && (r = ptr2char(pb) - partval) <= 0)
      {
         if (r == 0)
         {
            swap2(pa, pb);
            pa++;
         }
         pb++;
      }
      while (pb <= pc && (r = ptr2char(pc) - partval) >= 0)
      {
         if (r == 0)
         {
            swap2(pc, pd);
            pd--;
         }
         pc--;
      }
      if (pb > pc) break;
      swap2(pb, pc);
      pb++;
      pc--;
   }
   pn = a + n;
   r = min(pa - a, pb - pa);
   vecswap2(a, pb - r, r);
   r = min(pd - pc, pn - pd - 1);
   vecswap2(pb, pn - r, r);
   if ((r = pb - pa) > 1)
      ssort2(a, r, depth);
   if (ptr2char(a + r) != 0)
      ssort2(a + r, pa - a + pn - pd - 1, depth + 1);
   if ((r = pd - pc) > 1)
      ssort2(a + n - r, r, depth);
}


/* Aufruf der Multikey-Quicksortroutine */
void BWT_M_mk_qsort(void)
{
   ssort2(M, Mlen, 0);
}
