#include "prime.h"
#include <cmath>

//------------------------------------------------------------------
void Prime::Bucket(uint64 n)
{
	if(n >= use) {
		this->BucketSieve();
	}
}
//------------------------------------------------------------------
void Prime::BucketMore()
{
	buckets = new bucket[ _memory_per_create ];

	uint32 e = _memory_per_create - 1;
	uint32 j;

	for(j = 0; j < e; j++) {
		buckets[j].next = &buckets[j + 1]; 
	}

	buckets[e].next = NULL;
}
//------------------------------------------------------------------
void Prime::BucketGet(uint32 n)
{
	if(buckets == NULL) BucketMore();

	bucket *buck;

	buck    = buckets;
	buckets	= buckets->next;

	buck->count = 0;
	buck->next  = lists[n];

	lists[n] = buck;
}
//------------------------------------------------------------------
void Prime::BucketSet()
{
	lists[curr] = buckets;

	buckets = buckets->next;

	lists[curr]->next  = NULL;
	lists[curr]->count = 0;

	curr = (curr + 1) & lsize;
}
//------------------------------------------------------------------
void Prime::BucketInit()
{
	buckets	= NULL;

	 curr = 0;
	lsize = listsize(rsp, incr);

	lists = new bucket* [lsize];

	for(uint32 i = 0; i < lsize; i++) {
		lists[i] = NULL;

		BucketGet(i);
	}

	lsize -= 1; /*AND, 2^n-1 */
}
//------------------------------------------------------------------
void Prime::BucketSetUse()
{
	use = (uint64) shift *
		  (uint64) shift;

	use = (sta < use)
		?use - ((use - sta) % incr) :sta;

	logd = (uint32)
		ceil( log((double)(size)) / log(2) );

	modd = (1 << logd) - 1;
}
//------------------------------------------------------------------
