//Copyright (C) 2003 Kim Walisch

//Sieve Of Eratosthenes, Segmented Mod30 Wheel

//Ecprime, Version 1,4, 23.10.2003

#include "prime.h"
#include <stdio.h>
#include <cstdlib>
#include <cctype>

#if defined( _MSC_VER )		//Ms Visual C++ & Intel

 #define	atol64(_n)	_atoi64(_n)
#else
 #define	atol64(_n)	strtoll(_n, NULL, 10)
#endif

void Help();

int main(int argc, char* argv[])
{
	if(argc < 2 || argc > 19 || !isdigit(argv[1][0]) )
		Help();

	Prime prime;
	prime.SetStop( atol64(argv[1]) );

	uint64 n;


	while( --argc > 1 )
	{
		n = atol64( &argv[argc][2] );

		switch( argv[ argc ][1] )
		{

			case 's': prime.SetSieve( (uint32) (1 << n) * _EC_KB ); /*2^n KB */
				
					for(int i = 2; argv[ argc ][i] != NULL; i++) {
						if(ispunct(argv[ argc ][i]))

							n = atol64( &argv[ argc ][i + 1] );
					}

				      prime.SetGSize( (uint32) (1 << n) * _EC_KB ); /*2^n KB */
				break;
			case 'r': prime.SetRepF(  (uint32) (n) );
				break;
			case 'n': prime.SetStart( (uint64) (n) );
				break;
			case 'g': prime.SetPGap(  (uint32) (n) );	/*sets _EC_PGAPS_ */
				break;
			case 't': prime.SetState( (uint32) _EC_COUNT(n - 1) );
				break;
			case 'p': prime.SetState( (uint32) _EC_PRINT(n - 1) );
				break;
			case 'c': prime.SetState( _EC_PGAPS_CONST  );
				break;
			case 'd': prime.SetState( _EC_TIMES_DETAIL );
				break;

			default: 

				Help();
		}
	}

	printf("\n");

	prime.SetState( _EC_COUNT_PRIMES );
	prime.Search();

	return 1;
}

void Help()
{
	printf("\
		\
		\rversion 1.4, 2003\n \
		\n \
		\recprime [nr] [-n[nr]] [-s[s;u]] [-r[nr]] [-g[nr]] [-t[k]] [-p[k]] [-c] [-d]\n \
		\n \
		\r [nr]  primes up to [nr]\n \
		\n \
		\r  -p1  print primes to file \
		\n");

	exit(1);
}
