/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.util;

public class Matrix
implements Cloneable {
    private static final int MATRIX_SIZE = 3;
    private float[] single = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f};

    public float getValue(int row, int column) {
        return this.single[row * 3 + column];
    }

    public void setValue(int row, int column, float value) {
        this.single[row * 3 + column] = value;
    }

    public Matrix multiply(Matrix b) {
        Matrix result = new Matrix();
        float[] bMatrix = b.single;
        float[] resultMatrix = result.single;
        resultMatrix[0] = this.single[0] * bMatrix[0] + this.single[1] * bMatrix[3] + this.single[2] * bMatrix[6];
        resultMatrix[1] = this.single[0] * bMatrix[1] + this.single[1] * bMatrix[4] + this.single[2] * bMatrix[7];
        resultMatrix[2] = this.single[0] * bMatrix[2] + this.single[1] * bMatrix[5] + this.single[2] * bMatrix[8];
        resultMatrix[3] = this.single[3] * bMatrix[0] + this.single[4] * bMatrix[3] + this.single[5] * bMatrix[6];
        resultMatrix[4] = this.single[3] * bMatrix[1] + this.single[4] * bMatrix[4] + this.single[5] * bMatrix[7];
        resultMatrix[5] = this.single[3] * bMatrix[2] + this.single[4] * bMatrix[5] + this.single[5] * bMatrix[8];
        resultMatrix[6] = this.single[6] * bMatrix[0] + this.single[7] * bMatrix[3] + this.single[8] * bMatrix[6];
        resultMatrix[7] = this.single[6] * bMatrix[1] + this.single[7] * bMatrix[4] + this.single[8] * bMatrix[7];
        resultMatrix[8] = this.single[6] * bMatrix[2] + this.single[7] * bMatrix[5] + this.single[8] * bMatrix[8];
        return result;
    }

    public Object clone() {
        Matrix clone = new Matrix();
        System.arraycopy(this.single, 0, clone.single, 0, 9);
        return clone;
    }

    public Matrix copy() {
        return (Matrix)this.clone();
    }

    public String toString() {
        StringBuffer result = new StringBuffer("");
        result.append("[[");
        result.append(this.single[0] + ",");
        result.append(this.single[1] + ",");
        result.append(this.single[2] + "][");
        result.append(this.single[3] + ",");
        result.append(this.single[4] + ",");
        result.append(this.single[5] + "][");
        result.append(this.single[6] + ",");
        result.append(this.single[7] + ",");
        result.append(this.single[8] + "]]");
        return result.toString();
    }

    public float getXScale() {
        float xScale = this.single[0];
        if (this.single[1] != 0.0f || this.single[3] != 0.0f) {
            xScale = (float)Math.sqrt(Math.pow(this.single[0], 2.0) + Math.pow(this.single[1], 2.0));
        }
        return xScale;
    }

    public float getYScale() {
        float yScale = this.single[4];
        if (this.single[1] != 0.0f || this.single[3] != 0.0f) {
            yScale = (float)Math.sqrt(Math.pow(this.single[3], 2.0) + Math.pow(this.single[4], 2.0));
        }
        return yScale;
    }

    public float getXPosition() {
        return this.single[6];
    }

    public float getYPosition() {
        return this.single[7];
    }
}

