/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.examples.fdf;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.pdfbox.exceptions.CryptographyException;
import org.pdfbox.exceptions.InvalidPasswordException;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.pdmodel.PDDocumentCatalog;
import org.pdfbox.pdmodel.common.PDRectangle;
import org.pdfbox.pdmodel.interactive.annotation.PDWidget;
import org.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.pdfbox.pdmodel.interactive.form.PDField;

public class PrintFields {
    public void printFields(PDDocument pdfDocument) throws IOException {
        PDDocumentCatalog docCatalog = pdfDocument.getDocumentCatalog();
        PDAcroForm acroForm = docCatalog.getAcroForm();
        List fields = acroForm.getFields();
        Iterator fieldsIter = fields.iterator();
        while (fieldsIter.hasNext()) {
            PDField field = (PDField)fieldsIter.next();
            PDWidget widget = field.getWidget();
            PDRectangle rectangle = null;
            if (widget != null) {
                rectangle = widget.getRectangle();
            }
            String outputString = field.getName() + "=" + field.toString() + " rect=" + rectangle + " type=" + field.getClass().getName();
            System.out.println(outputString);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException, CryptographyException {
        block8: {
            PDDocument pdf = null;
            try {
                if (args.length != 1) {
                    PrintFields.usage();
                    break block8;
                }
                pdf = PDDocument.load(args[0]);
                PrintFields exporter = new PrintFields();
                if (pdf.isEncrypted()) {
                    try {
                        pdf.decrypt("");
                    }
                    catch (InvalidPasswordException e) {
                        System.err.println("Error: The document is encrypted.");
                        PrintFields.usage();
                    }
                }
                exporter.printFields(pdf);
            }
            finally {
                if (pdf != null) {
                    pdf.close();
                }
            }
        }
    }

    private static void usage() {
        System.err.println("usage: org.pdfbox.examples.fdf.PrintFields <pdf-file>");
    }
}

