/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel.edit;

import java.io.IOException;
import java.io.OutputStream;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.pdfbox.cos.COSName;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.pdmodel.PDPage;
import org.pdfbox.pdmodel.PDResources;
import org.pdfbox.pdmodel.common.PDStream;
import org.pdfbox.pdmodel.font.PDFont;

public class PDPageContentStream {
    private PDPage page;
    private OutputStream output;
    private boolean inTextMode = false;
    private Map fontMappings = new HashMap();
    private int fontNumber = 1;
    private PDResources resources;
    private NumberFormat formatDecimal = NumberFormat.getNumberInstance();
    private static final byte[] BEGIN_TEXT = "BT\n".getBytes();
    private static final byte[] END_TEXT = "ET\n".getBytes();
    private static final byte[] SET_FONT = "Tf\n".getBytes();
    private static final byte[] MOVE_TO_TEXT_POSITION = "Td\n".getBytes();
    private static final byte[] SHOW_TEXT = "Tj\n".getBytes();
    private static final int SPACE = 32;

    public PDPageContentStream(PDDocument document, PDPage sourcePage) throws IOException {
        this.page = sourcePage;
        this.resources = this.page.getResources();
        if (this.resources == null) {
            this.resources = new PDResources();
            this.page.setResources(this.resources);
        }
        PDStream contents = new PDStream(document);
        ArrayList<COSName> filters = new ArrayList<COSName>();
        filters.add(COSName.FLATE_DECODE);
        contents.setFilters(filters);
        sourcePage.setContents(contents);
        this.output = contents.createOutputStream();
        this.formatDecimal.setMaximumFractionDigits(10);
    }

    public void beginText() throws IOException {
        if (this.inTextMode) {
            throw new IOException("Error: Nested beginText() calls are not allowed.");
        }
        this.output.write(BEGIN_TEXT);
        this.inTextMode = true;
    }

    public void endText() throws IOException {
        if (!this.inTextMode) {
            throw new IOException("Error: You must call beginText() before calling endText.");
        }
        this.output.write(END_TEXT);
        this.inTextMode = false;
    }

    public void setFont(PDFont font, float fontSize) throws IOException {
        String fontMapping = (String)this.fontMappings.get(font);
        if (fontMapping == null) {
            fontMapping = "F" + this.fontNumber++;
            this.fontMappings.put(font, fontMapping);
            this.resources.getFonts().put(fontMapping, font);
        }
        this.output.write("/".getBytes());
        this.output.write(fontMapping.getBytes());
        this.output.write(32);
        this.output.write(this.formatDecimal.format(fontSize).getBytes());
        this.output.write(32);
        this.output.write(SET_FONT);
    }

    public void moveToTextPosition(float x, float y) throws IOException {
        this.output.write(this.formatDecimal.format(x).getBytes());
        this.output.write(32);
        this.output.write(this.formatDecimal.format(y).getBytes());
        this.output.write(32);
        this.output.write(MOVE_TO_TEXT_POSITION);
    }

    public void drawString(String text) throws IOException {
        this.output.write(("(" + text + ") ").getBytes());
        this.output.write(SHOW_TEXT);
    }

    public void appendRawCommands(String commands) throws IOException {
        this.output.write(commands.getBytes());
    }

    public void close() throws IOException {
        this.output.close();
    }
}

