/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel.graphics.color;

import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.ColorModel;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.pdfbox.cos.COSArray;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSFloat;
import org.pdfbox.cos.COSInteger;
import org.pdfbox.cos.COSName;
import org.pdfbox.cos.COSNumber;
import org.pdfbox.cos.COSStream;
import org.pdfbox.pdmodel.common.COSArrayList;
import org.pdfbox.pdmodel.common.PDRange;
import org.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.pdfbox.pdmodel.graphics.color.PDColorSpaceFactory;

public class PDICCBased
extends PDColorSpace {
    public static final String NAME = "ICCBased";
    private COSArray array;
    private COSStream stream;

    public PDICCBased(COSArray iccArray) {
        this.array = iccArray;
        this.stream = (COSStream)iccArray.getObject(1);
    }

    public String getName() {
        return NAME;
    }

    public COSBase getCOSObject() {
        return this.stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ColorSpace createColorSpace() throws IOException {
        InputStream profile = null;
        ICC_ColorSpace cSpace = null;
        try {
            profile = this.stream.getUnfilteredStream();
            ICC_Profile iccProfile = ICC_Profile.getInstance(profile);
            cSpace = new ICC_ColorSpace(iccProfile);
        }
        finally {
            if (profile != null) {
                profile.close();
            }
        }
        return cSpace;
    }

    public ColorModel createColorModel(int bpc) throws IOException {
        throw new IOException("Not implemented");
    }

    public int getNumberOfComponents() throws IOException {
        COSNumber n = (COSNumber)this.stream.getDictionaryObject(COSName.getPDFName("N"));
        return n.intValue();
    }

    public void setNumberOfComponents(int n) {
        this.stream.setItem(COSName.getPDFName("N"), new COSInteger(n));
    }

    public List getAlternateColorSpaces() throws IOException {
        COSBase alternate = this.stream.getDictionaryObject(COSName.getPDFName("Alternate"));
        COSArray alternateArray = null;
        if (alternate == null) {
            alternateArray = new COSArray();
            int numComponents = this.getNumberOfComponents();
            String csName = null;
            if (numComponents == 1) {
                csName = "DeviceGray";
            } else if (numComponents == 3) {
                csName = "DeviceRGB";
            } else if (numComponents == 4) {
                csName = "DeviceCMYK";
            } else {
                throw new IOException("Unknown colorspace number of components:" + numComponents);
            }
            alternateArray.add(COSName.getPDFName(csName));
        } else if (alternate instanceof COSArray) {
            alternateArray = (COSArray)alternate;
        } else if (alternate instanceof COSName) {
            alternateArray = new COSArray();
            alternateArray.add(alternate);
        } else {
            throw new IOException("Error: expected COSArray or COSName and not " + alternate.getClass().getName());
        }
        ArrayList<PDColorSpace> retval = new ArrayList<PDColorSpace>();
        for (int i = 0; i < alternateArray.size(); ++i) {
            retval.add(PDColorSpaceFactory.createColorSpace((COSName)alternateArray.get(i)));
        }
        return new COSArrayList(retval, alternateArray);
    }

    public void setAlternateColorSpaces(List list) {
        COSArray altArray = null;
        if (list != null) {
            altArray = COSArrayList.converterToCOSArray(list);
        }
        this.stream.setItem(COSName.getPDFName("Alternate"), altArray);
    }

    private COSArray getRangeArray(int n) {
        COSArray rangeArray = (COSArray)this.stream.getDictionaryObject(COSName.getPDFName("Range"));
        if (rangeArray == null) {
            rangeArray = new COSArray();
            this.stream.setItem(COSName.getPDFName("Range"), rangeArray);
            while (rangeArray.size() < n * 2) {
                rangeArray.add(new COSFloat(-100.0f));
                rangeArray.add(new COSFloat(100.0f));
            }
        }
        return rangeArray;
    }

    public PDRange getRangeForComponent(int n) {
        COSArray rangeArray = this.getRangeArray(n);
        return new PDRange(rangeArray, n);
    }

    public void setRangeForComponent(PDRange range, int n) {
        COSArray rangeArray = this.getRangeArray(n);
        rangeArray.set(n * 2, new COSFloat(range.getMin()));
        rangeArray.set(n * 2 + 1, new COSFloat(range.getMax()));
    }

    public COSStream getMetadata() {
        return (COSStream)this.stream.getDictionaryObject(COSName.getPDFName("Metadata"));
    }

    public void setMetadata(COSStream metadata) {
        this.stream.setItem(COSName.getPDFName("Metadata"), metadata);
    }
}

