/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.highlight;

import java.io.IOException;
import java.util.HashSet;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.highlight.WeightedTerm;

public final class QueryTermExtractor {
    public static final WeightedTerm[] getTerms(Query query) {
        return QueryTermExtractor.getTerms(query, false);
    }

    public static final WeightedTerm[] getIdfWeightedTerms(Query query, IndexReader reader, String fieldName) {
        WeightedTerm[] terms = QueryTermExtractor.getTerms(query, false);
        int totalNumDocs = reader.numDocs();
        for (int i = 0; i < terms.length; ++i) {
            try {
                int docFreq = reader.docFreq(new Term(fieldName, terms[i].term));
                float idf = (float)(Math.log((double)totalNumDocs / (double)(docFreq + 1)) + 1.0);
                terms[i].weight *= idf;
                continue;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return terms;
    }

    public static final WeightedTerm[] getTerms(Query query, boolean prohibited) {
        HashSet terms = new HashSet();
        QueryTermExtractor.getTerms(query, terms, prohibited);
        return terms.toArray(new WeightedTerm[0]);
    }

    private static final void getTerms(Query query, HashSet terms, boolean prohibited) {
        if (query instanceof BooleanQuery) {
            QueryTermExtractor.getTermsFromBooleanQuery((BooleanQuery)query, terms, prohibited);
        } else if (query instanceof PhraseQuery) {
            QueryTermExtractor.getTermsFromPhraseQuery((PhraseQuery)query, terms);
        } else if (query instanceof TermQuery) {
            QueryTermExtractor.getTermsFromTermQuery((TermQuery)query, terms);
        }
    }

    private static final void getTermsFromBooleanQuery(BooleanQuery query, HashSet terms, boolean prohibited) {
        BooleanClause[] queryClauses = query.getClauses();
        for (int i = 0; i < queryClauses.length; ++i) {
            if (!prohibited && queryClauses[i].prohibited) continue;
            QueryTermExtractor.getTerms(queryClauses[i].query, terms, prohibited);
        }
    }

    private static final void getTermsFromPhraseQuery(PhraseQuery query, HashSet terms) {
        Term[] queryTerms = query.getTerms();
        for (int i = 0; i < queryTerms.length; ++i) {
            terms.add(new WeightedTerm(query.getBoost(), queryTerms[i].text()));
        }
    }

    private static final void getTermsFromTermQuery(TermQuery query, HashSet terms) {
        terms.add(new WeightedTerm(query.getBoost(), query.getTerm().text()));
    }
}

