; -----------------------------------------------------------------------------
; #############################################################################
; -----------------------------------------------------------------------------
; Name:               CommandLine
; -----------------------------------------------------------------------------
; Prefix:             cl_
; Version:            0.4
; Date:               2005-10-10
; Author:             Wolfgang Reszel fr c't
;                     Nach einem Skript von Rajat
; Copyright:          2005 Heise Zeitschriften Verlag GmbH & Co. KG
; -----------------------------------------------------------------------------

; -----------------------------------------------------------------------------
; === Initialisation ==========================================================
; -----------------------------------------------------------------------------

init_CommandLine:
   Prefix = cl
   %Prefix%_ScriptName   = CommandLine
   %Prefix%_ScriptVersion = 0.4

   if Lng = 07  ; = Deutsch (0407, 0807, 0c07 ...)
   {
      MenuName                      = %cl_ScriptName% - Explorer Adressleiste als Kommandozeile`t<
      Description                   = Dos-Kommandos lassen sich direkt in der Adressleiste des Explorers eingeben (ein < muss vorangestellt werden)
      lng_cl_FolderOptions          = In den Ordneroptionen muss eingestellt werden, `ndass im Fenstertitel oder in der Adressleiste der vollstndige Pfad angezeigt wird.
   }
   else        ; = other languages (english)
   {
      MenuName                   = %cl_ScriptName% - explorer address-bar as command-line`t<
      Description                = The address-bar of an explorer-window will act as a command-line if entries are prefixed by <
      lng_cl_FolderOptions          = Please configure windows explorer to show the `nfull path either in the window-title or the address-bar.
   }
   If CustomLanguage <>
      gosub, CustomLanguage
Return

SettingsGui_CommandLine:
Return

SaveSettings_CommandLine:
Return

CancelSettings_CommandLine:
Return

DoEnable_CommandLine:
   Hotkey, ~Enter, On
Return

DoDisable_CommandLine:
   Hotkey, ~Enter, Off
Return

DefaultSettings_CommandLine:
Return

; -----------------------------------------------------------------------------
; === Hotkeys =================================================================
; -----------------------------------------------------------------------------

~Enter:: ; cl
   If Enable_CommandLine = 1
      Gosub, cl_main_CommandLine_invoke
Return

; -----------------------------------------------------------------------------
; === Subroutines =============================================================
; -----------------------------------------------------------------------------

; -----------------------------------------------------------------------------
cl_main_CommandLine_invoke:
   WinGetClass, cl_winClass, A

   If cl_winClass in CabinetWClass,ExploreWClass
   {
      WinGet, cl_winID, ID, A
      ControlGetFocus, cl_Control, A
      If cl_Control = Edit1
      {
         ControlGetText, cl_Command, Edit1, A

         StringLeft, cl_CmdLeft, cl_Command, 1
         StringLeft, cl_CmdLeft2, cl_Command, 2

         If (cl_CmdLeft <> "<" AND cl_CmdLeft2 <> "<<")
            Return

         Send,{ESC}

         RegRead, cl_FullPath, HKCU,Software\Microsoft\Windows\CurrentVersion\Explorer\CabinetState,FullPath
         RegRead, cl_FullPathAddress, HKCU,Software\Microsoft\Windows\CurrentVersion\Explorer\CabinetState,FullPathAddress

         If cl_FullPath = 1
         {
            WinGetTitle, cl_path, ahk_id %cl_winID%
            cl_path = %cl_path%
         }
         Else If cl_FullPathAddress = 1
         {
            If cl_path =
            {
               Send,^z
               Sleep,100
               ControlGetText, cl_path, Edit1, ahk_id %cl_winID%
               cl_path = %cl_path%
               Send,^z{Right}
            }
         }

         If cl_path =
         {
            BalloonTip(%cl_ScriptName% %cl_ScriptVersion%, %lng_cl_FolderOptions%, Error)
            Return
         }

         StringLeft, cl_CmdLeft, cl_Command, 2

         If (cl_CmdLeft = "<<")
         {
            StringTrimLeft, cl_Command, cl_Command, 2
            run, %comspec% /c %cl_Command%, %cl_path%, hide
         }
         Else
         {
            StringLeft, cl_CmdLeft, cl_Command, 1

            If (cl_CmdLeft = "<")
            {
               StringTrimLeft, cl_Command, cl_Command, 1
               run, %comspec% /k %cl_Command%, %cl_path%
            }
         }
      }
   }

   cl_path =
Return

