; -----------------------------------------------------------------------------
; #############################################################################
; -----------------------------------------------------------------------------
; Name:               Eject
; -----------------------------------------------------------------------------
; Prefix:             ej_
; Version:            0.2
; Date:               2005-10-10
; Author:             Wolfgang Reszel fr c't
; Copyright:          2005 Heise Zeitschriften Verlag GmbH & Co. KG
; -----------------------------------------------------------------------------

; -----------------------------------------------------------------------------
; === Initialisation ==========================================================
; -----------------------------------------------------------------------------

init_Eject:
   Prefix = ej
   %Prefix%_ScriptName    = Eject
   %Prefix%_ScriptVersion = 0.2

   if Lng = 07  ; = Deutsch (0407, 0807, 0c07 ...)
   {
      MenuName                      = %ej_ScriptName% - Medien auswerfen
      Description                   = CDs und andere Medien per Tastaturkrzel auswerfen.
      lng_ej_Drive                  = Laufwerk
      lng_ej_Hotkey                 = Tastaturkrzel
      lng_ej_ShowOSD                = Grafische Anzeige aktivieren (OSD)
   }
   else        ; = other languages (english)
   {
      MenuName                      = %ej_ScriptName% - eject media
      Description                   = Ejects CDs or other media with hotkeys.
      lng_ej_Drive                  = Drive
      lng_ej_Hotkey                 = Hotkey
      lng_ej_ShowOSD                = enable on-screen-display
   }
   If CustomLanguage <>
      gosub, CustomLanguage

   ej_FadeSpeed = 2 ; Ausblenden-Geschwindigkeit

   Loop, 10
   {
      IniRead, ej_Drive%A_Index%, %ConfigFile%, %ej_ScriptName%, Drive%A_Index%
      If ej_Drive%A_Index% = ERROR
         ej_Drive%A_Index% =

      If (A_Index = 1 AND ej_Drive%A_Index% = "")
      {
         DriveGet, ej_Drives, List, CDROM
         StringLeft, ej_Drives, ej_Drives, 1
         ej_Drive%A_Index% = %ej_Drives%
         func_HotkeyRead( "ej_Hotkey" A_Index, ConfigFile, ej_ScriptName, "Hotkey" A_Index, "sub_Hotkey_Eject", "ScrollLock" )
         continue
      }

      If ej_Drive%A_Index% <> ""
         func_HotkeyRead( "ej_Hotkey" A_Index, ConfigFile, ej_ScriptName, "Hotkey" A_Index, "sub_Hotkey_Eject", "" )
   }

   IniRead, ej_EnableOSD, %ConfigFile%, %ej_ScriptName%, OSD, 1
Return

SettingsGui_Eject:
   DriveGet, ej_Drives, List, CDROM
   ej_AllDrives =
   Loop, Parse, ej_Drives,
   {
      ej_AllDrives = %ej_AllDrives%|%A_LoopField%
   }
   Loop, 11
   {
      Gui, Add, Text, XS+10 y+7, %lng_ej_Drive%:
      Gui, Add, DropDownList, gsub_CheckIfSettingsChanged X+5 yp-3 W40 vej_Drive%A_Index%,%ej_AllDrives%
      func_HotkeyAddGuiControl( lng_ej_Hotkey, "ej_Hotkey" A_Index, "x+20 yp+3" )
      GuiControl, Choosestring, ej_Drive%A_Index%, % ej_Drive%A_Index%
   }
   Gui, Add, CheckBox, gsub_CheckIfSettingsChanged vej_EnableOSD xs+280 ys+290 Checked%ej_EnableOSD%, %lng_ej_ShowOSD%
Return

SaveSettings_Eject:
   Loop, 11
   {
      func_HotkeyWrite( "ej_Hotkey" A_Index, ConfigFile, ej_ScriptName, "Hotkey" A_Index )
      IniWrite, % ej_Drive%A_Index%, %ConfigFile%, %ej_ScriptName%, Drive%A_Index%
   }
   IniWrite, %ej_EnableOSD%, %ConfigFile%, %ej_ScriptName%, OSD
Return

CancelSettings_Eject:
Return

DoEnable_Eject:
   Loop, 11
   {
      func_HotkeyEnable( "ej_Hotkey" A_Index )
   }
Return

DoDisable_Eject:
   Loop, 11
   {
      func_HotkeyDisable( "ej_Hotkey" A_Index )
   }
Return

DefaultSettings_Eject:
Return

; ---------------------------------------------------------------------
; -- Tastaturkrzel ---------------------------------------------------
; ---------------------------------------------------------------------

sub_Hotkey_Eject:
   ej_Drive := func_HotkeyGetVar("ej_Hotkey",11,"ej_Drive")
   gosub, ej_main_Eject
Return

; ---------------------------------------------------------------------
ej_main_Eject: ; Medium auswerfen [ej_Drive]
   ej_transparent = 150 ; Anfangstransparenz

   ; Position berechnen
   ej_posY  := A_ScreenHeight - (A_ScreenHeight / 4)

   ; Auswefen-Symbol darstellen
   Gui, 75:Default

   If ej_EnableOSD = 1
   ifExist, extensions\ac'tivAid_Eject_eject.gif ; nur wenn auch vorhanden
   {
      Gui, 75:Default
      Gui, +Lastfound +Disabled +ToolWindow -Caption
      Gui, Add, pic, x0 y0, extensions\ac'tivAid_Eject_eject.gif  ; Bild laden
      Gui, Font, S14 bold C777777, Arial
      Gui, Add, Text, BackgroundTrans x70 y118, %ej_Drive%
      Gui, Font, S14 bold C666666, Arial
      Gui, Add, Text, BackgroundTrans x69 y117, %ej_Drive%
      Gui, Font, S14 bold C444444, Arial
      Gui, Add, Text, BackgroundTrans x68 y116, %ej_Drive%
      Gui, Font, S14 bold Caaaaaa, Arial
      Gui, Add, Text, BackgroundTrans x67 y115, %ej_Drive%
      WinGet, ej_OSDid, ID
      WinSet, TransColor ,0000FF %ej_transparent%    ; Transparenz setzen
      WinSet, AlwaysOnTop, On                        ; Immer im Vordergrund
      Gui, Show, w150 h150 y%ej_posY% NA             ; Symbol darstellen
   }

   Drive, Eject, %ej_Drive%                        ; Medium auswerden

   if A_TimeSinceThisHotkey < 1000                   ; Wenn Auswerfen sehr schnell ging
   {                                                 ; dann war das Laufwerk schon offen
      Drive, Eject, %ej_Drive%, 1                  ; also wird es nun geschlossen
   }

   ; Auswerfen-Symbol langsam ausblenden
   If ej_EnableOSD = 1
   ifExist, extensions\ac'tivAid_Eject_eject.gif ; nur wenn auch vorhanden
   {
      ej_Count = %ej_transparent%
      ej_Count /= %ej_FadeSpeed%
      Loop, %ej_Count%                               ; Schleife "Anfangstransparenz" mal
      {
         ej_transparent -= %ej_FadeSpeed%            ; Transparenz runterzhlen
         WinSet, TransColor,0000FF %ej_transparent%, ahk_id %ej_OSDid%  ; Transparenz setzen
      }
      Gui, Destroy                                   ; Symbol/Fenster aus dem Speicher
   }
return
