; -----------------------------------------------------------------------------
; #############################################################################
; -----------------------------------------------------------------------------
; Name:               MusicControl
; -----------------------------------------------------------------------------
; Prefix:             muc_
; Version:            0.3
; Date:               2005-10-10
; Author:             Wolfgang Reszel fr c't
; Copyright:          2005 Heise Zeitschriften Verlag GmbH & Co. KG
; -----------------------------------------------------------------------------

; -----------------------------------------------------------------------------
; === Initialisation ==========================================================
; -----------------------------------------------------------------------------

init_MusicControl:
   Prefix = muc
   %Prefix%_ScriptName    = MusicControl
   %Prefix%_ScriptVersion = 0.3

   if Lng = 07  ; = Deutsch (0407, 0807, 0c07 ...)
   {
      MenuName                       = %muc_ScriptName% - Tastaturkrzel fr WinAmp und iTunes
      Description                    = Bietet Tastaturkrzel fr WinAmp/iTunes und fr die Systemlautstrke, welche hnlich OS X grafisch dargestellt wird.
      lng_muc_MasterVolume           = Systemlautstrke
      lng_muc_VolUp                  = Lauter
      lng_muc_VolDown                = Leiser
      lng_muc_VolMute                = Stumm/An
      lng_muc_Prev                   = Vorheriges Lied
      lng_muc_Next                   = Nchstes Lied
      lng_muc_Pause                  = Pause
      lng_muc_Rwd                    = Zurckspulen
      lng_muc_FFwd                   = Vorspulen
      lng_muc_Up                     = WinAmp/iTunes lauter
      lng_muc_Down                   = WinAmp/iTunes leiser
      lng_muc_Stop                   = Stop
      lng_muc_Play                   = Play
      lng_muc_ShowOSD                = Grafische Anzeige aktivieren (OSD)
      lng_muc_PlaySound              = akustisches Signal
   }
   else        ; = other languages (english)
   {
      MenuName                       = %muc_ScriptName% - controlling WinAmp and iTunes
      Description                    = Provides hotkeys for conrollling WinAmp/iTunes and the systems' volume. It provides visual feedback like in OS X.
      lng_muc_MasterVolume           = master volume
      lng_muc_VolUp                  = Up
      lng_muc_VolDown                = Down
      lng_muc_VolMute                = Mute/On
      lng_muc_Prev                   = previous song
      lng_muc_Next                   = next song
      lng_muc_Pause                  = pause
      lng_muc_Rwd                    = backwards
      lng_muc_FFwd                   = fast forward
      lng_muc_Up                     = WinAmp/iTunes volume up
      lng_muc_Down                   = WinAmp/iTunes volume down
      lng_muc_Stop                   = Stop
      lng_muc_Play                   = Play
      lng_muc_ShowOSD                = enable visual feedback (OSD)
      lng_muc_PlaySound              = enable acoustic feedback
   }
   If CustomLanguage <>
      gosub, CustomLanguage

   muc_FadeSpeed = 2

   HideSettings = 0

   func_HotkeyRead( "muc_VolUp",   ConfigFile, muc_ScriptName, "VolUp",   "muc_VolUp",    "#Up" )
   func_HotkeyRead( "muc_VolDown", ConfigFile, muc_ScriptName, "VolDown", "muc_VolDown",  "#Down" )
   func_HotkeyRead( "muc_VolMute", ConfigFile, muc_ScriptName, "VolMute", "muc_VolMute",  "Pause" )
   func_HotkeyRead( "muc_Prev",    ConfigFile, muc_ScriptName, "Prev",    "muc_Prev",     "#Left" )
   func_HotkeyRead( "muc_Next",    ConfigFile, muc_ScriptName, "Next",    "muc_Next",     "#Right" )
   func_HotkeyRead( "muc_Pause",   ConfigFile, muc_ScriptName, "Pause",   "muc_Pause",    "#Delete" )
   func_HotkeyRead( "muc_Rwd",     ConfigFile, muc_ScriptName, "Rwd",     "muc_Rwd",      "#+Left" )
   func_HotkeyRead( "muc_FFwd",    ConfigFile, muc_ScriptName, "FFwd",    "muc_FFwd",     "#+Right" )
   func_HotkeyRead( "muc_Up",      ConfigFile, muc_ScriptName, "Up",      "muc_Up",       "#+Up" )
   func_HotkeyRead( "muc_Down",    ConfigFile, muc_ScriptName, "Down",    "muc_Down",     "#+Down" )
   func_HotkeyRead( "muc_Stop",    ConfigFile, muc_ScriptName, "Stop",    "muc_Stop",     "#End" )
   func_HotkeyRead( "muc_Play",    ConfigFile, muc_ScriptName, "Play",    "muc_Play",     "#Home" )

   IniRead, muc_EnableOSD, %ConfigFile%, %muc_ScriptName%, OSD, 1

   IniRead, muc_EnableSound, %ConfigFile%, %muc_ScriptName%, Sound, 1

   If muc_EnableOSD = 1
   {
      muc_transparent = 150

      ; Position berechnen
      muc_posY  := A_ScreenHeight - (A_ScreenHeight / 4)

      Gui, 77:+Lastfound +Disabled +ToolWindow -Caption
      Gui, 77:Add, pic, x0 y0 vmuc_OSDvpic, extensions\ac'tivAid_MusicControl_vol.gif  ; Bild laden
      Gui, 77:Add, Pic, x78 y20 vmuc_OSDmpic w60 h100, extensions\ac'tivAid_MusicControl_vol2.gif
      Gui, 77:Color, 000000
      muc_X = 131
      Loop, 20
      {
         Gui, 77:Add, Text, x%muc_X% y126 w4 h6 vmuc_Volume%A_Index%,
         muc_X := muc_X-6
      }
      WinGet,muc_OSDid, ID
      WinSet, TransColor ,0000FF %muc_transparent% ; Transparenz setzen
      WinSet, AlwaysOnTop, On                        ; Immer im Vordergrund

      SoundGet, muc_LastMaster, MASTER
      muc_LastMaster := 20.1-(muc_LastMaster/5)
      SoundGet, muc_LastMute, MASTER, Mute

      SetTimer, muc_tim_VolOSD, 100
   }

   ; Prfen ob WSH aktiv
   RegRead, muc_WSH1, HKEY_CURRENT_USER,Software\Microsoft\Windows Script Host\Settings,Enabled
   RegRead, muc_WSH2, HKEY_LOCAL_MACHINE,Software\Microsoft\Windows Script Host\Settings,Enabled

   If (muc_WSH1 = 0 OR muc_WSH2 = 0 OR FileExist(windir "\system32\cscript.exe") = "")
      muc_WSHdisabled = 1
Return


SettingsGui_MusicControl:

   func_HotkeyAddGuiControl( lng_muc_Prev, "muc_Prev",       "xs+10 y+3 W150" )
   func_HotkeyAddGuiControl( lng_muc_Next, "muc_Next",       "xs+10 y+3 W150" )
   func_HotkeyAddGuiControl( lng_muc_Pause, "muc_Pause",     "xs+10 y+3 W150" )
   func_HotkeyAddGuiControl( lng_muc_Rwd, "muc_Rwd",         "xs+10 y+3 W150" )
   func_HotkeyAddGuiControl( lng_muc_FFwd, "muc_FFwd",       "xs+10 y+3 W150" )
   func_HotkeyAddGuiControl( lng_muc_Up, "muc_Up",           "xs+10 y+3 W150" )
   func_HotkeyAddGuiControl( lng_muc_Down, "muc_Down",       "xs+10 y+3 W150" )
   func_HotkeyAddGuiControl( lng_muc_Stop, "muc_Stop",       "xs+10 y+3 W150" )
   func_HotkeyAddGuiControl( lng_muc_Play, "muc_Play",       "xs+10 y+3 W150" )

   Gui, Add, GroupBox, xs+10 y+0 h90 w550, %lng_muc_MasterVolume%

   func_HotkeyAddGuiControl( lng_muc_VolUp, "muc_VolUp",     "xs+19 yp+14 W141" )
   func_HotkeyAddGuiControl( lng_muc_VolDown, "muc_VolDown", "xs+19 y+3 W141" )
   func_HotkeyAddGuiControl( lng_muc_VolMute, "muc_VolMute", "xs+19 y+3 W141" )

   Gui, Add, CheckBox, gsub_CheckIfSettingsChanged vmuc_EnableOSD xs+166 y+2 Checked%muc_EnableOSD%, %lng_muc_ShowOSD%
   Gui, Add, CheckBox, gsub_CheckIfSettingsChanged vmuc_EnableSound x+10 Checked%muc_EnableSound%, %lng_muc_PlaySound%
Return

SaveSettings_MusicControl:
   func_HotkeyWrite( "muc_VolUp", ConfigFile, muc_ScriptName, "VolUp")
   func_HotkeyWrite( "muc_VolDown", ConfigFile, muc_ScriptName, "VolDown")
   func_HotkeyWrite( "muc_VolMute", ConfigFile, muc_ScriptName, "VolMute")
   func_HotkeyWrite( "muc_Prev", ConfigFile, muc_ScriptName, "Prev")
   func_HotkeyWrite( "muc_Next", ConfigFile, muc_ScriptName, "Next")
   func_HotkeyWrite( "muc_Pause", ConfigFile, muc_ScriptName, "Pause")
   func_HotkeyWrite( "muc_Rwd", ConfigFile, muc_ScriptName, "Rwd")
   func_HotkeyWrite( "muc_FFwd", ConfigFile, muc_ScriptName, "FFwd")
   func_HotkeyWrite( "muc_Up", ConfigFile, muc_ScriptName, "Up")
   func_HotkeyWrite( "muc_Down", ConfigFile, muc_ScriptName, "Down")
   func_HotkeyWrite( "muc_Stop", ConfigFile, muc_ScriptName, "Stop")
   func_HotkeyWrite( "muc_Play", ConfigFile, muc_ScriptName, "Play")
   IniWrite, %muc_EnableOSD%, %ConfigFile%, %muc_ScriptName%, OSD
   IniWrite, %muc_EnableSound%, %ConfigFile%, %muc_ScriptName%, Sound
Return

CancelSettings_MusicControl:
Return

DoEnable_MusicControl:
   func_HotkeyEnable( "muc_VolUp" )
   func_HotkeyEnable( "muc_VolDown" )
   func_HotkeyEnable( "muc_VolMute" )
   func_HotkeyEnable( "muc_Prev" )
   func_HotkeyEnable( "muc_Next" )
   func_HotkeyEnable( "muc_Pause" )
   func_HotkeyEnable( "muc_Rwd" )
   func_HotkeyEnable( "muc_FFwd" )
   func_HotkeyEnable( "muc_Up" )
   func_HotkeyEnable( "muc_Down" )
   func_HotkeyEnable( "muc_Stop" )
   func_HotkeyEnable( "muc_Play" )
Return

DoDisable_MusicControl:
   func_HotkeyDisable( "muc_VolUp" )
   func_HotkeyDisable( "muc_VolDown" )
   func_HotkeyDisable( "muc_VolMute" )
   func_HotkeyDisable( "muc_Prev" )
   func_HotkeyDisable( "muc_Next" )
   func_HotkeyDisable( "muc_Pause" )
   func_HotkeyDisable( "muc_Rwd" )
   func_HotkeyDisable( "muc_FFwd" )
   func_HotkeyDisable( "muc_Up" )
   func_HotkeyDisable( "muc_Down" )
   func_HotkeyDisable( "muc_Stop" )
   func_HotkeyDisable( "muc_Play" )
Return

DefaultSettings_MusicControl:
Return

; -----------------------------------------------------------------------------
; === Hotkeys =================================================================
; -----------------------------------------------------------------------------

muc_VolUp:
   SoundSet, +5            ; Gesamtlautstrke Lauter
Return
muc_VolDown:
   SoundSet, -5            ; Gesamtlautstrke Leiser
Return
muc_VolMute:
   SoundSet, +1, , mute    ; Ton an/aus
Return
muc_Prev:                        ; Vorheriger Titel
   Detecthiddenwindows,On
   PostMessage, 0x111,40044,,,ahk_class Winamp v1.x
   IfWinExist, ahk_class iTunes
   {
      If muc_WSHdisabled <> 1
      {
         FileAppend,
         (
            try {
            var iTunesApp = WScript.CreateObject("iTunes.Application");
            iTunesApp.Play();
            iTunesApp.PreviousTrack();
            } catch (e) {}
         ), muc_iTunesTmp.js
         RunWait, %windir%\system32\cscript.exe //NoLogo //B muc_iTunesTmp.js,,Hide
         FileDelete, muc_iTunesTmp.js
      }
   }
return
muc_Next:                       ; Nchster Titel
   Detecthiddenwindows,On
   PostMessage, 0x111,40048,,,ahk_class Winamp v1.x
   IfWinExist, ahk_class iTunes
   {
      If muc_WSHdisabled <> 1
      {
         FileAppend,
         (
            try {
            var iTunesApp = WScript.CreateObject("iTunes.Application");
            iTunesApp.Play();
            iTunesApp.NextTrack();
            } catch (e) {}
         ), muc_iTunesTmp.js
         RunWait, %windir%\system32\cscript.exe //NoLogo //B muc_iTunesTmp.js,,Hide
         FileDelete, muc_iTunesTmp.js
      }
   }
return
muc_Pause:                     ; Pause/Play
   Detecthiddenwindows,On
   PostMessage, 0x111,40046,,,ahk_class Winamp v1.x
   IfWinExist, ahk_class iTunes
   {
      If muc_WSHdisabled <> 1
      {
         FileAppend,
         (
            try {
            var iTunesApp = WScript.CreateObject("iTunes.Application");
            iTunesApp.PlayPause();
            } catch (e) {}
         ), muc_iTunesTmp.js
         RunWait, %windir%\system32\cscript.exe //NoLogo //B muc_iTunesTmp.js,,Hide
         FileDelete, muc_iTunesTmp.js
      }
   }
return
muc_Rwd:                     ; Zurckspulen
   Detecthiddenwindows,On
   PostMessage, 0x111,40144,,,ahk_class Winamp v1.x
   IfWinExist, ahk_class iTunes
   {
      If muc_WSHdisabled <> 1
      {
         FileAppend,
         (
            try {
            var iTunesApp = WScript.CreateObject("iTunes.Application");
            position = iTunesApp.PlayerPosition;
            position = position - 7;
            iTunesApp.PlayerPosition = position;
            } catch (e) {}
         ), muc_iTunesTmp.js
         RunWait, %windir%\system32\cscript.exe //NoLogo //B muc_iTunesTmp.js,,Hide
         FileDelete, muc_iTunesTmp.js
      }
   }
return
muc_FFwd:                     ; Vorspulen
   Detecthiddenwindows,On
   PostMessage, 0x111,40148,,,ahk_class Winamp v1.x
   IfWinExist, ahk_class iTunes
   {
      If muc_WSHdisabled <> 1
      {
         FileAppend,
         (
            try {
            var iTunesApp = WScript.CreateObject("iTunes.Application");
            position = iTunesApp.PlayerPosition;
            position = position + 7;
            iTunesApp.PlayerPosition = position;
            } catch (e) {}
         ), muc_iTunesTmp.js
         RunWait, %windir%\system32\cscript.exe //NoLogo //B muc_iTunesTmp.js,,Hide
         FileDelete, muc_iTunesTmp.js
      }
   }
return
muc_Up:                     ; Winamp/iTunes Lauter
   Detecthiddenwindows,On
   PostMessage, 0x111,40058,,,ahk_class Winamp v1.x
   IfWinExist, ahk_class iTunes
   {
      If muc_WSHdisabled <> 1
      {
         FileAppend,
         (
            try {
            var iTunesApp = WScript.CreateObject("iTunes.Application");
            volume = iTunesApp.SoundVolume;
            volume = volume + 7;
            iTunesApp.SoundVolume = volume;
            } catch (e) {}
         ), muc_iTunesTmp.js
         RunWait, %windir%\system32\cscript.exe //NoLogo //B muc_iTunesTmp.js,,Hide
         FileDelete, muc_iTunesTmp.js
      }
   }
return
muc_Down:                     ; Winamp/iTunes Leiser
   Detecthiddenwindows,On
   PostMessage, 0x111,40059,,,ahk_class Winamp v1.x
   IfWinExist, ahk_class iTunes
   {
      If muc_WSHdisabled <> 1
      {
         FileAppend,
         (
            try {
            var iTunesApp = WScript.CreateObject("iTunes.Application");
            volume = iTunesApp.SoundVolume;
            volume = volume - 7;
            iTunesApp.SoundVolume = volume;
            } catch (e) {}
         ), muc_iTunesTmp.js
         RunWait, %windir%\system32\cscript.exe //NoLogo //B muc_iTunesTmp.js,,Hide
         FileDelete, muc_iTunesTmp.js
      }
   }
return
muc_Stop:                     ; Stop
   Detecthiddenwindows,On
   PostMessage, 0x111,40047,,,ahk_class Winamp v1.x
   IfWinExist, ahk_class iTunes
   {
      If muc_WSHdisabled <> 1
      {
         FileAppend,
         (
            try {
            var iTunesApp = WScript.CreateObject("iTunes.Application");
            iTunesApp.Stop();
            } catch (e) {}
         ), muc_iTunesTmp.js
         RunWait, %windir%\system32\cscript.exe //NoLogo //B muc_iTunesTmp.js,,Hide
         FileDelete, muc_iTunesTmp.js
      }
   }
return
muc_Play:                     ; Play
   Detecthiddenwindows,On
   PostMessage, 0x111,40045,,,ahk_class Winamp v1.x
   IfWinExist, ahk_class iTunes
   {
      If muc_WSHdisabled <> 1
      {
         FileAppend,
         (
            try {
            var iTunesApp = WScript.CreateObject("iTunes.Application");
            iTunesApp.Play();
            } catch (e) {}
         ), muc_iTunesTmp.js
         RunWait, %windir%\system32\cscript.exe //NoLogo //B muc_iTunesTmp.js,,Hide
         FileDelete, muc_iTunesTmp.js
      }
   }
return

; -----------------------------------------------------------------------------
; === Subroutines =============================================================
; -----------------------------------------------------------------------------

muc_tim_VolOSD:
   If muc_EnableOSD <> 1
      Return

   SoundGet, muc_Master, MASTER
   SoundGet, muc_Mute, MASTER, Mute
   muc_Master := 20.1-(muc_Master/5)

   if (muc_Master = muc_LastMaster AND muc_Mute = muc_LastMute)
      Return

   muc_LastMaster = %muc_Master%
   muc_LastMute   = %muc_Mute%

   if muc_Mute <> muc_LastMute
   {
      If muc_Mute = On
      {
        GuiControl,77:Show, muc_OSDmpic
        muc_Master = 21
      }
      Else
      {
        GuiControl,77:Hide, muc_OSDmpic
      }
   }

   Gui, 77:Show, w150 h150 y%muc_posY% NA            ; Symbol darstellen

   Loop, 20
   {
      If A_Index < %muc_Master%
         GuiControl, 77:Show, muc_Volume%A_Index%
      Else
         GuiControl, 77:Hide, muc_Volume%A_Index%
   }
   muc_transparent = 150 ; Anfangstransparenz
   WinSet, TransColor,0000FF %muc_transparent%, ahk_id %muc_OSDid%

   If muc_EnableSound = 1
   {
      SoundPlay,extensions\ac'tivAid_MusicControl_vol.wav,1
   }

   muc_FirstRun =

   Settimer, muc_tim_FadeOSD, 1500
Return

muc_tim_FadeOSD:
   Settimer, muc_tim_FadeOSD, Off

   Loop                                           ; Schleife "Anfangstransparenz" mal
   {
      muc_transparent -= %muc_FadeSpeed%            ; Transparenz runterzhlen
      If muc_transparent < 1
         break
      WinSet, TransColor,0000FF %muc_transparent%, ahk_if %muc_OSDid%  ; Transparenz setzen
   }
   Gui, 77:Hide
Return


