; -----------------------------------------------------------------------------
; #############################################################################
; -----------------------------------------------------------------------------
; Name:               FilePaste
; -----------------------------------------------------------------------------
; Prefix:             fp_
; Version:            0.6
; Date:               2005-10-10
; Author:             Wolfgang Reszel fr c't
; Copyright:          2005 Heise Zeitschriften Verlag GmbH & Co. KG
; -----------------------------------------------------------------------------

; -----------------------------------------------------------------------------
; === Initialisation ==========================================================
; -----------------------------------------------------------------------------

init_FilePaste:
   Prefix = fp
   %Prefix%_ScriptName    = FilePaste
   %Prefix%_ScriptVersion = 0.6

   CustomHotkey_FilePaste = 1    ; Benutzerdefiniertes Hotkey
   Hotkey_FilePaste       = ^!+v ; Standard-Hotkey
   HotkeyPrefix_FilePaste = $    ; Hook

   if Lng = 07  ; = Deutsch (0407, 0807, 0c07 ...)
   {
      MenuName                      = %fp_ScriptName% - kopierte Dateien als Text einfgbar
      Description                   = Fgt den Inhalt der Zwischenablage ohne Metainformationen ein. Im Explorer kopierte Dateien lassen sich so als Dateinamen in Textform in andere Anwendungen einfgen.
      lng_fp_PastePaths             = Kompletten Dateipfad einfgen
   }
   else        ; = other languages (english)
   {
      MenuName                      = %fp_ScriptName% - paste filenames as plain text
      Description                   = Pastes text without meta-information. Thus it is possible to paste copied filenames as text into other applications.
      lng_fp_PastePaths             = paste whole path
   }
   If CustomLanguage <>
      gosub, CustomLanguage

   IniRead, fp_PastePaths, %ConfigFile%, %fp_ScriptName%, PastePaths, 0
Return

SettingsGui_FilePaste:
   Gui, Add, CheckBox, gsub_CheckIfSettingsChanged xs+10 y+10 vfp_PastePaths Checked%fp_PastePaths%, %lng_fp_PastePaths%
Return

SaveSettings_FilePaste:
   IniWrite, %fp_PastePaths%, %ConfigFile%, %fp_ScriptName%, PastePaths
Return

CancelSettings_FilePaste:
Return

DoEnable_FilePaste:
   Hotkey, ~^c, on
Return

DoDisable_FilePaste:
   Hotkey, ~^c, off
Return

DefaultSettings_FilePaste:
Return

; -----------------------------------------------------------------------------
; === Hotkeys =================================================================
; -----------------------------------------------------------------------------

~^c:: ; fp
   If Enable_FilePaste = 1
      Gosub, fp_main_FilePaste_copy

   If Extend_CtrlC <>
      Gosub, %Extend_CtrlC%
Return

sub_Hotkey_FilePaste:
   StringReplace, fp_LastHotkey, A_ThisHotkey, $,

   If Enable_FilePaste = 1
      Gosub, fp_main_FilePaste_paste
   Else
      Send, {%fp_LastHotkey%}

   If Extend_CtrlAltShiftV <>
      Gosub, %Extend_CtrlAltShiftV%
Return

; -----------------------------------------------------------------------------
; === Subroutines =============================================================
; -----------------------------------------------------------------------------

; Strg+C heimlich abfragen und merken welche Verzeichnis sichtbar war
fp_main_FilePaste_copy:
   fp_path =
   WinGetClass, fp_winClass, A

   If fp_winClass in ExploreWClass,CabinetWClass,Progman
   {
      If fp_PastePaths = 0
      {
         RegRead, fp_FullPath, HKCU,Software\Microsoft\Windows\CurrentVersion\Explorer\CabinetState, FullPath
         RegRead, fp_FullPathAddress, HKCU,Software\Microsoft\Windows\CurrentVersion\Explorer\CabinetState, FullPathAddress

         If fp_FullPath = 1
         {
            WinGetTitle, fp_path, ahk_class %fp_winClass%
            fp_path = %fp_path%\
         }

         If fp_FullPathAddress = 1
         {
            ControlGetText, fp_path, Edit1, ahk_class %fp_winClass%
            fp_path = %fp_path%\
         }

         If fp_winClass = Progman
         {
            fp_CurrentExplorerDirectory = %A_Desktop%\
         }
      }
   }
Return

; Textversion der Zwischenablage einfgen
fp_main_FilePaste_paste:
   fp_text = %Clipboard%
   If fp_PastePaths = 0
   {
      StringReplace, fp_text, fp_text, %fp_path% ,,A
      StringReplace, fp_path, fp_path, \\ ,\,A
      StringReplace, fp_text, fp_text, %fp_path% ,,A
   }
   Clipboard = %fp_text%
   ClipWait, 2

   ; Folgendes sorgt dafr, dass man Unformatierten Text auch in Adobe-Anwendungen einfgen kann.
   WinGet, fp_actID, ID, A
   IfWinActive, Adobe
   {
      WinActivate,ahk_class Progman ; Aktiviert kurz den Desktop
      WinWaitActive, ahk_class Progman
      WinActivate,ahk_ID %fp_actID% ; und dann wieder die ursprngliche Anwendung
      WinWaitActive,ahk_ID %fp_actID%
   }

   Send, ^v
Return

