; -----------------------------------------------------------------------------
; #############################################################################
; -----------------------------------------------------------------------------
; Name:               WindowToBottom
; -----------------------------------------------------------------------------
; Prefix:             wb_
; Version:            0.1
; Date:               2005-04-22
; Author:             Wolfgang Reszel fr c't
; Copyright:          2005 Heise Zeitschriften Verlag GmbH & Co. KG
; -----------------------------------------------------------------------------

; -----------------------------------------------------------------------------
; === Initialisation ==========================================================
; -----------------------------------------------------------------------------

init_WindowToBottom:
   Prefix = wb
   %Prefix%_ScriptName    = WindowToBottom
   %Prefix%_ScriptVersion = 0.2

   if Lng = 07  ; = Deutsch (0407, 0807, 0c07 ...)
   {
      MenuName                      = %wb_ScriptName% - Fenster nach hinten`tMButton
      Description                   = Klickt man mit der mittleren Maustaste auf die Titelleiste eines Fenster, wird es hinter alle anderen gesetzt.
   }
   else        ; = other languages (english)
   {
      MenuName                      = %wb_ScriptName% - window below all other windows`tMButton
      Description                   = Clicking the middle mouse-button on a windows' titlebar will minimize that window.
   }
   If CustomLanguage <>
      gosub, CustomLanguage
Return

SettingsGui_WindowToBottom:
Return

SaveSettings_WindowToBottom:
Return

CancelSettings_WindowToBottom:
Return

DoEnable_WindowToBottom:
   Extend_MButton = wb_main_WindowToBottom
Return

DoDisable_WindowToBottom:
   Extend_MButton =
Return

DefaultSettings_WindowToBottom:
Return

; -----------------------------------------------------------------------------
; === Hotkeys =================================================================
; -----------------------------------------------------------------------------

; -----------------------------------------------------------------------------
; === Subroutines =============================================================
; -----------------------------------------------------------------------------

wb_main_WindowToBottom:
   GetKeyState, wb_LButton, LButton, P
   If wb_LButton = D
      return
   Extend_MButton_Executed =
   If Enable_WindowToBottom = 1
   {
      SysGet, wb_CaptionHeight, 4 ; SM_CYCAPTION
      SysGet, wb_BorderHeight, 7  ; SM_CXDLGFRAME

      CoordMode, Mouse, Screen
      MouseGetPos, wb_MouseX , wb_MouseY, wb_WinID
      WinGetPos, wb_WinX, wb_WinY, wb_WinW, wb_WinH, ahk_id %wb_WinID%

      wb_WinX2 := wb_WinX + wb_WinW
      wb_WinY2 := wb_WinY + wb_CaptionHeight + wb_BorderHeight

      If ( wb_MouseX >= wb_WinX AND wb_MouseX <= wb_WinX2 AND wb_MouseY >= wb_WinY AND wb_MouseY <= wb_WinY2 )
      {
         WinSet, Bottom,, ahk_id %wb_WinID%
         IfWinActive, ahk_id %wb_WinID%
            Send,!{Tab}
         ;Send,{LButton}!{ESC}
         MButton_send = no
         Extend_MButton_Executed = yes
      }
   }
Return

