; -----------------------------------------------------------------------------
; #############################################################################
; -----------------------------------------------------------------------------
; Name:               WindowsControl
; -----------------------------------------------------------------------------
; Prefix:             wc_
; Version:            0.2
; Date:               2005-10-13
; Author:             Wolfgang Reszel fr c't
; Copyright:          2005 Heise Zeitschriften Verlag GmbH & Co. KG
; -----------------------------------------------------------------------------

; -----------------------------------------------------------------------------
; === Initialisation ==========================================================
; -----------------------------------------------------------------------------

init_WindowsControl:
   Prefix = wc
   %Prefix%_ScriptName    = WindowsControl
   %Prefix%_ScriptVersion = 0.2

   if Lng = 07  ; = Deutsch (0407, 0807, 0c07 ...)
   {
      MenuName                      = %wc_ScriptName% - Fenster- und Powermanagement-Funktionen
      Description                   = Bietet Tastaturkrzel fr Minimieren, Maximieren, Schlieen, Computer ausschalten, Standby, Ruhezustand und die Simulation der Windows-Taste auf Tastaturen ohne diese Taste.
      lng_wc_Min                    = Fenster minimieren
      lng_wc_Max                    = Fenster maximieren
      lng_wc_MaxLeft                = Fenster auf linke Hlfe maximieren
      lng_wc_MaxRight               = Fenster auf rechte Hlfe maximieren
      lng_wc_Close                  = Fenster/Programm schlieen
      lng_wc_Kill                   = Programm direkt beenden/abschieen `n(Achtung: evtl. Datenverlust)
      lng_wc_AOT                    = Fenster im Vordergrund festhalten
      lng_wc_ShutDown               = Computer ausschalten
      lng_wc_Reboot                 = Computer neu starten
      lng_wc_Standby                = Computer in Standby schalten
      lng_wc_Hibernat               = Computer in den Ruhezustand schalten
      lng_wc_Logoff                 = Benutzer abmelden
      lng_wc_SimWin                 = Windows-Taste simulieren
      lng_wc_SimWinHold             = nur wenn die Taste lnger gehalten wird
      lng_wc_HotkeyButtonMsg        = Simulierte Windows-Taste erkannt,`nbitte loslassen und die zustzlichen Tasten drcken.
   }
   else        ; = other languages (english)
   {
      MenuName                      = %wc_ScriptName% - Window and windows-management
      Description                   = Provides hotkeys for minimize, maximize, close, turn off computer, standby, hibernate and the simulation of the windows-keys on keyboards without them.
      lng_wc_Min                    = minimize window
      lng_wc_Max                    = maximize window
      lng_wc_Close                  = close window/program
      lng_wc_Kill                   = kill programm`n(Attention: data my be lost)
      lng_wc_AOT                    = window always on top
      lng_wc_ShutDown               = Shutdown
      lng_wc_Reboot                 = Reboot
      lng_wc_Standby                = Standby
      lng_wc_Hibernat               = Hibernate
      lng_wc_Logoff                 = Logoff
      lng_wc_SimWin                 = simulate windows-key
      lng_wc_SimWinHold             = only if held for a second
      lng_wc_HotkeyButtonMsg        = windows-key detected,`nplease release and press additional keys.
   }
   If CustomLanguage <>
      gosub, CustomLanguage

   func_HotkeyRead( "wc_Min",        ConfigFile, wc_ScriptName, "Minimize",      "wc_Min",      "#Space" )
   func_HotkeyRead( "wc_Max",        ConfigFile, wc_ScriptName, "Maximize",      "wc_Max",      "#!Space" )
   func_HotkeyRead( "wc_MaxLeft",    ConfigFile, wc_ScriptName, "MaximizeLeft",  "wc_MaxLeft",  "#!^Left" )
   func_HotkeyRead( "wc_MaxRight",   ConfigFile, wc_ScriptName, "MaximizeRight", "wc_MaxRight", "#!^Right" )
   func_HotkeyRead( "wc_Close",      ConfigFile, wc_ScriptName, "Close",         "wc_Close",    "#X" )
   func_HotkeyRead( "wc_Kill",       ConfigFile, wc_ScriptName, "Kill",          "wc_Kill",     "#+Delete" )
   func_HotkeyRead( "wc_AOT",        ConfigFile, wc_ScriptName, "AlwaysOnTop",   "wc_AOT",      "#+Home" )
   func_HotkeyRead( "wc_ShutDown",   ConfigFile, wc_ScriptName, "ShutDown",      "wc_ShutDown", "#^PgDn" )
   func_HotkeyRead( "wc_Reboot",     ConfigFile, wc_ScriptName, "Reboot",        "wc_Reboot",   "#^PgUp" )
   func_HotkeyRead( "wc_Standby",    ConfigFile, wc_ScriptName, "Standby",       "wc_Standby",  "#+Pause" )
   func_HotkeyRead( "wc_Hibernat",   ConfigFile, wc_ScriptName, "Hibernate",     "wc_Hibernate","#^CtrlBreak" )
   func_HotkeyRead( "wc_Logoff",     ConfigFile, wc_ScriptName, "Logoff",        "wc_Logoff",   "#^End" )
   func_HotkeyRead( "wc_SimWin",     ConfigFile, wc_ScriptName, "SimulateWinKey","wc_SimWin",   "", "*" )
   IniRead, wc_SimWinHold, %ConfigFile%, %wc_ScriptName%, SimulateWinKeyOnHold, 1

   SysGet, wc_WorkArea, MonitorWorkArea
   wc_WorkAreaWidth  := wc_WorkAreaRight-wc_WorkAreaLeft
   wc_WorkAreaHeight := wc_WorkAreaBottom-wc_WorkAreaTop
   SysGet, wc_DeskWidth, 78
   SysGet, wc_DeskHeight, 79
Return

SettingsGui_WindowsControl:
   func_HotkeyAddGuiControl( lng_wc_Min, "wc_Min",             "xs+10 y+1 W200" )
   func_HotkeyAddGuiControl( lng_wc_Max, "wc_Max",             "xs+10 y+3 W200" )
   func_HotkeyAddGuiControl( lng_wc_MaxLeft, "wc_MaxLeft",     "xs+10 y+3 W200" )
   func_HotkeyAddGuiControl( lng_wc_MaxRight, "wc_MaxRight",   "xs+10 y+3 W200" )
   func_HotkeyAddGuiControl( lng_wc_Close, "wc_Close",         "xs+10 y+3 W200" )
   func_HotkeyAddGuiControl( lng_wc_AOT, "wc_AOT",             "xs+10 y+3 W200" )
   func_HotkeyAddGuiControl( lng_wc_Kill, "wc_Kill",           "xs+10 y+3 W200" )
   func_HotkeyAddGuiControl( lng_wc_ShutDown, "wc_ShutDown",   "xs+10 y+15 W200" )
   func_HotkeyAddGuiControl( lng_wc_Reboot, "wc_Reboot",       "xs+10 y+3 W200" )
   func_HotkeyAddGuiControl( lng_wc_Standby, "wc_Standby",     "xs+10 y+3 W200" )
   func_HotkeyAddGuiControl( lng_wc_Hibernat, "wc_Hibernat",   "xs+10 y+3 W200" )
   func_HotkeyAddGuiControl( lng_wc_Logoff, "wc_Logoff",       "xs+10 y+3 W200" )
   Gui, Add, Text, y+5 xs+10, %lng_wc_SimWin%
   func_HotkeyAddGuiControl( "", "wc_SimWin", "xs+215 YP-3 W130" )
   Gui, Add, CheckBox, gsub_CheckIfSettingsChanged x+10 yp+3 vwc_SimWinHold Checked%wc_SimWinHold%, %lng_wc_SimWinHold%
Return

SaveSettings_WindowsControl:
   func_HotkeyWrite( "wc_Min", ConfigFile, wc_ScriptName, "Minimize")
   func_HotkeyWrite( "wc_Max", ConfigFile, wc_ScriptName, "Maximize")
   func_HotkeyWrite( "wc_MaxLeft", ConfigFile, wc_ScriptName, "MaximizeLeft")
   func_HotkeyWrite( "wc_MaxRight", ConfigFile, wc_ScriptName, "MaximizeRight")
   func_HotkeyWrite( "wc_Close", ConfigFile, wc_ScriptName, "Close")
   func_HotkeyWrite( "wc_Kill", ConfigFile, wc_ScriptName, "Kill")
   func_HotkeyWrite( "wc_AOT", ConfigFile, wc_ScriptName, "AOT")
   func_HotkeyWrite( "wc_ShutDown", ConfigFile, wc_ScriptName, "ShutDown")
   func_HotkeyWrite( "wc_Reboot", ConfigFile, wc_ScriptName, "Reboot")
   func_HotkeyWrite( "wc_Standby", ConfigFile, wc_ScriptName, "Standby")
   func_HotkeyWrite( "wc_Hibernat", ConfigFile, wc_ScriptName, "Hibernate")
   func_HotkeyWrite( "wc_Logoff", ConfigFile, wc_ScriptName, "Logoff")
   func_HotkeyWrite( "wc_SimWin", ConfigFile, wc_ScriptName, "SimulateWinKey")
   IniWrite, %wc_SimWinHold%, %ConfigFile%, %wc_ScriptName%, SimulateWinKeyOnHold
Return

CancelSettings_WindowsControl:
Return

DoEnable_WindowsControl:
   func_HotkeyEnable( "wc_Min" )
   func_HotkeyEnable( "wc_Max" )
   func_HotkeyEnable( "wc_MaxLeft" )
   func_HotkeyEnable( "wc_MaxRight" )
   func_HotkeyEnable( "wc_Close" )
   func_HotkeyEnable( "wc_Kill" )
   func_HotkeyEnable( "wc_AOT" )
   func_HotkeyEnable( "wc_ShutDown" )
   func_HotkeyEnable( "wc_Reboot" )
   func_HotkeyEnable( "wc_Standby" )
   func_HotkeyEnable( "wc_Hibernat" )
   func_HotkeyEnable( "wc_Logoff" )
   func_HotkeyEnable( "wc_SimWin" )
Return

DoDisable_WindowsControl:
   func_HotkeyDisable( "wc_Min" )
   func_HotkeyDisable( "wc_Max" )
   func_HotkeyDisable( "wc_MaxLeft" )
   func_HotkeyDisable( "wc_MaxRight" )
   func_HotkeyDisable( "wc_Close" )
   func_HotkeyDisable( "wc_Kill" )
   func_HotkeyDisable( "wc_AOT" )
   func_HotkeyDisable( "wc_ShutDown" )
   func_HotkeyDisable( "wc_Reboot" )
   func_HotkeyDisable( "wc_Standby" )
   func_HotkeyDisable( "wc_Hibernat" )
   func_HotkeyDisable( "wc_Logoff" )
   func_HotkeyDisable( "wc_SimWin" )
Return

DefaultSettings_WindowsControl:
Return

; -----------------------------------------------------------------------------
; === Hotkeys =================================================================
; -----------------------------------------------------------------------------

wc_Min:
   WinMinimize, A
Return

wc_Max:
   WinGet, wc_MinMax, MinMax, A
   If wc_MinMax = 1
      WinRestore, A
   Else
      WinMaximize, A
Return

wc_MaxLeft:
   WinRestore, A
   WinMove, A,, %wc_WorkAreaLeft%, %wc_WorkAreaTop%, % wc_WorkAreaWidth/2, %wc_WorkAreaHeight%
Return

wc_MaxRight:
   WinRestore, A
   WinMove, A,, % wc_WorkAreaLeft + wc_WorkAreaWidth/2, %wc_WorkAreaTop%, % wc_WorkAreaWidth/2, %wc_WorkAreaHeight%
Return

wc_Close:
   WinClose, A
Return

wc_Kill:
   WinKill, A
Return

wc_AOT:
   WinGetTitle, wc_WinTitle, A
   WinGet, wc_ExStyle, ExStyle, A
   if (wc_ExStyle & 0x8)
   {
      WinSet, AlwaysOnTop, Off, A
      IfInString, wc_WinTitle, /\
         StringTrimLeft, wc_WinTitle, wc_WinTitle, 5
      WinSet, ExStyle, -0x20000, A
   }
   Else
   {
      WinSet, AlwaysOnTop, On, A
      IfNotInString, wc_WinTitle, /\
         wc_WinTitle = /\  %wc_WinTitle%
      WinSet, ExStyle, +0x20000, A
   }
   WinSetTitle, A,, %wc_WinTitle%
return

wc_ShutDown:
   ShutDown, 9
Return

wc_Reboot:
   ShutDown, 2
Return

wc_Logoff:
   ShutDown, 0
Return

wc_Standby:
   DllCall("powrprof.dll\SetSuspendState","Int",0,"Int",0,"Int",0)
Return

wc_Hibernate:
   DllCall("powrprof.dll\SetSuspendState","Int",1,"Int",0,"Int",0)
Return

wc_SimWin:
   StringReplace, wc_THKplain, A_ThisHotkey, $,
   StringReplace, wc_THKplain, wc_THKplain, *,
   If wc_SimWinHold = 1
   {
      KeyWait, %wc_THKplain%, T0.2
      GetKeyState, wc_SimWinState, %wc_THKplain%,p
      If wc_SimWinState = D
      {
         tooltip,WIN
         Send, {Blind}{LWin Down}
         KeyWait, %wc_THKplain%
         Send, {Blind}{LWin Up}
         tooltip
      }
      Else
      {
         Send, {Blind}{%wc_THKplain% Down}
         Send, {Blind}{%wc_THKplain% Up}
      }
   }
   Else
   {
      tooltip,WIN
      SetKeyDelay -1
      Send, {Blind}{LWin Down}
      KeyWait, %wc_THKplain%
      Send, {Blind}{LWin Up}
      tooltip
   }
Return

; -----------------------------------------------------------------------------
; === Subroutines =============================================================
; -----------------------------------------------------------------------------

