import sys
import psjobBasic as psjob
import photoshopy as pspy
comc = pspy.constants

class WasserzeichenPsEnv(psjob.PhotoshopEnv):
  EXTENSIONS = ['JPG', 'DNG', 'PSD','CRW']
  JPG_QUALITY = 8
  ARCHIVE_NAME = '-wz'

  def prepare(self):
    """one time initializations"""
    psjob.PhotoshopEnv.prepare(self)  # aufruf ueberschriebener Vorgaenger
    self.tc = pspy.SolidColor()       # neues "PS color" Objekt
    self.tc.RGB.Red, self.tc.RGB.Green, self.tc.RGB.Blue = 220, 220, 220

  def handleDocument(self, doc):
    print "%s..." % doc.Name
    doc.Flatten()              # auf einen Layer reduzieren
    # add a watermark
    ly = doc.ArtLayers.Add()   # neuen Layer kreieren
    ly.Kind = comc.psTextLayer # ...und zum TextLayer machen
    ti = ly.TextItem           # ...hat die Klasse TextItem
    ti.Contents = "(c) 2005 Torsten Will"
    ti.SetColor(self.tc)
    ti.Font = 'ArialMT'
    h = max(12, doc.Height/100)
    ti.Size = h               # Schriftgroesse
    ti.Position = (3,doc.Height-3)     # untere linke Ecke
    ly.Opacity = 60           # ziemlich transparent
    doc.Flatten()             # nochmal auf einen Layer reduzieren

job = WasserzeichenPsEnv( (sys.argv[1],sys.argv[1]) ) # gleicher Speicherort
job.run()


