program cts; {c't April 20005, Andreas Stiller }
{$J+}
{$APPTYPE CONSOLE}

uses
  WinTypes,dialogs,SysUtils;
  {$R *.res}

 (*

 kleines Console-Tool zum Abfragen des Modemstatus
 gibt status des cts-Eingangs  aus

 Aufruf CTS comnr [/n]

 /n unterdrckt die Ausgabe => nur Errorcode

 Errorcode 0: CTS low
 Errorcode 1: CTS high
 Errocode > 250 Fehler aufgetreten

 z.B  batchdatei im Autostartordner

 cts 1 /n
 if errorlevel 2 goto Fehler
 if errorlevel 1 goto ctson
 ctsoff:
 ....



 Benutzt folgende Defines aus Windows

 *** fr GetCommModemStatus ***

   MS_CTS_ON = DWORD($0010);
   MS_DSR_ON = DWORD($0020);
   MS_RING_ON = DWORD($0040);
   MS_RLSD_ON = DWORD($0080);

  **** fr EscapeComm *****
  SETXOFF = 1;    { Simulate XOFF received }

  SETXON = 2;     { Simulate XON received }
  SETRTS = 3;     { Set RTS high }
  CLRRTS = 4;     { Set RTS low }
  SETDTR = 5;     { Set DTR high }
  CLRDTR = 6;     { Set DTR low }
  RESETDEV = 7;   { Reset device if possible }
  SETBREAK = 8;   { Set the device break line. }
  CLRBREAK = 9;   { Clear the device break line. }

 *)


const
  CommStr:PChar='COM1:';
  Display:boolean=true;
  currcts:integer=0;
var
   hcom:Thandle;
   lpmodstat:longword;
   i:integer;
   para:string;
begin
for i:=1 to paramcount do
 begin
 para:=paramstr(i);
 if (para[1]='/') or (para[1]='-') and (length(para) > 1) then
  begin
   case upcase(para[2]) of
    'N':Display:=false;
   end;
  end
  else if para[1] in ['1'..'9'] then commstr:=pchar('COM'+para+':');
 end;

hcom:=CreateFile (Commstr, GENERIC_READ or GENERIC_WRITE,0, Nil,open_existing,0,0);
If hcom=INVALID_HANDLE_VALUE then
 begin
 Writeln ('Kann Comport ', commstr,' nicht ffnen');
 halt ($FF);
 end;

if not getcommModemStatus (hcom,lpmodstat) then
 begin
 writeln ('Fehler beim Modemstatus');
 halt ($FE);
 end;
if (lpmodstat and MS_CTS_ON) >0 then currcts:=1 else currcts:=0;
if display then Writeln ('CTS auf ',commstr,' =',currcts);
halt (currcts);


end.
