/* $Id: padlock.h 42 2005-05-03 05:40:16Z olau $ */

#ifndef _CORE_PADLOCK_H_
#define _CORE_PADLOCK_H_

/* openssl/evp.h enthlt Definition fr AES_KEY */
#include <openssl/evp.h>
#include "../types.h"

#ifdef __cplusplus
extern "C" {
#endif

#include <sys/types.h>

#ifdef __GNUC__
#include <stdint.h>
#endif

#define PADLOCK_EXISTS                 0x40
#define PADLOCK_ENABLED                0x80

#define PADLOCK_BLOCK_BOUNDARY         16
#define MIN_KEY_LENGTH                 16
#define MAX_KEY_LENGTH                 32
#define IV_LENGTH                      16

/* type codes for encryption algorithms
   (ACE currently supports no other algorithm than AES) */
#define ALGORITHM_AES                   0

/* key sources */
#define KEY_GENERATED_BY_HARDWARE       0
#define KEY_LOADED_FROM_MEMORY          1

/* decrypt or encrypt? */
#define ENCRYPT                         0
#define DECRYPT                         1

/* intermediate/normal operation? */
#define NO_EXAMINATION                  0
#define ALLOW_EXAMINATION               1

/* codes for key sizes (don't use reserved code) */
#define KEY_LENGTH_128BIT               0
#define KEY_LENGTH_192BIT               1
#define KEY_LENGTH_256BIT               2
#define KEY_LENGTH_RESERVED             3

/* number of rounds corresponds to AES key size */
#define ROUNDS_128BIT_KEY              10
#define ROUNDS_192BIT_KEY              12
#define ROUNDS_256BIT_KEY              14

/* xcrypt control word:

   Bits 3:0 (Round count): This four-bit field contains the number
   of rounds to be used for the encryption or decryption
   operation. Although the number of rounds for each key size is
   specified by the AES, this standard value is not built into the
   hardware; the application program must specify the number of
   rounds.

   Bits 6:4 (Algorithm Type): This three-bit field specifies the
   cryptographic algorithm. The only algorithm currently supported is
   the AES, which has a field value of 0. Other values are reserved
   and the ACE behavior is undefined if this field is set to reserved
   values.

   Bit 7 (Key Generation Type): This one-bit field specifies whether
   the extended keys are to be generated by the hardware (0) or are
   to be loaded from memory (1).

   Bit 8 (Intermediate/Normal): This one-bit field specifies normal
   operation (0) or intermediate operation (1). Intermediate mode
   allows examination of the result of intermediate rounds.

   Bit 9 (Encrypt/Decrypt): This one-bit field specifies encryption (0)
   or decryption (1).

   Bits 11:10 (Key size): This two-bit field specifies the key size:
   128-bit (0), 192-bit (1), 256-bit (2), and reserved (3). The ACE
   behavior is undefined if key size is set to the reserved value.

   Bits 31:12 (Reserved): These bits should be set to 0 and the contents
   of this field should not be used by the application.
   
   Bits 32:127 (Reserved)
*/
typedef struct _ctlword {
  unsigned int rounds:4;
  unsigned int algo:3;
  unsigned int keygen:1;
  unsigned int interm:1;
  unsigned int encdec:1;
  unsigned int ksize:2;
  unsigned int res0:20;
  uint32_t res[3];
} controlword_t;


extern bool has_cpuid();
extern unsigned int padlock_status();
extern unsigned int get_cache_line_size();
extern void padlock_reload_key();

#define PADLOCK_XCRYPT_ASM_EX(name) \
size_t name(const void *ibuf, \
            const void *obuf, \
            size_t cnt, \
            const AES_KEY *key, \
            controlword_t *ctl, \
            const void *iv);

extern PADLOCK_XCRYPT_ASM_EX(padlock_xcrypt_ecb);
extern PADLOCK_XCRYPT_ASM_EX(padlock_xcrypt_cbc);
extern PADLOCK_XCRYPT_ASM_EX(padlock_xcrypt_cfb);
extern PADLOCK_XCRYPT_ASM_EX(padlock_xcrypt_ofb);

#ifdef __cplusplus
}
#endif

#endif /* _CORE_PADLOCK_H_ */
