// $Id: Thesaurus.java 199 2005-06-22 13:21:30Z olau $

package de.ct.wortschatz.gui;

import org.eclipse.swt.widgets.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.dnd.*;
import org.eclipse.swt.SWT;

import de.ct.wortschatz.Wortschatz;

public class Thesaurus {

	public static Display display = null;

	private Shell shell = null;

	private Menu menu = null;

	private MenuItem menuitem_file = null;

	private MenuItem menuitem_help = null;

	private Menu menu_file = null;

	private Menu menu_help = null;

	private MenuItem menuitem_quit = null;

	private MenuItem menuitem_about = null;
	
	private GridLayout layout_Grid = null;

	private Label label_Word = null;

	private Text text_Word = null;

	private Button button_OK = null;

	private List list = null;

	private Label label_Status = null;

	private Wortschatz ws = null;
	
	public static void main(String[] args) {
		display = new Display();
		Thesaurus thes = new Thesaurus();
		thes.createShell();
		thes.shell.open();
		thes.setStatusBar("Verbinden an Web-Service ...");
		thes.getWebserviceStatus();
		while (!thes.shell.isDisposed()) {
			if (!display.readAndDispatch())
				display.sleep();
		}
		display.dispose();
	}

	private void createShell() {
		ws = new Wortschatz();

		shell = new Shell(display);
		shell.setText("Wortschatz-Thesaurus");
		shell.setSize(330, 300);

		menu = new Menu(shell, SWT.BAR);
		shell.setMenuBar(menu);

		menuitem_file = new MenuItem(menu, SWT.CASCADE);
		menuitem_file.setText("&Datei");
		menuitem_file.setAccelerator(SWT.ALT + 'D');
		menu_file = new Menu(shell, SWT.DROP_DOWN);
		menuitem_file.setMenu(menu_file);
		menuitem_quit = new MenuItem(menu_file, SWT.PUSH);
		menuitem_quit.setText("B&eenden");
		menuitem_quit.setAccelerator(SWT.ALT + 'E');
		menuitem_quit.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event e) {
				shell.close();
				shell.dispose();
			}
		});

		menuitem_help = new MenuItem(menu, SWT.CASCADE);
		menuitem_help.setText("&Hilfe");
		menuitem_help.setAccelerator(SWT.ALT + 'H');
		menu_help = new Menu(shell, SWT.DROP_DOWN);
		menuitem_help.setMenu(menu_help);
		menuitem_about = new MenuItem(menu_help, SWT.PUSH);
		menuitem_about.setText("&ber ...");
		menuitem_about.setAccelerator(SWT.ALT + 'B');
		menuitem_about.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event e) {
				System.out.println("Action performed!");
			}
		});

		label_Word = new Label(shell, SWT.LEFT | SWT.BOTTOM);
		label_Word.setText("zu suchendes Wort");

		text_Word = new Text(shell, SWT.BORDER);
		text_Word.setEditable(true);
		text_Word.addKeyListener(new KeyListener() {
			public void keyPressed(KeyEvent e) {
				if (e.character == '\r') {
					fetchSynonyms(text_Word.getText());
				}
			}
			public void keyReleased(KeyEvent e) {
				// Event ignorieren
			}
		});

		button_OK = new Button(shell, SWT.PUSH);
		button_OK.setText("suchen");
		button_OK.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				fetchSynonyms(text_Word.getText());
			}
		});

		list = new List(shell, SWT.SINGLE | SWT.BORDER | SWT.H_SCROLL
				| SWT.V_SCROLL);
		list.addMouseListener(new MouseListener() {
			public void mouseUp(MouseEvent e) {
				// Event ignorieren
			};
			public void mouseDown(MouseEvent e) {
				String word = getSelectedWord();
				if (word != null) {
					Clipboard cb = new Clipboard(display);
					TextTransfer textTransfer = TextTransfer.getInstance();
					Transfer[] types = new Transfer[] { textTransfer };
					cb.setContents(new Object[] { word }, types);
				}
			};
			public void mouseDoubleClick(MouseEvent e) {
				String word = getSelectedWord();
				if (word != null) {
					text_Word.setText(word);
					fetchSynonyms(word);
				}
			};
		});

		label_Status = new Label(shell, SWT.LEFT | SWT.BOTTOM);

		layout_Grid = new GridLayout();
		layout_Grid.numColumns = 2;
		shell.setLayout(layout_Grid);

		GridData data = new GridData();
		data.horizontalSpan = 2;
		label_Word.setLayoutData(data);
		data = new GridData(GridData.FILL_HORIZONTAL);
		data.widthHint = 100;
		text_Word.setLayoutData(data);
		data = new GridData();
		data.widthHint = 50;
		button_OK.setLayoutData(data);
		data = new GridData(GridData.FILL_HORIZONTAL | GridData.FILL_VERTICAL);
		data.horizontalSpan = 2;
		list.setLayoutData(data);
		data = new GridData(GridData.FILL_HORIZONTAL);
		data.horizontalSpan = 2;
		label_Status.setLayoutData(data);
	}
	
	public void getWebserviceStatus() {
		setStatusBar(ws.getStatus());
	}

	public void setStatusBar(String msg) {
		label_Status.setText(msg);
	}

	/**
	 * Die Synonyme fr <code>word</code> mit Hilfe der
	 * Wortschatz-Web-Services ermitteln und in die Liste <code>list</code>
	 * eintragen.
	 * 
	 * @param word
	 *            Wort, fr das Synonyme ermittelt werden sollen.
	 */
	private void fetchSynonyms(String word) {
		if (word == null)
			return;
		if (word.length() == 0)
			return;
		setStatusBar("Suchen nach '" + word + "' ...");
		ws.setTerm(word);
		String[] syns = ws.getSynonyms();
		list.removeAll();
		if (syns != null) {
			list.setItems(syns);
		}
		setStatusBar("Ausfhrungszeit: " + ws.getExecutionTime());
	}

	/**
	 * Das ausgewhlte Wort aus der Liste <code>list</code> zurckgeben.
	 * 
	 * @return Ausgewhltes Wort aus Liste <code>list</code>
	 */
	private String getSelectedWord() {
		String words[] = list.getSelection();
		if (words == null)
			return null;
		if (words.length == 0)
			return null;
		return words[0];
	}
}
