/* c't Mikrocontroller-im-LAN Demo Source
 * Datei: tools.c 
 * Info: Hilfsroutinen
 * Autor: Benjamin Benz (bbe@heise.de)
 * Datum: 24.06.04
*/
#include <io.h>

// Hilfsfunktion zur Anzeige von Hex-zahlen
void to_hex(char in, char out[3]){		
	out[0]= (in >> 4 ) + '0' ;
	if (out[0] > '9') 
		out[0]+=7;
	
	out[1]= (in & 0x0F) + '0' ;
	if (out[1] > '9') 
		out[1]+=7;
	out[2]=0x00;
}

void int_to_str(int in, char out[6]){
	int tmp =in;
	if (in <0) out[0]='-'; else out[0]='0'; 
	tmp=abs(tmp);	
	out[1]= (tmp /10000)+'0';	tmp=tmp % 10000;		
	out[2]= (tmp / 1000)+'0'  ;  tmp=tmp % 1000;
	out[3]= (tmp / 100) +'0' ;   tmp=tmp % 100;
	out[4]= (tmp / 10)  +'0';    tmp=tmp % 10;
	out[5]= (tmp)       +'0';  
}

//Piep
void beep(void){
	char old= DDRA;
	DDRA|=0x10; 			// Piepserport PA4 auf Ausgang
	while ((TCNT1 & 0x80) != 0x80){
		PORTA = (PORTA & ~0x10) | ((TCNT1 << 2) & 0x10 );
	}
	DDRA=old;
}