/*
 * Created on 14.04.2004
 *
 * To change the template for this generated file go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
/**
 * @author olz
 *
 * This class generates the graphical user interface for the communication with the XPort.
 * It also initializes and runs the other methods.
 * 
 * 01.01.2005 Plymo 
 *    Probleme nach Disconnect und Reconnect - Reader-Thread ist natuerlich nicht mehr
 *    zu verwenden. Es muss ein Neuer erzeugt werden.
 *    java.util.Calender statt des depricated java.util.Date.
 *    Minuten und Sekunden mit fuehrender Null falls einstellig.
 * 26.08.05 Bbe Großer Rewrite, leider noch nicht alle Unschönheiten entfernt 
 * TODO
 */

import java.applet.Applet;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.RenderingHints;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Line2D;
import java.io.IOException;
import java.util.Calendar;

/**
 * @author Oliver Zechiel (olz)
 * 			Benjamin Benz (bbe)
 *  
 */
public class GUI extends Applet implements ActionListener {
    static final long serialVersionUID = 1;

    /** port 10001 is used to directly transmit data from RS232 to Ethernet */
    private static final int bridgePort = 10001;
    
    /** Number of I/O pins available on WiPort */ 
    private static final int NUMCPINS = 3;

    
    /* Number of Relais on B-Module   */
    private static final int NUMRELAIS = 7;
    
    /* Number of bytes in a Command for the B-Module*/
	private static final int CMD_LENGTH = 5;
	
	/* Request the Relais-States */
	private static final int CMD_READRELAIS = 0x81;
	
	/* Command to set relais */
	private static final int CMD_SETRELAIS = 0x80;

	/* Ask B-Module for 64 Samples*/
	private static final int CMD_READADC_64 =0x43;

    /** this value is just a placeholder to encode XPort specific values */
    private static final int START_CODE = 0x41; /* 'A' */

    /** this value is just a placeholder to encode XPort specific values */
    private static final int STOP_CODE = 0x42;  /* 'B' */



    
    /**
     * this variable will keep track if a connection to the XPort currently
     * exists
     */
    private boolean isConnected = false;

    /**
     * This variable will keep track if a connection to the XPort existed before
     * sending a command to the B-module. Its purpose is to check if the
     * connection is to be be ended after the command was sent.
     */
    private boolean wasConnected = false;

    /** instance of a Communication class object */
    private Communication XPort;

    /** this TextField serves to send messages to the XPort */
    private TextField eingabeFeld;

    /** this TextField stores the IP address */
    private TextField IPAdresse;

    /** this TextField stores the port */
    private TextField PortField;

    /** this TextArea will display information on the TCP/IP communication etc */
    private TextArea statusFeld;

    /** this TextArea will show the answers sent by the XPort */
    private TextArea ausgabeFeld;

    /** clicking on this button initiates the connection setup to the XPort */
    private Button Connect;

    /** Clicking on this button will allow to toggle the LEDs on / off */
    private Button setCPins;

    /** this button will terminate the connection to the XPort */
    private Button Disconnect;

    /** this instance will effectively control the XPort's network connections */
    private IOControl IOControl1;

    /**
     * this thread will loop endlessly while connected, receiving data from the
     * XPort
     */
    private OutputReadThread ReadThread;

    /**
     * this textfield will display if the I/O pins are set to outgoing or
     * incoming
     */
    private TextArea IODir;

    /** this button will re-read the XPort's I/O pins' status */
    private Button getCPinDir, setCPinDir, getCPins;

    /** this textfield will display the LED's status */
//    private TextArea LEDStatus;

    /** this button will allow to read and set the I/O pins' settings and values */
//    private Button getState;

    /** this panel will contain the GUI's elements for the A panel */
    private Panel xPortPannel, aPanel;
    
    /** this panel will contain the GUI's elements for the B panel */
    private Panel bPanel;

    /** this panel will contain the GUI's elements for the Terminal-Mode */
    private Panel terminalPanel;
    
    /* Displays the Oszilloskop Graphic */
    private Oszilloskop oszilloskop;
    
    /** this checkbox will allow toggling its respective LED on and off */
    private Checkbox[] CPins; //1, checkLED2, checkLED3;

    /** this Buttons control the 7 Relais **/
    private Button[] relais;
    
    /** this Buttons reads the Relais State**/
    private Button getRelais;

    /** this Buttons reads the 64 Sample Values and displays them in Oszilloskop**/
    private Button getSamples;

    
    private int relaisValues = 0;
    
    /** this checkbox selects, if messages shall be shown as ASCII or Hex*/
    public Checkbox showASCII; 
    
    /**
     * this checkbox will allow setting ist respective I/O direction to incoming /
     * outgoing
     */
    private Checkbox[] CPinDir;

    /** this textfields are used to send commands to the B-Module */
    private TextField StartCodeField, Command, Data, StopCodeField;

    /** this textfields are used to send commands to the B-Module */
    private TextField adcChannel;

    /** this checkbox selects, if 50Hz Filter is to use */
    public Checkbox useFilter; 
    
    /* 
     * Switch from A-Module Control to B-Module-Control
     */
    private Button toBControl;

    /* 
     * Switch from A-Module Control to B-Module-Control
     */
    private Button toAControl;

    /** this button will send a command to the B-Module as set up in the B panel */
    private Button sendCommand;

    /** this array of bytes will contain responses from the XPort */
    byte[] controlAntwort = { 0, 0, 0, 0, 0 };

    
    


    /**
     * this method will allow to switch between the XPort's control panel and
     * the B-module's control panel
     */
    private void changeTab(char tab) {
        if ((tab == 'B') || (tab == 'b')) {
            aPanel.setVisible(false); // set A panel to invisible
            bPanel.setVisible(true); // set B panel to visible
        } else {
            bPanel.setVisible(false); // set B panel invisible
            aPanel.setVisible(true); // set A panel visible
        }

        this.doLayout();
        bPanel.doLayout(); // re-arrange the Applet's layout
        aPanel.doLayout(); // re-arrange the Applet's layout

//        this.repaint(); // re-arrange the Applet's layout
        this.doLayout();
    }


    
    /************************************************************
     * Construct B-Panel
     * *********************************************************/
    private void constructBPanel(){
    	int row,col;
    	GridBagLayout gbl = new GridBagLayout();
        bPanel.setLayout(gbl);
        
        GridBagConstraints c = new GridBagConstraints();
        // ein paar defaults einstellen;
        c.fill = GridBagConstraints.BOTH;   // wie Komponente Bereich füllen soll
        c.weightx = 90;                     // Breite
        c.weighty = 100;                    // Höhe
        c.insets = new Insets(0,5,10,15);   // Abstände definieren
        
        // Und nun auf zu den Komponenten fürs B-Modul-Panel
        
        // -------------------------------------
        row=0; col=0;
      
        Label label = new Label("B-Modul");
        c.gridx = col++;    c.gridy = row;   c.gridwidth = 2;    c.gridheight = 1;
        gbl.setConstraints(label, c);
        bPanel.add(label);
        col++;
        
        toAControl = new Button();
        toAControl.setLabel("Switch to A-module control");
        toAControl.addActionListener(this);
        c.gridx = col++;    c.gridy = row;   c.gridwidth = 3;    c.gridheight = 1;
        gbl.setConstraints(toAControl, c);
        bPanel.add(toAControl);
        

        oszilloskop = new Oszilloskop();
        c.gridx = 5;    c.gridy = row;   c.gridwidth = 4;    c.gridheight = 4;
        gbl.setConstraints(oszilloskop, c);
        bPanel.add(oszilloskop);

        // -------------------------------------
        row++; col=0;        
        
        relais = new Button[8];
        
        relais[6] = new Button("Aux");
        relais[6].addActionListener(this);
        relais[6].setEnabled(false); // buttons are not allowed until 1st showRelais()
        c.gridx = col++;    c.gridy = row;   c.gridwidth = 1;    c.gridheight = 1;
        gbl.setConstraints(relais[6], c);
        bPanel.add(relais[6]);
        
        for (int i = 0; i < NUMRELAIS-1; i++) {
            if (i ==2){
                label = new Label("PWR");
                c.gridx = col++;    c.gridy = row;   c.gridwidth = 1;    c.gridheight = 1;
                gbl.setConstraints(label, c);
                bPanel.add(label);
                row++; col=0;  
            }
        	relais[i] = new Button("Rel "+ (i+1));
            relais[i].addActionListener(this);
            relais[i].setEnabled(false); // buttons are not allowed until 1st showRelais()
            c.gridx = col++;    c.gridy = row;   c.gridwidth = 1;    c.gridheight = 1;
            gbl.setConstraints(relais[i], c);
            bPanel.add(relais[i]);
        }
        
        
        
        getRelais = new Button("Read Relais");
        getRelais.addActionListener(this);
        c.gridx = 4;    c.gridy = row-1;   c.gridwidth = 1;    c.gridheight = 1;
        gbl.setConstraints(getRelais, c);
        bPanel.add(getRelais);

        // -------------------------------------
        row++; col=0;

        label = new Label("Start");
        c.gridx = col++;    c.gridy = row;   c.gridwidth = 1;    c.gridheight = 1;
        gbl.setConstraints(label, c);
        bPanel.add(label);
                
        label = new Label("Cmd");
        c.gridx = col++;    c.gridy = row;   c.gridwidth = 1;    c.gridheight = 1;
        gbl.setConstraints(label, c);
        bPanel.add(label);
        
        label = new Label("Data");
        c.gridx = col++;    c.gridy = row;   c.gridwidth = 1;    c.gridheight = 1;
        gbl.setConstraints(label, c);
        bPanel.add(label);
        
        label = new Label("Stop");
        c.gridx = col++;    c.gridy = row;   c.gridwidth = 1;    c.gridheight = 1;
        gbl.setConstraints(label, c);
        bPanel.add(label);

        // -------------------------------------
        row++; col=0;

        StartCodeField = new TextField(1);
        StartCodeField.addActionListener(this);
        StartCodeField.setText(Integer.toHexString(START_CODE));
        StartCodeField.setEditable(false);
        c.gridx = col++;    c.gridy = row;   c.gridwidth = 1;    c.gridheight = 1;
        gbl.setConstraints(StartCodeField, c);
        bPanel.add(StartCodeField);

        Command = new TextField(1);
        Command.addActionListener(this);
        Command.setText("80");
        c.gridx = col++;    c.gridy = row;   c.gridwidth = 1;    c.gridheight = 1;
        gbl.setConstraints(Command, c);
        bPanel.add(Command);

        Data = new TextField(1);
        Data.addActionListener(this);
        Data.setText("30");
        c.gridx = col++;    c.gridy = row;   c.gridwidth = 1;    c.gridheight = 1;
        gbl.setConstraints(Data, c);
        bPanel.add(Data);

        StopCodeField = new TextField(1);
        StopCodeField.addActionListener(this);
        StopCodeField.setText(Integer.toHexString(STOP_CODE));
        StopCodeField.setEditable(false);
        c.gridx = col++;    c.gridy = row;   c.gridwidth = 1;    c.gridheight = 1;
        gbl.setConstraints(StopCodeField, c);
        bPanel.add(StopCodeField);

        sendCommand = new Button();
        sendCommand.setLabel("send command");
        sendCommand.addActionListener(this);
        c.gridx = col++;    c.gridy = row;   c.gridwidth = 1;    c.gridheight = 1;
        gbl.setConstraints(sendCommand, c);
        bPanel.add(sendCommand);
                        
        label = new Label("Channel");
        c.gridx = col++;    c.gridy = row;   c.gridwidth = 1;    c.gridheight = 1;
        c.fill = GridBagConstraints.NONE;
        gbl.setConstraints(label, c);
        bPanel.add(label);
        
        adcChannel = new TextField(2);
        adcChannel.setText("0");
        c.gridx = col++;    c.gridy = row;   c.gridwidth = 1;    c.gridheight = 1;
        c.fill = GridBagConstraints.NONE;
        gbl.setConstraints(adcChannel, c);
        bPanel.add(adcChannel);

        useFilter = new Checkbox("Filter?", false);
        c.gridx = col++;    c.gridy = row;   c.gridwidth = 1;    c.gridheight = 1;
        c.fill = GridBagConstraints.BOTH;
        gbl.setConstraints(useFilter, c);
        bPanel.add(useFilter);

        
        getSamples = new Button("Sample");
        getSamples.addActionListener(this);
        c.gridx = col++;    c.gridy = row;   c.gridwidth = 1;    c.gridheight = 1;
        gbl.setConstraints(getSamples, c);
        bPanel.add(getSamples);

    }
    
    
/*
 *  Construct Connection Panel
 */
    private void constructXPortPanel(){
        GridBagLayout gbl = new GridBagLayout();
        xPortPannel.setLayout(gbl);
        
        GridBagConstraints c = new GridBagConstraints();
        // ein paar defaults einstellen;
        c.fill = GridBagConstraints.BOTH;   // wie Komponente Bereich füllen soll
        c.weightx = 90;                     // Breite
        c.weighty = 120;                    // Höhe
        c.insets = new Insets(0,5,10,15);   // Abstände definieren
        
        Label label = new Label("IP-Adresse");
        c.gridx = 0;    c.gridy = 0;   c.gridwidth = 2;    c.gridheight = 1;
        gbl.setConstraints(label, c);
        xPortPannel.add(label);

        IPAdresse = new TextField(5);
        c.gridx = 0;    c.gridy = 1;   c.gridwidth = 2;    c.gridheight = 1;
        gbl.setConstraints(IPAdresse, c);
        xPortPannel.add(IPAdresse);

        label = new Label("Port");
        c.gridx = 2;    c.gridy = 0;   c.gridwidth = 2;    c.gridheight = 1;
        gbl.setConstraints(label, c);
        xPortPannel.add(label);

        PortField = new TextField(5);
        PortField.setText(Integer.toString(bridgePort));
        c.gridx = 2;    c.gridy = 1;   c.gridwidth = 2;    c.gridheight = 1;
        gbl.setConstraints(PortField, c);
        xPortPannel.add(PortField);
        
        
        
        Connect = new Button();
        Connect.setLabel("Connect to XPort");
        Connect.addActionListener(this);
        c.gridx = 0;    c.gridy = 2;   c.gridwidth = 2;    c.gridheight = 1;
        gbl.setConstraints(Connect, c);
        xPortPannel.add(Connect);

        Disconnect = new Button();
        Disconnect.setLabel("Disconnect");
        Disconnect.addActionListener(this);
        c.gridx = 2;    c.gridy = 2;   c.gridwidth = 2;    c.gridheight = 1;
        gbl.setConstraints(Disconnect, c);
        xPortPannel.add(Disconnect);

    }   
    /* 
     * setzt das I/O Panel zusammen
     */
    private void constructAPanel(){
    	int col, row;
    	
        GridBagLayout gbl = new GridBagLayout();
        aPanel.setLayout(gbl);

        GridBagConstraints c = new GridBagConstraints();
        // ein paar defaults einstellen;
        c.fill = GridBagConstraints.BOTH;   // wie Komponente Bereich füllen soll
        c.weightx = 90;                     // Breite
        c.weighty = 100;                    // Höhe
        c.insets = new Insets(0,5,10,15);   // Abstände definieren
        
        col=0; row=0;
        
        Label label = new Label("XPort I/O Pins");
        c.gridx = col++;    c.gridy = row;   c.gridwidth = 1;    c.gridheight = 1;
        gbl.setConstraints(label, c);
        aPanel.add(label);

        toBControl = new Button();
        toBControl.setLabel("Switch to B-module control");
        toBControl.addActionListener(this);
        c.gridx = col++;    c.gridy = row;   c.gridwidth = 4;    c.gridheight = 1;
        gbl.setConstraints(toBControl, c);
        aPanel.add(toBControl);

        
        // -------------------------------------
        row++; col=0;
        
        label = new Label("Value");
        c.gridx = col++;    c.gridy = row;   c.gridwidth = 1;    c.gridheight = 1;
        gbl.setConstraints(label, c);
        aPanel.add(label);

    	setCPins = new Button();
        setCPins.setLabel("Set");
        setCPins.addActionListener(this);
        c.gridx = col++;    c.gridy = row;   c.gridwidth = 1;    c.gridheight = 1;
        gbl.setConstraints(setCPins, c);
        aPanel.add(setCPins);
        
        
        CPins = new Checkbox[NUMCPINS];
        for (int i = 0; i < NUMCPINS; i++) {
            CPins[i] = new Checkbox("CP" + (i + 1), false);
            c.gridx = col++;    c.gridy = row;   c.gridwidth = 1;    c.gridheight = 1;
            gbl.setConstraints(CPins[i], c);
            aPanel.add(CPins[i]);
        }
        
        getCPins = new Button();
        getCPins.setLabel("Read");
        getCPins.addActionListener(this);
        c.gridx = col++;    c.gridy = row;   c.gridwidth = 1;    c.gridheight = 1;
        gbl.setConstraints(getCPins, c);
        aPanel.add(getCPins);

        // -------------------------------------
        row++; col=0;
        
        label = new Label("Direction");
        c.gridx = col++;    c.gridy = row;   c.gridwidth = 1;    c.gridheight = 1;
        gbl.setConstraints(label, c);
        aPanel.add(label);
        
        setCPinDir = new Button();
        setCPinDir.setLabel("Set");
        setCPinDir.addActionListener(this);
        c.gridx = col++;    c.gridy = row;   c.gridwidth = 1;    c.gridheight = 1;
        gbl.setConstraints(setCPinDir, c);
        aPanel.add(setCPinDir);
        
        CPinDir = new Checkbox[NUMCPINS];
        for (int i = 0; i < NUMCPINS; i++) {
            CPinDir[i] = new Checkbox("CP" + (i + 1), false);
            c.gridx = col++;    c.gridy = row;   c.gridwidth = 1;    c.gridheight = 1;
            gbl.setConstraints(CPinDir[i], c);
            aPanel.add(CPinDir[i]);
        }        

        getCPinDir = new Button();
        getCPinDir.setLabel("Read");
        getCPinDir.addActionListener(this);
        c.gridx = col++;    c.gridy = row;   c.gridwidth = 1;    c.gridheight = 1;
        gbl.setConstraints(getCPinDir, c);
        aPanel.add(getCPinDir);

        
    }
    
    
    /* 
     * setzt das Terminal Panel zusammen
     */
    private void constructTerminalPanel(){
    	int col, row;
    	
        GridBagLayout gbl = new GridBagLayout();
        terminalPanel.setLayout(gbl);

        GridBagConstraints c = new GridBagConstraints();
        // ein paar defaults einstellen;
        c.fill = GridBagConstraints.BOTH;   // wie Komponente Bereich füllen soll
        c.weightx = 90;                     // Breite
        c.weighty = 100;                    // Höhe
        c.insets = new Insets(0,5,10,15);   // Abstände definieren
        
        col=0; row=0;
        

        Label label = new Label("Data to COM");
        c.gridx = col++;    c.gridy = row;   c.gridwidth = 1;    c.gridheight = 1;
        gbl.setConstraints(label, c);
        terminalPanel.add(label);

        eingabeFeld = new TextField(12);
        eingabeFeld.addActionListener(this);
        c.gridx = col++;    c.gridy = row;   c.gridwidth = 4;    c.gridheight = 1;
        gbl.setConstraints(eingabeFeld, c);
        terminalPanel.add(eingabeFeld);

        // -------------------------------------
        row++; col=0;

        label = new Label("Output from COM");
        c.gridx = col++;    c.gridy = row;   c.gridwidth = 1;    c.gridheight = 1;
        gbl.setConstraints(label, c);
        terminalPanel.add(label);

        showASCII = new Checkbox("Decode Readable Chars?", false);
        c.gridx = 4;    c.gridy = row;   c.gridwidth = 1;    c.gridheight = 1;
        gbl.setConstraints(showASCII, c);
        terminalPanel.add(showASCII);
	
	        
        // -------------------------------------
        row++; col=0;
 
        ausgabeFeld = new TextArea(10, 50);
        ausgabeFeld.setText("");
        ausgabeFeld.setEditable(false);        
        c.gridx = col++;    c.gridy = row;   c.gridwidth = 5;    c.gridheight = 1;
        gbl.setConstraints(ausgabeFeld, c);
        terminalPanel.add(ausgabeFeld);
    }
    
    
    /**
     * This method will display all the GUI's elements on the Applet and preset
     * them with a number of values. It does not perform any actions other than
     * that. Since it's name is init() and we've got an Applet here, it's
     * automatically run by the JRE.
     */
    public void init() {
    	int col, row;
    	
        GridBagLayout gbl = new GridBagLayout();
        this.setLayout(gbl);

        GridBagConstraints c = new GridBagConstraints();
        // ein paar defaults einstellen;
        c.fill = GridBagConstraints.BOTH;   // wie Komponente Bereich füllen soll
        c.weightx = 90;                     // Breite
        c.weighty = 120;                    // Höhe
        c.insets = new Insets(0,5,10,15);   // Abstände definieren
        
    	// Zur Verinfachung kommt jede Funktionsgruppe in ihr eigenes Panel

        // -------------------------------------
        col=0; row=0;
      
        Label label = new Label("c't-Netz-Schalter");
        c.gridx = col++;    c.gridy = row;   c.gridwidth = 1;    c.gridheight = 1;
        gbl.setConstraints(label, c);
        this.add(label);
        
        // -------------------------------------
        row++; col=0;
                
    	// Dieses Panel kümmert sich um den Verbindungsaufbau zum XPort
    	xPortPannel = new Panel(); 
        c.gridx = col++;    c.gridy = row;   c.gridwidth = 1;    c.gridheight = 1;
        gbl.setConstraints(xPortPannel, c);
        this.add(xPortPannel);
        constructXPortPanel();
        xPortPannel.setBackground(new Color(200,200,200));
        
        // -------------------------------------
        row++; col=0;

        // Dieses Panel enthält die Steuerung der I/O-Pins des XPports
        aPanel = new Panel();
        c.gridx = col++;    c.gridy = row;   c.gridwidth = 1;    c.gridheight = 1;
        gbl.setConstraints(aPanel, c);
        this.add(aPanel);
        constructAPanel();
        aPanel.setBackground(new Color(200,200,200));
        aPanel.setVisible(false); // since we start with the B panel, we hide
	    // the A panel from the user
        
        // -------------------------------------
        row++; col=0;

        // Alles zur Steuerung des B-Moduls
        bPanel = new Panel();
        c.gridx = col++;    c.gridy = row;   c.gridwidth = 1;    c.gridheight = 1;
        gbl.setConstraints(bPanel, c);
        this.add(bPanel);
        constructBPanel();
        bPanel.setBackground(new Color(200,200,200));
     //   bPanel.setVisible(false); // since we start with the A panel, we hide
        						  // the B panel from the user
        
        // -------------------------------------
        row++; col=0;

        terminalPanel = new Panel();
        c.gridx = col++;    c.gridy = row;   c.gridwidth = 1;    c.gridheight = 1;
        gbl.setConstraints(terminalPanel, c);       
        this.add(terminalPanel);
        constructTerminalPanel();
        terminalPanel.setBackground(new Color(200,200,200));
        
        // -------------------------------------
        row++; col=0;
      
        label = new Label("Status");
        c.gridx = col++;    c.gridy = row;   c.gridwidth = 1;    c.gridheight = 1;
        gbl.setConstraints(label, c);
        this.add(label);
        

        
        // -------------------------------------
        row++; col=0;
        
        statusFeld = new TextArea(8, 30);
        statusFeld.setEditable(false);
        statusFeld.setText("");
        statusFeld.setForeground(Color.red);
        c.gridx = col++;    c.gridy = row;   c.gridwidth = 1;    c.gridheight = 1;
        gbl.setConstraints(statusFeld, c);
        this.add(statusFeld);



 /*      ChangeTab = new Button();
        ChangeTab.setLabel("Switch to B-module control");
        ChangeTab.addActionListener(this);
        c.gridx = col++;    c.gridy = row;   c.gridwidth = 1;    c.gridheight = 1;
        gbl.setConstraints(ChangeTab, c);
        this.add(ChangeTab);
 */       
        IOControl1 = new IOControl();
        


        
        this.setSize(1024, 768);
        this.doLayout();
    }

    /**
     * This method is responsible for some additional initialisations and
     * presetting values. Basically, it could be integrated into init() without
     * any major trouble.
     */
    public void start() {

        try { // intercept problems with wrong or invalid IP addresses and ports
            // that's why we're using a try statement here
            // this.getCodeBase() will return the Applet's IP, including
            // "http://".
            // However, we only want the pure IP address, so we use substring()
            // to
            // extract the numbers.
            IPAdresse.setText(this.getCodeBase().toString().substring(7,
                    this.getCodeBase().toString().length() - 1));
            //IPAdresse.setText("192.168.123.200");            
            append(statusFeld,"Current IP = " + IPAdresse.getText()); // display ip address
        } catch (NullPointerException NPEx) {
            System.err.println("NullPointerException occured");
            PortField.setText("0"); // default port for serial interface control
        }
        // create a new instance of a Communication object to allow control of
        // the XPort
        XPort = new Communication();
        append(statusFeld,"Applet initialised, ready to connect...");
        Disconnect.setEnabled(false); // keep the user from using the
        // "Disconnect" button while
        // not connected
        ReadThread = new OutputReadThread(); // initialise a thread and start
        // waiting for data from the XPort
    }

    /**
     * This method will just test if the value entered in the field PortField is
     * a number or not.
     * 
     * @return
     */
    private boolean port_auswert() {
        try {
            Integer.parseInt(PortField.getText());
        } catch (NumberFormatException NFEx) {
            ausgabeFeld
                    .append("Entered port has invalid format - please correct!\n");
            return false;
        }
        return true;
    }

    /**
     * This method will establish a connection to the XPort via the entered IP
     * address and port. Its second purpose is to enable and disable GUI
     * elements which are needed respectively not needed while a connection is
     * established.
     */
    private void connect() {
        append(statusFeld,"Trying to connect...");
        if (!port_auswert()) { // if no valid port is stated, stop immediately
            append(statusFeld,"Invalid port!");
            return;
        } else
            // well, let's see if the IP address is valid...
            // if it is, start a connection!
            try {
                int port = Integer.parseInt(PortField.getText());
                append(statusFeld,"Connecting to " + IPAdresse.getText()
                        + " at port " + port);
                // call the "real" connection method
                XPort.connect(IPAdresse.getText(), port);
                
                Connect.setEnabled(false); // allow user only to use button
                                           // "Disconnect"
                Disconnect.setEnabled(true);
                IPAdresse.setEditable(false);
                PortField.setEditable(false);
                // display some status info
                append(statusFeld,"Connection successfully established.");
                append(statusFeld,"Setting up reading loop.");

                wasConnected = true;
                isConnected = true;

                ReadThread = new OutputReadThread(); // initialise a thread and start
                ReadThread.gui=this;
                ReadThread.start();
                
                getCPinDir();

                return;
            }
            // If any error occurs, display it and stop connecting.
            catch (IOException IOEx) {
                append(statusFeld,"I/O error while connecting: " + IOEx);
            } catch (Exception Ex) {
                append(statusFeld,"Error while connecting: " + Ex);
                Ex.printStackTrace();
            }
    }

    /**
     * Will call LEDauswert() to check which LEDs are to be toggled and sends
     * this value to the XPort.
     */
    private void setCPins() {
        int pin, bitValue;
        LockButtons();
        try {
            controlAntwort = IOControl1.toggle(IPAdresse.getText(), LEDauswert());
        } catch (IOException IOEx) {
            append(statusFeld,"I/O error while toggling LEDs: " + IOEx);
        } catch (Exception Ex) {
            append(statusFeld,"Error while toggling LEDs: " + Ex);
        }
        
        for (pin = 0, bitValue = 1; pin < NUMCPINS; pin++) {
            if ((controlAntwort[pin/8] & bitValue) != 0) { // compare if bit is set
            	CPins[pin].setState(true); // Pin is high
            } else {
            	CPins[pin].setState(false); // Pin is Low
            }
            bitValue= (bitValue <<1) % 256;
        }
  
        UnlockButtons();
    }

    /**
     * Allows toggling the XPort's I/O directions between incoming and outgoing.
     * This method itself only sends the checkboxes' values to the XPort's
     * respective method, toggleDirection().
     *  
     */
    private void setCPinDir() {
        int pin, bitValue;
        LockButtons();
        try {
            controlAntwort = IOControl1.toggleDirection(IPAdresse.getText(),
                    IOauswert());
        } catch (IOException IOEx) {
            append(statusFeld,"I/O error while toggling I/O directions: " + IOEx);
        } catch (Exception Ex) {
            append(statusFeld,"Error while toggling I/O directions: " + Ex);
        }
        for (pin = 0, bitValue = 1; pin < NUMCPINS; pin++) {
            if ((controlAntwort[pin/8] & bitValue) != 0) { // compare if bit is set
            	CPinDir[pin].setState(true); // Pin is an Output
                CPins[pin].setEnabled(true); // Changes to PIN allowed
            } else {
            	CPinDir[pin].setState(false); // Pin is an Input
                CPins[pin].setEnabled(false); // Changes to PIN not allowed
            }
            bitValue= (bitValue <<1) % 256;
        }

        getCPinDir();
    }

    /**
     * Will ask the XPort how which I/O pins are availbale to user
     */
    private void getCPinFunctions() {
    	int pin, bitValue;
        LockButtons();
        try {
            controlAntwort = IOControl1.getFunc(IPAdresse.getText());
        } catch (IOException IOEx) {
            append(statusFeld,"I/O error while getting I/O functions: " + IOEx);
        } catch (Exception Ex) {
            append(statusFeld,"Error while getting I/O functions: " + Ex);
        }

        for (pin = 0, bitValue = 1; pin < NUMCPINS; pin++) {
            if ((controlAntwort[pin/8] & bitValue) != 0) { // compare if bit is set
            	CPinDir[pin].setEnabled(true); // Pin is available
                CPins[pin].setEnabled(true); // Changes to PIN allowed
            } else {
            	CPinDir[pin].setEnabled(false); // Pin is not available
                CPins[pin].setEnabled(false); // Changes to PIN not allowed
            }
            bitValue= (bitValue <<1) % 256;
        }
        UnlockButtons();
    }

    /**
     * reads the XPort's I/O directions and displays them on an output field.
     * There is no need to read more than bits 0 to 2 from byte 0 since the
     * XPort does not have more than three I/O pins.
     */
    private void getCPinDir() {
        int pin, bitValue;
        
        LockButtons();
        try {
            controlAntwort = IOControl1.getDir(IPAdresse.getText());
        } catch (IOException IOEx) {
            append(statusFeld,"I/O error while getting I/O directions: " + IOEx);
        } catch (Exception Ex) {
            append(statusFeld,"Error while getting I/O directions: " + Ex);
        }

        for (pin = 0, bitValue = 1; pin < NUMCPINS; pin++) {
            if ((controlAntwort[pin/8] & bitValue) != 0) { // compare if bit is set
            	CPinDir[pin].setState(true); // Pin is an Output
                CPins[pin].setEnabled(true); // Changes to PIN allowed
            } else {
            	CPinDir[pin].setState(false); // Pin is an Input
                CPins[pin].setEnabled(false); // Changes to PIN not allowed
            }
            bitValue= (bitValue <<1) % 256;
        }
        UnlockButtons();
    }

    /**
     * reads the XPort's I/O pin's current state and displays them.
     */
    private void getCPins() {
    	int pin, bitValue;
    	
    	LockButtons();
        try {
            controlAntwort = IOControl1.getCurrentState(IPAdresse.getText());
        } catch (IOException IOEx) {
            append(statusFeld,"I/O error while getting current states: " + IOEx);
        } catch (Exception Ex) {
            append(statusFeld,"Error while getting current states: " + Ex);
        }

        for (pin = 0, bitValue = 1; pin < NUMCPINS; pin++) {
            if ((controlAntwort[pin/8] & bitValue) != 0) { // compare if bit is set
            	CPins[pin].setState(true); // Pin is high
            } else {
            	CPins[pin].setState(false); // Pin is Low
            }
            bitValue= (bitValue <<1) % 256;
        }

        
        UnlockButtons();
    }

    /**
     * will end the connection to the XPort and re-enable the GUI elements faded
     * out while the connection existed.
     *  
     */
    private void disconnect() {
        append(statusFeld,"Trying to disconnect...");
        try {
            XPort.disconnect(); // end connection and stop reading thread.
            ReadThread.interrupt();
//            ReadThread.stop();  // depricated  Plymo 1.1.2005
            isConnected = false; // update connection flags
            wasConnected = false;
        } catch (IOException IOEx) {
            append(statusFeld,"I/O error during disconnect: " + IOEx);
        } catch (Exception Ex) {
            append(statusFeld,"General error during disconnect: " + Ex);
        }

        Connect.setEnabled(true); // re-activate GUI elements
        Disconnect.setEnabled(false); // and re-allow user to change IP address
        IPAdresse.setEditable(true); // and port
        PortField.setEditable(true);

        append(statusFeld,"Connection closed.");
    }

    /**
     * This method reads the input field after hitting enter and sends its
     * content to the XPort. The string read is also displayed on the output
     * textfield, preceded by >>.
     */
    private void sendText() {
        try {
            String sendString = eingabeFeld.getText();
            XPort.send(sendString);
            append(ausgabeFeld,"\n>> " + sendString);
        } catch (IOException IOEx) {
            append(statusFeld,"I/O error while reading: " + IOEx);
        } catch (Exception Ex) {
            append(statusFeld,"Error while reading: " + Ex);
        }
        eingabeFeld.setText("");
        eingabeFeld.requestFocus();
    }

    /**
     * Overrides ActionListener's actionPerformed(). To keep this method halfway
     * simple and not too complex, it only calls other methods to do the actual
     * work.
     */
    public void actionPerformed(ActionEvent e) throws NullPointerException {
        if (e.getActionCommand() == Connect.getLabel()) { // Buttion "Connect"
                                                          // was clicked
            connect();
            return;
        }
        if (e.getActionCommand() == Disconnect.getLabel()) {
            // user wants to end the connection to the XPort
            disconnect();
            return;
        }
        
        if (e.getActionCommand() == toAControl.getLabel()) {
            // switch from A panel to B panel and vice versa
            changeTab('A');
            return;
        }
        if (e.getActionCommand() == toBControl.getLabel()) {
            // switch from A panel to B panel and vice versa
            changeTab('B');
            return;
        }
        
        if (e.getActionCommand() == setCPins.getLabel()) {
            // user wants to toggle some LEDs
            setCPins();
            return;
        }
        
        if (e.getActionCommand() == getCPins.getLabel()) {
            // user wants to know how many pins are available
            getCPins();
            return;
        }
        if (e.getActionCommand() == setCPinDir.getLabel()) {
            // user wants to change I/O directions
            setCPinDir();
            return;
        }

        if (e.getActionCommand() == getCPinDir.getLabel()) {
            // user wants to get the I/O directions updated
        	getCPinFunctions();
            getCPinDir();
            return;
        }
        if (e.getActionCommand() == sendCommand.getLabel()) {
            // user wants to send a command to the B-Module
            cmdBModule();
            return;
        }

        if (e.getSource() == eingabeFeld) {
            // user wants to send some command to the XPort
            sendText();
        }
        
    	if (e.getActionCommand() == getRelais.getLabel()) {
    		readRelais();
    	}

    	if (e.getActionCommand() == getSamples.getLabel()) {
    		readSamples();
    	}

    	
    	for (int i=0; i< NUMRELAIS; i++){
        	if (e.getActionCommand() == relais[i].getLabel()) {
        		switchRelais(i);
        	}
        }
    }

    /*
     * Displays the values of relaisValues
     */
    private void showRelais(){
    	for (int i=0; i< NUMRELAIS; i++){
    		if ((relaisValues & (1<<i)) > 0)
    			relais[i].setBackground(Color.yellow);
    		else
    			relais[i].setBackground(Color.gray);
    		relais[i].setEnabled(true); // buttons are allowed after 1st update
    	}
    }

    /* 
     * Reads 64 AD-Samples from B-Module
     */
    synchronized private void readSamples(){
        int[] fullCommand = { START_CODE ,  CMD_READADC_64,  0, STOP_CODE};
        byte[] dataAntwort = new byte[64*7+CMD_LENGTH];

        fullCommand[2]=(int) Integer.valueOf("000000"+adcChannel.getText(), 16).intValue() ;
        
        if (useFilter.getState())
        	fullCommand[2]+=0x80;	// Wenn der Filter verwendet werden soll, dann Bit 7 setzen
        
        if (!isConnected
                & (Integer.parseInt(PortField.getText()) == bridgePort)) {
            // only connect to bridging port if not yet connected because the
            // XPort only allows one connection to one port at a time
            connect();
            wasConnected = false; // note that there was no connection to port
                                  // 10001
            // in the first place, so that we need to disconnect
            // after the command is sent.
        }
        
        
        // ask for Samples
        try { 
            ReadThread.pause_on();	// Turn off Read-Thread
        	
        	XPort.send(fullCommand); // send data
        
//          Wait for answer
            int timeout=0;
            while ((!XPort.DataReady()) & (timeout<20) ){
            	wait(100);
            	timeout++;
            }
            
        	int length=XPort.readBuffer(dataAntwort,64*7);
        	
/*        	if ((dataAntwort[0] != START_CODE) |(dataAntwort[1] != CMD_READRELAIS)
        			|(dataAntwort[4] != STOP_CODE)|(length !=CMD_LENGTH)){
        		throw(new Exception("No correct answer from B-Module"));
        	}
*/
        	
        	int[] samples = new int[64];
        	for (int i=0; i< 64; i++){        		
            	samples[i]=new Integer(new String(dataAntwort,i*7,6)).intValue();        		
        	}

        	int[] data = new int[CMD_LENGTH];
        	length=XPort.readBuffer(data,CMD_LENGTH);
        	
        	if ((data[0] != START_CODE) |(data[1] != CMD_READADC_64)
        			|(data[4] != STOP_CODE)|(length !=CMD_LENGTH)){
        		throw(new Exception("No correct answer from B-Module"));
        	}

        	int min, max;
        	if ((fullCommand[2] & 0x80) > 0){ // 50 Hz Filter an?
        		max= 11000;     		min= -max;
        	} else {
        		max= 1024;        		min= 0;
        	}
        	oszilloskop.setData(samples,min,max);

            
        } catch (IOException IOEx) {
            append(statusFeld,"I/O error while switching Relais: " + IOEx);
        } catch (Exception Ex) {
            append(statusFeld,"Error while switching Relais: " + Ex);
        }

        ReadThread.pause_off();	// Turn on Read-Thread
        
        
        // check wasConnected if we need to close the connection to port 10001
        // and
        // disconnect if neccessary.
        if (wasConnected == false) {
            try {
                disconnect();
            } catch (Exception Ex) {
                append(statusFeld,"Error while trying to disconnect: " + Ex);
            }
        }
	
    }
    
    
    /*
     * Reads the current State of the Relais
     */
    synchronized private void readRelais(){
        int[] fullCommand = { START_CODE ,  CMD_READRELAIS,  0, STOP_CODE};
        int[] dataAntwort = new int[CMD_LENGTH];

        if (!isConnected
                & (Integer.parseInt(PortField.getText()) == bridgePort)) {
            // only connect to bridging port if not yet connected because the
            // XPort only allows one connection to one port at a time
            connect();
            wasConnected = false; // note that there was no connection to port
                                  // 10001
            // in the first place, so that we need to disconnect
            // after the command is sent.
        }
        
        
        // First ask for State of Relais
        try { 
            ReadThread.pause_on();	// Turn off Read-Thread
        	
        	XPort.send(fullCommand); // send data
        
//          Wait for answer
            int timeout=0;
            while ((!XPort.DataReady()) & (timeout<20) ){
            	wait(100);
            	timeout++;
            }
            
        	int length=XPort.readBuffer(dataAntwort,CMD_LENGTH);
        	
        	if ((dataAntwort[0] != START_CODE) |(dataAntwort[1] != CMD_READRELAIS)
        			|(dataAntwort[4] != STOP_CODE)|(length !=CMD_LENGTH)){
        		throw(new Exception("No correct answer from B-Module"));
        	}
        	
        	relaisValues =dataAntwort[2];
        	
            showRelais();
            
        } catch (IOException IOEx) {
            append(statusFeld,"I/O error while switching Relais: " + IOEx);
        } catch (Exception Ex) {
            append(statusFeld,"Error while switching Relais: " + Ex);
        }

        ReadThread.pause_off();	// Turn on Read-Thread
        
        
        // check wasConnected if we need to close the connection to port 10001
        // and
        // disconnect if neccessary.
        if (wasConnected == false) {
            try {
                disconnect();
            } catch (Exception Ex) {
                append(statusFeld,"Error while trying to disconnect: " + Ex);
            }
        }

    }
    
    
    /**
     * Toggles one of the Relais
	 * @param i The Relais
	 */
	synchronized private void switchRelais(int channel) {
        int[] fullCommand = { START_CODE ,  CMD_READRELAIS,  0, STOP_CODE};
        int[] dataAntwort = new int[CMD_LENGTH];
        
        if (!isConnected
                & (Integer.parseInt(PortField.getText()) == bridgePort)) {
            // only connect to bridging port if not yet connected because the
            // XPort only allows one connection to one port at a time
            connect();
            wasConnected = false; // note that there was no connection to port
                                  // 10001
            // in the first place, so that we need to disconnect
            // after the command is sent.
        }
        
        
        // First ask for State of Relais
        try { 

            ReadThread.pause_on();	// Turn off Read-Thread

        	
        	XPort.send(fullCommand); // send data
        
//          Wait for answer
            int timeout=0;
            while ((!XPort.DataReady()) & (timeout<20) ){
            	wait(100);
            	timeout++;
            }
            
        	int length=XPort.readBuffer(dataAntwort,CMD_LENGTH);
        	
        	if ((dataAntwort[0] != START_CODE) |(dataAntwort[1] != CMD_READRELAIS)
        			|(dataAntwort[4] != STOP_CODE)|(length !=CMD_LENGTH)){
        		throw(new Exception("No correct answer from B-Module"));
        	}
        	
        	int newRelaisValues=dataAntwort[2];
        	
        	// alle anderen Relais lassen, wie sie waren
        	newRelaisValues = newRelaisValues & (~(1 << channel));
        	
        	// den einen Kanal Invertieren und dann dazupacken
        	newRelaisValues += (~relaisValues) & (1 << channel);
        	
	        fullCommand[1] = CMD_SETRELAIS;
	        fullCommand[2] = (byte) (newRelaisValues & 0xFF);
        
	        // Switch Relais
            XPort.send(fullCommand);

            //  Wait for answer
            timeout=0;
            while ((!XPort.DataReady()) & (timeout<20) ){
            	wait(100);
            	timeout++;
            }

            length=XPort.readBuffer(dataAntwort,CMD_LENGTH);
        	
        	if ((dataAntwort[0] != START_CODE) |(dataAntwort[1] != CMD_SETRELAIS)
        			|(dataAntwort[4] != STOP_CODE)|(length !=CMD_LENGTH)){
        		throw(new Exception("No correct answer from B-Module"));
        	}
        
            relaisValues=dataAntwort[2];
            showRelais();
            
        } catch (IOException IOEx) {
            append(statusFeld,"I/O error while switching Relais: " + IOEx);
        } catch (Exception Ex) {
            append(statusFeld,"Error while switching Relais: " + Ex);
        }

        ReadThread.pause_off();	// Turn on Read-Thread
        
        
        // check wasConnected if we need to close the connection to port 10001
        // and
        // disconnect if neccessary.
        if (wasConnected == false) {
            try {
                disconnect();
            } catch (Exception Ex) {
                append(statusFeld,"Error while trying to disconnect: " + Ex);
            }
        }

		
	}



	/**
     * Will lock the GUI's buttons during execution of a command to keep the
     * user from doing stupid things.
     */

    private void LockButtons() {
        setCPins.setEnabled(false);
        getCPins.setEnabled(false);

        setCPinDir.setEnabled(false);
        getCPinDir.setEnabled(false);
//      getState.setEnabled(false);
        return;
    }

    /** After execution of a command, re-enables the GUI's buttons */
    private void UnlockButtons() {
        setCPins.setEnabled(true);
        getCPins.setEnabled(true);

        getCPinDir.setEnabled(true);
        setCPinDir.setEnabled(true);
//      getState.setEnabled(true);
        return;
    }

    /**
     * Will determine which LEDs are to be set. Just a helper method for
     * toggleLED().
     */
    private int LEDauswert() {
        int activeLEDs = 0;
        int bitv = 1;
        for (int i = 0; i < NUMCPINS; i++) {
            if (CPins[i].getState()) {
                activeLEDs |= bitv;
            }
            bitv <<= 1;
        }
        return activeLEDs;
    }

    /**
     * Will determine which I/O directions are to be changed. Another helper
     * method.
     * 
     * @return
     */
    private int IOauswert() {
        int activePins = 0;
        int bitv = 1;
        for (int i = 0; i < NUMCPINS; i++) {
            if (CPinDir[i].getState()) {
                activePins |= bitv;
            }
            bitv <<= 1;
        }
        return activePins;
    }

    /**
     * will evaluate the B panel's GUI elements, create a command from them and
     * send this command to the B-Module via the XPort's TCP/IP connection. An
     * already existing connection to port 10001 is used if available. If not
     * connected to port 10001 yet, this method will establish a connection to
     * that port, send the command and close the conenction to 10001.
     *  
     */
    private void cmdBModule() {
        // These calls will convert the values typed into the B panel's
        // textfields
        // into hex bytes and put them into an array of bytes.

        int command = (int) Integer.valueOf("000000"+Command.getText(), 16).intValue();
        int data = (int) Integer.valueOf("000000"+Data.getText(), 16).intValue() ;
        int[] fullCommand = { START_CODE ,  command,  data,  STOP_CODE};

        
        if (!isConnected
                & (Integer.parseInt(PortField.getText()) == bridgePort)) {
            // only connect to bridging port if not yet connected because the
            // XPort only allows one connection to one port at a time
            connect();
            wasConnected = false; // note that there was no connection to port
                                  // 10001
            // in the first place, so that we need to disconnect
            // after the command is sent.
        }
        try { // send data
            XPort.send(fullCommand);
        } catch (IOException IOEx) {
            append(statusFeld,"I/O error while reading: " + IOEx);
        } catch (Exception Ex) {
            append(statusFeld,"Error while reading: " + Ex);
        }
        // check wasConnected if we need to close the connection to port 10001
        // and
        // disconnect if neccessary.
        if (wasConnected == false) {
            try {
                disconnect();
            } catch (Exception Ex) {
                append(statusFeld,"Error while trying to disconnect: " + Ex);
            }
        }
    }

    /**
     * Prints the current time, its parameter string and \n to the output
     * textfield.
     */
    private void append(TextArea textArea, String output) {
        /*Date*/ Calendar now = Calendar.getInstance();//.getTime();
        String b = "" + now.get(Calendar.HOUR_OF_DAY);//   now.getHours();
        if (b.length() == 1)
            b = "0" + b;
        textArea.append("[" + b);
        b = "" + now.get(Calendar.MINUTE);   //getMinutes();
        if (b.length() == 1)
            b = "0" + b;
        textArea.append(":" + b);
        b = "" + now.get(Calendar.SECOND); //getSeconds();
        if (b.length() == 1)
            b = "0" + b;
        textArea.append(":" + b + "] " + output + "\n");
    }

    /**
     * This Thread will loop while a connection to the XPort exists. It will
     * wait for data to read and display it on the Applet's textfield. Numbers
     * and ASCII chars will be displayed as such, whereas non-readable ASCII
     * chars will show up as bytes in a (0xbyte) form.
     */
    private class OutputReadThread extends Thread {
    	GUI gui = null;
    	private boolean pause = false;
    	/*
    	 * Schaltet den ReadThread solange ab, bis ein continue kommt
    	 */
    	public void pause_on(){
    		pause=true;
    	}
    	
    	/*
    	 * Schaltet den ReadThread wieder an
    	 */
    	synchronized public void pause_off(){
    		pause=false;
    	}    	

    	synchronized private String parseString(int[] s, int length){
    		String gelesen= "";
    		
    		for (int i=0; i< length; i++){
	    		if (gui.showASCII.getState()){ //Try to convert Message to Ascii
	    	            // scan for printable ASCII characters and add them to gelesen
	    	            switch (s[i]) {
	    	            	case 0x0a: gelesen += "\n"; // add Line Feed
	    	            		break;
	    	            	case 0x20: gelesen += " "; // add Blank
	    	        			break;
	    	            	case 0x0d: gelesen += "\r"; // add Carriage Return
	    	            		break;
	    	            	default :
	    	            		if (s[i] > 0x20 && s[i] < 0x7e)  // add readable chars
	    	                            gelesen += new Character((char) s[i]).toString();
	    	                    else // add non-readable chars as bytes in brackets
	    	                    	gelesen += " (0x" + Integer.toHexString(s[i])+ ") "; 
	    	                     
	    	               }
	    	        } else	// Show message as Hex
	    	        	gelesen += " (0x" + Integer.toHexString(s[i])+ ") ";
    		} 
    		return gelesen;
    	}
    	
    	
    	
        public void run() {
        	boolean i = false;
        	int length=512;
        	int[] gelesen= new int[length];
        	
    		try { // since we need to handle some possible exceptions,

	        	while (!isInterrupted()) { // run while needed
	

	        		if (!pause){
	        			// check if data is available
	                	                    
	                    if (! XPort.DataReady()) { // wait while no data
	                    	sleep(10);
	                    } else { 
	                    	// receive data, 
	                    	length=XPort.readBuffer(gelesen,length);
	                    	// display it 
	                        append(ausgabeFeld,parseString(gelesen,length));
	                        // clear the input field
	                        eingabeFeld.setText("");
	                    }
	            	}

	        	}
        	
    		} catch (InterruptedException iEx){
//    			append(statusFeld,"Read-Loop, Interrupted:  " + iEx);
    		} catch (Exception ex) {
	            append(statusFeld,"Error in Read-Loop, Dying:  " + ex);
	        }
        }
    }

    
    private class Oszilloskop extends Panel{

    	private int[] data= null;
    	private int min=0;
    	private int max=0;
    	private int maxAmplitude=0;
    	
    	public Dimension getMinimumSize(){
        	return new Dimension(200,100);	
        }
    	
    	public void paint(Graphics g) {
            Graphics2D g2 = (Graphics2D) g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Dimension d = getSize();
            FontMetrics fontMetrics = g2.getFontMetrics();
            int gridWidth = d.width / 6;
            int gridHeight = d.height / 2;

            int x,y;
//            fontMetrics = pickFont(g2, "Filled and Stroked GeneralPath",
 //                                  gridWidth);
            setBackground(Color.black);
            
            Color fg3D = Color.white;

            g2.setPaint(fg3D);
            g2.drawRect(0, 0, d.width - 1, d.height - 1);
            //g2.drawRect(3, 3, d.width - 7, d.height - 7);

            
            if (data!= null){
	        	// factor zum Skalieren
	        	float yscale= (float)(d.height-2)/ (float)maxAmplitude;
	        	int offset= (int)(-(min *yscale)+2); 
	        		
	        	float xscale= (float)d.width/(float)data.length;
	        	
	            // Beschriftung und Achsen
	        	g2.setPaint(Color.yellow);

	            String label = new Integer(min).toString();
	            g2.drawString(label, d.width-fontMetrics.stringWidth(label), d.height-2 );
	            
	            label=new Integer(max).toString();
	            g2.drawString(label, d.width-fontMetrics.stringWidth(label),fontMetrics.getHeight());

	            if (min <0){
		            y=d.height-offset;
		            label = "0";
		            g2.drawString(label, d.width-fontMetrics.stringWidth(label), y +fontMetrics.getHeight()/2);
	            
	            	g2.draw(new Line2D.Double(1, y,d.width-2-fontMetrics.stringWidth("0"),y));
	            }
	            // Horizontal Line all 8 samples
	            for (int i=8; i<64; i+=8){
		            g2.draw(new Line2D.Double(i*xscale, 1,i*xscale,d.height-2));	            	
	            }

	        	x=0;
	        	y=d.height-((int)(data[0]*yscale)+offset);
	        	int oldx,oldy;

	            
	        	// Daten
	        	g2.setPaint(Color.green);
	        	for (int i=1; i< data.length-1; i++){
	            	oldx=x; oldy=y;
	            	x=(int)(i*xscale); y=d.height-((int)(data[i]*yscale)+offset);
	            	g2.draw(new Line2D.Double(oldx, oldy,x,y));
	            }
	          	            
            }            	
            g2.setPaint(Color.black);
           
    	}
		/**
		 * @param data The data to set.
		 */
		public void setData(int[] data,int min, int max) {
			this.data = new int[data.length];
			this.min=min;
			this.max=max;
			
			for (int i=0; i<data.length; i++){
				this.data[i] = data[i];
//				if (min> this.data[i]) min=this.data[i];
//				if (max< this.data[i]) max=this.data[i];
			}
			maxAmplitude=max-min;
			
			repaint();
		}
    }
    
    
}
