<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1//EN" "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd">

<html>
 <head>
  <title>Mailformular</title>
  <meta http-equiv="Content-type" content="charset=iso-8859-1"/>
  <meta name="author" content="Herbert Braun, Redaktion c't"/>
  <meta name="description" content="Gesichertes PHP-Formular zum Versand von E-Mails"/>
  <meta name="date" content="2005-09-30"/>
 </head>
 <body>
<!--
  <h1>Abgesichertes E-Mail-Formular</h1>
  <p>Das Skript berprft alle Formulardaten, die der Anwender eingibt. Fr eventuelle Fehler knnen wir keine Haftung bernehmen. Die Fehlerbehandlung mit die()-Anweisungen ist nicht besonders benutzerfreundlich.</p>
-->
  <?php
 //Gib Fehler und Warnungen aus
 error_reporting(E_ALL);
 //Deutschsprachige Umgebung, damit die
 //regulren Ausdrcke auch Umlaute etc. erkennen
 setlocale(LC_ALL, 'de_DE');
 //Erzeuge einen zufllig aussehenden Zugangscode aus dem Datum ...
 $code = chr((date("y") + 7) % 10 + date("m") + 68 + (date("m") % 2) * 32) . chr((date("d") + (date("d") %2)) / 2 + 66 + (37 * (date("d") %2)));
 //... den der Anwender mittels verborgenem Eingabefeld bergibt.
 //So lsst sich das Gros der skriptgesteuerten Angriffe von
 //vornherein abblocken.
 //Wurde das Formular abgeschickt?
 //Falls ja: Daten prfen und versenden
 if(isset($_POST['los'])) {
  if(!isset($_POST['code']) || $_POST['code'] != $code) die('Mailcode fehlt!');
  //Liste der zu berprfenden Formularfelder:
  //'absender' muss genau eine Mailadresse sein,
  //'betreff' ist ein mindestens drei Zeichen langer Text ohne Umbruch,
  //'text' muss zehn Zeichen lang sein.
  $pruefung = array(
  'absender' => '/^ [\w.!#%&\*\/=\?\^\`\{\|\}\~+-]{1,64} \@
  [[:alnum:].-]{1,255} \. [a-z]{2,6} $/xi',
   //prft auf gltige E-Mail-Adresse nach RFC 2822,
   //erlaubt auch ungewhnliche Adressen wie "{@heise.de";
   //strengere Prfung (erfordert z.B. mindestens 2 Zeichen vor @
   //und im Domainnamen, schliet ungewhnliche Adressen aus):
   //'absender' => '/^[\w.+-]{2,64}\@[\w.-]{2,255}\.[a-z]{2,6}$/',
   'betreff' => '/^[[:print:]]{3,}$/',
   //restriktivere Variante:
   //'betreff' => '/^[[:alnum:]\s\?.!,;:\(\)\/\"-]{3,}$/',
   'text' => '/^[[:print:][:space:]]{10,}$/'
  );
  //Durchlaufe alle Formulardaten:
  foreach($_POST as $parameter => $wert) {
   //Formularfelder, die in $pruefung stehen,
   //mssen in die oben definierten Muster passen
   if(isset($pruefung[$parameter])) {
    if(!preg_match($pruefung[$parameter], $wert)) die('Probleme mit Feld ' . $parameter . ': ' . $wert);
   } else {
    //Der Rest wird weggeworfen.
    unset($_POST[$parameter]);
   }
  }
  //Prfe, ob die Absenderadresse einem gltigen MX-Host angehrt
  //Zu jeder Domain in einer Mailadresse (nach dem @-Zeichen)
  //sollte ein Mail Exchange Resource Record (MX-RR) im Domain Name
  //System (DNS) eingetragen sein. Die MX-Hosts versenden die E-Mail
  //per SMTP. getmxrr() schreibt MX-Hosts in das Array $mxhosts
  //ACHTUNG: Dieser Befehl ist nur auf Unix-Maschinen implementiert,
  //unter anderen Betriebssystemen ist die Zeile zu streichen!
  //Auerdem scheint getmxrr() Probleme mit Umlautdomains zu haben.
  if(!getmxrr(substr(strstr($_POST['absender'], '@'), 1), $mxhosts)) die("Konnte keine gltige Domain fr " . $_POST['absender'] . " finden!");
  //Die Formulardaten sind ok -- der Mailversand wird vorbereitet:
  //mail() erwartet Empfnger, Betreff, Text und weitere Kopfdaten
  if(mail('nobody@heise.de', $_POST['betreff'], $_POST['text'], "From:" . $_POST['absender'])) {
   //Es hat geklappt: Besttigung ausgeben
   echo "<p>Nachricht von " . $_POST['absender'] . " an nobody@heise.de gesendet!</p>";
  } else {
   //Irgendwas ist schiefgelaufen :-(
   echo "<p>Nachricht konnte nicht gesendet werden!</p>";
  }
 } else {
 //Es wurden keine Formulardaten bergeben ->
 //Gib einen HTML-Block mit dem Formular aus.
?>
  <p>Senden Sie eine Nachricht:</p>
  <form method="post" action="">
   <table>
    <tbody>
     <tr>
      <td>
       <label for="absender">Absender:</label><br/>
       E-Mail-Adresse
      </td>
      <td>
       <input id="absender" name="absender"/>
      </td>
     </tr>
     <tr>
      <td>
       <label for="betreff">Betreff:</label><br/>
       mindestens drei Zeichen
      </td>
      <td>
       <input id="betreff" name="betreff"/>
      </td>
     </tr>
     <tr>
      <td>
       <label for="text">Text:</label><br/>
       mindestens zehn Zeichen
      </td>
      <td>
       <textarea id="text" name="text" rows="3" cols="40">
       </textarea>
       <input type="hidden" id="code" name="code" value="<?php echo($code); ?>"/>
      </td>
     </tr>
     <tr>
      <td></td>
      <td>
       <input type="submit" name="los" value="Abschicken!"/>
      </td>
     </tr>
    </tbody>
   </table>
  </form>
<?php
 //Schliet die if-else-Schleife
 }
?>
 </body>
</html>

