; -----------------------------------------------------------------------------
; #############################################################################
; -----------------------------------------------------------------------------
; Name:               Eject
; -----------------------------------------------------------------------------
; Prefix:             ej_
; Version:            0.6
; Date:               2006-03-11
; Author:             Wolfgang Reszel fr c't
; Copyright:          2006 Heise Zeitschriften Verlag GmbH & Co. KG
; -----------------------------------------------------------------------------

; -----------------------------------------------------------------------------
; === Initialisation ==========================================================
; -----------------------------------------------------------------------------

init_Eject:
   Prefix                 = ej
   %Prefix%_ScriptName    = Eject
   %Prefix%_ScriptVersion = 0.6
   %Prefix%_Author        = Wolfgang Reszel

   if Lng = 07  ; = Deutsch (0407, 0807, 0c07 ...)
   {
      MenuName                      = %ej_ScriptName% - Medien auswerfen
      Description                   = CDs und andere Medien per Tastaturkrzel auswerfen.
      lng_ej_Drive                  = Laufwerk
      lng_ej_Hotkey                 = Tastaturkrzel
      lng_ej_ShowOSD                = Grafische Anzeige aktivieren (OSD)
      lng_ej_devejectOn             = deveject.exe wurde gefunden
      lng_ej_devejectOff            = deveject.exe wurde nicht gefunden (ntig fr USB-Sticks etc.)
   }
   else        ; = other languages (english)
   {
      MenuName                      = %ej_ScriptName% - eject media
      Description                   = Ejects CDs or other media with hotkeys.
      lng_ej_Drive                  = Drive
      lng_ej_Hotkey                 = Hotkey
      lng_ej_ShowOSD                = enable on-screen-display
   }
   If CustomLanguage <>
      gosub, CustomLanguage

   IfExist, %A_ScriptDir%\deveject.exe
      Description = %Description%`n%lng_ej_devejectOn%
   Else
      Description = %Description%`n%lng_ej_devejectOff%

   If activAid_HasChanged = 1
   {
      IfNotExist, extensions\ac'tivAid_Eject_eject.gif
         FileInstall, extensions\ac'tivAid_Eject_eject.gif, extensions\ac'tivAid_Eject_eject.gif
   }

   ej_FadeSpeed = 5 ; Ausblenden-Geschwindigkeit
   Loop, 10
   {
      IniRead, ej_Drive%A_Index%, %ConfigFile%, %ej_ScriptName%, Drive%A_Index%
      If ej_Drive%A_Index% = ERROR
         ej_Drive%A_Index% =

      If (A_Index = 1 AND ej_Drive%A_Index% = "")
      {
         ej_Drive%A_Index% = *
         func_HotkeyRead( "ej_Hotkey" A_Index, ConfigFile, ej_ScriptName, "Hotkey" A_Index, "sub_Hotkey_Eject", "^+e", "$" )
         continue
      }

      If (A_Index = 2 AND ej_Drive%A_Index% = "")
      {
         DriveGet, ej_Drives, List, CDROM
         StringLeft, ej_Drives, ej_Drives, 1
         ej_Drive%A_Index% = %ej_Drives%
         func_HotkeyRead( "ej_Hotkey" A_Index, ConfigFile, ej_ScriptName, "Hotkey" A_Index, "sub_Hotkey_Eject", "ScrollLock", "$" )
         continue
      }

      If ej_Drive%A_Index% <> ""
         func_HotkeyRead( "ej_Hotkey" A_Index, ConfigFile, ej_ScriptName, "Hotkey" A_Index, "sub_Hotkey_Eject", "", "$" )
   }

   IniRead, ej_EnableOSD, %ConfigFile%, %ej_ScriptName%, OSD, 1
Return

SettingsGui_Eject:
   DriveGet, ej_Drives, List, CDROM
   IfExist, %A_ScriptDir%\deveject.exe
   {
      DriveGet, ej_Drives2, List, REMOVABLE
      ej_Drives = %ej_Drives%%ej_Drives2%
   }
   ej_AllDrives = |*
   Loop, Parse, ej_Drives,
   {
      ej_AllDrives = %ej_AllDrives%|%A_LoopField%
   }
   Sort, ej_AllDrives, D|

   ej_AllDrives = %ej_AllDrives%

   Loop, 11
   {
      Gui, Add, Text, XS+10 y+7, %lng_ej_Drive%:
      Gui, Add, ComboBox, gsub_CheckIfSettingsChanged X+5 yp-3 W40 vej_Drive%A_Index%,%ej_AllDrives%
      func_HotkeyAddGuiControl( lng_ej_Hotkey, "ej_Hotkey" A_Index, "x+20 yp+3" )
      IfNotInstring, ej_AllDrives, % ej_Drive%A_Index%
         GuiControl, , ej_Drive%A_Index%, % ej_Drive%A_Index%
      GuiControl, Choosestring, ej_Drive%A_Index%, % ej_Drive%A_Index%
   }
   Gui, Add, CheckBox, gsub_CheckIfSettingsChanged vej_EnableOSD xs+310 ys+290 -Wrap Checked%ej_EnableOSD%, %lng_ej_ShowOSD%
Return

SaveSettings_Eject:
   Loop, 11
   {
      func_HotkeyWrite( "ej_Hotkey" A_Index, ConfigFile, ej_ScriptName, "Hotkey" A_Index )
      IniWrite, % ej_Drive%A_Index%, %ConfigFile%, %ej_ScriptName%, Drive%A_Index%
   }
   IniWrite, %ej_EnableOSD%, %ConfigFile%, %ej_ScriptName%, OSD
Return

CancelSettings_Eject:
Return

DoEnable_Eject:
   Loop, 11
   {
      func_HotkeyEnable( "ej_Hotkey" A_Index )
   }
Return

DoDisable_Eject:
   Loop, 11
   {
      func_HotkeyDisable( "ej_Hotkey" A_Index )
   }
Return

DefaultSettings_Eject:
Return

; ---------------------------------------------------------------------
; -- Tastaturkrzel ---------------------------------------------------
; ---------------------------------------------------------------------

sub_Hotkey_Eject:
   ej_Drive := func_HotkeyGetVar("ej_Hotkey",11,"ej_Drive","","$")
   ej_LastEject = %ej_Drive%
   if ej_Drive = *
   {
      WinGet, ej_WinID, ID, A
      WinGetClass, ej_Class, ahk_id %ej_WinID%
      If ej_Class not contains ExploreWClass,CabinetWClass,Progman
      {
         StringTrimLeft, ej_Thishotkey, A_Thishotkey, 1
         StringLower, ej_Thishotkey, ej_Thishotkey
         Send, %ej_Thishotkey%
         Return
      }
      ej_actDir := func_GetDir(ej_WinID)
      If ej_actDir <>
      {
         If ej_actDir = %A_Desktop%
         {
            ControlGet, ej_Selected, List, Focused Col1, SysListView321, A
            FileGetShortcut, %ej_actDir%\%ej_Selected%.lnk, ej_TmpTarget
            If (func_StrRight(ej_TmpTarget,2) = ":\")
            {
               ej_Drive := func_StrLeft(ej_TmpTarget,1)
            }
            Else
               Return
         }
         Else IfInString, ej_actDir, \
         {
            If (func_StrRight(ej_actDir,2) = ":\")
            {
               ej_Drive := func_StrLeft(ej_actDir,1)
               WinClose, ahk_id %ej_WinID%
            }
            Else
               Return
         }
         Else
         {
            ControlGet, ej_Selected, List, Focused Col1, SysListView321, A
            IfInString, ej_Selected, `:)
            {
               StringGetPos, ej_Pos, ej_Selected, `:)
               StringLeft, ej_Drive, ej_Selected, %ej_Pos%
               StringRight, ej_Drive, ej_Drive, 1
            }
            Else
               Return
         }
      }
   }

   DriveGet, ej_Type, Type, %ej_Drive%:
   IfNotExist, %A_ScriptDir%\deveject.exe
      If ej_Type = REMOVABLE
         Return
   gosub, ej_main_Eject
Return

; ---------------------------------------------------------------------
ej_main_Eject: ; Medium auswerfen [ej_Drive]
   ej_transparent = 150 ; Anfangstransparenz

   ; Position berechnen
   ej_posY  := A_ScreenHeight - (A_ScreenHeight / 4) - 103

   ; Auswefen-Symbol darstellen
   Gui, 75:Default

   If ej_EnableOSD = 1
   ifExist, %A_ScriptDir%\extensions\ac'tivAid_Eject_eject.gif ; nur wenn auch vorhanden
   {
      Gui, 75:Default
      Gui, +Lastfound +Disabled +ToolWindow -Caption
      Gui, Add, pic, x0 y0 w205 h205, %A_ScriptDir%\extensions\ac'tivAid_Eject_eject.gif  ; Bild laden
      Gui, Font, S16 bold C666666, Arial
      Gui, Add, Text, BackgroundTrans x102 y153, %ej_Drive%
      Gui, Font, S16 bold C555555, Arial
      Gui, Add, Text, BackgroundTrans x101 y152, %ej_Drive%
      Gui, Font, S16 bold C333333, Arial
      Gui, Add, Text, BackgroundTrans x100 y151, %ej_Drive%
      Gui, Font, S16 bold Cffffff, Arial
      Gui, Add, Text, BackgroundTrans x99 y150, %ej_Drive%
      WinGet, ej_OSDid, ID
      WinSet, TransColor ,0000FF %ej_transparent%    ; Transparenz setzen
      WinSet, AlwaysOnTop, On                        ; Immer im Vordergrund
      Gui, Show, w205 h205 y%ej_posY% NA             ; Symbol darstellen
   }

   If ej_Type = REMOVABLE
   {
      RunWait, %A_Scriptdir%\deveject.exe -EjectDrive:%ej_Drive%:,,Hide UseErrorlevel
   }
   Else
   {
      Drive, Eject, %ej_Drive%:                         ; Medium auswerden

      if A_TimeSinceThisHotkey < 1000                   ; Wenn Auswerfen sehr schnell ging
      {                                                 ; dann war das Laufwerk schon offen
         Drive, Eject, %ej_Drive%:, 1                   ; also wird es nun geschlossen
      }
   }

   ; Auswerfen-Symbol langsam ausblenden
   If ej_EnableOSD = 1
      IfExist, %A_ScriptDir%\extensions\ac'tivAid_Eject_eject.gif ; nur wenn auch vorhanden
      {
         ej_StartTicks = %A_TickCount%
         Settimer, ej_tim_FadeOSD, 5
      }
return

ej_tim_FadeOSD:
   ej_transparent -= %ej_FadeSpeed%          ; Transparenz runterzhlen
   ej_Ticks := (A_TickCount-ej_StartTicks) / 500
   ej_transparent := ej_transparent - ej_FadeSpeed * ej_Ticks   ; Transparenz runterzhlen
   if ej_transparent < 1
   {
      Settimer, ej_tim_FadeOSD, Off
      Gui, 75:Destroy
      Return
   }
   WinSet, TransColor,0000FF %ej_transparent%, ahk_id %ej_OSDid%  ; Transparenz setzen
Return

