; -----------------------------------------------------------------------------
; #############################################################################
; -----------------------------------------------------------------------------
; Name:               QuickChangeDir
; -----------------------------------------------------------------------------
; Prefix:             qc_
; Version:            0.9
; Date:               2006-03-29
; Author:             Wolfgang Reszel fr c't
; Copyright:          2006 Heise Zeitschriften Verlag GmbH & Co. KG
; -----------------------------------------------------------------------------

; -----------------------------------------------------------------------------
; === Initialisation ==========================================================
; -----------------------------------------------------------------------------

init_QuickChangeDir:
   ; Programmname und Version
   Prefix           = qc
   %Prefix%_ScriptName    = QuickChangeDir
   %Prefix%_ScriptVersion = 0.9
   %Prefix%_Author        = Wolfgang Reszel
   %Prefix%_Titel = %qc_ScriptName% v%qc_ScriptVersion%

   CustomHotkey_QuickChangeDir = 1    ; Benutzerdefiniertes Hotkey
   Hotkey_QuickChangeDir       = #-   ; Standard-Hotkey
   HotkeyPrefix_QuickChangeDir =
   ConfigFile_QuickChangeDir   = settings\QuickChangeDir.ini

   SubMenu = QuickChangeDir_Menu

   ; Name der Index-Dateien
   qc_IndexFile = QCD_Index_
   qc_IndexFileRoot = QCD_Index

   qc_selectedDrives = %qc_PathsToIndex%

   if Lng = 07  ; = Deutsch (0407, 04807, 0c07 ...)
   {
      MenuName                      = %qc_ScriptName% - Schneller Verzeichniswechsel
      Description                   = Schneller Verzeichniswechsel durch Eingabe eines Teils des gesuchten Verzeichnisnamens. Fr den Verzeichniswechsel muss die Adressleiste im Explorer sichtbar sein.
      QuickChangeDir_EnableMenu     = %qc_ScriptName% aktiviert
      lng_qc_Untersuche             = Untersuche Laufwerk
      lng_qc_Indiziere              = Erstelle Verzeichnisindex
      lng_qc_Wechseln               = &Verzeichnis wechseln
      lng_qc_ReIndizierung          = Verzeichnisindex &aktualisieren
      lng_qc_Suchen                 = &Suchen
      lng_qc_Aktualisieren          = 8
      lng_qc_AktualisierenEinzeln   = ###`taktualisieren
      lng_qc_AktualisierenAlle      = alle Verzeichnisse aktualisieren
      lng_qc_NeuesFenster           = &Neues Fenster
      lng_qc_VerzWechseln           = &OK, wechseln
      lng_qc_berVerzHinzu          = berverzeichnis hinzufgen
      lng_qc_AusIndexEntf           = Verzeichnis samt Unterverzeichnissen aus Index entfernen
      lng_qc_LaufwerkERR            = Laufwerk existiert nicht
      lng_qc_SucheERR               = Nichts gefunden
      lng_qc_SuchEingabe            = Suchbegriff eingeben:
      lng_qc_DosBox                 = &DOS-Box
      lng_qc_AddToIndexList         = Laufwerke/Verzeichnisse, die indexiert werden:
      lng_qc_IndexPath              = Verzeichnis, wo die Indexdateien abgelegt werden (leer = im Hauptverzeichnis des jeweiligen Laufwerks):
      lng_qc_NoIndex                = Es wurde noch kein Verzeichnisindex angelegt, die Suche funktioniert, nachdem die Indexierung beendet wurde.

      lng_qc_Scheduler              = Indexierungs-Planer
      lng_qc_SchedulerInfo          = Die Indexierung kann automatisch unter folgenden Kriterien erfolgen ...
      lng_qc_AutoIndexing           = wenn sich der freie Speicher eines Laufwerks um folgenden Wert verndert hat:
      lng_qc_IndexingTime           = zu bestimmten Uhrzeiten (08:00,23:00,...):
      lng_qc_IndexingTimeFailure    = versumte Indexierungen beim Starten von ac'tivAid nachholen
      lng_qc_IndexingInterval       = alle
      lng_qc_Hours                  = Stunden

      lng_qc_NoBalloonTips          = Sprechblasenhinweise deaktivieren
      lng_qc_SucheNach              = Suche nach:
      lng_qc_FolderTree             = Explorer mit Verzeichnisbaum ffnen
      lng_qc_NoIndexer              = Zur Indexierung wird das Skript "extensions/ac'tivAid_QuickChangeDir Indexer.ahk" bentigt.

      lng_qc_Found                  = gefunden
      lng_qc_SearchDefault          = Suchbegriff-Vorgabe

      lng_qc_WindowDocking            = Fenster andocken

      tooltip_a                     = Index fr den ausgewhlten Pfad aktualisieren
   }
   else        ; = andere Sprachen
   {
      MenuName                      = %qc_ScriptName% - fast folder-switching
      Description                   = Change the folder of the actual window to a pre-indexed folder by typing a part of its name. The address bar has to be visible to change the directory.
      QuickChangeDir_EnableMenu     = %qc_ScriptName% active
      lng_qc_Untersuche             = scanning drive
      lng_qc_Indiziere              = creating directory-index
      lng_qc_Wechseln               = &change directory
      lng_qc_ReIndizierung          = &update directory-index
      lng_qc_Suchen                 = &Search
      lng_qc_Aktualisieren          = 8
      lng_qc_AktualisierenEinzeln   = update ###
      lng_qc_AktualisierenAlle      = update all directories
      lng_qc_NeuesFenster           = &new window
      lng_qc_VerzWechseln           = &OK, change
      lng_qc_berVerzHinzu          = add upper directory
      lng_qc_AusIndexEntf           = remove folder and sub-folders from index
      lng_qc_LaufwerkERR            = drive does not exist
      lng_qc_SucheERR               = nothing found
      lng_qc_SuchEingabe            = Enter search term:
      lng_qc_DosBox                 = &DOS-Box
      lng_qc_AddToIndexList         = Drives/Paths to index:
      lng_qc_IndexPath              = Directory to store the index-files (empty = at the root of every indexed drive):
      lng_qc_NoIndex                = No index-files found. You can use the search after the indexing has finished.

      lng_qc_AutoIndexing           = Automatic indexing, if the drive-space changed about:
      lng_qc_Scheduler              = schedule indexing
      lng_qc_SchedulerInfo          = Automatic indexing can be controlled with the following rules ...
      lng_qc_AutoIndexing           = if the drive-space changed about:
      lng_qc_IndexingTime           = at a appointed time (08:00,23:00,...):
      lng_qc_IndexingTimeFailure    = retry missed indexing when ac'tivAid starts
      lng_qc_IndexingInterval       = every
      lng_qc_Hours                  = hours

      lng_qc_NoBalloonTips          = no BalloonTips
      lng_qc_SucheNach              = search for:
      lng_qc_FolderTree             = open Explorer with folder-tree
      lng_qc_NoIndexer              = The script "extensions/ac'tivAid_QuickChangeDir Indexer.ahk" is missing.

      lng_qc_Found                  = found
      lng_qc_SearchDefault          = default search item

      lng_qc_WindowDocking            = attach windows

      tooltip_a                     = update index for the selected path
   }
   If CustomLanguage <>
      gosub, CustomLanguage

   qc_Points = ...................................................................

   IniRead, qc_PathsToIndex, %ConfigFile_QuickChangeDir%, Config, PathsToIndex
   If (qc_PathsToIndex = "ERROR" OR qc_PathsToIndex = "")
      qc_PathsToIndex = C:\

   IniRead, qc_IndexPath, %ConfigFile_QuickChangeDir%, Config, IndexPath, %A_Scriptdir%\settings\%qc_ScriptName%

   IniRead, qc_History, %ConfigFile_QuickChangeDir%, History, SearchHistory
   If (qc_History = "ERROR")
      qc_History =

   IniRead, qc_SearchDefault, %ConfigFile_QuickChangeDir%, Config, SearchDefault
   If (qc_SearchDefault = "ERROR")
      qc_SearchDefault =

   ;StringReplace, qc_History, qc_History, ||,|, A

   If qc_IndexPath <>
      IfNotExist, %qc_IndexPath%
         FileCreateDir, %qc_IndexPath%

   IniRead, qc_AutoIndexingSpace, %ConfigFile_QuickChangeDir%, Schedule, AutoIndexingSpace, 0
   IniRead, qc_IndexThreshold, %ConfigFile_QuickChangeDir%, Schedule, IndexThreshold, 10
   IniRead, qc_AutoIndexingTime, %ConfigFile_QuickChangeDir%, Schedule, AutoIndexingTime, 0
   IniRead, qc_AutoIndexingTimeFailure, %ConfigFile_QuickChangeDir%, Schedule, AutoIndexingTimeFailure, 0
   IniRead, qc_IndexTimeValues, %ConfigFile_QuickChangeDir%, Schedule, IndexTimeValues, %A_Space%
   IniRead, qc_AutoIndexingInterval, %ConfigFile_QuickChangeDir%, Schedule, AutoIndexingInterval, 0
   IniRead, qc_IndexInterval, %ConfigFile_QuickChangeDir%, Schedule, IndexInterval, %A_Space%

   IniRead, qc_NoBalloonTips, %ConfigFile_QuickChangeDir%, Config, NoBalloonTips, 0
   IniRead, qc_LastTimeIndexed , %ConfigFile_QuickChangeDir%, Schedule, LastTimeIndexed, 00000000000000
   IniRead, qc_NextIndexing, %ConfigFile_QuickChangeDir%, Schedule, NextIndexing, 0
   IniRead, qc_WindowDocking, %ConfigFile_QuickChangeDir%, Window, WindowDocking, 1

   ; Traymen erweitern
   Menu, QuickChangeDir_Menu, Add, %QuickChangeDir_EnableMenu%, sub_MenuCall
   Menu, QuickChangeDir_Menu, Add

   ; Untermen fr die Laufwerksaktualisierung erzeugen
   Loop, Parse, qc_PathsToIndex, `,
   {
      qc_LoopField := qc_func_GetDrive(A_LoopField,"RealPath")
      StringReplace, qc_SubMenuItem, lng_qc_AktualisierenEinzeln, ###, %qc_LoopField%
      Menu, QuickChangeDir_Menu, Add, %qc_SubMenuItem%, qc_submenu_IndexDrives
   }
   Menu, QuickChangeDir_Menu, Add, %lng_qc_AktualisierenAlle%, qc_submenu_IndexDrives

   IniRead, qc_FolderTree, %ConfigFile_QuickChangeDir%, Config, FolderTree, 0

   If activAid_HasChanged = 1
   {
      IfNotExist, extensions\ac'tivAid_QuickChangeDir Indexer.exe
      {
         FileInstall, extensions\ac'tivAid_QuickChangeDir Indexer.exe, extensions\ac'tivAid_QuickChangeDir Indexer.exe, 1
      }
   }

   qc_winYDistance := CaptionHeight+BorderHeight
Return

SettingsGui_QuickChangeDir:
   Gui, Add, Text, xs+10 y+8 , %lng_qc_SearchDefault%:
   Gui, Add, Edit, gsub_CheckIfSettingsChanged x+5 yp-3 R1 w180 vqc_SearchDefault, %qc_SearchDefault%

   Gui, Add, Text, Y+5 XS+10, %lng_qc_AddToIndexList%
   StringReplace, qc_PathsToIndex_Box, qc_PathsToIndex , `, , | , a
   Gui, Add, ListBox, Y+5 vqc_PathsToIndex_Box_tmp W530 R9, %qc_PathsToIndex_Box%
   qc_PathsToIndex_Box_DontAllowSubfolders = 1
   Gui, Add, Button, -Wrap x+4 w21 vqc_Add_PathsToIndex_Box gsub_ListBox_addFolder, +
   Gui, Add, Button, -Wrap y+4 w21 vqc_Remove_PathsToIndex_Box gsub_ListBox_remove, %MinusString%
   Gui, Font, S%FontSize10%, Marlett
   Gui, Add, Button, -Wrap y+49 w21 gqc_sub_ListBox_DoIndex, a
   Gosub, GuiDefaultFont

   Gui, Add, CheckBox, -Wrap xs+10 y+15 Checked%qc_NoBalloonTips% gsub_CheckIfSettingsChanged vqc_NoBalloonTips, %lng_qc_NoBalloonTips%
   Gui, Add, CheckBox, -Wrap X+20 vqc_FolderTree gsub_CheckIfSettingsChanged Checked%qc_FolderTree%, %lng_qc_FolderTree%
   Gui, Add, CheckBox, -Wrap X+20 vqc_WindowDocking gsub_CheckIfSettingsChanged Checked%qc_WindowDocking%, %lng_qc_WindowDocking%

   Gui, Add, Text, xs+10 y+15 , %lng_qc_IndexPath%
   Gui, Add, Edit, gsub_CheckIfSettingsChanged R1 w320 vqc_IndexPath, %qc_IndexPath%
   Gui, Add, Button, -Wrap X+5 YP-1 W100 gqc_sub_Browse, %lng_Browse%
   Gui, Add, Button, -Wrap X+5 W120 gqc_sub_Scheduler, %lng_qc_Scheduler% ...
Return

qc_sub_Scheduler:
   Gui, 1:+Disabled
   Gui, 10:Default
   Gui, +Owner1
   Gui, Add, Text,, %lng_qc_SchedulerInfo%

   Gui, Add, GroupBox, x10 w520 h35
   Gui, Add, CheckBox, xp+10 yp+15 -Wrap Checked%qc_AutoIndexingSpace% gsub_CheckIfSettingsChanged vqc_AutoIndexingSpace, %lng_qc_AutoIndexing%
   Gui, Add, ComboBox, x+5 yp-4 w50 gsub_CheckIfSettingsChanged vqc_IndexThreshold, 2|5|10|15|20|30|50|75|100|250|500|1000
   GuiControl,Text, qc_IndexThreshold, %qc_IndexThreshold%
   Gui, Add, Text, yp+4 x+5, MB

   Gui, Add, GroupBox, x10 y+5 w520 h55
   Gui, Add, CheckBox, xp+10 yp+15 -Wrap Checked%qc_AutoIndexingTime% gsub_CheckIfSettingsChanged vqc_AutoIndexingTime, %lng_qc_IndexingTime%
   Gui, Add, Edit, x+5 yp-4 w280 gsub_CheckIfSettingsChanged vqc_IndexTimeValues, %qc_IndexTimeValues%
   Gui, Add, CheckBox, x40 y+3 -Wrap Checked%qc_AutoIndexingTimeFailure% gsub_CheckIfSettingsChanged vqc_AutoIndexingTimeFailure, %lng_qc_IndexingTimeFailure%

   Gui, Add, GroupBox, x10 y+5 w520 h35

   Gui, Add, CheckBox, xp+10 yp+15 -Wrap Checked%qc_AutoIndexingInterval% gsub_CheckIfSettingsChanged vqc_AutoIndexingInterval, %lng_qc_IndexingInterval%
   Gui, Add, ComboBox, x+5 yp-4 w50 gsub_CheckIfSettingsChanged vqc_IndexInterval, 00:05|00:15|00:30|01:00|02:00|03:00|04:00|06:00|12:00|24:00|48:00
   GuiControl,Text, qc_IndexInterval, %qc_IndexInterval%
   Gui, Add, Text, yp+4 x+5, %lng_qc_Hours%

   Gui, Add, Button, -Wrap X180 W80 vMainGuiOK Default gqc_sub_SchedulerOK, &%lng_OK%
   Gui, Add, Button, -Wrap X+5 W80 vMainGuiCancel g10GuiClose, &%lng_cancel%

   Gui, Show, w540, %qc_ScriptName% %lng_qc_Scheduler%
Return

10GuiClose:
10GuiEscape:
   Gui, 1:-Disabled
   Gui, Destroy
Return

qc_sub_SchedulerOK:
   func_SettingsChanged( "QuickChangeDir" )
   Gui, 1:-Disabled
   Gui, Submit
   Sort, qc_IndexTimeValues, D`,
   Gui, Destroy
Return

qc_sub_ListBox_DoIndex:
   GuiControlGet, qc_selectedDrives, , qc_PathsToIndex_Box_tmp
   qc_selectedDrives := qc_func_GetDrive( qc_selectedDrives, "RealPath" )
   gosub, qc_sub_IndexDrives
Return

qc_sub_Browse:
   Gui +OwnDialogs
   FileSelectFolder, qc_IndexPath, , 3
   If qc_IndexPath <>
      GuiControl,,qc_IndexPath,%qc_IndexPath%
Return

SaveSettings_QuickChangeDir:
   StringReplace, qc_PathsToIndex, qc_PathsToIndex_Box, |, `, ,a
   If (func_StrLeft(qc_PathsToIndex,1) = ",")
      StringTrimLeft, qc_PathsToIndex, qc_PathsToIndex, 1
   If (func_StrRight(qc_PathsToIndex,1) = ",")
      StringTrimRight, qc_PathsToIndex, qc_PathsToIndex, 1

   IniWrite, %qc_IndexPath%, %ConfigFile_QuickChangeDir%, Config, IndexPath
   IniWrite, %qc_PathsToIndex%, %ConfigFile_QuickChangeDir%, Config, PathsToIndex
   IniWrite, %qc_AutoIndexingSpace%, %ConfigFile_QuickChangeDir%, Schedule, AutoIndexingSpace
   IniWrite, %qc_IndexThreshold%, %ConfigFile_QuickChangeDir%, Schedule, IndexThreshold
   IniWrite, %qc_AutoIndexingTime%, %ConfigFile_QuickChangeDir%, Schedule, AutoIndexingTime
   IniWrite, %qc_AutoIndexingTimeFailure%, %ConfigFile_QuickChangeDir%, Schedule, AutoIndexingTimeFailure
   IniWrite, %qc_IndexTimeValues%, %ConfigFile_QuickChangeDir%, Schedule, IndexTimeValues
   IniWrite, %qc_AutoIndexingInterval%, %ConfigFile_QuickChangeDir%, Schedule, AutoIndexingInterval
   IniWrite, %qc_IndexInterval%, %ConfigFile_QuickChangeDir%, Schedule, IndexInterval
   IniWrite, %qc_NoBalloonTips%, %ConfigFile_QuickChangeDir%, Config, NoBalloonTips
   IniWrite, %qc_FolderTree%, %ConfigFile_QuickChangeDir%, Config, FolderTree
   IniWrite, %qc_SearchDefault%, %ConfigFile_QuickChangeDir%, Config, SearchDefault
   IniWrite, %qc_WindowDocking%, %ConfigFile_QuickChangeDir%, Window, WindowDocking
Return

CancelSettings_QuickChangeDir:
Return

DoEnable_QuickChangeDir:
   SetTimer, qc_tim_AutoIndexing, 6000
Return

DoDisable_QuickChangeDir:
   SetTimer, qc_tim_AutoIndexing, Off
   Gui, 8:Destroy
   Gui, 9:Destroy
   qc_GUI=
Return

DefaultSettings_QuickChangeDir:
Return

; -----------------------------------------------------------------------------
; === Hotkeys =================================================================
; -----------------------------------------------------------------------------

sub_Hotkey_QuickChangeDir:
   gosub, qc_main_QuickChangeDir
Return

; -----------------------------------------------------------------------------
; === Subroutines =============================================================
; -----------------------------------------------------------------------------

; ---------------------------------------------------------------------
qc_main_QuickChangeDir: ; Unterroutine fr das Eingabefenster
   SetTimer, qc_tim_WatchWindows, Off

   If Enable_QuickChangeDir = 1
   {
      If qc_GUI <> 8 ; Fenster aufbauen, wenn es noch nicht existiert
      {
         If qc_GUI = 9
            Gosub, 9GuiClose
         Else
         {
            WinGet     , qc_TargetWindowID, ID, A             ; ID es aktiven Fensters
            WinGetClass, qc_class, ahk_id %qc_TargetWindowID%  ; Fensterklasse ermitteln
         }

         If qc_Class contains %ChangeDirClasses%
            qc_DoDocking = 1
         Else
            qc_DoDocking = 0

         qc_WinH   = 80   ; Fensterhhe
         qc_WinW   = 300  ; Fensterbreite

         If (qc_WindowDocking = 0 OR qc_DoDocking = 0)
         {
            IniRead, qc_WinX, %ConfigFile_QuickChangeDir%, Window, SearchWindowX, %A_Space%
            IniRead, qc_WinY, %ConfigFile_QuickChangeDir%, Window, SearchWindowY, %A_Space%
         }
         Else
         {
            WinGetPos, qc_TargetWinX, qc_TargetWinY, qc_TargetWinW, qc_TargetWinH, ahk_id %qc_TargetWindowID%

            qc_WinX := qc_TargetWinX + (qc_TargetWinW-qc_WinW)/2
            qc_WinY := qc_TargetWinY + qc_WinYDistance
            If (qc_WinX+qc_WinW > WorkAreaWidth)
               qc_WinX := WorkAreaWidth-qc_WinW
            If (qc_WinY+qc_WinH > WorkAreaHeight)
               qc_WinY := WorkAreaHeight-qc_WinH
            If (qc_WinX < WorkAreaLeft)
               qc_WinX := WorkAreaLeft
            If (qc_WinY < WorkAreaTop)
               qc_WinY := WorkAreaTop

            qc_WinX = x%qc_WinX%
            qc_WinY = y%qc_WinY%

         }

         ; Fenster aufbauen
         Gui, 8:Add, Text    ,                                    , %lng_qc_SuchEingabe%
         Gui, 8:Font, Ccc0000 ; Text Rot (#CC0000)
         Gui, 8:Add, Text, vqc_StatusMsg x+5 w200, %qc_ErrorMsg%
         Gui, 8:Add, ComboBox, vqc_FindString x10 w280, %qc_SearchDefault%||%qc_History%
         Gui, 8:Font,,Marlett
         Gui, 8:Add, Button  , -Wrap gqc_sub_IndexingMenu w20, %lng_qc_Aktualisieren%
         Gui, 8:Font
         Gui, 8:Add, Button  , -Wrap g8GuiClose x+95 w80, %lng_Cancel%
         Gui, 8:Add, Button  , -Wrap gqc_sub_SearchOK x+5 w80 Default, %lng_qc_Suchen%
         Gui, 8:-Maximize +Alwaysontop +Lastfound
         WinGet, qc_GuiWinID, ID
         qc_LastTempID = %qc_GuiWinID%
         Gui, 8:Show, w%qc_WinW% h%qc_WinH% %qc_WinX% %qc_WinY%, %qc_Titel%
         WinGetPos, qc_StartX, qc_StartY, qc_StartW, qc_StartH, ahk_id %qc_GuiWinID%

         SetTimer, qc_tim_WatchWindows, 10

         Send, {Right}
         qc_ErrorMsg =
         qc_GUI = 8

         Loop, Parse, qc_PathsToIndex, `,
         {
            qc_ActDrive := qc_func_GetDrive( A_LoopField ) ; Aktuelles Laufwerk
            if qc_IndexPath =
            {
               qc_IndexPathDrv := qc_func_GetDrive( A_LoopField, "RealPath" )
               qc_IndexTemp = %qc_IndexPathDrv%%qc_IndexFileRoot%.dat ; Dateiname Verzeichnisindex
               IfExist, %qc_IndexPathDrv%%qc_IndexFile%%qc_ActDrive%.dat
                  FileMove, %qc_IndexPathDrv%%qc_IndexFile%%qc_ActDrive%.dat, %qc_IndexTemp%, 1
            }
            Else
            {
               qc_IndexTemp = %qc_IndexPath%\%qc_IndexFile%%qc_ActDrive%.dat ; Dateiname Verzeichnisindex
            }
            IfNotExist, %qc_IndexTemp%
            {
               gosub, qc_sub_IndexDrives
               msgbox, 64, %qc_Titel%, %lng_qc_NoIndex%`n%qc_IndexTemp%
               break
            }
         }
      }
      else ; ... wenn Fenster existiert ...
      {
         WinActivate, ahk_id %qc_GuiWinID% ; .. in den Vordergrund
      }
   }
Return

qc_tim_WatchWindows:
   If LoadingFinished <> 1
      Return

   DetectHiddenwindows, On
   IfWinNotExist, ahk_id %qc_TargetWindowID%
      Goto, %qc_GUI%GuiClose

   WinGet, qc_tempID, ID, A

   If (qc_tempID <> qc_GuiWinID AND qc_tempID <> qc_TargetWindowID)
   {
      qc_LastTempID = %qc_tempID%
      Return
   }

   WinGetPos, qc_tmpWinX, qc_tmpWinY, qc_tmpWinW, qc_tmpWinH, ahk_id %qc_GuiWinID%
   WinGetPos, qc_TargetWinX, qc_TargetWinY, qc_TargetWinW, qc_TargetWinH, ahk_id %qc_TargetWindowID%
   WinGet, qc_TargetMax, MinMax, ahk_id %qc_TargetWindowID%

   If (qc_TargetWinX = qc_TargetWinY AND qc_TargetWinX > WorkAreaRight AND qc_TargetWinY > WorkAreaBottom)
      Goto, %qc_GUI%GuiClose

   If (qc_tempID = qc_GuiWinID)
   {
      qc_WinX := qc_tmpWinX-(qc_TargetWinW-qc_tmpWinW) /2
      qc_WinY := qc_tmpWinY-qc_winYDistance

      If ((qc_tmpWinX <> qc_StartX OR qc_tmpWinY <> qc_StartY OR qc_tmpWinH <> qc_StartH OR qc_tmpWinW <> qc_StartW) AND qc_TargetMax = 0 AND qc_WindowDocking = 1 AND qc_DoDocking = 1)
      {
         WinMove, ahk_id %qc_TargetWindowID%,, %qc_WinX%, %qc_WinY%
      }
      If (qc_LastTempID <> qc_GuiWinID AND qc_LastTempID <> qc_TargetWindowID)
      {
         WinSet, AlwaysOnTop, Toggle, ahk_id %qc_TargetWindowID%
         WinSet, AlwaysOnTop, Toggle, ahk_id %qc_TargetWindowID%
         WinSet, AlwaysOnTop, On, ahk_id %qc_GuiWinID%
      }
   }
   If qc_tempID = %qc_TargetWindowID%
   {
      If (qc_TargetWinX = qc_TargetWinY AND qc_TargetWinX > WorkAreaRight AND qc_TargetWinY > WorkAreaBottom)
         Goto, %qc_GUI%GuiClose

      qc_WinX := qc_TargetWinX + (qc_TargetWinW-qc_tmpWinW)/2
      qc_WinY := qc_TargetWinY + qc_winYDistance

      If (qc_WinX+qc_WinW > WorkAreaWidth)
         qc_WinX := WorkAreaWidth-qc_WinW
      If (qc_WinY+qc_WinH > WorkAreaHeight)
         qc_WinY := WorkAreaHeight-qc_WinH
      If (qc_WinX < WorkAreaLeft)
         qc_WinX := WorkAreaLeft
      If (qc_WinY < WorkAreaTop)
         qc_WinY := WorkAreaTop
      If ((qc_WinX <> qc_LastWinX OR qc_WinY <> qc_lastWinY) AND qc_WindowDocking = 1 AND qc_DoDocking = 1)
         WinMove, ahk_id %qc_GuiWinID%,, %qc_WinX%, %qc_WinY%
      qc_LastWinX = %qc_WinX%
      qc_LastWinY = %qc_WinY%
   }
   qc_StartX = %qc_tmpWinX%
   qc_StartY = %qc_tmpWinY%
   qc_StartH = %qc_tmpWinH%
   qc_StartW = %qc_tmpWinW%
   qc_LastTempID = %qc_tempID%
Return

8GuiEscape:
8GuiClose:
   SetTimer, qc_tim_WatchWindows, Off
   qc_Break = 1
   wingetpos qc_newWinX,qc_newWinY,,, %qc_Titel% ; nochmals Fenstermae ermitteln
   IniWrite, x%qc_newWinX%, %ConfigFile_QuickChangeDir%, Window, SearchWindowX
   IniWrite, y%qc_newWinY%, %ConfigFile_QuickChangeDir%, Window, SearchWindowY
   Gui,8:Destroy
   If qc_DoDocking = 1
      IfWinNotActive, ahk_id %qc_TargetWindowID%
         WinActivate, ahk_id %qc_TargetWindowID%
   qc_GUI =
Return

; ---------------------------------------------------------------------
qc_sub_SearchOK: ;    Suchen-Schaltflche
   wingetpos qc_newWinX,qc_newWinY,,, %qc_Titel% ; nochmals Fenstermae ermitteln
   IniWrite, x%qc_newWinX%, %ConfigFile_QuickChangeDir%, Window, SearchWindowX
   IniWrite, y%qc_newWinY%, %ConfigFile_QuickChangeDir%, Window, SearchWindowY

   GetKeyState, qc_ctrlState, Ctrl ; Status der Strg-Taste ermitteln
   if qc_ctrlState = U             ; wenn nicht gedruckt
      qc_ctrlState =               ; Statusvariable lschen, damit sie im Ergebnisfenster nochmals abgefragt wird
   Gosub, qc_sub_Result
Return


; ---------------------------------------------------------------------
; -- Ergebnisfenster der Suche ----------------------------------------
; ---------------------------------------------------------------------

; ---------------------------------------------------------------------
qc_sub_Result: ; Unterroutine fr die Verzeichnissuche [Suchen-Schaltflche]
   SetTimer, qc_tim_WatchWindows, Off
   Gui, 8:Submit, NoHide  ; Eingaben des Fenster in die Variablen bertragen

   qc_Break =

   GuiControl, 8:+Disabled, qc_FindString
   ;GuiControl, 8:+Disabled, %lng_Cancel%
   GuiControl, 8:+Disabled, %lng_qc_Suchen%

   Gui, 8:Font, C000000 ; Text Rot (#CC0000)
   GuiControl, 8:Font, qc_StatusMsg

   GuiControl, 8:, qc_StatusMsg, 0 %lng_qc_Found%

   StringReplace, qc_History, qc_History, %qc_FindString%| ; Doppelter Eintrag in Historie entfernen
   qc_History = %qc_FindString%|%qc_History%               ; Suchbegriffhistorie erweitern
   StringReplace, qc_History, qc_History, ||,|, A
   StringGetPos, qc_HistoryPos, qc_History, |, L20
   If qc_HistoryPos > 1
      StringLeft, qc_History, qc_History, % qc_HistoryPos+1
   IniWrite, %qc_History%, %ConfigFile_QuickChangeDir%, History, SearchHistory

   ; Wenn Suchbegriff lnger als ein Zeichen
   if (!FileExist(qc_FindString) OR !(InStr(qc_FindString,"\") OR (InStr(qc_FindString,":") AND StrLen(qc_FindString) = 2)) OR InStr(qc_FindString,"*") )
   {
      qc_NumDirs  = 0      ; Anzahl der gefundenen Verzeichnisse auf 0 setzen

      IniRead, qc_WinW, %ConfigFile_QuickChangeDir%, Window, ResultWindowWidth, 620  ; Fensterbreite
      IniRead, qc_WinH, %ConfigFile_QuickChangeDir%, Window, ResultWindowHeight, 460 ; Fensterhhe
      If (qc_WindowDocking = 0 OR qc_DoDocking = 0)
      {
         IniRead, qc_WinX, %ConfigFile_QuickChangeDir%, Window, ResultWindowX, %A_Space%  ; Fenster X
         IniRead, qc_WinY, %ConfigFile_QuickChangeDir%, Window, ResultWindowY, %A_Space% ; Fenster Y
      }
      Else
      {
         qc_WinX := qc_TargetWinX + (qc_TargetWinW-qc_WinW-BorderHeight*2)/2
         qc_WinY := qc_TargetWinY + qc_winYDistance

         If (qc_WinX+qc_WinW > WorkAreaWidth)
            qc_WinX := WorkAreaWidth-qc_WinW
         If (qc_WinY+qc_WinH > WorkAreaHeight)
            qc_WinY := WorkAreaHeight-qc_WinH
         If (qc_WinX < WorkAreaLeft)
            qc_WinX := WorkAreaLeft
         If (qc_WinY < WorkAreaTop)
            qc_WinY := WorkAreaTop
         qc_WinX = x%qc_WinX%
         qc_WinY = y%qc_WinY%
      }
      qc_MinW     = 520   ; minimale Fensterbreite
      qc_MinH     = 200   ; minimale Fensterhhe
      qc_ListY    = 30    ; Y-Position der Ergebnisliste
      qc_ListW    := qc_WinW-20  ; Breite der Ergebnisliste
      qc_ListH    := qc_WinH-90   ; Hhe der Ergebnisliste
      qc_EditY    := qc_WinH-60   ; Position der Statuszeile
      qc_ButtonY  := qc_WinH-30   ; Y-Position der Schaltflchen
      qc_Button2X := qc_WinW-415   ; X-Position von "Abbrechen"
      qc_Button5X := qc_WinW-305   ; X-Position von "DOS-Box"
      qc_Button3X := qc_WinW-215   ; X-Position von "gleiches Fenster"
      qc_Button4X := qc_WinW-110   ; X-Position von "neues Fenster"

      Gui, 9:Add, Edit, w%qc_ListW% vqc_SearchTheList gqc_sub_SearchTheList

      Gui, 9:Add, ListBox, x10 y%qc_ListY% h%qc_ListH% w%qc_ListW% +HScroll Choose1 vqc_varResults gqc_sub_ResultList ; Ergebnisliste
      qc_AllResults =

      IfInString, qc_FindString, *
      {
         qc_Wildcards = 1
         If (func_StrLeft(qc_FindString,1) <> "*" AND !InStr(func_StrLeft(qc_FindString,2),":") )
            qc_FindStringAdd = *\
      }
      Else
      {
         qc_Wildcards = 0
            qc_FindStringAdd =
      }

      If (InStr(func_StrLeft(qc_FindString,2),":"))
      {
         qc_OnlyOneDrive := func_StrLeft(qc_FindString,2)
         If qc_Wildcards = 0
            StringTrimLeft, qc_FindString, qc_FindString, 2

      }
      Else
         qc_OnlyOneDrive =

      Loop, Parse, qc_PathsToIndex, `, ; alle Laufwerke duchgehen
      {
         If A_LoopField =
            break

         GetKeyState, qc_ESC, Esc
         If (qc_ESC = "D" OR qc_Break = 1)
            break

         qc_ActDrive := qc_func_GetDrive( A_LoopField ) ; Aktuelles Laufwerk

         If (qc_ActDrive ":" <> qc_OnlyOneDrive AND qc_OnlyOneDrive <> "")
            continue

         if qc_IndexPath =
         {
            qc_IndexPathDrv := qc_func_GetDrive( A_LoopField, "RealPath" )
            qc_IndexTemp = %qc_IndexPathDrv%%qc_IndexFileRoot%.dat ; Dateiname Verzeichnisindex
         }
         Else
         {
            qc_IndexTemp = %qc_IndexPath%\%qc_IndexFile%%qc_ActDrive%.dat ; Dateiname Verzeichnisindex
         }

         Loop, Read, %qc_IndexTemp%                         ; Verzeichnisindex laden
         {
            If (qc_IndexPath = "" AND qc_ActDrive ":" <> func_StrLeft(A_LoopReadLine,2) )
               qc_LoopReadLine = %qc_ActDrive%:%A_LoopReadLine%
            Else
               qc_LoopReadLine = %A_LoopReadLine%

            GetKeyState, qc_ESC, Esc
            If (qc_ESC = "D" OR qc_Break = 1)
               break

            SplitPath, qc_LoopReadLine, CheckFile, CheckDir ; Pfad aufteilen
            If qc_Wildcards = 1
            {
               If func_WildcardMatch(qc_LoopReadLine, qc_FindStringAdd qc_FindString)         ; Wenn Suchbegriff vorhanden
               {
                  qc_AllResults = %qc_LoopReadLine%`n%qc_AllResults%
                  qc_NumDirs++                               ; Anzahl gefundener Verz. erhhen
               }
            }
            Else
            {
               If CheckFile contains %qc_FindString%         ; Wenn Suchbegriff vorhanden
               {
                  qc_AllResults = %qc_LoopReadLine%`n%qc_AllResults%
                  qc_NumDirs++                               ; Anzahl gefundener Verz. erhhen
               }
            }
            If (A_Tickcount > qc_Tickcount+100)
            {
               qc_Tickcount = %A_Tickcount%
               qc_Status++
               If qc_Status = 30
                  qc_Status = 1
               StringLeft, qc_AddStatus, qc_Points, %qc_Status%
               GuiControl, 8:, qc_StatusMsg, %qc_NumDirs% %lng_qc_Found% %qc_AddStatus%
            }
         }
         GuiControl, 9:Choose, qc_varResults, 1             ; erstes Verz. auswhlen
      }
      qc_AllResultsRevers = %qc_AllResults%
      qc_Break =
      Sort, qc_AllResults, U
      Sort, qc_AllResultsRevers, R

      StringReplace, qc_AllResultsBox, qc_AllResults, `n, |, A

      GuiControl,9:,qc_varResults,%qc_AllResultsBox% ; Pfad zum Fenster hinzufgen

      Gui, 8:Destroy ; Eingabefenster beenden

      ; Fenster zeigen, wenn mehr als ein Verz. gefunden
      if qc_NumDirs > 1
      {
         Gui, 9:Add, Edit  ,                        x10             y%qc_EditY%   w%qc_ListW% vStatusBar ReadOnly
         Gui, 9:Font,, Marlett
         Gui, 9:Add, Button, -Wrap gqc_sub_IndexingMenu x10             y%qc_ButtonY% w20        , %lng_qc_Aktualisieren%
         Gui, 9:Font
         Gui, 9:Add, Button, -Wrap g9GuiClose             x%qc_Button2X% y%qc_ButtonY% w100        , %lng_Cancel%
         Gui, 9:Add, Button, -Wrap gqc_sub_ResultOK2         x%qc_Button3X% y%qc_ButtonY% w100 , %lng_qc_NeuesFenster%
         Gui, 9:Add, Button, -Wrap gqc_sub_ResultOK          x%qc_Button4X% y%qc_ButtonY% w100 Default, %lng_qc_VerzWechseln%
         Gui, 9:Add, Button, -Wrap gqc_sub_ResultOK3         x%qc_Button5X% y%qc_ButtonY% w80 , %lng_qc_DosBox%
         Gui, 9:+Resize +AlwaysOnTop +Lastfound
         Gui, 9:Show, w%qc_WinW% h%qc_WinH% %qc_WinX% %qc_WinY%, %qc_Titel% - %lng_qc_SucheNach% %qc_FindString%
         qc_GUI = 9
         WinGet, qc_GuiWinID, ID
         qc_LastTempID = %qc_GuiWinID%
         WinGetPos, qc_StartX, qc_StartY, qc_StartW, qc_StartH, ahk_id %qc_GuiWinID%

         SetTimer, qc_tim_WatchWindows, 10

         func_AddMessage(0x100,"qc_func_Edit1Keys")
         IniRead, qc_varResults, %ConfigFile_QuickChangeDir%, Favourites, % func_Hex(func_StrLower(qc_FindString))
         If qc_varResults <> ERROR
            GuiControl, 9:ChooseString, qc_varResults, %qc_varResults%
      }

      ; Wenn nur ein Verzeichnis gefunden, direkt dort hin wechseln
      if qc_NumDirs = 1
      {
         Gui,9:Destroy                    ; Fenster beenden
         StringTrimRight, qc_varResults, qc_AllResultsBox, 1
         qc_GUI =
         gosub, qc_sub_ResultOK
      }

      ; Wenn kein Verzeichnis gefunden, dann Suchfenster wieder aufrufen
      if qc_NumDirs = 0
      {
         Gui,9:Destroy                    ; Fenster beenden
         WinActivate, ahk_id %qc_TargetWindowID%
         qc_GUI =
         qc_ErrorMsg = %lng_qc_SucheERR%   ; Fehlermeldung setzen
         Gosub, qc_main_QuickChangeDir     ; Suchfenster wieder aufrufen
      }

   }
   Else
   {
      Gui, 8:Destroy ; Eingabefenster beenden
      qc_path = %qc_FindString%                  ; Pfad setzen
      gosub, qc_sub_ChangeDir                    ; Unterroutine um Pfad zu ffnen oder zu wechseln
      qc_ctrlState =                             ; Status der Strg-Taste zurcksetzen
      qc_GUI =
   }
Return

; ---------------------------------------------------------------------
qc_sub_IndexingMenu:    ;    Indizierung von der Ergebnisliste aufrufen
   CoordMode, Menu, Relative
   Menu, QuickChangeDir_Menu, Show
Return

qc_sub_SearchTheList:
   GuiControlGet, qc_SearchTheList, 9:
   GuiControl, 9:+Altsubmit, qc_varResults
   GuiControlGet, qc_varResults, 9:
   GuiControl, 9:-Altsubmit, qc_varResults
   If (StrLen(qc_SearchTheList) < 2)
      qc_varResults = 0
   Loop, Parse, qc_AllResults, `n
   {
      If ( A_Index < qc_varResults)
         continue

      IfInString, A_LoopField, %qc_SearchTheList%
      {
         GuiControl, 9:ChooseString, qc_varResults, %A_LoopField%
         Gosub, qc_sub_ResultList
         break
      }
   }
Return

qc_sub_SearchTheListNext:
   GuiControlGet, qc_SearchTheList, 9:
   GuiControl, 9:+Altsubmit, qc_varResults
   GuiControlGet, qc_varResults
   GuiControl, 9:-Altsubmit, qc_varResults
   Loop, Parse, qc_AllResults, `n
   {
      If A_LoopField =
         continue

      If ( A_Index <= qc_varResults )
         continue

      IfInString, A_LoopField, %qc_SearchTheList%
      {
         GuiControl, 9:ChooseString, qc_varResults, %A_LoopField%
         Gosub, qc_sub_ResultList
         break
      }
   }
Return

qc_sub_SearchTheListPrevious:
   GuiControlGet, qc_SearchTheList, 9:
   GuiControl, 9:+Altsubmit, qc_varResults
   GuiControlGet, qc_varResults
   GuiControl, 9:-Altsubmit, qc_varResults
   test := qc_varResults - 1 "`n"
   Loop, Parse, qc_AllResultsRevers, `n
   {
      If A_LoopField =
         continue
      If ( qc_NumDirs - A_Index >= qc_varResults - 1)
         continue

      IfInString, A_LoopField, %qc_SearchTheList%
      {
         GuiControl, 9:ChooseString, qc_varResults, %A_LoopField%
         Gosub, qc_sub_ResultList
         break
      }
   }
Return


qc_func_Edit1Keys:
   qc_Key = %#wParam%
   If A_GuiControl <> qc_SearchTheList
      return

   GetKeyState, qc_CtrlStateTmp, Ctrl
   If qc_CtrlStateTmp = D
      qc_Key := qc_Key + 1000
   GetKeyState, qc_ShiftState, Shift
   If qc_ShiftState = D
      qc_Key := qc_Key + 2000
   GetKeyState, qc_AltState, Alt
   If qc_AltState = D
      qc_Key := qc_Key + 4000

   If qc_Key = 33
   {
      ControlSend,ListBox1,{PgUp}, A
      #Return = 0
   }
   If qc_Key = 34
   {
      ControlSend,ListBox1,{PgDn}, A
      #Return = 0
   }
   If qc_Key = 1035
   {
      ControlSend,ListBox1,{End}, A
      #Return = 0
   }
   If qc_Key = 1036
   {
      ControlSend,ListBox1,{Home}, A
      #Return = 0
   }
   If qc_Key = 40
   {
      ControlSend,ListBox1,{Down}, A
      #Return = 0
   }
   If qc_Key = 38
   {
      ControlSend,ListBox1,{Up}, A
      #Return = 0
   }

   If qc_Key = 1040
   {
      Gosub, qc_sub_SearchTheListNext
      #Return = 0
   }
   If qc_Key = 1038
   {
      Gosub, qc_sub_SearchTheListPrevious
      #Return = 0
   }
   If qc_Key = 1008
   {
      Send,+^{Left}{Del}
      #Return = 0
   }
Return

; ---------------------------------------------------------------------
9GuiSize: ;    Fenstergren-berwachung
; sorgt dafr, dass beim Vergrern des Sucherergebnisfensters die Schaltflchen
; und die Ergebnisliste mit angepasst werden
   Critical

   wingetpos qc_newWinX,qc_newWinY,qc_newWinW,qc_newWinH, ahk_id %qc_GuiWinID% ; Fenstermae ermitteln
   if qc_newWinW < %qc_MinW%                                            ; Breitenlimit unterschritten ...
      WinMove, ahk_id %qc_GuiWinID%,,,,%qc_MinW%                                  ; ... dann auf Minimalbreite setzen
   if qc_newWinH < %qc_MinH%                                            ; Hhenlimit unterschritten ...
      WinMove, ahk_id %qc_GuiWinID%,,,,,%qc_MinH%                                 ; ... dann auf Minimalhhe setzen

   wingetpos qc_newWinX,qc_newWinY,qc_newWinW,qc_newWinH, ahk_id %qc_GuiWinID% ; nochmals Fenstermae ermitteln

   qc_TitleH := CaptionHeight+BorderHeight*2

   ; Differenz des vernderten Fensters zu der Originalgre errechnen
   qc_DiffH := qc_newWinH-qc_TitleH-qc_WinH

   qc_DiffW := qc_newWinW-BorderHeight*2-qc_WinW

   if (qc_DiffW = qc_lastDiffW AND qc_DiffH = qc_lastDiffH)
      return

   qc_lastDiffW = %qc_DiffW%
   qc_lastDiffH = %qc_DiffH%

   ; Neue Positionen und Gren berechnen
   qc_newListW    :=  qc_ListW+qc_DiffW
   qc_newListH    :=  qc_ListH+qc_DiffH
   qc_newEditY    :=  qc_EditY+qc_DiffH
   qc_newButtonY  :=  qc_ButtonY+qc_DiffH
   qc_newButton2X :=  qc_Button2X+qc_DiffW
   qc_newButton3X :=  qc_Button3X+qc_DiffW
   qc_newButton4X :=  qc_Button4X+qc_DiffW
   qc_newButton5X :=  qc_Button5X+qc_DiffW

   ; Fensterelemente anpassen
   GuiControl, 9:move, Edit1,                                      w%qc_newListW%
   GuiControl, 9:move, ListBox1,                  y%qc_ListY%      w%qc_newListW% h%qc_newListH%
   GuiControl, 9:move, Edit2,                     y%qc_newEditY%   w%qc_newListW%
   GuiControl, 9:move, Button1,                   y%qc_newButtonY%
   GuiControl, 9:move, Button2, x%qc_newButton2X% y%qc_newButtonY%
   GuiControl, 9:move, Button3, x%qc_newButton3X% y%qc_newButtonY%
   GuiControl, 9:move, Button4, x%qc_newButton4X% y%qc_newButtonY%
   GuiControl, 9:move, Button5, x%qc_newButton5X% y%qc_newButtonY%

   SetTimer, qc_tim_SizeSaveChanges, 5

   Gosub, qc_tim_WatchWindows
Return

qc_tim_SizeSaveChanges:
   SetTimer, qc_tim_SizeSaveChanges, Off
   IniWrite, %qc_newWinW%, %ConfigFile_QuickChangeDir%, Window, ResultWindowWidth
   IniWrite, %qc_newWinH%, %ConfigFile_QuickChangeDir%, Window, ResultWindowHeight
Return

; ---------------------------------------------------------------------
qc_sub_ResultOK: ;    Verzeichnis wechseln (OK-Schaltflche)
   SetTimer, qc_tim_WatchWindows, Off
   if qc_NumDirs > 1
   {
      wingetpos qc_newWinX,qc_newWinY,,, %qc_Titel% ; nochmals Fenstermae ermitteln
      IniWrite, x%qc_newWinX%, %ConfigFile_QuickChangeDir%, Window, ResultWindowX
      IniWrite, y%qc_newWinY%, %ConfigFile_QuickChangeDir%, Window, ResultWindowY
      SetTimer, qc_tim_WatchWindows, Off
      Gui, 9:Submit
      Gui, 9:Destroy
      WinActivate, ahk_id %qc_TargetWindowID%
   }

   func_RemoveMessage(0x100,"qc_func_Edit1Keys")
   qc_GUI =

   IfExist,%qc_varResults% ; nur wechslen wenn Verzeichnis existiert
   {
      If qc_ctrlState =
         GetKeyState, qc_ctrlState, Ctrl ; Status der Strg-Taste ermitteln
      If qc_ctrlState = U
         qc_ctrlState =

      IniWrite, %qc_varResults%, %ConfigFile_QuickChangeDir%, Favourites, % func_Hex(func_StrLower(qc_FindString))
      qc_path = %qc_varResults%
      gosub, qc_sub_ChangeDir
      qc_ctrlState =
   }
   Else
      BalloonTip(qc_ScriptName " v" qc_ScriptVersion, lng_FolderDoesNotExist "`n" qc_varResults, "Info")
return

; ---------------------------------------------------------------------
qc_sub_ResultOK2: ;    neues Explorer-Fenster (Explorer-Schaltflche)
   qc_GUI =
   qc_ctrlState = D   ; gedrckte Strg-Taste vortuschen
   gosub, qc_sub_ResultOK
Return

; ---------------------------------------------------------------------
qc_sub_ResultOK3: ;    DOS-Fenster
   SetTimer, qc_tim_WatchWindows, Off
   wingetpos qc_newWinX,qc_newWinY,,, %qc_Titel% ; nochmals Fenstermae ermitteln
   IniWrite, x%qc_newWinX%, %ConfigFile_QuickChangeDir%, Window, ResultWindowX
   IniWrite, y%qc_newWinY%, %ConfigFile_QuickChangeDir%, Window, ResultWindowY

   Gui, 9:Submit
   Gui, 9:Destroy
   WinActivate, ahk_id %qc_TargetWindowID%
   func_RemoveMessage(0x100,"qc_func_Edit1Keys")
   qc_GUI =

   IfExist,%qc_varResults% ; nur wechseln wenn Verzeichnis existiert
   {
      StringSplit,splittedpath,qc_varResults,:,,
      Run, %comspec% /K %splittedpath1%: && cd "%splittedpath2%"
      qc_ctrlState =
   }
Return

; ---------------------------------------------------------------------
9GuiEscape: ;    Abbrechen/ESC beider Fenster (Eingabe und Ergebnisfenster)
9GuiClose:  ;    Abbrechen/ESC beider Fenster (Eingabe und Ergebnisfenster)
   SetTimer, qc_tim_WatchWindows, Off
   qc_GUI =
   wingetpos qc_newWinX,qc_newWinY,,, %qc_Titel% ; nochmals Fenstermae ermitteln
   IniWrite, x%qc_newWinX%, %ConfigFile_QuickChangeDir%, Window, ResultWindowX
   IniWrite, y%qc_newWinY%, %ConfigFile_QuickChangeDir%, Window, ResultWindowY
   Gui, 9:Destroy            ; Fenster schlieen
   If qc_DoDocking = 1
      IfWinNotActive, ahk_id %qc_TargetWindowID%
         WinActivate, ahk_id %qc_TargetWindowID%
Return

; ---------------------------------------------------------------------
qc_sub_ResultList: ;    Klick auf Ergebnisliste

   ; Statuszeile mit dem Namen ohne Pfad setzen
   GuiControlGet, qc_ListLine,9:,qc_varResults
   SplitPath,qc_ListLine,qc_FName,qc_FDir
   GuiControl, 9:,StatusBar,%qc_FName%

   GuiControl, 9:Focus, qc_SearchTheList

   ; Bei Doppelklick "neues Fenster" ausfhren
   if A_GuiControlEvent = DoubleClick
      gosub, qc_sub_ResultOK
return

; Kontextmen der Ergebnisliste
9GuiContextMenu: ; HotkeyDef
   IfWinActive, %qc_Titel%    ; nur wenn Fenster aktiv
   {
      MouseGetPos,,,,qc_MouseControl  ; Control unter Maus ermitteln
      if qc_MouseControl = ListBox1   ; Wenn Control Ergebnisliste ...
      {
         ; ... dann Kontextmen aufbauen
         Send, {LButton} ; An Mauspositoin einen Klick ausfhren, damit die Zeile markiert wird
         Menu, context, add, %lng_qc_NeuesFenster%, qc_sub_ResultOK
         Menu, context, add, %lng_qc_VerzWechseln%, qc_sub_ResultOK2
         Menu, context, add, %lng_qc_DosBox%, qc_sub_ResultOK3
         Menu, context, add
         Menu, context, add, %lng_qc_AusIndexEntf%, qc_menu_DeleteEntry
         Menu, context, add, %lng_qc_berVerzHinzu%, qc_sub_AddParent
         Menu, context, show
         Menu, context, DeleteAll
      }
    }
Return

; ---------------------------------------------------------------------
qc_menu_DeleteEntry: ;    Menpunkt Eintrag aus der Verzeichnisindex entfernen

   GuiControlGet, qc_ListLine,9:,qc_varResults ; aktuelle Zeile ermitteln
   gosub, qc_sub_DeleteEntry
Return

; ---------------------------------------------------------------------
qc_sub_AddParent: ;    Menpunkt berverzeichnis zur Liste hinzufgen

   GuiControlGet, qc_ListLine,9:,qc_varResults
   SplitPath, qc_ListLine,,qc_ListLine
   GuiControl, 9:Choose, qc_varResults, 1
   GuiControl, 9:ChooseString, qc_varResults, %qc_ListLine%
   GuiControlGet, SelLine,9:,qc_varResults
   if qc_ListLine  <> %SelLine%
      GuiControl,9:, qc_varResults, %qc_ListLine%
   GuiControl, 9:ChooseString, qc_varResults, %qc_ListLine%
   WinActivate, %qc_Titel%
Return

; ---------------------------------------------------------------------
qc_sub_DeleteEntry: ;    Unterroutine fr Eintrag aus der Verzeichnisindex entfernen

   ; Schaltflchen deaktivieren
   GuiControl, 9:Disable, Button1
   GuiControl, 9:Disable, Button2
   GuiControl, 9:Disable, Button3
   GuiControl, 9:Disable, Button4
   GuiControl, 9:Disable, ListBox1

   qc_ActDrive := qc_func_GetDrive( qc_ListLine ) ; Laufwerksbuchstabe des ausgewhlten Pfads
   if qc_IndexPath =
   {
      qc_IndexPathDrv := qc_func_GetDrive( qc_ListLine, "RealPath" )
      qc_IndexTemp = %qc_IndexPathDrv%%qc_IndexFileRoot%_tmp.dat ; Temporrer Index
      qc_IndexDest = %qc_IndexPathDrv%%qc_IndexFileRoot%.dat ; Verzeichnisindex
   }
   Else
   {
      qc_IndexTemp = %qc_IndexPath%\%qc_IndexFile%%qc_ActDrive%_tmp.dat ; Temporrer Index
      qc_IndexDest = %qc_IndexPath%\%qc_IndexFile%%qc_ActDrive%.dat ; Verzeichnisindex
   }
   GuiControl,9:+AltSubmit,qc_varResults ; ... damit nicht der Name, sondern die ListenNr ermittelt wird

   Loop, Read, %qc_IndexDest%   ; Verzeichnisindex laden
   {
      StringLen,qc_Len,qc_ListLine                       ; Lnge des ausgewhlten Pfads
      StringLeft, qc_MatchLine, A_LoopReadLine, %qc_Len% ; geladener Eintrag aus Verzeichnisindex krzen

      If qc_MatchLine <> %qc_ListLine%                   ; Wenn ausgewhlter Pfad <> geladener Eintrag
      {
         FileAppend, %A_LoopReadLine%`n, %qc_IndexTemp%   ; ... wieder in Verzeichnisindex schreiben
      }
      else                                                 ; ... sonst nicht schreiben ...
      {
         GuiControl,9:ChooseString,qc_varResults, %A_LoopReadLine% ; Eintrag in Ergebnisliste auswhlen
         GuiControlGet,qc_ListN,9:,qc_varResults                  ; ListenNr ermitteln
         Control, Delete, %qc_ListN%, ListBox1, %qc_Titel%      ; Eintrag lschen
      }
   }
   GuiControl,9:-AltSubmit,qc_varResults         ; ... damit wieder der Name von Listenelementen ermittelt wird
   FileMove, %qc_IndexTemp%, %qc_IndexDest%,1 ; Verzeichnisindex durch temporren Index ersetzen

   ; Schaltflche wieder aktivieren
   GuiControl, 9:Enable, Button1
   GuiControl, 9:Enable, Button2
   GuiControl, 9:Enable, Button3
   GuiControl, 9:Enable, Button4
   GuiControl, 9:Enable, ListBox1
   GuiControl, 9:Focus , ListBox1
Return


; ---------------------------------------------------------------------
; -- Laufwerke indizieren ---------------------------------------------
; ---------------------------------------------------------------------
qc_sub_IndexDrives: ; Laufwerke indizieren
   DetectHiddenwindows,On
   SetTitleMatchMode, 2
   IfWinExist, ac'tivAid_QuickChangeDir Indexer.
      return

   IfInString, qc_selectedDrives, %A_Space%
      qc_selectedDrives = "%qc_selectedDrives%"

   If A_IsCompiled = 1
   {
      IfExist %A_ScriptDir%\extensions\ac'tivAid_QuickChangeDir Indexer.exe
         Run, "%A_ScriptDir%\extensions\ac'tivAid_QuickChangeDir Indexer.exe" %qc_selectedDrives%%qc_tmpNoBallon%, %A_WorkingDir%
      Else IfExist %A_AhkPath%
         IfExist %A_ScriptDir%\extensions\ac'tivAid_QuickChangeDir Indexer.ahk
            Run, %A_AhkPath% "%A_ScriptDir%\extensions\ac'tivAid_QuickChangeDir Indexer.ahk" %qc_selectedDrives%%qc_tmpNoBallon%, %A_WorkingDir%
         Else
            BalloonTip(ScriptTitle " - " qc_ScriptName, lng_qc_NoIndexer ,"Error")
      Else
         BalloonTip(ScriptTitle " - " qc_ScriptName, lng_qc_NoIndexer ,"Error")
   }
   Else
   {
      IfExist %A_ScriptDir%\extensions\ac'tivAid_QuickChangeDir Indexer.ahk
         Run, %A_AhkPath% "%A_ScriptDir%\extensions\ac'tivAid_QuickChangeDir Indexer.ahk" %qc_selectedDrives%%qc_tmpNoBallon%, %A_WorkingDir%
      Else
         BalloonTip(ScriptTitle " - " qc_ScriptName, lng_qc_NoIndexer ,"Error")
   }
   Sleep,100
   qc_LastTimeIndexed := A_Now
   IniWrite, %qc_LastTimeIndexed% , %ConfigFile_QuickChangeDir%, Schedule, LastTimeIndexed
   qc_tmpNoBallon =
Return

; ---------------------------------------------------------------------
qc_submenu_IndexDrives: ; Laufwerke indizieren:Aufruf vom Untermen
   if A_ThisMenuItem = %lng_qc_AktualisierenAlle%
   {
      qc_selectedDrives =
   }
   else
   {
      StringReplace, qc_GetDriveLtr, lng_qc_AktualisierenEinzeln, ###,,
      StringReplace, qc_selectedDrives, A_ThisMenuItem, %qc_GetDriveLtr%,
      StringTrimRight, qc_selectedDrives, qc_selectedDrives, 1
   }
   gosub, qc_sub_IndexDrives
Return


; ---------------------------------------------------------------------
; -- Unterroutine fr den Verzeichniswechsel --------------------------
; ---------------------------------------------------------------------
qc_sub_ChangeDir: ; Unterroutine fr den Verzeichniswechsel
   Sleep,50

   If qc_ctrlState =
      qc_NewWindow = -1
   Else
      qc_NewWindow = 1

   func_ChangeDir(qc_Path,qc_NewWindow,qc_FolderTree)
Return

qc_tim_AutoIndexing:
   Critical
   DetectHiddenwindows,On
   SetTitleMatchMode, 2
   IfWinExist, ac'tivAid_QuickChangeDir Indexer
      return

   If qc_AutoIndexingSpace = 1
   {
      Loop, Parse, qc_PathsToIndex, `,
      {
         If A_LoopField =
            break
         qc_ActDrive := qc_func_GetDrive( A_LoopField ) ; Aktuelles Laufwerk
         IniRead, qc_DriveSpace, %ConfigFile_QuickChangeDir%, Drives, %qc_ActDrive%, -1
         DriveSpaceFree, qc_actSpace, % qc_func_GetDrive( A_LoopField, "RealPath" )
         If (qc_actSpace <> qc_LastActSpace_%qc_ActDrive%)
         {
            qc_LastActSpace_%qc_ActDrive% := qc_actSpace
            continue
         }
         qc_LastActSpace_%qc_ActDrive% := qc_actSpace

         If (qc_actSpace > qc_DriveSpace)
            qc_Diff := qc_actSpace-qc_DriveSpace
         Else
            qc_Diff := qc_DriveSpace-qc_actSpace

         If (qc_Diff > qc_AutoIndexThreshold OR qc_DriveSpace = "ERROR" )
         {
            qc_selectedDrives = % qc_func_GetDrive( A_LoopField, "RealPath" )
            IniWrite, %qc_actSpace%, %ConfigFile_QuickChangeDir%, Drives, %qc_ActDrive%
            qc_tmpNoBallon := " NoBalloonTips"

            Gosub, qc_sub_IndexDrives
            break
         }
      }
   }
   qc_Next =
   If qc_AutoIndexingTime = 1
   {
      If (qc_NextIndexing < qc_LastTimeIndexed AND qc_AutoIndexingTimeFailure = 1)
      {
         qc_selectedDrives =
         Gosub, qc_sub_IndexDrives
         qc_Next = 2
      }
      StringSplit, qc_Time, qc_IndexTimeValues, `,
      Loop, %qc_Time0%
      {
         StringReplace, qc_Time, qc_Time%A_Index%, :,
         qc_Now := A_Hour A_Min A_Sec
         If (qc_Next = 2 AND qc_Now < qc_Time)
         {
            qc_NextIndexing := A_YYYY A_MM A_DD qc_Time
            IniWrite, %qc_NextIndexing%, %ConfigFile_QuickChangeDir%, Schedule, NextIndexing
            qc_Next =
            break
         }
         If (qc_Now = qc_Time)
         {
            qc_selectedDrives =
            Gosub, qc_sub_IndexDrives
            qc_Next = 1
         }
         If qc_Next = 1
         {
            qc_NextIndexing := A_YYYY A_MM A_DD qc_Time
            IniWrite, %qc_NextIndexing%, %ConfigFile_QuickChangeDir%, Schedule, NextIndexing
            qc_Next =
            break
         }
      }
      If qc_Next <>
      {
         qc_NextIndexing := A_YYYY A_MM A_DD qc_Time
         EnvAdd, qc_NextIndexing, 1, Days
         qc_NextIndexing := func_StrLeft(qc_NextIndexing, 12)
         IniWrite, %qc_NextIndexing%, %ConfigFile_QuickChangeDir%, Schedule, NextIndexing
         qc_Next =
      }
   }
   If qc_AutoIndexingInterval = 1
   {
      StringSplit, qc_Time, qc_IndexInterval, :,
      qc_Time := qc_Time1*60+qc_Time2
      qc_Diff := A_Now
      EnvSub, qc_Diff, qc_LastTimeIndexed , Min
      If ( qc_Diff >= qc_Time)
      {
         qc_selectedDrives =
         Gosub, qc_sub_IndexDrives
      }
   }

Return

qc_func_GetDrive( Path, RealPath = "" )
{
   StringLeft, Drive, Path, 1
   If Drive = \
   {
      StringSplit, Path, Path, \
      If RealPath = RealPath
         Drive = \\%Path3%\%Path4%\
      Else
         Drive := func_StrTranslate(Path3 "#" Path4, "-+ !&()'", "______[]_")
   }
   Else If RealPath = RealPath
      Drive = %Drive%:\

   Return %Drive%
}
