; -----------------------------------------------------------------------------
; #############################################################################
; -----------------------------------------------------------------------------
; Name:               UserHotkeys
; -----------------------------------------------------------------------------
; Prefix:             uh_
; Version:            1.3
; Date:               2006-05-31
; Author:             Wolfgang Reszel fr c't
; Bugfixing:          Stephan Noy
; Additions:          Robert Deimel
; Copyright:          2006 Heise Zeitschriften Verlag GmbH & Co. KG
; -----------------------------------------------------------------------------

; -----------------------------------------------------------------------------
; === Initialisation ==========================================================
; -----------------------------------------------------------------------------

init_UserHotkeys:
   Prefix = uh
   %Prefix%_ScriptName     = UserHotkeys
   %Prefix%_ScriptVersion  = 1.2
   %Prefix%_Author         = Wolfgang Reszel, Stephan Noy, Robert Deimel
   AddSettings_UserHotkeys = 1

   if Lng = 07  ; = Deutsch (0407, 0807, 0c07 ...)
   {
      MenuName                      = %uh_ScriptName% - Benutzerdefinierte Tastaturkrzel
      Description                   = Frei belegbare Tastaturkrzel. Sie lassen sich mit Programmen, Skripten, Verzeichnissen, URLs und einigen Spezialbefehlen, wie die Ausgabe von Text, belegen.
      lng_uh_FileTypes              = *.exe; *.cmd; *.bat; *.ahk; *.vbs; *.hlp; *.chm; *.txt; *.htm; *.html; *.txt; *.doc; *.xls; *.ppt; *.sxw; *.sxc; *.odt; *.ott; *.ods; *.ots; *.odp; *.otp
      lng_uh_Edit                   = Tastaturkrzel bearbeiten
      lng_uh_Add                    = Tastaturkrzel hinzufgen
      lng_uh_CMEdit                 = Bearbeiten`t(Doppelklick/Leertaste)
      lng_uh_CMAdd                  = Hinzufgen`t(Einfg)
      lng_uh_CMDelete               = Lschen`t(Entf)
      lng_uh_Legend                 = Folgende Spezialbefehle sind mglich:
      lng_uh_Category               = Kategorie
      lng_uh_Command                = Befehl/Beschreibung
      lng_uh_Description            = Beschreibung
      lng_uh_CategoryHotkey         = Krzel fr Kategorie-Men
      lng_uh_Application            := "Programm: "
      lng_uh_OnlyOneApplication     = Nur fr folgende Programme (ein oder mehrere Fenstertitel mit Komma getrennt ODER ahk_class FensterKlasse):
      lng_uh_ClipSave               = Zwischenablage fr <PasteFile> in Datei speichern
      lng_uh_running                = wird ausgefhrt
      lng_uh_runningError           = kann nicht ausgefhrt werden
      lng_uh_BalloonTips            = Sprechblasenhinweise
      lng_uh_Cat_Applications       = Anwendungen
      lng_uh_Cat_Snippets           = Textbausteine
      lng_uh_Cmd_Send               = TEXT
      lng_uh_Cmd_SendRaw            = reiner TEXT
      lng_uh_Cmd_Reload             = ac'tivAid neu laden
      lng_uh_Cmd_ListHotkeys        = alle AHK-Tastaturkrzel auflisten
      lng_uh_Cmd_ListLines          = die zuletzt ausgefhrten AHK-Befehle auflisten
      lng_uh_Cmd_ListVars           = alle AHK-Variablen auflisten
      lng_uh_Cmd_ExitApp            = ac'tivAid beenden
      lng_uh_Cmd_KeyHistory         = die zuletzt gedrckten Tasten auflisten
      lng_uh_Cmd_ChDir              = Verzeichniswechsel
      lng_uh_Cmd_getControl         = Name des Fensterelements unter der Maus
      lng_uh_Cmd_getColour          = Farbe des Pixels unter der Maus
      lng_uh_Cmd_getControlText     = Text unter der Maus
      lng_uh_Cmd_SingleInstance     = Ein-/Ausblenden
      lng_uh_Cmd_SingleInstanceClose= Starten/Beenden
      lng_uh_Cmd_AOT                = Immer vorne
      lng_uh_Cmd_Min                = Minimiert
      lng_uh_Cmd_Max                = Maximiert
      lng_uh_Cmd_Hide               = Versteckt
      lng_uh_Cmd_CategoryMenu       = Kategorie-Men anzeigen
      lng_uh_Cmd_PasteFile          = PasteFile

      lng_uh_Desc_Calc              = Taschenrechner
      lng_uh_Desc_Control           = Systemsteuerung

      tooltip_uh_BalloonTip         = Aus = Es werden keine Sprechblasenhinweise angezeigt`nAktiviert = Es werden nur Fehler angezeigt`nGrau/Grn = Es werden Fehler und auch das ausgefhrte Programm angezeigt
   }
   else        ; = other languages (english)
   {
      MenuName                      = %uh_ScriptName% - user-definable hotkeys
      Description                   = Assign hotkeys to programs, scripts, folders, urls and some special commands, like the typing text or getting the colour under the mouse.
      lng_uh_FileTypes              = programs/scripts (*.exe; *.cmd; *.bat; *.ahk; *.vbs)
      lng_uh_Edit                   = edit hotkey
      lng_uh_Add                    = add hotkey
      lng_uh_CMEdit                 = edit`t(Double-click/Space)
      lng_uh_CMAdd                  = add`t(Ins)
      lng_uh_CMDelete               = delete`t(Del)
      lng_uh_Legend                 = The following special commands are available:
      lng_uh_Category               = Category
      lng_uh_Command                = Command/Description
      lng_uh_Description            = Description
      lng_uh_CategoryHotkey         = Hotkey for category-menu
      lng_uh_Application            := "App: "
      lng_uh_OnlyOneApplication     = Only for the following applications (one or more window titles, comma-separated OR ahk_class WindowClass):
      lng_uh_ClipSave               = Save clipboard as file for <PasteFile>
      lng_uh_running                = is being executed
      lng_uh_runningError           = couldn't be executed
      lng_uh_BalloonTips            = BalloonTips
      lng_uh_Cat_Applications       = Application
      lng_uh_Cat_Snippets           = Snippets
      lng_uh_Cmd_Send               = Send text
      lng_uh_Cmd_SendRaw            = Send raw text
      lng_uh_Cmd_Reload             = reload ac'tivAid
      lng_uh_Cmd_ListHotkeys        = list all AHK-hotkeys
      lng_uh_Cmd_ListLines          = list last executed AHK-commands
      lng_uh_Cmd_ListVars           = list all AHK-variables
      lng_uh_Cmd_ExitApp            = quit ac'tivAid
      lng_uh_Cmd_KeyHistory         = list key-history
      lng_uh_Cmd_ChDir              = Change directory
      lng_uh_Cmd_getControl         = Control-name under the mouse-pointer
      lng_uh_Cmd_getColour          = Pixel-colour under the mouse-pointer
      lng_uh_Cmd_getControlText     = Text under the mouse-pointer
      lng_uh_Cmd_SingleInstance     = Show/hide a program
      lng_uh_Cmd_SingleInstanceClose= Start/quit a program
      lng_uh_Cmd_AOT                = Always on top
      lng_uh_Cmd_Min                = minimised
      lng_uh_Cmd_Max                = maximised
      lng_uh_Cmd_Hide               = hidden
      lng_uh_Cmd_CategoryMenu       = show category-menu
      lng_uh_Cmd_PasteFile          = PasteFile

      lng_uh_Desc_Calc              = Calculator
      lng_uh_Desc_Control           = Control panel

      tooltip_uh_BalloonTip         = Off = No BalloonTips`nActive = Show errors`nGrey/Green = Shows errors and the executed program
   }
   If CustomLanguage <>
      gosub, CustomLanguage

   IniRead, uh_NumHotkeys, %ConfigFile%, %uh_ScriptName%, NumberOfHotkeys, 16
   IniRead, uh_Sort, %ConfigFile%, %uh_ScriptName%, SortCol, %A_Space%
   IniRead, uh_BalloonTip, %ConfigFile%, %uh_ScriptName%, ShowBalloonTip, 1
   IniRead, uh_BalloonTimeOut, %ConfigFile%, %uh_ScriptName%, BalloonTimeOut, 4

   StringLeft, uh_SortCol, uh_Sort, 1
   StringTrimLeft, uh_SortDir, uh_Sort, 1
   uh_SortCol%uh_SortCol% = %uh_SortDir%

   Loop, %uh_NumHotkeys%
   {
      IniRead, uh_Path%A_Index%, %ConfigFile%, %uh_ScriptName%, Path%A_Index%
      IniRead, uh_Category%A_Index%, %ConfigFile%, %uh_ScriptName%, Category%A_Index%
      IniRead, uh_App%A_Index%, %ConfigFile%, %uh_ScriptName%, Application%A_Index%
      IniRead, uh_Description%A_Index%, %ConfigFile%, %uh_ScriptName%, Description%A_Index%
      If uh_App%A_Index% = ERROR
         uh_App%A_Index% =
      If uh_Category%A_Index% = ERROR
         uh_Category%A_Index% =
      If uh_Description%A_Index% = ERROR
         uh_Description%A_Index% =
      if (uh_Path%A_Index% = "ERROR" AND A_Index = 1)
      {
         uh_Path%A_Index% = 320MPH New.ahk
         uh_DefHotkey = $^+Space
         uh_Category%A_Index% = %lng_uh_Cat_Applications%
         uh_Description%A_Index% = 320MPH
      }
      if (uh_Path%A_Index% = "ERROR" AND A_Index = 2)
      {
         uh_Path%A_Index% = <SingleInstanceClose>regedit.exe
         uh_DefHotkey = $#+F12
         uh_Category%A_Index% = %lng_uh_Cat_Applications%
         uh_Description%A_Index% = RegEdit
      }
      if (uh_Path%A_Index% = "ERROR" AND A_Index = 3)
      {
         uh_Path%A_Index% = Control
         uh_DefHotkey = $#c
         uh_Description%A_Index% = %lng_uh_Desc_Control%
      }
      if (uh_Path%A_Index% = "ERROR" AND A_Index = 4)
      {
         uh_Path%A_Index% = Properties C:\
         uh_DefHotkey = $#^!c
      }
      if (uh_Path%A_Index% = "ERROR" AND A_Index = 5)
      {
         uh_Path%A_Index% = <SingleInstanceClose><AOT>calc.exe
         uh_DefHotkey = $##
         uh_Category%A_Index% = %lng_uh_Cat_Applications%
         uh_Description%A_Index% = %lng_uh_Desc_Calc%
      }
      if (uh_Path%A_Index% = "ERROR" AND A_Index = 6)
      {
         uh_Path%A_Index% = <send>
         uh_DefHotkey = $!-
         uh_Category%A_Index% = %lng_uh_Cat_Snippets%
      }
      if (uh_Path%A_Index% = "ERROR" AND A_Index = 7)
      {
         uh_Path%A_Index% = <send>
         uh_DefHotkey = $^!-
         uh_Category%A_Index% = %lng_uh_Cat_Snippets%
      }
      if (uh_Path%A_Index% = "ERROR" AND A_Index = 8)
      {
         uh_Path%A_Index% = <send>
         uh_DefHotkey = $!+-
         uh_Category%A_Index% = %lng_uh_Cat_Snippets%
      }
      if (uh_Path%A_Index% = "ERROR" AND A_Index = 9)
      {
         uh_Path%A_Index% = <send>
         uh_DefHotkey = $^!.
         uh_Category%A_Index% = %lng_uh_Cat_Snippets%
      }
      if (uh_Path%A_Index% = "ERROR" AND A_Index = 10)
      {
         uh_Path%A_Index% = <send><a href="`%Selection`%"></a>{Left 4}
         uh_DefHotkey = $#!l
         uh_Category%A_Index% = %lng_uh_Cat_Snippets%
      }
      if (uh_Path%A_Index% = "ERROR" AND A_Index = 11)
      {
         uh_Path%A_Index% = <send>`%A_DD`%.`%A_MM`%.`%A_YYYY`% - `%A_Hour`%:`%A_Min`%
         uh_DefHotkey = $#+d
         uh_Category%A_Index% = %lng_uh_Cat_Snippets%
      }
      if (uh_Path%A_Index% = "ERROR" AND A_Index = 12)
      {
         uh_Path%A_Index% = <getControl>
         uh_DefHotkey = $#^
      }
      if (uh_Path%A_Index% = "ERROR" AND A_Index = 13)
      {
         uh_Path%A_Index% = <getColour><RGB>
         uh_DefHotkey = $#.
      }
      if (uh_Path%A_Index% = "ERROR" AND A_Index = 14)
      {
         uh_Path%A_Index% = <getControlText>
         uh_DefHotkey = $#^c
      }
      if (uh_Path%A_Index% = "ERROR" AND A_Index = 15)
      {
         uh_Path%A_Index% = <CategoryMenu>
         uh_DefHotkey = $#+a
         uh_Category%A_Index% = %lng_uh_Cat_Applications%
      }
      if (uh_Path%A_Index% = "ERROR" AND A_Index = 16)
      {
         uh_Path%A_Index% = <CategoryMenu>
         uh_DefHotkey = $#+s
         uh_Category%A_Index% = %lng_uh_Cat_Snippets%
      }
      if uh_Path%A_Index% = ERROR
         uh_Path%A_Index% =

      If uh_Path%A_Index% <> ""
         func_HotkeyRead( "uh_Hotkey" A_Index, ConfigFile, uh_ScriptName, "Hotkey" A_Index, "sub_Hotkey_UserHotkey", uh_DefHotkey, "$" )
      uh_DefHotkey =
   }

   uh_NumHotkeys_new = %uh_NumHotkeys%
   uh_SpecialCommands = <PasteFile>,<Send>,<SendRaw>,<ControlSend>,<Reload>,<ListHotkeys>,<ListLines>,<ListVars>,<ExitApp>,<KeyHistory>,<ChDir>,<getControl>,<getColour>,<getControlText>,<SingleInstance>,<SingleInstanceClose>,<AOT>,<Min>,<Max>,<Hide>,<CategoryMenu>
   StringReplace, uh_LegendItems, uh_SpecialCommands, `, , %A_Space%, a
   uh_LegendItems= %uh_LegendItems%`n`%Selection`%

   uh_AlphaNums := "1234567890ABCDEFGHIJKLMNOPQRSTUVWXYZ"
Return

SettingsGui_UserHotkeys:
   uh_Categories = |
   uh_Apps =
   Gui, Add, Text, xs+10 y+2 w50, %lng_uh_Category%:
   Gui, Add, DropDownList, x+5 yp-3 w160 vuh_CategoryFilter guh_sub_CategoryFilter, %uh_Categories%

   Gui, Add, Text, xs+235 yp+3 w130 Hidden, %lng_uh_CategoryHotkey%:
   func_HotkeyAddGuiControl( "", "uh_CatHotkey", "X+5 YP-3 w190 Hidden guh_sub_CatHotkey")

   Gui, Add, ListView, Count%uh_NumHotkeys% AltSubmit -Multi -LV0x10 Grid xs+10 y+5 r16 w550 vuh_ListView guh_sub_ListView, Hk|%lng_Hotkey%|%lng_uh_Command%|%lng_uh_Category%|Cmd|#|App

   GuiControl, -Redraw, uh_ListView
   Loop, %uh_NumHotkeys%
   {
      If A_IsCompiled = 1
         StringReplace, uh_Path%A_Index%, uh_Path%A_Index%, .ahk, .exe

      uh_Path%A_Index%_new := uh_Path%A_Index%
      uh_Category%A_Index%_new := uh_Category%A_Index%
      uh_App%A_Index%_new := uh_App%A_Index%
      If uh_Description%A_Index% =
         uh_Description%A_Index%_new := uh_func_ShortenPath(uh_Path%A_Index%)
      Else
         uh_Description%A_Index%_new := uh_Description%A_Index%
      LV_Add("", Hotkey_uh_Hotkey%A_Index%_new, func_HotkeyDecompose(Hotkey_uh_Hotkey%A_Index%_new,0), uh_Description%A_Index%_new, uh_Category%A_Index%_new, uh_Path%A_Index%_new, A_Index, uh_App%A_Index%_new)

      If uh_Category%A_Index%_new <>
      {
         IfNotInstring, uh_Category%A_Index%_new, % lng_uh_Application
         {
            StringReplace, uh_Categories, uh_Categories, % uh_Category%A_Index%_new "|", , All
            uh_Categories := uh_Categories uh_Category%A_Index%_new "|"
         }
      }
      If uh_App%A_Index%_new <>
      {
         StringReplace, uh_Apps, uh_Apps, % lng_uh_Application uh_App%A_Index%_new "|", , All
         uh_Apps := uh_Apps lng_uh_Application uh_App%A_Index%_new "|"
      }

      func_CreateListOfHotkeys( Hotkey_uh_Hotkey%A_Index%_new, uh_Path%A_Index%_new, "UserHotkeys" )
   }

   LV_ModifyCol(1,0)
   LV_ModifyCol(2,150)
   LV_ModifyCol(3,280)
   LV_ModifyCol(4,99)
   LV_ModifyCol(5,0)
   LV_ModifyCol(6,0)
   LV_ModifyCol(7,0)
   LV_Modify(1, "Focus")
   GuiControl, +Redraw, uh_ListView

   Gui, Add, Button, -Wrap xs+365 ys+290 w25 h15 guh_sub_AddHotkey, +
   Gui, Add, Button, -Wrap x+5 h15 w25 guh_sub_DelHotkey, %MinusString%
   Gui, Add, Button, -Wrap x+5 h15 w135 guh_sub_EditHotkey, %lng_uh_Edit%

   GuiControl, , uh_CategoryFilter, |%uh_Categories%%uh_Apps%
   GuiControl, Choose, uh_CategoryFilter, 1

   uh_EditTitle = %lng_uh_Edit%

   Gui, Add, CheckBox, gsub_CheckIfSettingsChanged vuh_BalloonTip Check3 xs+220 ys+290 -Wrap Checked%uh_BalloonTip%, %lng_uh_BalloonTips%
Return

uh_sub_CategoryFilter:
   Critical
   Gui, 1:Default
   Gui, ListView, uh_ListView

   GuiControlGet, uh_CategoryFilter
   uh_CategoryFilterOrg = %uh_CategoryFilter%
   StringReplace, uh_CategoryFilter, uh_CategoryFilter, %lng_uh_Application%,,

   If uh_CategoryFilter =
   {
      GuiControl, Hide, %lng_uh_CategoryHotkey%:
      GuiControl, Hide, Hotkey_uh_CatHotkey
   }
   Else
   {
      GuiControl, Show, %lng_uh_CategoryHotkey%:
      GuiControl, Show, Hotkey_uh_CatHotkey
      GuiControl,, Hotkey_uh_CatHotkey,
      uh_CatHotkeyNum =
   }

   GuiControl, -Redraw, uh_ListView
   LV_Delete()
   Loop, %uh_numHotkeys_new%
   {
      If (uh_Category%A_Index%_new = uh_CategoryFilterOrg OR uh_Category%A_Index%_new = uh_CategoryFilter OR uh_CategoryFilter = "" OR uh_App%A_Index%_new = uh_CategoryFilter)
      {
         If uh_Description%A_Index%_new =
            uh_Description%A_Index%_new := uh_func_LocalizedCommand(uh_Path%A_Index%_new)

         If ((uh_Path%A_Index%_new <> "<CategoryMenu>" AND uh_Path%A_Index%_new <> "<CategoryMenu> ") OR uh_CategoryFilter = "")
            LV_Add("", Hotkey_uh_Hotkey%A_Index%_new, func_HotkeyDecompose(Hotkey_uh_Hotkey%A_Index%_new,0), uh_Description%A_Index%_new, uh_Category%A_Index%_new, uh_Path%A_Index%_new, A_Index, uh_App%A_Index%_new)
         Else
         {
            uh_CatHotkeyNum := A_Index
            GuiControl,, Hotkey_uh_CatHotkey, % func_HotkeyDecompose(Hotkey_uh_Hotkey%A_Index%_new)
         }
      }
   }

   LV_ModifyCol(1,0)
   LV_ModifyCol(2,150)
   LV_ModifyCol(3,280)
   LV_ModifyCol(4,99)
   LV_ModifyCol(5,0)
   LV_ModifyCol(6,0)
   LV_ModifyCol(7,0)

   ;LV_ModifyCol(uh_SortCol, uh_SortCol%uh_SortCol%)

   LV_Modify(1, "Select")
   GuiControl, +Redraw, uh_ListView
Return

uh_sub_CatHotkey:
   Gosub, sub_HotkeyButton
   If uh_CatHotkeyNum =
   {
      uh_NumHotKeys_new++
      uh_CatHotkeyNum = %uh_NumHotKeys_new%
      uh_Category%uh_CatHotkeyNum%_new = %uh_CategoryFilterOrg%
      uh_Path%uh_CatHotkeyNum%_new = <CategoryMenu>
   }
   Hotkey_uh_Hotkey%uh_CatHotkeyNum%_new := Hotkey_uh_CatHotkey_new
Return

uh_sub_ListView:
   Gui, 1:Default
   Gui, ListView, uh_ListView
   StringCaseSense, On
   If A_GuiEvent = s
      GuiControl, +Redraw, uh_ListView

   If A_GuiEvent in I,C,E,F,f,M,S,s
      Return

   uh_LVrow := LV_GetNext()

   If A_GuiEvent in Normal,D,d
   {
      GuiControlGet, uh_temp, FocusV
      if uh_temp <> uh_ListView
         GuiControl, Focus, uh_ListView
      Return
   }

   StringCaseSense, Off

   LV_GetText(uh_RowText, uh_LVrow, 5)
   If ( A_GuiEvent = "A" OR A_GuiEvent = "DoubleClick" OR ( A_GuiEvent = "K" AND A_EventInfo = 32 ))
      Goto, uh_sub_EditHotkey
   If (A_GuiEvent = "RightClick" OR ( A_GuiEvent = "K" AND A_EventInfo = 93 ))
      Goto, uh_sub_ContextMenu
   If ( A_GuiEvent = "K" AND A_EventInfo = 46 )
      Goto, uh_sub_DelHotkey
   If ( A_GuiEvent = "K" AND A_EventInfo = 45 )
      Goto, uh_sub_AddHotkey
   If A_GuiEvent = ColClick
   {
      If uh_SortCol%A_EventInfo% <> Sort
         uh_SortCol%A_EventInfo% = Sort
      Else
         uh_SortCol%A_EventInfo% = SortDesc

      LV_ModifyCol(A_EventInfo, uh_SortCol%A_EventInfo%)

      uh_Sort := A_EventInfo uh_SortCol%A_EventInfo%
      uh_SortCol := A_EventInfo

      func_SettingsChanged( "UserHotkeys" )
   }
Return

uh_sub_DelHotkey:
   Critical
   Gui, 1:Default
   Gui, ListView, uh_ListView

   uh_LVrow := LV_GetNext()
   LV_GetText(uh_Num, uh_LVrow, 6)

   func_HotkeyDisable( "uh_Hotkey" uh_LVrow )
   LV_Delete( uh_LVrow )
   LV_Modify( uh_LVrow, "Select")

   StringReplace, Hotkey_AllNewHotkeys, Hotkey_AllNewHotkeys, % "" Hotkey_uh_Hotkey%uh_LVrow%_new "" , , A

   uh_delRows := uh_NumHotKeys_new - uh_Num
   GuiControl, -Redraw, uh_ListView
   Loop, %uh_delRows%
   {
      uh_nextRow := uh_Num + A_Index
      Uh_thisRow := uh_nextRow - 1
      Hotkey_uh_Hotkey%uh_thisRow%_new := Hotkey_uh_Hotkey%uh_nextRow%_new
      uh_Path%uh_thisRow%_new := uh_Path%uh_nextRow%_new
      uh_Description%uh_thisRow%_new := uh_Description%uh_nextRow%_new
      uh_Category%uh_thisRow%_new := uh_Category%uh_nextRow%_new
      uh_App%uh_thisRow%_new := uh_App%uh_nextRow%_new
      LV_Modify( uh_LVrow+A_Index-1,"Col6", uh_thisRow)
   }
   GuiControl, +Redraw, uh_ListView
   uh_NumHotkeys_new--

   Gosub, uh_sub_RefreshCategories

   func_SettingsChanged( "UserHotkeys" )
Return

uh_sub_RefreshCategories:
   uh_Categories = |
   uh_Apps = |
   Loop, %uh_NumHotkeys_new%
   {
      If uh_Category%A_Index%_new <>
      {
         IfNotInstring, uh_Category%A_Index%_new, % lng_uh_Application
         {
            StringReplace, uh_Categories, uh_Categories, % uh_Category%A_Index%_new "|", , All
            uh_Categories := uh_Categories uh_Category%A_Index%_new "|"
         }
      }
      If uh_App%A_Index%_new <>
      {
         StringReplace, uh_Apps, uh_Apps, % lng_uh_Application uh_App%A_Index%_new "|", , All
         uh_Apps := uh_Apps lng_uh_Application uh_App%A_Index%_new "|"
      }
   }
   GuiControl, , uh_CategoryFilter, |%uh_Categories%%uh_Apps%
   GuiControl, Choose, uh_CategoryFilter, 1
   GuiControl, ChooseString, uh_CategoryFilter, %uh_CategoryFilter%
Return

uh_sub_AddHotkey:
   Gui, 1:Default
   Gui, ListView, uh_ListView
   GuiControlGet, uh_CategoryFilter
   If uh_CategoryFilter <>
   {
      IfNotInString, uh_CategoryFilter, %lng_uh_Application%
      {
         StringReplace, uh_Categories, uh_Categories, % uh_CategoryFilter "|", , All
         uh_Categories := uh_Categories uh_CategoryFilter "|"
         uh_CategoryFilterTmp = %uh_CategoryFilter%
      }
      Else
      {
         StringReplace, uh_AppTmp, uh_CategoryFilter, %lng_uh_Application%, , All
         uh_CategoryFilterTmp =
      }
   }

   uh_NumHotkeys_new++
   LV_Add("Select", "","","",uh_CategoryFilterTmp,"",uh_NumHotKeys_new)
   uh_LVrow := LV_GetNext()
   uh_EditTitle = %lng_uh_Add%
   Hotkey_uh_Hotkey%uh_LVrow%_Sub = sub_Hotkey_UserHotkey
   Gosub, uh_sub_EditHotkey
   func_SettingsChanged( "UserHotkeys" )
Return

uh_sub_EditHotkey:
   Gui, 1:Default
   Gui, ListView, uh_ListView

   if (uh_LVrow = 0 OR uh_LVrow = "")
      Goto, uh_sub_AddHotkey

   If uh_GUI = 3
      Return

   uh_GUI = 3

   LV_GetText(Hotkey_uh_Hotkey, uh_LVrow, 1)
   LV_GetText(uh_Description, uh_LVrow, 3)
   LV_GetText(uh_Category, uh_LVrow, 4)
   LV_GetText(uh_Path, uh_LVrow, 5)
   LV_GetText(uh_Num, uh_LVrow, 6)
   LV_GetText(uh_App, uh_LVrow, 7)
   Hotkey_uh_Hotkey_new = %Hotkey_uh_Hotkey%

   If (uh_AppTmp <> "" AND uh_App = "")
      uh_App = %uh_AppTmp%

   StringReplace, uh_AppsTmp, uh_Apps, %lng_uh_Application%,, A

   Gui, 3:Default
   Gui, -MaximizeBox +Owner1
   Gui, 1:+Disabled

   ;Hotkey_uh_Hotkey%uh_LVrow% := Hotkey_uh_Hotkey%uh_LVrow%_new
   func_HotkeyAddGuiControl( lng_Hotkey, "uh_Hotkey", "y+10 w80" )
   If (uh_Description = uh_func_ShortenPath(uh_Path))
      uh_Description =
   Gui, Add, Text, x10 y+7 w80, %lng_uh_Description%:
   Gui, Add, Edit, x+5 R1 yp-3 W200 vuh_Description, % uh_Description
   Gui, Add, Text, x+25 yp+3 w50, %lng_uh_Category%:
   Gui, Add, ComboBox, x+5 yp-3 W180 vuh_Category, %uh_Categories%
   GuiControl, ChooseString, uh_Category, % uh_Category
   Gui, Add, Text, x10 y+7 w80, %lng_Command%:
   Gui, Add, Edit, x+5 yp-3 W460 h20 R3 -WantReturn vuh_Path, % uh_Path
   Gui, Add, Button, -Wrap x+5 h20 W21 vuh_Button guh_sub_Browse, ...
   Gui, Add, Text, Readonly x95 y+30, %lng_uh_Legend%
   Gui, Add, Edit, +0x100 Readonly R4 x95 W460 y+2 +AltSubmit, %uh_LegendItems%
   Gui, Add, Button, -Wrap X+5 h27 w18 vCH_UserHotkeys gsub_ContextHelp, ?
   Gui, Add, Button, xs+295 w250 y+34 h15 guh_sub_ClipSave, %lng_uh_ClipSave%

   Gui, Add, Text, x95 y+5, %lng_uh_OnlyOneApplication%
   Gui, Add, ComboBox, y+5 w460 vuh_App, %uh_AppsTmp%
   Gui, Add, Button, -Wrap x+5 w20 h21 vuh_Add_App guh_sub_addApp, +

   GuiControl, ChooseString, uh_App, % uh_App
   Gui, Add, Button, -Wrap y+10 x200 w100 Default guh_sub_OK, &OK
   Gui, Add, Button, -Wrap x+10 w100 g3GuiClose, %lng_Cancel%
   Gui, Show, w600 AutoSize, %uh_EditTitle%

   uh_AppTmp =
Return

uh_sub_OK:
   Gui, 1:-Disabled
   Gui, Submit
   Gui, Destroy
   Gui, 1:Default
   Gui, ListView, uh_ListView

   uh_GUI =

   If uh_Description =
      uh_Description := uh_func_ShortenPath(uh_Path)

   LV_Modify( uh_LVrow,"" , Hotkey_uh_Hotkey_new, func_HotkeyDecompose(Hotkey_uh_Hotkey_new,0), uh_Description, uh_Category, uh_Path,uh_Num, uh_App )

   Hotkey_uh_Hotkey%uh_Num%_new := Hotkey_uh_Hotkey_new
   uh_Description%uh_Num%_new := uh_Description
   uh_Category%uh_Num%_new := uh_Category
   uh_Path%uh_Num%_new := uh_Path
   uh_App%uh_Num%_new := uh_App

   If uh_Category <>
   {
      StringReplace, uh_Categories, uh_Categories, % uh_Category "|", , All
      uh_Categories := uh_Categories uh_Category "|"
   }
   If uh_App <>
   {
      StringReplace, uh_Apps, uh_Apps, % lng_uh_Application uh_App "|", , All
      uh_Apps := uh_Apps lng_uh_Application uh_App "|"
   }
   GuiControl, , uh_CategoryFilter, |%uh_Categories%%uh_Apps%
   GuiControl, ChooseString, uh_CategoryFilter, %uh_CategoryFilter%

   uh_EditTitle = %lng_uh_Edit%
   func_SettingsChanged( "UserHotkeys" )
Return

3GuiClose:
3GuiEscape:
   Gui, 1:-Disabled
   Gui, Submit
   Gui, Destroy
   Gui, 1:Default
   Gui, ListView, uh_ListView

   uh_GUI =

   Hotkey_uh_Hotkey%uh_Num%_new := Hotkey_uh_Hotkey%uh_Num%

   StringReplace, Hotkey_AllNewHotkeys, Hotkey_AllNewHotkeys, % "" Hotkey_uh_Hotkey_new "" , , A

   If uh_EditTitle = %lng_uh_Add%
   {
      LV_Delete( uh_LVrow )
      uh_NumHotkeys_new--
   }
   uh_EditTitle = %lng_uh_Edit%
Return

uh_sub_ContextMenu:
   Menu, uh_ContextMenu, Add, &%lng_uh_CMEdit% , uh_sub_EditHotkey
   Menu, uh_ContextMenu, Add, &%lng_uh_CMAdd% , uh_sub_AddHotkey
   Menu, uh_ContextMenu, Add, &%lng_uh_CMDelete% , uh_sub_DelHotkey
   Menu, uh_ContextMenu, Show
Return

uh_sub_Browse:
   Gui +OwnDialogs
   ;StringReplace, uh_Control, A_GuiControl,
   ;GuiControlGet, uh_Control,3:,uh_Path ;%uh_Control%

   GuiControlGet, uh_DefaultPath,3:,uh_Path
   uh_PathOnly = %uh_DefaultPath%

   IfNotExist, %uh_DefaultPath%
   {
      Loop
      {
         StringGetPos, uh_PathBeginVars, uh_Path, %A_Space%, R%A_Index%
         If ErrorLevel = 1
         {
            break
         }
         StringLeft, uh_PathOnly, uh_DefaultPath, %uh_PathBeginVars%
         If (InStr(FileExist(uh_PathOnly), "D") = 0 AND FileExist(uh_PathOnly))
         {
            StringMid, uh_Parameters, uh_Path, % uh_PathBeginVars+1
            break
         }
         uh_PathOnly = %uh_DefaultPath%
      }
   }


   SplitPath, uh_PathOnly, uh_DefaultFile, uh_DefaultPath

   if uh_DefaultPath =
   {
      IfExist, %uh_DefaultFile%
         uh_DefaultPath = %A_ScriptDir%\%uh_DefaultFile%
      Else IfExist, extensions\UserHotkeys-scripts\%uh_DefaultFile%
         uh_DefaultPath = extensions\UserHotkeys-scripts\%uh_DefaultFile%
      Else
         uh_DefaultPath = %uh_DefaultPath%\%uh_DefaultFile%
   }
   Else
      uh_DefaultPath = %uh_DefaultPath%\%uh_DefaultFile%

   IfNotExist, %uh_DefaultPath%
      uh_DefaultPath = extensions\UserHotkeys-scripts\

   FileSelectFile, uh_Control,, %uh_DefaultPath%, %uh_ScriptName%, %lng_uh_FileTypes%
   If Errorlevel = 0
   {
      StringReplace, uh_Control, uh_Control, %A_Scriptdir%\,
      StringReplace, uh_Control, uh_Control, extensions\userhotkeys-scripts\,
      GuiControl,3:,uh_Path, %uh_Control%
   }
Return

SaveSettings_UserHotkeys:
   Gui, 1:Default
   Gui, ListView, uh_ListView
   uh_LastCategoryFilter = %uh_CategoryFilter%
   If uh_CategoryFilter <>
   {
      uh_CategoryFilter =
      GuiControl, Choose, uh_CategoryFilter, 1
      Gosub, uh_sub_CategoryFilter
   }
   IniDelete, %ConfigFile%, %uh_ScriptName%
   uh_NumHotkeys := LV_GetCount()
   IniWrite, %uh_NumHotkeys%, %ConfigFile%, %uh_ScriptName%, NumberOfHotkeys
   IniWrite, %uh_Sort%, %ConfigFile%, %uh_ScriptName%, SortCol
   IniWrite, %uh_BalloonTip%, %ConfigFile%, %uh_ScriptName%, ShowBalloonTip
   IniWrite, %uh_BalloonTimeOut%, %ConfigFile%, %uh_ScriptName%, BalloonTimeOut
   GuiControl, -Redraw, uh_ListView
   Loop, %uh_NumHotkeys%
   {
      LV_GetText(Hotkey_uh_Hotkey%A_Index%_new, A_Index, 1)
      LV_GetText(uh_Description%A_Index%, A_Index, 3)
      LV_GetText(uh_Category%A_Index%, A_Index, 4)
      LV_GetText(uh_Path%A_Index%, A_Index, 5)
      LV_GetText(uh_App%A_Index%, A_Index, 7)
      If (uh_Description%A_Index% = uh_func_LocalizedCommand(uh_Path%A_Index%))
         uh_Description%A_Index% =
      func_HotkeyWrite( "uh_Hotkey" A_Index, ConfigFile, uh_ScriptName, "Hotkey" A_Index, "sub_Hotkey_UserHotkey", "$" )
      IniWrite, % uh_Path%A_Index%, %ConfigFile%, %uh_ScriptName%, Path%A_Index%
      IniWrite, % uh_Description%A_Index%, %ConfigFile%, %uh_ScriptName%, Description%A_Index%
      IniWrite, % uh_Category%A_Index%, %ConfigFile%, %uh_ScriptName%, Category%A_Index%
      IniWrite, % uh_App%A_Index%, %ConfigFile%, %uh_ScriptName%, Application%A_Index%
      LV_Modify( A_Index,"Col6", A_Index)
      uh_Description%A_Index%_new := uh_Description%A_Index%
      uh_Category%A_Index%_new := uh_Category%A_Index%
      uh_Path%A_Index%_new := uh_Path%A_Index%
      uh_App%A_Index%_new := uh_App%A_Index%
   }
   GuiControl, +Redraw, uh_ListView
   IfExist, settings/Clipboards
      Gosub, uh_sub_CleanUpClipSaves

   If uh_LastCategoryFilter <>
   {
      uh_CategoryFilter = %uh_LastCategoryFilter%
      GuiControl, ChooseString, uh_CategoryFilter, %uh_CategoryFilter%
      Gosub, uh_sub_CategoryFilter
   }
Return

AddSettings_UserHotkeys:
   Gui, 1:Default
   Gui, ListView, uh_ListView
   If AddFreshSettings = 1
   {
      uh_NumHotkeys_new = 0
      LV_Delete()
   }

   uh_FirstError =
   Loop
   {
      IniRead, uh_PathTmp, %AddFile%, %uh_ScriptName%, Path%A_Index%

      If (uh_PathTmp = "ERROR" AND uh_FirstError = "")
         continue
      If uh_PathTmp = ERROR
         break

      uh_FirstError = 1
      IniRead, uh_HotkeyTmp, %AddFile%, %uh_ScriptName%, Hotkey%A_Index%
      IniRead, uh_DescriptionTmp, %AddFile%, %uh_ScriptName%, Description%A_Index%
      IniRead, uh_CategoryTmp, %AddFile%, %uh_ScriptName%, Category%A_Index%
      IniRead, uh_AppTmp, %AddFile%, %uh_ScriptName%, Application%A_Index%

      uh_Duplicates = 0
      Loop, %uh_NumHotkeys_new%
      {
         If (uh_HotkeyTmp = Hotkey_uh_Hotkey%A_Index%_new)
         {
            uh_Duplicates++
            break
         }
      }
      If uh_Duplicates = 0
      {
         uh_NumHotkeys_new++
         Hotkey_uh_Hotkey%uh_NumHotkeys_new%_new = %uh_HotkeyTmp%
         uh_Path%uh_NumHotkeys_new%_new = %uh_PathTmp%
         If uh_DescriptionTmp =
            uh_Description%uh_NumHotkeys_new%_new := uh_func_LocalizedCommand(uh_Path%uh_NumHotkeys_new%_new)
         Else
            uh_Description%uh_NumHotkeys_new%_new := uh_DescriptionTmp

         uh_Category%uh_NumHotkeys_new%_new := uh_CategoryTmp
         uh_App%uh_NumHotkeys_new%_new := uh_AppTmp

         LV_Add("", Hotkey_uh_Hotkey%uh_NumHotkeys_new%_new, func_HotkeyDecompose(Hotkey_uh_Hotkey%uh_NumHotkeys_new%_new,0), uh_Description%uh_NumHotkeys_new%_new, uh_Category%uh_NumHotkeys_new%_new, uh_Path%uh_NumHotkeys_new%_new, uh_NumHotkeys_new, uh_App%uh_NumHotkeys_new%_new)
      }
   }
   func_SettingsChanged( "UserHotkeys" )
   Gosub, uh_sub_RefreshCategories
Return

CancelSettings_UserHotkeys:
   Loop, %uh_NumHotkeys%
   {
      Hotkey_uh_Hotkey%A_Index%_new := Hotkey_uh_Hotkey%A_Index%
      uh_Path%A_Index%_new := uh_Path%A_Index%
      uh_Description%A_Index%_new := uh_Description%A_Index%
   }
   uh_NumHotkeys_new = %uh_NumHotkeys%
   IfExist, settings/Clipboards
      Gosub, uh_sub_CleanUpClipSaves
Return

DoEnable_UserHotkeys:
   Loop, %uh_NumHotkeys%
   {
      func_HotkeyEnable( "uh_Hotkey" A_Index )
   }
Return

DoDisable_UserHotkeys:
   Loop, %uh_NumHotkeys%
   {
      func_HotkeyDisable( "uh_Hotkey" A_Index )
   }
Return

DefaultSettings_UserHotkeys:
Return

; -----------------------------------------------------------------------------
; === Hotkeys =================================================================
; -----------------------------------------------------------------------------

sub_Hotkey_UserHotkey:
   Setkeydelay, 0
   If uh_ThisPath =
   {
      uh_Path := func_HotkeyGetVar("uh_Hotkey",uh_NumHotkeys,"uh_Path",uh_ThisHotkey,"$")
      uh_Description := func_HotkeyGetVar("uh_Hotkey",uh_NumHotkeys,"uh_Description",uh_ThisHotkey,"$")
      uh_App := func_HotkeyGetVar("uh_Hotkey",uh_NumHotkeys,"uh_App",uh_ThisHotkey,"$")
   }
   Else
   {
      uh_Path = %uh_ThisPath%
      uh_App = %uh_ThisApp%
      uh_Description = %uh_ThisDescription%
   }
   uh_A_ThisHotkey := func_prepareHotkeyForSend(A_ThisHotkey)
   uh_HotkeyNumber := func_HotkeyGetNumber("uh_Hotkey",uh_NumHotkeys,"$", uh_ThisHotkey )
   uh_DescriptionOrPath = %uh_Description%
   if uh_Description =
      uh_DescriptionOrPath = %uh_Path%
   uh_Category := func_HotkeyGetVar("uh_Hotkey",uh_NumHotkeys,"uh_Category",uh_ThisHotkey,"$")
   uh_CategoryOrg = %uh_Category%
   StringReplace, uh_Category, uh_Category, %lng_uh_Application%,,

   uh_ThisDescription =
   uh_ThisHotkey =
   uh_ThisPath =
   uh_ThisApp =

   If (func_StrLeft(uh_App, 5) = "[not]")
   {
      uh_NotApp = 1
      StringTrimLeft, uh_App, uh_App, 5
   }
   Else
      uh_NotApp = 0

   If uh_App contains ahk_class,ahk_id,ahk_pid,ahk_group
   {
      IfInString, uh_Path, <ControlSend>
      {
         DetectHiddenWindows, On
         IfWinNotExist, %uh_App%
         {
            Send,%uh_A_Thishotkey%
            Return
         }
         DetectHiddenWindows, Off
      }
      Else
      {
         IfWinNotActive, %uh_App%
         {
            Send,%uh_A_Thishotkey%
            Return
         }
      }
   }
   Else If uh_App <>
   {
      IfInString, uh_Path, <ControlSend>
         DetectHiddenWindows, On

      WinGetTitle, uh_Title, A
      If uh_NotApp = 0
      {
         If uh_title not Contains %uh_App%
         {
            Send,%uh_A_Thishotkey%
            Return
         }
      }
      Else
      {
         If uh_title Contains %uh_App%
         {
            Send,%uh_A_Thishotkey%
            Return
         }
      }
      IfInString, uh_Path, <ControlSend>
         DetectHiddenWindows, Off
   }

   If A_IsCompiled = 1
   {
      StringReplace, uh_Path_tmp, uh_Path, .ahk, .exe
      IfExist, %uh_Path_tmp%
         uh_Path = %uh_Path_tmp%
   }

   IfInString, uh_Path, <AOT>
   {
      StringReplace, uh_Path, uh_Path, <AOT>,
      uh_AOT = 1
   }
   Else
      uh_AOT = 0

   IfInString, uh_Path, <NoBalloonTip>
   {
      StringReplace, uh_Path, uh_Path, <NoBalloonTip>,
      uh_NoBalloonTip = 1
   }
   Else
      uh_NoBalloonTip = 0

   uh_RunParameter =
   IfInString, uh_Path, <Min>
   {
      StringReplace, uh_Path, uh_Path, <Min>,
      uh_RunParameter = Min
   }
   IfInString, uh_Path, <Max>
   {
      StringReplace, uh_Path, uh_Path, <Max>,
      uh_RunParameter = Max
   }
   IfInString, uh_Path, <hidden>
   {
      StringReplace, uh_Path, uh_Path, <hidden>,
      uh_RunParameter = Hide
   }
   IfInString, uh_Path, <Hide>
   {
      StringReplace, uh_Path, uh_Path, <Hide>,
      uh_RunParameter = Hide
   }

   IfInString, uh_Path, `%Selection`%
   {
      func_GetSelection()
   }
   IfInString, uh_Path, `%
      Gosub, sub_GetAllEnv

   Transform, uh_Path, Deref, %uh_Path%

   uh_PathOnly = %uh_Path%
   uh_Parameters =

   IfNotExist, extensions\userhotkeys-scripts\%uh_Path%
   IfNotExist, %uh_Path%
   {
      Loop
      {
         StringGetPos, uh_PathBeginVars, uh_Path, %A_Space%, R%A_Index%
         If ErrorLevel = 1
         {
            break
         }
         StringLeft, uh_PathOnly, uh_Path, %uh_PathBeginVars%
         If (InStr(FileExist(uh_PathOnly), "D") = 0 AND FileExist(uh_PathOnly))
         {
            StringMid, uh_Parameters, uh_Path, % uh_PathBeginVars+1
            break
         }
         uh_PathOnly = %uh_Path%
      }
   }

   If (FileExist( uh_PathOnly ) AND InStr( uh_PathOnly, " ") AND !InStr(uh_PathOnly, """") )
      uh_Quote = "
   Else
      uh_Quote =

   uh_AddAHKPath =
   If (!InStr(uh_Path,"A_AHKPath") AND func_StrRight(uh_Path,4)=".ahk")
   {
      uh_AddAHKPath := A_AHKPath " "
      If (!InStr(uh_Path, """"))
         uh_Quote = "
   }

   StringGetPos, uh_PathBeginVars, uh_PathOnly, >
   StringLeft, uh_PathTag, uh_PathOnly, % uh_PathBeginVars + 1
   If StrLen(uh_PathTag) > 3
      StringReplace, uh_PathWithoutTag, uh_pathOnly, %uh_PathTag%,

   If uh_PathTag Not in %uh_SpecialCommands%
   {
      SplitPath, uh_Path, uh_OutFileName, , uh_OutExtension, uh_OutNameNoExt
      if uh_Description <>
         uh_OutNameNoExt = %uh_Description%
      If (uh_BalloonTip = -1 AND uh_NoBalloonTip = 0)
         BalloonTip( uh_ScriptName, A_Quote uh_OutNameNoExt A_Quote " " lng_uh_running, "Info" , 0, 0, uh_BalloonTimeOut)

      If uh_OutExtension = lnk
      {
         FileGetShortcut, %uh_Path%, uh_ShortcutPath
         IfNotExist, %uh_ShortcutPath%
         {
            If (uh_BalloonTip <> 0 AND uh_NoBalloonTip = 0)
               BalloonTip( uh_ScriptName, A_Quote uh_OutNameNoExt A_Quote " " lng_uh_runningError "`n`n" uh_Path, "Error" , 0, 0, uh_BalloonTimeOut)
         }
      }

      IfExist, extensions\userhotkeys-scripts\%uh_PathOnly%
         Run, %uh_AddAHKPath%%uh_Quote%extensions\userhotkeys-scripts\%uh_PathOnly%%uh_Quote%%uh_Parameters%,,UseErrorlevel %uh_RunParameter%, uh_ProcID%uh_HotkeyNumber%
      Else
         Run, %uh_AddAHKPath%%uh_Quote%%uh_PathOnly%%uh_Quote%%uh_Parameters%,,UseErrorlevel %uh_RunParameter%, uh_ProcID%uh_HotkeyNumber%
      uh_Error = 0
      If ErrorLevel = ERROR
         uh_Error = 1

      IfWinNotActive, % "ahk_pid" uh_ProcID%uh_HotkeyNumber%,,1
         WinWaitActive, % "ahk_pid" uh_ProcID%uh_HotkeyNumber%,,1
   }
   If uh_PathTag = <send>
   {
      uh_Error = 0
      Send, %uh_PathWithoutTag%

   }
   If uh_PathTag = <sendraw>
   {
      uh_Error = 0
      SendRaw, %uh_PathWithoutTag%
   }
   If uh_PathTag = <reload>
   {
      uh_Error = 0
      Reload
   }
   If uh_PathTag = <listhotkeys>
   {
      uh_Error = 0
      ListHotkeys
   }
   If uh_PathTag = <listlines>
   {
      uh_Error = 0
      ListLines
   }
   If uh_PathTag = <listvars>
   {
      uh_Error = 0
      ListVars
   }
   If uh_PathTag = <exitapp>
   {
      uh_Error = 0
      ExitApp
   }
   If uh_PathTag = <keyhistory>
   {
      uh_Error = 0
      KeyHistory
   }
   If uh_PathTag = <getControl>
   {
      uh_Error = 0
      MouseGetPos, , , uh_WinID, uh_ControlClass
      Clipboard = %uh_ControlClass%
      ToolTip, %uh_ControlClass%
      Sleep, 800
      ToolTip
   }
   If (uh_PathTag = "<getColour>" OR uh_PathTag = "<getColor>")
   {
      uh_Error = 0
      CoordMode, Mouse, Screen
      CoordMode, Pixel, Screen
      MouseGetPos, uh_MouseX , uh_MouseY
      PixelGetColor, uh_Colour, %uh_MouseX%, %uh_MouseY%, RGB
      StringTrimLeft, uh_Colour, uh_Colour, 2
      IfInString, uh_PathWithoutTag, <RGB>
      {
         StringReplace, uh_Colour, uh_PathWithoutTag, <RGB>, %uh_Colour%,a
      }
      Else
         uh_Colour = %uh_PathWithoutTag%%uh_Colour%
      Clipboard = %uh_Colour%
      ToolTip, %uh_Colour%
      Sleep, 800
      ToolTip
   }
   If uh_PathTag = <getControlText>
   {
      uh_Error = 0
      CoordMode, Mouse, Screen
      MouseGetPos, uh_MouseX , uh_MouseY, uh_gWin, uh_gControl
      ControlGetText, uh_getText, %uh_gControl%, ahk_id %uh_gWin%
      uh_getText = %uh_PathWithoutTag%%uh_getText%
      Clipboard = %uh_getText%
      ToolTip, %uh_getText%
      Sleep, 800
      ToolTip
   }
   If uh_PathTag = <SingleInstance>
   {
      Critical
      uh_Error = 0
      StringReplace, uh_PathOnly,uh_PathOnly,<SingleInstance>,
      ifExist, extensions\userhotkeys-scripts\%uh_PathOnly%
         uh_Path = extensions\userhotkeys-scripts\%uh_PathWithoutTag%
      Else
         uh_Path = %uh_PathWithoutTag%

      IfWinExist, % "ahk_group " uh_ProcID%uh_HotkeyNumber%
      {
         IfWinNotActive, % "ahk_group " uh_ProcID%uh_HotkeyNumber%
         {
            WinRestore, % "ahk_group " uh_ProcID%uh_HotkeyNumber%
            IfWinNotActive, % "ahk_group " uh_ProcID%uh_HotkeyNumber%
               WinActivate, % "ahk_group " uh_ProcID%uh_HotkeyNumber%
         }
         Else
         {
            WinMinimize, % "ahk_group " uh_ProcID%uh_HotkeyNumber%
         }
      }
      Else
      {
         SplitPath, uh_PathOnly, uh_OutFileName, , uh_OutExtension, uh_OutNameNoExt
         if uh_Description <>
            uh_OutNameNoExt = %uh_Description%
         If (uh_BalloonTip = -1 AND uh_NoBalloonTip = 0)
            BalloonTip( uh_ScriptName, A_Quote uh_OutNameNoExt A_Quote " " lng_uh_running , "Info", 0, 0, uh_BalloonTimeOut)

         If uh_OutExtension = lnk
         {
            FileGetShortcut, %uh_Path%, uh_ShortcutPath
            IfNotExist, %uh_ShortcutPath%
            {
               If (uh_BalloonTip <> 0 AND uh_NoBalloonTip = 0)
                  BalloonTip( uh_ScriptName, A_Quote uh_OutNameNoExt A_Quote " " lng_uh_runningError "`n`n" uh_Path, "Error" , 0, 0, uh_BalloonTimeOut)
               Return
            }
         }

         Run, %uh_AddAHKPath%%uh_Quote%%uh_PathOnly%%uh_Quote%%uh_Parameters%,, UseErrorLevel %uh_RunParameter%, uh_PID
         If ErrorLevel = ERROR
         {
            If (uh_BalloonTip <> 0 AND uh_NoBalloonTip = 0)
               BalloonTip( uh_ScriptName, A_Quote uh_OutNameNoExt A_Quote " " lng_uh_runningError "`n`n" uh_Path, "Error" , 0, 0, uh_BalloonTimeOut)
            Return
         }

         IfWinNotActive, ahk_pid %uh_PID%
         {
            WinWaitActive,  ahk_pid %uh_PID%,,2
            If ErrorLevel = 1
            {
               WinGet, uh_ProcName, ProcessName, A
               If (uh_ProcName = uh_OutFileName OR uh_PID = "")
               {
                  WinGet, uh_PID, PID, A
               }
            }
         }
         WinGet, uh_ProcName, ProcessName, A
         uh_ProcName := func_Hex(uh_ProcName)
         uh_ProcID%uh_HotkeyNumber% = g%uh_PID%%uh_ProcName%
         WinGet, uh_WinList, List, ahk_pid %uh_PID%
         loop, %uh_WinList%
         {
            uh_wid := uh_WinList%A_Index%
            GroupAdd, g%uh_PID%%uh_ProcName%, ahk_id %uh_wid%
         }
      }
   }
   If uh_PathTag = <SingleInstanceClose>
   {
      Critical
      uh_Error = 0
      StringReplace, uh_PathOnly,uh_PathOnly,<SingleInstanceClose>,
      ifExist, extensions\userhotkeys-scripts\%uh_PathOnly%
         uh_Path = extensions\userhotkeys-scripts\%uh_PathWithoutTag%
      Else
         uh_Path = %uh_PathWithoutTag%

      IfWinExist, % "ahk_group " uh_ProcID%uh_HotkeyNumber%
      {
         IfWinNotActive, % "ahk_group " uh_ProcID%uh_HotkeyNumber%
         {
            WinRestore, % "ahk_group " uh_ProcID%uh_HotkeyNumber%
            IfWinNotActive, % "ahk_group " uh_ProcID%uh_HotkeyNumber%
               WinActivate, % "ahk_group " uh_ProcID%uh_HotkeyNumber%
         }
         Else
         {
            GroupClose, % uh_ProcID%uh_HotkeyNumber%, A
         }
      }
      Else
      {
         SplitPath, uh_PathOnly, uh_OutFileName, , uh_OutExtension, uh_OutNameNoExt
         if uh_Description <>
            uh_OutNameNoExt = %uh_Description%
         If (uh_BalloonTip = -1 AND uh_NoBalloonTip = 0)
            BalloonTip( uh_ScriptName, A_Quote uh_OutNameNoExt A_Quote " " lng_uh_running, "Info" , 0, 0, uh_BalloonTimeOut)

         If uh_OutExtension = lnk
         {
            FileGetShortcut, %uh_Path%, uh_ShortcutPath
            IfNotExist, %uh_ShortcutPath%
            {
               If (uh_BalloonTip <> 0 AND uh_NoBalloonTip = 0)
                  BalloonTip( uh_ScriptName, A_Quote uh_OutNameNoExt A_Quote " " lng_uh_runningError "`n`n" uh_Path, "Error" , 0, 0, uh_BalloonTimeOut)
               Return
            }
         }

         Run, %uh_AddAHKPath%%uh_Quote%%uh_PathOnly%%uh_Quote%%uh_Parameters%,, UseErrorLevel %uh_RunParameter%, uh_PID
         If ErrorLevel = ERROR
         {
            If (uh_BalloonTip <> 0 AND uh_NoBalloonTip = 0)
               BalloonTip( uh_ScriptName, A_Quote uh_OutNameNoExt A_Quote " " lng_uh_runningError "`n`n" uh_Path, "Error" , 0, 0, uh_BalloonTimeOut)
            Return
         }

         IfWinNotActive, ahk_pid %uh_PID%
         {
            WinWaitActive,  ahk_pid %uh_PID%,,2
            If ErrorLevel = 1
            {
               WinGet, uh_ProcName, ProcessName, A
               If (uh_ProcName = uh_OutFileName OR uh_PID = "")
               {
                  WinGet, uh_PID, PID, A
               }
            }
         }
         WinGet, uh_ProcName, ProcessName, A
         uh_ProcName := func_Hex(uh_ProcName)
         uh_ProcID%uh_HotkeyNumber% = g%uh_PID%%uh_ProcName%
         WinGet, uh_WinList, List, ahk_pid %uh_PID%
         loop, %uh_WinList%
         {
            uh_wid := uh_WinList%A_Index%
            GroupAdd, g%uh_PID%%uh_ProcName%, ahk_id %uh_wid%
         }
      }
   }
   If uh_PathTag = <chdir>
   {
      uh_Error = 0
      func_ChangeDir(uh_PathWithoutTag,-1,0)
   }
   If uh_PathTag = <ControlSend>
   {
      DetectHiddenWindows, On
      IfWinExist, %uh_App%
      {
         uh_temp1 =
         uh_temp2 =
         uh_temp3 =
         StringSplit, uh_temp, uh_PathWithoutTag, `,
         if uh_temp2 =
         {
            ControlSend, ahk_parent,%uh_temp1%
         }
         Else
            ControlSend, %uh_temp1%,%uh_temp2%
      }
      Else
      {
         Send,%uh_A_Thishotkey%
         Return
      }

      DetectHiddenWindows, Off
      uh_Error =
   }
   If uh_PathTag = <PasteFile>
   {
      uh_Error = 0
      uh_Temp = %ClipBoardAll%
      FileRead, Clipboard, *c %uh_PathWithoutTag%
      Send, ^v
      Sleep, 100
      ClipBoard = %uh_Temp%
   }

   If uh_AOT = 1
   {
     WinGet, uh_ExStyle, ExStyle, % "ahk_group " uh_ProcID%uh_HotkeyNumber%

     if not (uh_ExStyle & 0x8)
     {
       WinGetTitle, uh_WinTitle, % "ahk_group " uh_ProcID%uh_HotkeyNumber%

       WinSet, AlwaysOnTop, On, % "ahk_group " uh_ProcID%uh_HotkeyNumber%
       IfNotInString, uh_WinTitle, /\
         uh_WinTitle = /\  %uh_WinTitle%
       WinSet, ExStyle, +0x20000, % "ahk_group " uh_ProcID%uh_HotkeyNumber%
       WinSetTitle, % "ahk_group " uh_ProcID%uh_HotkeyNumber%,, %uh_WinTitle%
     }
   }

   If uh_PathTag = <CategoryMenu>
   {
      uh_Error = 0
      If (uh_Category <> uh_CategoryOrg)
      {
         WinGetTitle, uh_Title, A
         If uh_title not Contains %uh_Category%
            Return
      }


      Menu, % func_Hex(uh_Category "!"), Add, % "[ " uh_CategoryOrg " ]", uh_sub_CategoryMenu
      ;Menu, % func_Hex(uh_Category "!"), Disable, % uh_CategoryOrg
      Menu, % func_Hex(uh_Category "!"), Add
      uh_Index = 1
      Loop, %uh_NumHotkeys%
      {
         If ((uh_Category%A_Index% = uh_Category OR uh_App%A_Index% = uh_Category) AND uh_Path <> uh_Path%A_Index%)
         {
            StringMid, uh_AlphaNum, uh_AlphaNums, uh_Index, 1
            uh_Index++
            If Hotkey_uh_Hotkey%A_Index%_new =
               uh_AddMenuHotkey =
            Else
               uh_AddMenuHotkey := "`t (" func_HotkeyDecompose(Hotkey_uh_Hotkey%A_Index%_new,1) ")"

            If uh_Description%A_Index% =
               Menu, % func_Hex(uh_Category "!"), Add, % "&" uh_AlphaNum " - " uh_func_ShortenPath(uh_Path%A_Index%) uh_AddMenuHotkey, uh_sub_CategoryMenu
            Else
               Menu, % func_Hex(uh_Category "!"), Add, % "&" uh_AlphaNum " - " uh_Description%A_Index%  uh_AddMenuHotkey, uh_sub_CategoryMenu
         }
      }
      Menu, % func_Hex(uh_Category "!"), Show
      Menu, % func_Hex(uh_Category "!"), DeleteAll
   }

   If uh_Error = 1
      If (uh_BalloonTip <> 0 AND uh_NoBalloonTip = 0)
         BalloonTip( uh_ScriptName, A_Quote uh_OutNameNoExt A_Quote " " lng_uh_runningError "`n`n" uh_Path, "Error" , 0, 0, uh_BalloonTimeOut)
Return

; -----------------------------------------------------------------------------
; === Subroutines =============================================================
; -----------------------------------------------------------------------------

uh_sub_CategoryMenu:
   Menu, %A_ThisMenu%, DeleteAll
   Loop, %uh_NumHotkeys%
   {
      StringTrimLeft, uh_ThisMenuItem, A_ThisMenuItem, 5
      If Hotkey_uh_Hotkey%A_Index%_new =
         uh_ThisMenuHotkey =
      Else
         uh_ThisMenuHotkey := "`t (" func_HotkeyDecompose(Hotkey_uh_Hotkey%A_Index%_new,1) ")"

      If ((uh_func_LocalizedCommand(uh_Path%A_Index%) uh_ThisMenuHotkey = uh_ThisMenuItem OR uh_Description%A_Index% uh_ThisMenuHotkey = uh_ThisMenuItem) AND func_Hex(uh_Category%A_Index% "!") = A_ThisMenu )
      {
         uh_ThisHotkey := Hotkey_uh_Hotkey%A_Index%
         uh_ThisPath := uh_Path%A_Index%
         gosub, sub_Hotkey_UserHotkey
         break
      }
   }
Return

uh_func_LocalizedCommand( String )
{
   global
   Loop, Parse, uh_SpecialCommands, `,
   {
      uh_tmpCommand := func_StrTranslate( A_LoopField , "<>" , "")
      If lng_uh_Cmd_%uh_tmpCommand% <>
         StringReplace, String, String, %A_LoopField%, % "<" lng_uh_Cmd_%uh_tmpCommand% "> "
      IfNotInstring, String, <
         Break
   }
   Return, %String%
}

uh_sub_ClipSave:
   IfNotExist, settings/Clipboards
      FileCreateDir, settings/Clipboards
   Loop
   {
      uh_ClipFileName = settings/Clipboards/UH_ClipSave%A_Index%.dat
      IfNotExist, %uh_ClipFileName%
         break
   }
   FileAppend, %ClipBoardAll%, %uh_ClipFileName%
   GuiControl,,uh_Path, <PasteFile>%uh_ClipFileName%
Return

uh_sub_CleanUpClipSaves:
   Loop, settings/Clipboards/UH_*.*
   {
      uh_FileName = %A_LoopFileName%
      uh_DeleteFile = 1
      Loop, %uh_NumHotkeys%
      {
         IfInString, uh_Path%A_Index%, <PasteFile>settings/Clipboards/%uh_FileName%
            uh_DeleteFile = 0
      }
      If uh_DeleteFile = 1
         FileDelete, settings/Clipboards/%A_LoopFileName%
   }
Return

uh_sub_addApp:
   StringReplace, uh_VarApp, A_GuiControl, Add_,
   WinSet,Bottom,, %ScriptTitle%
   SplashImage,,b1 cwFFFF80 FS9 WS700, %lng_AddApps%
   Gui,+Disabled
   Input,uh_GetKey,,{Enter}{ESC}
   StringReplace,uh_GetKey,ErrorLevel,Endkey:
   SplashImage, Off
   Gui,-Disabled
   WinGetClass, uh_GetName, A
   If uh_Getkey = Enter
   {
      IfNotInstring, %uh_VarApp%, %uh_GetName%
      {
         GuiControl,,%uh_VarApp%, ahk_class %uh_GetName%
         GuiControl,ChooseString, %uh_VarApp%, ahk_class %uh_GetName%
         %uh_VarApp% := %uh_VarApp% "|" uh_GetName
         StringReplace,%uh_VarApp%,%uh_VarApp%,||,|,a
      }
   }
   Gui,Show
   WinSet, Top, , %ScriptTitle%
Return

uh_func_ShortenPath(Path)
{
   StringGetPos, uh_Temp, Path, >, R
   StringLeft, uh_Temp1, Path, % uh_Temp+1
   StringMid, uh_Temp2, Path, % uh_Temp+2
   SplitPath, uh_Temp2, uh_Temp3
   If (uh_Temp3 <> uh_Temp2 AND !InStr(uh_Temp1,"<Send") AND uh_Temp3 <> "" )
      Return % uh_func_LocalizedCommand(uh_Temp1) "...\" uh_Temp3
   Else
      Return % uh_func_LocalizedCommand(uh_Temp1) uh_Temp2
}

