/* c't Mikrocontroller-im-LAN Demo Source
 * Datei: adc.h 
 * Info: Routinen zum Einlesen der Analogeingnge
 * Autor: Benjamin Benz (bbe@heise.de)
 * Datum: 24.06.04
*/

#define ADC_BUFFER	64

extern volatile int adc_buffer[ADC_BUFFER];	// Ringpuffer

//Liest einen analogen kanal aus
//Der Parameter ist die hex-Wertigkeit des Pins (0x01 fr PA0; 0x02 fr PA1, ..)
int adc_read(char channel);

/* Wechselt einen ADU-kanal. Dafr muessen auch die Puffer zurckgesetzt werden */
void adc_select_channel(char channel);

// Diese Routine wird vom Timer-Interrupt aufgerufen und speichert einen 
// Messwert. (vorher wendet sie evtl. noch eine Filterfkt an)
void adc_isr(void);

/* bertrage den Inhalt des ADC-Puffers per uart */
void adc_transmit(void);

// Initialisert den AD-Umsetzer. Fr jeden Kanal, den man nutzen mchte, 
// muss das entsprechende Bit in channel gesetzt sein:
// Bit0 = Kanal 0 usw.
void adc_init(char channel);