/* c't Mikrocontroller-im-LAN Demo Source
 * Datei: adc_pt100.c 
 * Info: Routinen zum Einlesen der PT100-Sensoren
 * Autor: Benjamin Benz (bbe@heise.de)
 * Datum: 05.10.05
*/
#include "../mcu.h"

#include "adc.h"

#include <math.h>

#ifdef PT100_AVAILABLE
//Zum Kalibrieren bentigen wir Zwei Sttzstellen. Den Rest macht der Precompiler fr uns :-)
//Bitte entsprechend eintragen 

//Sensor 0
#define pt100_0_messwert_1 614.00	//Messwert 2
#define pt100_0_realwert_1 26.50	//passende temperatur in hunderstel Grad

#define pt100_0_messwert_2 458.00	//Messwert 1
#define pt100_0_realwert_2 12.30	//passende temperatur in hunderstel Grad 

//Sensor 0
#define pt100_1_messwert_1 740.00	//Messwert 2
#define pt100_1_realwert_1 31.60	//passende temperatur in hunderstel Grad

#define pt100_1_messwert_2 771.00	//Messwert 1
#define pt100_1_realwert_2 35.70	//passende temperatur in hunderstel Grad 


// Nicht bearbeiten!!!
#define pt100_0_faktor ((pt100_0_realwert_1-pt100_0_realwert_2)/(pt100_0_messwert_1-pt100_0_messwert_2))
#define pt100_0_offset (pt100_0_realwert_1- (pt100_0_faktor*pt100_0_messwert_1))
#define pt100_1_faktor ((pt100_1_realwert_1-pt100_1_realwert_2)/(pt100_1_messwert_1-pt100_1_messwert_2))
#define pt100_1_offset (pt100_1_realwert_1- (pt100_1_faktor*pt100_1_messwert_1))

const float korr_faktor[] ={pt100_0_faktor,pt100_1_faktor};
const float korr_offset[] ={pt100_0_offset,pt100_1_offset};

//Liefert die Temperatur der PT100 Sensoren in Hunderstel Grad Celsius zurck 
int pt100_read(unsigned char channel){
	float temp =(float)adc_read(channel);	// Wert auslesen
	temp =((korr_faktor[channel] * temp) + korr_offset[channel]);
	return floor(temp*100);
}
#endif
